/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.scd.ISCDTransformModel;
import com.sas.etl.models.job.transforms.scd.ISCDType2TransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class BusinessKeyTableModel
extends WsAbstractTableModel {
    private WAdminResource bundle = WAdminResource.getBundle(BusinessKeyTableModel.class);
    public static final int COLUMNNAME_COLUMN = 0;
    public static final int COLUMNDESC_COLUMN = 1;
    public static final int METADATA_COLUMN = 2;
    private static final int VISIBLE_COLUMNS = 2;
    private static final int HIDDEN_COLUMNS = 1;
    private static final int COLUMNNAME_WIDTH = 200;
    private static final int COLUMNDESC_WIDTH = 200;
    private ISCDTransformModel m_model;
    private ModelListener m_modelListener;

    public BusinessKeyTableModel(ISCDTransformModel model) {
        this.m_model = model;
        this.createColumnDefinitions();
        this.m_modelListener = new ModelListener();
        this.m_model.getModel().addModelListener((IModelListener)this.m_modelListener);
    }

    public void dispose() {
        this.m_model.getModel().removeModelListener((IModelListener)this.m_modelListener);
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumns()];
        this.m_aColumns[0] = new WsStringTableColumn(0, this.bundle.getString("BusinessKeyTableModel.column.name.txt"), 200);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, this.bundle.getString("BusinessKeyTableModel.column.desc.txt"), 200);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2] = new WsMetadataTableColumn();
    }

    private List createRowValues(IColumn column) {
        ArrayList<String> values = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
        values.add(column.getName());
        values.add(column.getDescription());
        values.add((String)column);
        return values;
    }

    public void setModel(ISCDType2TransformModel model) {
        this.m_model = model;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_model == null) {
            return;
        }
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        IColumn[] columns = this.m_model.getBusinessKeyColumns();
        for (int i = 0; i < columns.length; ++i) {
            ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumns());
            alRow.add(columns[i].getName());
            alRow.add(columns[i].getDescription());
            alRow.add((String)columns[i]);
            this.m_lData.add(alRow);
        }
        nRows = this.m_lData.size();
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore not implemented.  changes are immediately made to the model");
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getHiddenColumns() {
        return 1;
    }

    public IColumn getColumnForRow(int index) {
        return (IColumn)this.getValueAt(index, 2);
    }

    public int getRowIndex(IColumn column) {
        for (int row = 0; row < this.m_lData.size(); ++row) {
            if (this.getColumnForRow(row) != column) continue;
            return row;
        }
        return -1;
    }

    private void addColumn(IColumn column, int index) {
        if (index < this.getRowCount() && this.getColumnForRow(index) == column) {
            return;
        }
        List rowValues = this.createRowValues(column);
        this.m_lData.add(index, rowValues);
        ++this.m_nRowInstances;
        this.fireTableRowsInserted(index, index);
    }

    private void removeColumn(IColumn column) {
        for (int i = 0; i < this.m_lData.size(); ++i) {
            if (this.getColumnForRow(i) != column) continue;
            List deletedRows = (List)this.m_lData.remove(i);
            this.fireTableRowDeleted(i, deletedRows);
            break;
        }
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String type = event.getType();
            IObject object = event.getModelObject();
            if (object != BusinessKeyTableModel.this.m_model) {
                return;
            }
            if (type.equals("SCDTransformModel:BusinessKeyAdded")) {
                IColumn column = (IColumn)event.getData();
                int index = BusinessKeyTableModel.this.m_model.getBusinessKeyColumnsList().indexOf(column);
                BusinessKeyTableModel.this.addColumn(column, index);
            } else if (type.equals("SCDTransformModel:BusinessKeyRemoved")) {
                IColumn column = (IColumn)event.getData();
                BusinessKeyTableModel.this.removeColumn(column);
            } else if (type.equals("SCDTransformModel:BusinessKeyMoved")) {
                IColumn column = (IColumn)event.getData();
                int index = BusinessKeyTableModel.this.m_model.getBusinessKeyColumnsList().indexOf(column);
                BusinessKeyTableModel.this.removeColumn(column);
                BusinessKeyTableModel.this.addColumn(column, index);
            }
        }
    }
}

