/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.job.transforms.scd.ISCDTransformModel;
import com.sas.etl.models.job.transforms.scd.ISCDType2TransformModel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Key;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.scd.BusinessKeyTableModel;
import com.sas.wadmin.transforms.scd.ColumnItem;
import com.sas.wadmin.transforms.scd.ColumnSelectorPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.SCDType2Utilities;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class BusinessKeyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(BusinessKeyTab.class);
    private WAPanel m_bkPanel;
    private WATextArea m_bkDescription;
    private JScrollPane m_bkScrPane;
    private JButton m_btnNewRow;
    private JButton m_btnDeleteRow;
    private JButton m_btnMoveUp;
    private JButton m_btnMoveDown;
    private JPanel m_btnPanel;
    private WsAbstractAction m_actNewRow;
    private WsAbstractAction m_actDeleteRow;
    private WsAbstractAction m_actMoveUp;
    private WsAbstractAction m_actMoveDown;
    private ListSelectionListener m_lsnrTableSelection;
    private RowModelListener m_lsnrTableRowModel;
    private boolean m_bShowDescription;
    private ISCDTransformModel m_model;
    private ITable m_targetDimension;
    protected ClassifierMap m_transform;
    protected WsTable m_bkTable;
    protected BusinessKeyTableModel m_bkTableModel;
    public static String SCD = "SCD";
    public static String KED = "KED";
    private static final int UP = 0;
    private static final int DOWN = 1;

    public BusinessKeyTab(ISCDTransformModel model, String type, String helpTopicId) {
        this.setHelpProduct("wdb");
        this.setHelpTopic(helpTopicId);
        this.m_model = model;
        if (type == SCD) {
            this.m_bShowDescription = true;
            this.setName(bundle.getString("BusinessKeyTab.Name.txt"));
        } else if (type == KED) {
            this.m_bShowDescription = false;
            this.setName(bundle.getString("BusinessKeyTab.Key.txt"));
        } else {
            throw new IllegalArgumentException("Invalid BusinessKeyTab type argument; expecting SCD or KED, got: " + type);
        }
        this.initialize();
    }

    public BusinessKeyTab(ISCDType2TransformModel model, boolean showDescription, String helpTopicId) {
        this.m_model = model;
        this.m_bShowDescription = showDescription;
        this.setHelpTopic(helpTopicId);
        this.initialize();
        this.setName(bundle.getString("BusinessKeyTab.Name.txt"));
    }

    public BusinessKeyTab(ISCDType2TransformModel model, String helpTopicId) {
        this(model, true, helpTopicId);
    }

    protected void initialize() {
        this.initializeVariables();
        this.createActions();
        this.createListeners();
        this.createButtons();
        this.createBusinessKeyPanel();
        this.layoutComponents();
    }

    protected void initializeVariables() {
        ITable[] targets = this.m_model.getTargetTables();
        if (targets == null || targets.length == 0) {
            return;
        }
        this.m_targetDimension = targets[0];
    }

    protected void createBusinessKeyPanel() {
        this.m_bkPanel = new WAPanel();
        if (this.m_bShowDescription) {
            this.m_bkDescription = new WATextArea();
            this.m_bkDescription.setBehavior(1);
            this.m_bkDescription.setText(bundle.getString("BusinessKeyTab.BKDesc.txt"));
            this.m_bkDescription.setAutosize(true);
        }
        this.m_bkTableModel = this.createTableModel();
        this.m_bkTable = new WsTable((WsAbstractTableModel)this.m_bkTableModel);
        this.m_bkTable.setRowHoldingEnabled(false);
        this.m_bkTable.setColumnHidingEnabled(false);
        this.m_bkTable.setColumnHoldingEnabled(false);
        this.m_bkTable.setSortingEnabled(false);
        this.m_bkTable.setRowHeaderVisible(true);
        this.m_bkTable.setRowsReorderable(true);
        this.m_bkTable.setUndoManager((UndoManager)this.waum);
        this.m_bkTable.setAutoResizeMode(4);
        this.m_bkScrPane = new JScrollPane((Component)this.m_bkTable);
        this.m_bkTable.setToolTipText(bundle.getString("BusinessKeyTab.BusKey.ToolTip.txt"));
        this.m_bkTable.getSelectionModel().setSelectionMode(2);
        this.m_bkTable.getSelectionModel().addListSelectionListener(this.m_lsnrTableSelection);
        this.m_bkTable.setTablePopupMenuRequestListener(this.createTablePopupMenuRequestListener());
        this.m_bkTable.setViewportPopupMenuRequestListener(this.createViewportPopupMenuRequestListener());
        ((WsDefaultTableRowModel)this.m_bkTable.getRowModel()).addRowModelListener((WsTableRowModelListener)this.m_lsnrTableRowModel);
        this.m_btnNewRow = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNewRow);
        this.m_btnDeleteRow = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDeleteRow);
        this.m_bkTable.getActionMap().put(this.m_actDeleteRow, (Action)this.m_actDeleteRow);
        this.m_bkTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDeleteRow);
    }

    protected void createButtons() {
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout((LayoutManager)new WsButtonsLayout(0, 2));
        this.m_btnMoveUp = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveDown);
        leftButtonPanel.add(this.m_btnMoveUp);
        leftButtonPanel.add(this.m_btnMoveDown);
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout((LayoutManager)new WsButtonsLayout(0, 4));
        this.m_btnNewRow = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNewRow);
        this.m_btnDeleteRow = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDeleteRow);
        rightButtonPanel.add(this.m_btnNewRow);
        rightButtonPanel.add(this.m_btnDeleteRow);
        this.m_btnPanel = new JPanel(new BorderLayout());
        this.m_btnPanel.add((Component)leftButtonPanel, "West");
        this.m_btnPanel.add((Component)rightButtonPanel, "East");
    }

    protected void createActions() {
        this.m_actNewRow = this.createNewRowAction();
        this.m_actDeleteRow = this.createDeleteRowAction();
        this.m_actMoveUp = this.createMoveUpAction();
        this.m_actMoveDown = this.createMoveDownAction();
    }

    protected BusinessKeyTableModel createTableModel() {
        return new BusinessKeyTableModel(this.m_model);
    }

    protected void createListeners() {
        this.m_lsnrTableSelection = this.createTableSelectionListener();
        this.m_lsnrTableRowModel = new RowModelListener();
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_bkPanel.setLayout((LayoutManager)new GridBagLayout());
        if (this.m_bShowDescription) {
            this.m_bkPanel.add((Component)this.m_bkDescription, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.m_bkPanel.add((Component)this.m_bkScrPane, (Object)new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.m_bkPanel.add((Component)this.m_btnPanel, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_bkPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        if (this.m_targetDimension == null) {
            return true;
        }
        int rowCount = this.m_bkTable.getRowCount();
        if (rowCount == 0) {
            MessageUtil.displayMessage((String)bundle.getString("BusinessKeyTab.BkErrorMessage.txt"), (int)2);
            return true;
        }
        ArrayList<IColumn> specialColumns = new ArrayList<IColumn>();
        if (this.m_model.getToDateColumn() != null) {
            specialColumns.add(this.m_model.getToDateColumn());
        }
        if (this.m_model.getLoadTimeColumn() != null) {
            specialColumns.add(this.m_model.getLoadTimeColumn());
        }
        if (this.m_model instanceof ISCDType2TransformModel) {
            if (((ISCDType2TransformModel)this.m_model).getVersionColumn() != null) {
                specialColumns.add(((ISCDType2TransformModel)this.m_model).getVersionColumn());
            }
            if (((ISCDType2TransformModel)this.m_model).getCurrentIndicatorColumn() != null) {
                specialColumns.add(((ISCDType2TransformModel)this.m_model).getCurrentIndicatorColumn());
            }
            if (((ISCDType2TransformModel)this.m_model).getGenerateKeyColumn() != null) {
                specialColumns.add(((ISCDType2TransformModel)this.m_model).getGenerateKeyColumn());
            }
            specialColumns.addAll(((ISCDType2TransformModel)this.m_model).getDigestVarsList());
            specialColumns.addAll(((ISCDType2TransformModel)this.m_model).getType1ColumnsList());
        }
        boolean hasSpecialColumn = false;
        for (int i = 0; i < rowCount; ++i) {
            IColumn column = (IColumn)this.m_bkTableModel.getValueAt(i, 2);
            if (!specialColumns.contains(column)) continue;
            hasSpecialColumn = true;
            break;
        }
        if (hasSpecialColumn) {
            MessageUtil.displayMessage((String)bundle.getString("BusinessKeyTab.BkErrorMessage2.txt"), (int)0);
            return false;
        }
        return true;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_targetDimension == null) {
            return;
        }
        this.m_bkTableModel.moveDataToModel();
        this.updateActions();
        this.setListeningForChanges(true);
    }

    public void saveSettingsAndCleanUp() {
        this.m_bkTable.getSelectionModel().removeListSelectionListener(this.m_lsnrTableSelection);
        ((WsDefaultTableRowModel)this.m_bkTable.getRowModel()).removeRowModelListener((WsTableRowModelListener)this.m_lsnrTableRowModel);
        this.m_bkTableModel.dispose();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNewRow.setActive(bActive);
        this.m_actDeleteRow.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateActions();
    }

    public void setTextDescription(String text) {
        this.m_bkDescription.setText(text);
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected WsPopupMenuRequestListener createTablePopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createViewportPopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected WsAbstractAction createNewRowAction() {
        return new cNewRowAction();
    }

    protected WsAbstractAction createDeleteRowAction() {
        return new cDeleteRowAction();
    }

    protected WsAbstractAction createMoveUpAction() {
        return new MoveUpAction();
    }

    protected WsAbstractAction createMoveDownAction() {
        return new MoveDownAction();
    }

    protected void updateActions() {
        int[] selectedRows = this.m_bkTable.getSelectedRowsFromSelectedCells();
        boolean editable = this.isEditable();
        boolean selected = selectedRows.length > 0;
        boolean firstRowSelected = false;
        boolean lastRowSelected = false;
        boolean rowsReorderable = this.m_bkTable.isRowsReorderable();
        boolean hasTarget = this.m_targetDimension != null;
        for (int i = 0; i < selectedRows.length; ++i) {
            if (selectedRows[i] == 0) {
                firstRowSelected = true;
            }
            if (selectedRows[i] != this.m_bkTable.getRowCount() - 1) continue;
            lastRowSelected = true;
        }
        this.m_actNewRow.setEnabled(editable && hasTarget);
        this.m_actDeleteRow.setEnabled(editable && selected);
        this.m_actMoveUp.setEnabled(editable && hasTarget && selected && !firstRowSelected && rowsReorderable);
        this.m_actMoveDown.setEnabled(editable && hasTarget && selected && !lastRowSelected && rowsReorderable);
    }

    protected List findSpecialColumnsList(ClassifierMap clsMap, DataTable table) {
        ArrayList<Object> specCols = new ArrayList<Object>();
        try {
            Column loadCol;
            OptionsPropertyHandler OP;
            String option;
            String loadTime;
            AssociationList alCols;
            AssociationList alTblCols = table.getColumns();
            Key key = SCDType2Utilities.findLogicalKey((DataTable)table, (String)"GENERATED_KEY");
            if (key != null && (alCols = key.getKeyedColumns()).size() > 0) {
                specCols.add(alCols.get(0));
            }
            if ((loadTime = (option = (OP = new OptionsPropertyHandler((Root)clsMap)).getOptionsString("LoadTime")).substring(option.indexOf("=") + 1)).length() > 0) {
                loadCol = SCDType2Utilities.findMetadataColumnFromName((DataTable)table, (String)loadTime);
                if (loadCol != null) {
                    specCols.add(loadCol);
                }
            } else {
                loadCol = SCDType2Utilities.findLoadTimeColumn((List)alTblCols);
                if (loadCol != null) {
                    specCols.add(loadCol);
                }
            }
            int type = SCDType2Utilities.findSCD2MethodBeingRequested((ClassifierMap)clsMap);
            if (type == 0) {
                FeatureMap fM = SCDType2Utilities.findFeatureMapByRole((ClassifierMap)clsMap, (String)"SCD2_FROMDATE");
                if (fM != null && !fM.getFeatureTargets().isEmpty()) {
                    specCols.add(fM.getFeatureTargets().get(0));
                }
                if ((fM = SCDType2Utilities.findFeatureMapByRole((ClassifierMap)clsMap, (String)"SCD2_TODATE")) != null && !fM.getFeatureTargets().isEmpty()) {
                    specCols.add(fM.getFeatureTargets().get(0));
                }
            } else if (type == 2) {
                FeatureMap fM = SCDType2Utilities.findFeatureMapByRole((ClassifierMap)clsMap, (String)"SCD2_CurrentIndicator");
                if (fM != null && !fM.getFeatureTargets().isEmpty()) {
                    specCols.add(fM.getFeatureTargets().get(0));
                }
            } else {
                FeatureMap fM = SCDType2Utilities.findFeatureMapByRole((ClassifierMap)clsMap, (String)"SCD2_Version");
                if (fM != null && !fM.getFeatureTargets().isEmpty()) {
                    specCols.add(fM.getFeatureTargets().get(0));
                }
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return specCols;
    }

    public IColumn[] promptForColumnsToAdd() {
        String title = bundle.formatString("BusinessKeyTab.NewDialog.Title.txt", (Object)this.m_targetDimension.getName());
        ColumnSelectorPanel colSelector = new ColumnSelectorPanel(this.m_targetDimension, bundle.getString("BusinessKeyTab.NewDialog.Desc.txt"), true);
        List columns = this.m_model.getBusinessKeyColumnsList();
        colSelector.hideColumns(columns);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), title, true, (WAPanel)colSelector);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return colSelector.getSelectedColumns();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumns(IColumn[] columns) {
        this.m_model.getModel().startCompoundUndoable();
        List keyColumns = this.m_model.getBusinessKeyColumnsList();
        try {
            int row = this.m_bkTable.getLastSelectedRow();
            int columnIndex = row == -1 ? keyColumns.size() - 1 : keyColumns.indexOf(this.m_bkTableModel.getColumnForRow(row));
            this.m_bkTable.clearSelection();
            this.m_model.getModel().undoableEditHappened(this.m_bkTable.createClearSelectionUndoable(true, false));
            ArrayList<ColumnItem> duplicates = new ArrayList<ColumnItem>();
            List existingColumns = this.m_model.getBusinessKeyColumnsList();
            for (int i = 0; i < columns.length; ++i) {
                if (existingColumns.contains(columns[i])) {
                    duplicates.add(new ColumnItem(columns[i]));
                    continue;
                }
                this.m_model.addBusinessKeyColumn(++columnIndex, columns[i]);
            }
            this.m_bkTable.selectRows(row + 1, row + columns.length);
            this.m_model.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(columns, false, true));
            if (duplicates.size() > 0) {
                String sMessage = bundle.getString("BusinessKeyTab.DuplicateColumnsRemovedWarning.txt");
                MessageUtil.displayListMessage((String)sMessage, duplicates);
            }
            this.updateActions();
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveColumn(int from, int to) {
        if (!this.m_bkTable.stopCellEditing()) {
            return;
        }
        this.m_model.getModel().startCompoundUndoable();
        try {
            this.m_bkTable.clearSelection();
            IColumn column = this.m_bkTableModel.getColumnForRow(from);
            this.m_model.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(column, true, false));
            ((ModelList)this.m_model.getBusinessKeyColumnsList()).move((Object)column, to);
            this.m_bkTable.selectRow(to);
            this.m_model.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(column, false, true));
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedColumns(int direction) {
        if (direction != 0 && direction != 1) {
            throw new IllegalArgumentException("Direction must be UP or DOWN but is: " + direction);
        }
        if (!this.m_bkTable.stopCellEditing()) {
            return;
        }
        this.m_model.getModel().startCompoundUndoable();
        try {
            int i;
            int[] rows = this.m_bkTable.getSelectedRowsFromSelectedCells();
            IColumn[] columns = new IColumn[rows.length];
            for (i = 0; i < rows.length; ++i) {
                columns[i] = this.m_bkTableModel.getColumnForRow(rows[i]);
            }
            this.m_model.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(columns, true, false));
            if (direction == 1) {
                for (i = rows.length - 1; i >= 0; --i) {
                    ((ModelList)this.m_model.getBusinessKeyColumnsList()).move((Object)columns[i], rows[i] + 1);
                }
            } else {
                for (i = 0; i < rows.length; ++i) {
                    ((ModelList)this.m_model.getBusinessKeyColumnsList()).move((Object)columns[i], rows[i] - 1);
                }
            }
            this.selectColumns(columns);
            this.m_model.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(columns, false, true));
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedColumns() {
        int i;
        if (!this.m_bkTable.stopCellEditing()) {
            return;
        }
        int[] rows = this.m_bkTable.getSelectedRowsFromSelectedCells();
        IColumn[] columns = new IColumn[rows.length];
        for (i = 0; i < rows.length; ++i) {
            int modelRow = this.m_bkTable.convertRowIndexToModel(rows[i]);
            columns[i] = this.m_bkTableModel.getColumnForRow(modelRow);
        }
        this.m_model.getModel().startCompoundUndoable();
        try {
            this.m_model.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(columns, true, false));
            for (i = 0; i < columns.length; ++i) {
                this.m_model.removeBusinessKeyColumn(columns[i]);
            }
            this.m_model.getModel().undoableEditHappened(this.m_bkTable.createClearSelectionUndoable(true, true));
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
        int row = Math.min(rows[rows.length - 1] - (rows.length - 1), this.m_bkTable.getRowCount() - 1);
        if (row >= 0) {
            this.m_bkTable.selectRow(row);
        }
    }

    private void selectColumns(IColumn[] columns) {
        this.m_bkTable.clearSelection();
        for (int i = 0; i < columns.length; ++i) {
            int row = this.m_bkTableModel.getRowIndex(columns[i]);
            if (row == -1) continue;
            this.m_bkTable.addRowToSelection(this.m_bkTable.convertRowIndexToView(row));
        }
    }

    private class SelectColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn[] m_aColumns;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectColumnsUndoable(IColumn column, boolean bOnUndo, boolean bOnRedo) {
            this(new IColumn[]{column}, bOnUndo, bOnRedo);
        }

        public SelectColumnsUndoable(IColumn[] aColumns, boolean bOnUndo, boolean bOnRedo) {
            this.m_aColumns = aColumns;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                BusinessKeyTab.this.selectColumns(this.m_aColumns);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                BusinessKeyTab.this.selectColumns(this.m_aColumns);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aColumns, null);
            this.m_aColumns = null;
        }
    }

    private class RowModelListener
    implements WsTableRowModelListener {
        private RowModelListener() {
        }

        public void rowDragged(TableRowModelEvent event) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)BusinessKeyTab.this.m_bkTable.getRowModel();
            mdlRows.clearRowMoves();
            BusinessKeyTab.this.moveColumn(event.getFromIndex(), event.getToIndex());
        }

        public void rowsRemapped(ChangeEvent ev) {
            BusinessKeyTab.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    public class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)BusinessKeyTab.this.m_actNewRow));
            mnuPopup.add(new JMenuItem((Action)BusinessKeyTab.this.m_actDeleteRow));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            BusinessKeyTab.this.updateActions();
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "BusinessKeyTab.Action.MoveDown", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessKeyTab.this.moveSelectedColumns(1);
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "BusinessKeyTab.Action.MoveUp", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        public void actionPerformed(ActionEvent event) {
            BusinessKeyTab.this.moveSelectedColumns(0);
        }
    }

    protected class cDeleteRowAction
    extends WsAbstractAction {
        public cDeleteRowAction() {
            super(bundle, "BusinessKeyTab.Delete", false);
        }

        public void actionPerformed(ActionEvent e) {
            BusinessKeyTab.this.deleteSelectedColumns();
            BusinessKeyTab.this.updateActions();
        }
    }

    protected class cNewRowAction
    extends WsAbstractAction {
        public cNewRowAction() {
            super(bundle, "BusinessKeyTab.New", false);
        }

        public void actionPerformed(ActionEvent e) {
            IColumn[] columns = BusinessKeyTab.this.promptForColumnsToAdd();
            if (columns != null && columns.length > 0) {
                BusinessKeyTab.this.addColumns(columns);
            }
        }
    }
}

