/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.rank;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.job.transforms.rank.RankTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.wadmin.transforms.rank.SASRankVariablesPropertyTab;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;

public class SASRankVariablesPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(SASRankVariablesPanel.class);
    protected RankTransformModel m_RankTransformModel;
    protected WAPanel varColumnsPanel;
    protected WAPanel rankColumnsPanel;
    protected DoubleListSelector varList;
    protected DoubleListSelector rankList;
    protected CollectionToListModelAdapter varSourceModel;
    protected CollectionToListModelAdapter varTargetModel;
    protected ArrayList allSourceNumericColumns;
    protected ArrayList allSelectedVarNumericColumns;
    protected CollectionToListModelAdapter rankSourceModel;
    protected CollectionToListModelAdapter rankTargetModel;
    protected ArrayList allTargetNumericColumns;
    protected ArrayList allSelectedRankNumericColumns;
    SASRankVariablesPropertyTab parentTab = null;
    static final int TYPE_CHARACTER = 0;
    static final int TYPE_NUMERIC = 1;
    static final int VAR = 0;
    static final int RANK = 1;
    protected boolean bColumnMoved = false;

    public SASRankVariablesPanel(RankTransformModel rankTransformModel) {
        this.m_RankTransformModel = rankTransformModel;
        this.initialize();
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    public void populateStore() {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
        this.setListeningForChanges(true);
    }

    public void moveDataToView() throws RemoteException {
        this.setListeningForChanges(false);
        this.populateVarColumns();
        this.populateRankColumns();
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.varList.setEnabled(bEditable);
        this.rankList.setEnabled(bEditable);
    }

    public void setStorePopulated(boolean bStorePopulated) {
        super.setStorePopulated(bStorePopulated);
    }

    public boolean validateData() {
        int varSize = this.varList.getTargetModel().getSize();
        int rankSize = this.rankList.getTargetModel().getSize();
        if (varSize > 0 && rankSize == 0) {
            int choice = JOptionPane.showConfirmDialog((Component)((Object)this), bundle.getString("SASRankVariablesPanel.NoRankColumns.msg"), bundle.getString("SASRankVariablesPanel.NoRankColumns.Title.msg"), 2, 2);
            switch (choice) {
                case 0: {
                    break;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
                default: {
                    return true;
                }
            }
        }
        if (varSize != rankSize && rankSize > 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), bundle.getString("SASRankVariablesPanel.UnequalVarRankColumns.msg"), bundle.getString("SASRankVariablesPanel.UnequalVarRankColumns.Title.msg"), 0);
            return false;
        }
        if (this.isColumnMoved()) {
            this.m_RankTransformModel.removeRankMappings();
            ListModel varModel = this.varList.getTargetModel();
            ListModel rankModel = this.rankList.getTargetModel();
            for (int iColumn = 0; iColumn < varSize; ++iColumn) {
                if (rankModel.getSize() - 1 < iColumn || rankModel.getSize() - 1 < iColumn) continue;
                this.m_RankTransformModel.addRankMapping((IColumn)varModel.getElementAt(iColumn), (IColumn)rankModel.getElementAt(iColumn));
            }
        }
        return true;
    }

    public boolean isColumnMoved() {
        return this.bColumnMoved;
    }

    public void setColumnMoved(boolean bMoved) {
        this.bColumnMoved = bMoved;
    }

    public void initialize() {
        try {
            this.allSelectedVarNumericColumns = new ArrayList();
            this.allSelectedRankNumericColumns = new ArrayList();
            this.varColumnsPanel = new WAPanel();
            this.varColumnsPanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
            this.varList = new DoubleListSelector(0);
            this.varList.setTargetControlsVisible(false);
            this.varList.setDragAndDropEnabled(false);
            this.varList.getSourceComponent().setToolTipText(bundle.getString("SASRankVariablesPanel.Varcolumns.SourceList.ToolTip.txt"));
            this.varList.getTargetComponent().setToolTipText(bundle.getString("SASRankVariablesPanel.Varcolumns.TargetList.ToolTip.txt"));
            this.varList.setRightButtonToolTipText(bundle.getString("SASRankVariablesPanel.Varcolumns.RightButton.ToolTip.txt"));
            this.varList.setAllRightButtonToolTipText(bundle.getString("SASRankVariablesPanel.Varcolumns.AllRightButton.ToolTip.txt"));
            this.varList.setLeftButtonToolTipText(bundle.getString("SASRankVariablesPanel.Varcolumns.LeftButton.ToolTip.txt"));
            this.varList.setAllLeftButtonToolTipText(bundle.getString("SASRankVariablesPanel.Varcolumns.AllLeftButton.ToolTip.txt"));
            this.varList.setSourceLabel(bundle.getString("SASRankVariablesPanel.Varcolumns.Source.Label.txt"));
            this.varList.setTargetLabel(bundle.getString("SASRankVariablesPanel.Varcolumns.Target.Label.txt"));
            this.varList.setSourceLabelMnemonic(bundle.getString("SASRankVariablesPanel.Varcolumns.Source.Label.mnem"));
            this.varList.setTargetLabelMnemonic(bundle.getString("SASRankVariablesPanel.Varcolumns.Target.Label.mnem"));
            this.varList.setAlternatingSingleButtonStyle(false);
            this.varList.setAlternatingMultipleButtonStyle(false);
            this.rankColumnsPanel = new WAPanel();
            this.rankColumnsPanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
            this.rankList = new DoubleListSelector(1);
            this.rankList.setTargetControlsVisible(false);
            this.rankList.setDragAndDropEnabled(false);
            this.rankList.getSourceComponent().setToolTipText(bundle.getString("SASRankVariablesPanel.Rankcolumns.SourceList.ToolTip.txt"));
            this.rankList.getTargetComponent().setToolTipText(bundle.getString("SASRankVariablesPanel.Rankcolumns.TargetList.ToolTip.txt"));
            this.rankList.setRightButtonToolTipText(bundle.getString("SASRankVariablesPanel.Rankcolumns.RightButton.ToolTip.txt"));
            this.rankList.setAllRightButtonToolTipText(bundle.getString("SASRankVariablesPanel.Rankcolumns.AllRightButton.ToolTip.txt"));
            this.rankList.setLeftButtonToolTipText(bundle.getString("SASRankVariablesPanel.Rankcolumns.LeftButton.ToolTip.txt"));
            this.rankList.setAllLeftButtonToolTipText(bundle.getString("SASRankVariablesPanel.Rankcolumns.AllLeftButton.ToolTip.txt"));
            this.rankList.setSourceLabel(bundle.getString("SASRankVariablesPanel.Rankcolumns.Source.Label.txt"));
            this.rankList.setTargetLabel(bundle.getString("SASRankVariablesPanel.Rankcolumns.Target.Label.txt"));
            this.rankList.setSourceLabelMnemonic(bundle.getString("SASRankVariablesPanel.Rankcolumns.Source.Label.mnem"));
            this.rankList.setTargetLabelMnemonic(bundle.getString("SASRankVariablesPanel.Rankcolumns.Target.Label.mnem"));
            this.rankList.setAlternatingSingleButtonStyle(false);
            this.rankList.setAlternatingMultipleButtonStyle(false);
            this.varList.setSourceCellRenderer(new cListCellRenderer());
            this.varList.setTargetCellRenderer(new cListCellRenderer());
            this.rankList.setSourceCellRenderer(new cListCellRenderer());
            this.rankList.setTargetCellRenderer(new cListCellRenderer());
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this), e.toString(), "", 0);
        }
    }

    protected void layoutWidgets() {
        this.varColumnsPanel.setLayout((LayoutManager)new GridBagLayout());
        this.varColumnsPanel.add((Component)((Object)this.varList), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.rankColumnsPanel.setLayout((LayoutManager)new GridBagLayout());
        this.rankColumnsPanel.add((Component)((Object)this.rankList), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.varColumnsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rankColumnsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void populateVarColumns() {
        this.allSourceNumericColumns = new ArrayList();
        this.varTargetModel = new CollectionToListModelAdapter();
        this.varSourceModel = new CollectionToListModelAdapter();
        IColumn[] aISourceColumn = this.m_RankTransformModel.getSourceNumericColumns();
        for (int i = 0; i < aISourceColumn.length; ++i) {
            this.allSourceNumericColumns.add(aISourceColumn[i]);
        }
        this.allSelectedVarNumericColumns.clear();
        IColumn[] aITargetColumn = this.m_RankTransformModel.getSelectedVarNumericColumns();
        for (int i = 0; i < aITargetColumn.length; ++i) {
            this.allSelectedVarNumericColumns.add(aITargetColumn[i]);
            this.allSourceNumericColumns.remove(aITargetColumn[i]);
        }
        this.varSourceModel.setModel((Collection)this.allSourceNumericColumns);
        this.varList.setModel((ListModel)this.varSourceModel);
        this.varTargetModel.setModel((Collection)this.allSelectedVarNumericColumns);
        this.varList.setTargetModel((ListModel)this.varTargetModel);
    }

    protected void populateRankColumns() {
        this.rankTargetModel = new CollectionToListModelAdapter();
        this.rankSourceModel = new CollectionToListModelAdapter();
        this.allTargetNumericColumns = new ArrayList();
        IColumn[] aISourceColumn = this.m_RankTransformModel.getTargetNumericColumns();
        for (int i = 0; i < aISourceColumn.length; ++i) {
            this.allTargetNumericColumns.add(aISourceColumn[i]);
        }
        this.allSelectedRankNumericColumns.clear();
        IColumn[] aITargetColumn = this.m_RankTransformModel.getSelectedRankNumericColumns();
        for (int i = 0; i < aITargetColumn.length; ++i) {
            this.allSelectedRankNumericColumns.add(aITargetColumn[i]);
            this.allTargetNumericColumns.remove(aITargetColumn[i]);
        }
        this.rankSourceModel.setModel((Collection)this.allTargetNumericColumns);
        this.rankList.setModel((ListModel)this.rankSourceModel);
        this.rankTargetModel.setModel((Collection)this.allSelectedRankNumericColumns);
        this.rankList.setTargetModel((ListModel)this.rankTargetModel);
    }

    public class cListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int iRow, boolean bSelected, boolean bHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, iRow, bSelected, bHasFocus);
            if (value instanceof IColumn) {
                IColumn oColumn = (IColumn)value;
                this.setIcon(ColumnUIUtilities.getTypeIcon(oColumn));
                this.setText(oColumn.getName());
            }
            return this;
        }
    }

    private class DoubleListSelector
    extends DualListSelector {
        int m_modelID;

        public DoubleListSelector(int iID) {
            this.setModelID(iID);
            this.sourceLabel.setLabelFor(this.sourceJList);
            this.targetLabel.setLabelFor(this.targetJList);
        }

        public void setModelID(int iID) {
            this.m_modelID = iID;
        }

        public int getModelID() {
            return this.m_modelID;
        }

        public void setRightButtonToolTipText(String tooltip) {
            this.rightButton.setToolTipText(tooltip);
        }

        public void setAllRightButtonToolTipText(String tooltip) {
            this.allRightButton.setToolTipText(tooltip);
        }

        public void setLeftButtonToolTipText(String tooltip) {
            this.leftButton.setToolTipText(tooltip);
        }

        public void setAllLeftButtonToolTipText(String tooltip) {
            this.allLeftButton.setToolTipText(tooltip);
        }

        public void setSourceLabelMnemonic(String mnemonic) {
            this.sourceLabel.setDisplayedMnemonic(mnemonic.charAt(0));
        }

        public void setTargetLabelMnemonic(String mnemonic) {
            this.targetLabel.setDisplayedMnemonic(mnemonic.charAt(0));
        }

        protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List passedItems) {
            super.transferItems(fromAdapter, toAdapter, passedItems);
            SASRankVariablesPanel.this.setColumnMoved(true);
        }

        protected synchronized void transferAllItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            super.transferAllItems(fromAdapter, toAdapter);
            SASRankVariablesPanel.this.setColumnMoved(true);
        }
    }
}

