/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.transforms.queues.QueueModel;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.impl.MetadataConnectionManager;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class QueueUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(QueueUtil.class);
    public static final String SASFILEEXTENSION = ".sas7bdat";
    public static final String QUEUE_PROPERTYSET_NAME = "queue";
    public static final String QUEUE_FMT_DEFAULT_LENGTH = "30";
    public static final String QUEUE_MESSAGE_TYPE = "ETLS_QCOL_TYPE";
    public static final String QUEUE_MESSAGE_LENGTH = "ETLS_QCOL_LENGTH";
    public static final String QUEUE_MESSAGE_FORMAT = "ETLS_QCOL_FORMAT";
    public static final String QUEUE_READER_WORK_TABLE = "Queue Reader Work Table";
    public static final String QUEUE_TABLE_ROLE_NAME = "SPECQUEUE";
    public static final String ETLS_MESSAGE_MACRO_VARIABLE = "etls_msg";
    private static final char[] HexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static WsAppServer getWsAppServerForDataTable(DataTable dataTable) throws ViewDataException {
        WsAppServer wsAppServer = null;
        MetadataConnectionManager metadataConnectionManager = new MetadataConnectionManager(dataTable);
        metadataConnectionManager.init();
        wsAppServer = metadataConnectionManager.getAppServer();
        return wsAppServer;
    }

    public static String getTableName(DataTable dataTable) throws MdException, RemoteException, ViewDataException {
        String libref = QueueUtil.getLibRef(dataTable);
        if (libref == null) {
            MessageUtil.displayMessage((String)bundle.getString("QueueUtil.LibraryFetchFail.txt"), (int)0);
        }
        if (dataTable instanceof WorkTable) {
            return libref + "." + ((WorkTable)dataTable).getSASTableName();
        }
        if (dataTable instanceof PhysicalTable) {
            return libref + "." + ((PhysicalTable)dataTable).getSASTableName();
        }
        return libref + "." + dataTable.getTableName();
    }

    protected static String getLibRef(DataTable dataTable) throws MdException, RemoteException, ViewDataException {
        SASLibrary library = QueueUtil.getLibrary(dataTable);
        if (library != null) {
            return library.getLibref();
        }
        return null;
    }

    public static SASLibrary getLibrary(DataTable dataTable) throws MdException, RemoteException, ViewDataException {
        WsAppServer appServer = QueueUtil.getWsAppServerForDataTable(dataTable);
        ServerContext iDefault = appServer.getServerContext();
        SASLibrary iLib = LibraryUtil.getLibrary((DataTable)dataTable, (ServerContext)iDefault);
        if (iLib == null) {
            return null;
        }
        return LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)iDefault);
    }

    public static String getTableName(DataTable dataTable, WsAppServer wsAppServer) throws MdException, RemoteException {
        String libref = QueueUtil.getLibRef(dataTable, wsAppServer);
        if (libref == null) {
            MessageUtil.displayMessage((String)bundle.getString("QueueUtil.LibraryFetchFail.txt"), (int)0);
        }
        if (wsAppServer == null) {
            return null;
        }
        if (dataTable instanceof PhysicalTable) {
            return libref + "." + ((PhysicalTable)dataTable).getSASTableName();
        }
        if (dataTable instanceof WorkTable) {
            return libref + "." + ((WorkTable)dataTable).getSASTableName();
        }
        return null;
    }

    protected static String getLibRef(DataTable dataTable, WsAppServer wsAppServer) throws MdException, RemoteException {
        SASLibrary library = QueueUtil.getLibrary(dataTable, wsAppServer);
        if (library != null) {
            return library.getLibref();
        }
        return null;
    }

    public static SASLibrary getLibrary(DataTable dataTable, WsAppServer wsAppServer) throws MdException, RemoteException {
        ServerContext iDefault = wsAppServer.getServerContext();
        SASLibrary iLib = LibraryUtil.getLibrary((DataTable)dataTable, (ServerContext)iDefault);
        if (iLib == null) {
            return null;
        }
        return LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)iDefault);
    }

    public static String[] getQueue(TransformationStep transformationStep, boolean qWriter) {
        String[] queueDetails = new String[]{"", "", "", ""};
        try {
            AssociationList alTransformations = null;
            alTransformations = qWriter ? transformationStep.getSourceTransformations() : transformationStep.getTargetTransformations();
            if (alTransformations.size() > 0) {
                Transformation transformation = (Transformation)alTransformations.get(0);
                queueDetails[0] = transformation.getName();
                AssociationList properties = transformation.getProperties();
                if (properties.size() > 0) {
                    queueDetails[1] = ((Property)properties.get(0)).getDefaultValue();
                }
                if (queueDetails[1].length() == 0) {
                    queueDetails[1] = ((DeployedComponent)transformation.getDeployedComponents().get(0)).getName();
                }
            }
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return queueDetails;
    }

    public static String[] getQueue(ClassifierMap classifierMap, boolean qWriter) throws MdException, RemoteException {
        AssociationList list = classifierMap.getSteps();
        TransformationStep transformationStep = null;
        if (list.size() > 0 && list.get(0) instanceof TransformationStep) {
            transformationStep = (TransformationStep)list.get(0);
        }
        return QueueUtil.getQueue(transformationStep, qWriter);
    }

    public static boolean hasQueue(ClassifierMap classifierMap, boolean qWriter) throws MdException, RemoteException {
        String[] sArray;
        AssociationList list = classifierMap.getSteps();
        TransformationStep transformationStep = null;
        if (list.size() > 0 && list.get(0) instanceof TransformationStep) {
            transformationStep = (TransformationStep)list.get(0);
        }
        return (sArray = QueueUtil.getQueue(transformationStep, qWriter))[0].length() != 0;
    }

    public static DataTable getWriterSourceTable(TransformationStep transformationStep) throws MdException, RemoteException {
        AssociationList alTransformations = transformationStep.getTransformations();
        if (alTransformations.size() > 0) {
            ClassifierMap classifierMap = (ClassifierMap)alTransformations.get(0);
            AssociationList alClassifierSources = classifierMap.getClassifierSources();
            for (int classifierSource = 0; classifierSource < alClassifierSources.size(); ++classifierSource) {
                if (!(alClassifierSources.get(classifierSource) instanceof DataTable)) continue;
                return (DataTable)alClassifierSources.get(classifierSource);
            }
        }
        return null;
    }

    public static DataTable getReaderTargetTable(TransformationStep transformationStep) throws MdException, RemoteException {
        ClassifierMap classifierMap;
        AssociationList alLoadTable;
        AssociationList alTransformations = transformationStep.getTransformations();
        if (alTransformations.size() > 0 && alTransformations.size() > 0 && (alLoadTable = (classifierMap = (ClassifierMap)alTransformations.get(0)).getClassifierTargets()).size() > 0) {
            return (DataTable)alLoadTable.get(0);
        }
        return null;
    }

    public static String escapeMacroValue(String string) {
        if (!string.startsWith("%str(")) {
            string = string.replaceAll("%", "%%").replaceAll("'", "%'").replaceAll("\"", "%\"").replaceAll("[(]", "%(").replaceAll("[)]", "%)");
        }
        return string;
    }

    public static void textMessageToMacroVariable(CodegenRequest cgReq, QueueModel model) {
        String messageContent = model.getTextContent().toString();
        boolean bHasMacroVar = false;
        if (messageContent.indexOf("&") >= 0) {
            bHasMacroVar = true;
        }
        int iLength = messageContent.length();
        int iSplitLength = 80;
        int iNum = iLength / iSplitLength + 1;
        int startPosn = 0;
        int endPosn = iSplitLength;
        cgReq.addSourceCode("%let ");
        cgReq.addSourceCode(ETLS_MESSAGE_MACRO_VARIABLE);
        cgReq.addSourceCode("=;\n");
        for (int i = 0; i < iNum; ++i) {
            if (endPosn > iLength) {
                endPosn = iLength;
            }
            cgReq.addSourceCode("%let etls_tmp");
            cgReq.addSourceCode(Integer.toString(i));
            cgReq.addSourceCode("=");
            cgReq.addSourceCode("%nrstr(");
            String sThisLine = QueueUtil.escapeMacroValue(messageContent.substring(startPosn, endPosn));
            cgReq.addSourceCode(sThisLine);
            cgReq.addSourceCode(");\n");
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(ETLS_MESSAGE_MACRO_VARIABLE);
            cgReq.addSourceCode("=&");
            cgReq.addSourceCode(ETLS_MESSAGE_MACRO_VARIABLE);
            cgReq.addSourceCode("&etls_tmp");
            cgReq.addSourceCode(Integer.toString(i));
            cgReq.addSourceCode(";\n\n");
            endPosn = (startPosn += iSplitLength) + iSplitLength;
        }
        if (bHasMacroVar) {
            cgReq.addSourceCode("data _null_;\n");
            cgReq.addSourceCode("etls_m01=resolve(\"&etls_msg\");\n");
            cgReq.addSourceCode("call symput('etls_msg', etls_m01);\n");
            cgReq.addSourceCode("run;\n");
        }
    }

    public static String getMessageColumnFormat(Column oColumn) throws MdException, RemoteException {
        String[] queueColumnFormats = QueueUtil.getColumnMessageFormats(oColumn);
        return queueColumnFormats[2];
    }

    protected static List buildMessageColumnsList(DataTable dataSourceTable) throws MdException, RemoteException {
        AssociationList alColumns = dataSourceTable.getColumns();
        ArrayList<String[]> messageList = new ArrayList<String[]>(alColumns.size());
        for (int i = 0; i < alColumns.size(); ++i) {
            Column queueColumn = (Column)alColumns.get(i);
            String queueColumnName = queueColumn.getName();
            String queueColumnFormat = queueColumn.getSASFormat();
            String queueColumnInformat = queueColumn.getSASInformat();
            String queueColumnType = queueColumn.getSASColumnType();
            String[] mqFormats = QueueUtil.getColumnMessageFormats(queueColumn);
            String mqFormat = mqFormats[2];
            String mqLength = mqFormats[1];
            String mqType = mqFormats[0];
            messageList.add(i, new String[]{queueColumnName, mqFormat, mqLength, mqType, queueColumnFormat, queueColumnInformat, queueColumnType});
        }
        return messageList;
    }

    public static final String toHexString(long value, int len, char pad) {
        StringBuffer sb = new StringBuffer(Long.toHexString(value));
        int npad = len - sb.length();
        while (npad-- > 0) {
            sb.insert(0, pad);
        }
        return new String(sb);
    }

    public static final String toHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(HexChars[bytes[i] >> 4 & 0xF]);
            sb.append(HexChars[bytes[i] & 0xF]);
        }
        return new String(sb);
    }

    public static final String toHexString(String sToConvert) {
        return QueueUtil.toHexString(sToConvert.getBytes());
    }

    public static final String toHexString(String sToConvert, int iLength) {
        StringBuffer sb = new StringBuffer(sToConvert);
        if (sb.length() > iLength) {
            return QueueUtil.toHexString(sb.substring(0, iLength).getBytes());
        }
        for (int i = sb.length(); i < iLength; ++i) {
            sb.append(" ");
        }
        return QueueUtil.toHexString(sb.toString().getBytes());
    }

    public static PropertyHandler getMessagePropertyHandler(Column oColumn) throws MdException, RemoteException {
        return new PropertyHandler((Root)oColumn, QUEUE_PROPERTYSET_NAME, true);
    }

    public static boolean hasMessageProperties(Column oColumn) throws MdException, RemoteException {
        PropertyHandler propertyHandler = QueueUtil.getMessagePropertyHandler(oColumn);
        AssociationList list = propertyHandler.getPropertyList();
        return list != null && list.size() != 0;
    }

    public static void addMessagePropertiesToColumn(Column oColumn, String sColWidth) throws MdException, RemoteException {
        QueueUtil.addMessagePropertiesToColumn(oColumn, "CHAR", sColWidth, "CHAR,," + sColWidth);
    }

    public static void addMessagePropertiesToColumn(Column oColumn, String sType, String sColWidth, String sFormat) throws MdException, RemoteException {
        PropertyHandler propertyHandler = QueueUtil.getMessagePropertyHandler(oColumn);
        PropertySet propertySet = propertyHandler.getPropertySet();
        if (propertySet == null) {
            propertyHandler.createPropertySet();
        }
        propertyHandler.setSpecificProperty(QUEUE_MESSAGE_TYPE, sType);
        propertyHandler.setSpecificProperty(QUEUE_MESSAGE_LENGTH, sColWidth);
        propertyHandler.setSpecificProperty(QUEUE_MESSAGE_FORMAT, sFormat);
    }

    public static PropertySet getMessagePropertySet(Column oColumn) throws MdException, RemoteException {
        return QueueUtil.getMessagePropertyHandler(oColumn).getPropertySet();
    }

    public static String[] getColumnMessageFormats(Column oColumn) throws MdException, RemoteException {
        if (!QueueUtil.hasMessageProperties(oColumn) && Workspace.getWorkspace().isObjectEditable((CMetadata)oColumn.getTable())) {
            QueueUtil.addMessagePropertiesToColumn(oColumn, Integer.toString(oColumn.getSASColumnLength()));
        }
        String[] queueColumnFormats = new String[]{"", "", "", ""};
        PropertyHandler propertyHandler = QueueUtil.getMessagePropertyHandler(oColumn);
        if (!QueueUtil.hasMessageProperties(oColumn)) {
            queueColumnFormats[0] = "CHAR";
            queueColumnFormats[1] = Integer.toString(oColumn.getSASColumnLength());
            queueColumnFormats[2] = queueColumnFormats[0] + ",," + queueColumnFormats[1];
        } else {
            queueColumnFormats[0] = propertyHandler.getSpecificProperty(QUEUE_MESSAGE_TYPE).getDefaultValue();
            if (propertyHandler.getSpecificProperty(QUEUE_MESSAGE_LENGTH) != null) {
                queueColumnFormats[1] = propertyHandler.getSpecificProperty(QUEUE_MESSAGE_LENGTH).getDefaultValue();
            }
            queueColumnFormats[2] = propertyHandler.getSpecificProperty(QUEUE_MESSAGE_FORMAT).getDefaultValue();
        }
        return queueColumnFormats;
    }
}

