/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class QueueModel {
    protected static final String STOREDTEXT = "STOREDTEXT";
    protected static final String SAVEHEADER = "SAVEHEADER";
    protected static final String DIRECTORY = "DIRECTORY";
    protected static final String SASMESSAGEQUEUE = "SASMessageQueue";
    protected static final String QOPTIONS_SET = "QOPTIONS_SET";
    protected static final String COMMA = ",";
    protected static final String QMACRO_OPTIONS_SET = "MACROOPTIONS";
    protected static final String QTYPE = "QTYPE";
    protected static final String FILE = "FILE";
    protected static final String TABLE = "TABLE";
    protected static final String TEXT = "TEXT";
    protected static final String FNAME = "FNAME";
    protected static final String MSGLEN = "MSGLEN";
    protected static final String TXTCONTENT = "TXTCONTENT";
    protected static final String ETLS_MSG_TEXT = "ETLS_MSG_TEXT";
    protected static final String YES = "YES";
    protected static final String NO = "NO";
    protected static final String MSGHEADERTABLE = "Q_MSG_HEADER_TABLE";
    protected static final String MACROVARIABLE = "MACROVARIABLE";
    protected static final String QOPTIONS = "QOPTIONS";
    protected static final String QUOTE = "\"";
    private PropertyHandler m_propertyHandlerQ_Options;
    private PropertyHandler m_propertyHandlerQ_MacroOptions;
    private TransformationStep m_transformStep;
    private boolean m_textMessage;
    private boolean m_fileMessage;
    private boolean m_tableMessage;
    private int m_messageLength;
    private List m_columnList;
    private String m_textContent;
    private String m_fileName;
    private MdObjectStore m_store;
    private ClassifierMap m_classifierMap;
    private String m_repository;
    private PhysicalTable m_msgHeaderTable;
    private String m_macroVariable;
    private boolean m_saveHeader;
    private String m_directory;
    private boolean m_reader;
    private String m_queueType;
    public static final String MS_MQ = "MSMQ";
    public static final String IBM_WS_MQ = "IBMWSMQ";

    public QueueModel(TransformationStep step, String queueType, boolean isReader) {
        this.m_transformStep = step;
        this.m_queueType = queueType;
        this.m_reader = isReader;
    }

    public String getQueueType() {
        return this.m_queueType;
    }

    public void setQueueType(String queueType) {
        this.m_queueType = queueType;
    }

    public TransformationStep getStep() {
        return this.m_transformStep;
    }

    public void setMessageLength(int msg_length) {
        this.m_messageLength = msg_length;
    }

    public int getMessageLength() {
        return this.m_messageLength;
    }

    public boolean isProduceErrorIfFileDoesNotExist() throws MdException, RemoteException {
        return this.getMacroPropertyHandler().getSpecificOptionValue("XFILE").equals(YES);
    }

    public void setTextMessage(boolean set) {
        this.m_textMessage = set;
    }

    public boolean isTextMessage() {
        return this.m_textMessage;
    }

    public void setSaveHeader(boolean set) {
        this.m_saveHeader = set;
    }

    public boolean isSaveHeader() {
        return this.m_saveHeader;
    }

    public void setTableMessage(boolean set) {
        this.m_tableMessage = set;
    }

    public boolean isTableMessage() {
        return this.m_tableMessage;
    }

    public void setFileMessage(boolean set) {
        this.m_fileMessage = set;
    }

    public boolean isFileMessage() {
        return this.m_fileMessage;
    }

    public void setMessageColumns(List msgColumnList) {
        this.m_columnList = msgColumnList;
    }

    public List getMessageColumns() {
        return this.m_columnList;
    }

    public void setDirectory(String txt) {
        this.m_directory = txt;
    }

    public String getDirectory() {
        if (this.m_directory == null) {
            return "";
        }
        return this.m_directory;
    }

    public void setTextContent(String txt) {
        this.m_textContent = txt;
    }

    public String getTextContent() {
        if (this.m_textContent == null) {
            return "";
        }
        return this.m_textContent;
    }

    public void setMacroVariable(String var) {
        this.m_macroVariable = var;
    }

    public String getMacroVariable() {
        return this.m_macroVariable;
    }

    public void setFileName(String fname) {
        this.m_fileName = fname;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setMsgHeaderTable(PhysicalTable tab) {
        this.m_msgHeaderTable = tab;
    }

    public DataTable getMsgHeaderTable() {
        return this.m_msgHeaderTable;
    }

    public String getSpecificOptionValueOptions(String option) {
        try {
            if (this.m_propertyHandlerQ_Options == null) {
                this.setPropertyHandlerOptions(QOPTIONS_SET);
            }
            return this.m_propertyHandlerQ_Options.getSpecificOptionValue(option);
        }
        catch (MdException mdException) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    public String getSpecificOptionValueMacroOptions(String option) {
        try {
            if (this.m_propertyHandlerQ_MacroOptions == null) {
                this.setPropertyHandlerMacroOptions(QMACRO_OPTIONS_SET);
            }
            return this.m_propertyHandlerQ_MacroOptions.getSpecificOptionValue(option);
        }
        catch (MdException mdException) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    public PropertyHandler getMacroPropertyHandler() {
        if (this.m_propertyHandlerQ_MacroOptions == null) {
            this.setPropertyHandlerMacroOptions(QMACRO_OPTIONS_SET);
        }
        return this.m_propertyHandlerQ_MacroOptions;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_transformStep == null) {
            return;
        }
        if (this.m_store == null) {
            this.m_store = (MdObjectStore)this.m_transformStep.getObjectStore();
        }
        if (this.m_repository == null) {
            this.m_repository = this.m_transformStep.getRepositoryID();
        }
        this.m_store.setGoToServerForMetadata(true);
        AssociationList transList = this.m_transformStep.getTransformations();
        if (transList.isEmpty()) {
            throw new MdException("ERROR");
        }
        this.m_classifierMap = (ClassifierMap)transList.get(0);
        AssociationList propSetList = this.m_classifierMap.getPropertySets();
        for (int i = 0; i < propSetList.size(); ++i) {
            PropertySet propSet = (PropertySet)propSetList.get(i);
            AssociationList propertyList = propSet.getSetProperties();
            if (!propSet.getSetRole().equals(QOPTIONS_SET)) continue;
            for (int j = 0; j < propertyList.size(); ++j) {
                Property prop = (Property)propertyList.get(j);
                String dVal = prop.getDefaultValue();
                if (prop.getPropertyName().equals(QTYPE)) {
                    this.setFileMessage(dVal.equalsIgnoreCase(FILE));
                    this.setTextMessage(dVal.equalsIgnoreCase(TEXT));
                    this.setTableMessage(dVal.equalsIgnoreCase(TABLE));
                }
                if (prop.getPropertyName().equals(STOREDTEXT)) {
                    this.setTextContent(dVal);
                }
                if (prop.getPropertyName().equals(FNAME)) {
                    this.setFileName(dVal);
                }
                if (prop.getPropertyName().equals(MSGLEN)) {
                    this.setMessageLength(Integer.parseInt(dVal));
                }
                if (prop.getPropertyName().equals(MACROVARIABLE)) {
                    this.setMacroVariable(dVal);
                }
                if (prop.getPropertyName().equals(DIRECTORY)) {
                    this.setDirectory(dVal);
                }
                if (!prop.getPropertyName().equals(SAVEHEADER)) continue;
                this.setSaveHeader(dVal.equalsIgnoreCase(YES));
            }
        }
        AssociationList tgList = this.m_classifierMap.getClassifierTargets();
        for (int i = 0; i < tgList.size(); ++i) {
            PhysicalTable pt;
            CMetadata cm = (CMetadata)tgList.get(i);
            if (!cm.getCMetadataType().equals("PhysicalTable") || !(pt = (PhysicalTable)cm).getTableName().equals(MSGHEADERTABLE)) continue;
            this.setMsgHeaderTable(pt);
        }
    }

    public ClassifierMap getClassifierMap() {
        return this.m_classifierMap;
    }

    public void setReader(boolean reader) {
        this.m_reader = reader;
    }

    public boolean isReader() {
        return this.m_reader;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setPropertyHandlerOptions(QOPTIONS_SET);
        this.m_propertyHandlerQ_Options.setUseSetProperties(true);
        String messageType = "";
        if (this.isFileMessage()) {
            messageType = FILE;
        }
        if (this.isTextMessage()) {
            messageType = TEXT;
        }
        if (this.isTableMessage()) {
            messageType = TABLE;
        }
        this.m_propertyHandlerQ_Options.setSpecificProperty(QTYPE, messageType, QOPTIONS, 0);
        if (messageType.equals(TEXT)) {
            this.m_propertyHandlerQ_Options.setSpecificProperty(STOREDTEXT, this.getTextContent(), QOPTIONS, 0);
            this.m_propertyHandlerQ_Options.setSpecificProperty(MACROVARIABLE, this.getMacroVariable(), QOPTIONS, 0);
        }
        this.m_propertyHandlerQ_Options.setSpecificProperty(MSGLEN, String.valueOf(this.getMessageLength()), QOPTIONS, 0);
        this.m_propertyHandlerQ_Options.setSpecificProperty(FNAME, this.getFileName(), QOPTIONS, 0);
        if (this.isReader()) {
            this.m_propertyHandlerQ_Options.setSpecificProperty(MACROVARIABLE, this.getMacroVariable(), QOPTIONS, 0);
        }
        if (this.getDirectory().length() > 0) {
            this.m_propertyHandlerQ_Options.setSpecificProperty(DIRECTORY, this.getDirectory(), QOPTIONS, 0);
        }
        String svh = NO;
        if (this.isSaveHeader()) {
            svh = YES;
        }
        this.m_propertyHandlerQ_Options.setSpecificProperty(SAVEHEADER, svh, QOPTIONS, 0);
        AssociationList tgList = this.getClassifierMap().getClassifierTargets();
        boolean msgHeaderFound = false;
        if (this.getMsgHeaderTable() != null) {
            for (int i = 0; i < tgList.size(); ++i) {
                CMetadata cm = (CMetadata)tgList.get(i);
                if (!cm.getCMetadataType().equals("PhysicalTable") || !((PhysicalTable)cm).getTableName().equals(MSGHEADERTABLE)) continue;
                msgHeaderFound = true;
            }
            if (this.getMsgHeaderTable() != null && !msgHeaderFound) {
                this.m_classifierMap.getClassifierTargets().add((Object)this.getMsgHeaderTable());
            }
        }
    }

    public String getQueueName() throws MdException, RemoteException {
        AssociationList alist = this.isReader() ? this.getStep().getTargetTransformations() : this.getStep().getSourceTransformations();
        if (alist == null) {
            return "";
        }
        for (int i = 0; i < alist.size(); ++i) {
            Transformation trans;
            CMetadata cm = (CMetadata)alist.get(i);
            if (!cm.getCMetadataType().equals("Transformation") || !(trans = (Transformation)cm).getTransformRole().equals(SASMESSAGEQUEUE)) continue;
            boolean bPrivate = false;
            AssociationList lProperties = trans.getProperties();
            for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
                Property property = (Property)lProperties.get(iProperty);
                if (property.getPropertyName().compareToIgnoreCase("IsPublicQueue") != 0 || property.getDefaultValue().compareTo("0") != 0) continue;
                bPrivate = true;
            }
            AssociationList lDC = trans.getDeployedComponents();
            String sMachineName = "";
            boolean bMSMQ = false;
            for (int iDC = 0; iDC < lDC.size(); ++iDC) {
                Machine machine;
                DeployedComponent deployedComponent = (DeployedComponent)lDC.get(iDC);
                if (deployedComponent.getClassIdentifier().compareToIgnoreCase("MessageQueue.MSMQ") == 0) {
                    bMSMQ = true;
                }
                if ((machine = deployedComponent.getAssociatedMachine()) == null) continue;
                sMachineName = machine.getName();
            }
            String sQueueName = "";
            if (sQueueName.indexOf("\\") <= 0 && bMSMQ) {
                if (bPrivate) {
                    sQueueName = sMachineName + "\\private$\\" + trans.getName();
                } else if (sMachineName != null && sMachineName.length() > 0) {
                    sQueueName = sMachineName + "\\" + trans.getName();
                }
            } else {
                sQueueName = trans.getName();
            }
            return sQueueName;
        }
        return "";
    }

    public void setPropertyHandlerOptions(String setName) {
        try {
            this.m_propertyHandlerQ_Options = new PropertyHandler((Root)this.m_classifierMap, setName);
            this.m_propertyHandlerQ_Options.setUseSetProperties(true);
        }
        catch (MdException mdException) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public static void BuildErrorHandling(CodegenRequest cgReq, String errorMessage) {
        cgReq.addSourceCode("if rc ^= 0 then do;\n");
        cgReq.indent().addSourceCode("msg = sysmsg();\n");
        cgReq.addSourceCode("put '").addSourceCode(errorMessage).addSourceCode("' msg ;\n");
        cgReq.unIndent().addSourceCode("end;\n");
        cgReq.addSourceCode("put rc;\n");
    }

    public void setPropertyHandlerMacroOptions(String setName) {
        try {
            this.m_propertyHandlerQ_MacroOptions = new PropertyHandler((Root)this.m_transformStep, setName);
        }
        catch (MdException mdException) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public DataTable getWriterSourceTable() throws MdException, RemoteException {
        AssociationList list = this.getClassifierMap().getClassifierSources();
        if (list.size() > 0) {
            return (DataTable)list.get(0);
        }
        return null;
    }

    public DataTable getReaderTargetTable() {
        try {
            AssociationList alTransformations = this.getStep().getTransformations();
            if (alTransformations.size() > 0) {
                ClassifierMap classifierMap = (ClassifierMap)alTransformations.get(0);
                return this.getReaderTargetTable(classifierMap);
            }
        }
        catch (MdException alTransformations) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    public DataTable getReaderTargetTable(ClassifierMap classifier) {
        try {
            AssociationList list = classifier.getClassifierTargets();
            if (list.size() > 0) {
                return (DataTable)list.get(0);
            }
            return null;
        }
        catch (MdException mde) {
            Workspace.getDefaultLogger().warn((Object)"Error reading target table");
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    public static boolean isTableQuoted(DataTable table) throws MdException, RemoteException {
        return DBMSNamesUtil.isTableQuoted((DataTable)table);
    }
}

