/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.queues.MSMQQueueCodegen;
import com.sas.wadmin.transforms.queues.MSMQQueueModel;
import com.sas.wadmin.transforms.queues.QueueUtil;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MSMQQueueReaderCodegen
extends MSMQQueueCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(MSMQQueueReaderCodegen.class);
    private static SASCodeGeneration m_attrib;
    private static SASCodeGeneration m_attribVal;

    public MSMQQueueReaderCodegen() {
        Workspace.getDefaultLogger().debug((Object)"This is a Queue Reader..");
    }

    public static void codegen(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        TransformationStep step = null;
        try {
            step = (TransformationStep)classifierMap.getSteps().get(0);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().warn((Object)"incomplete metadata, there needs to be a step..");
            return;
        }
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        MSMQQueueModel readerModel = new MSMQQueueModel(step, "MSMQ", true);
        readerModel.moveDataToModel();
        readerModel.setReader(true);
        if (!QueueUtil.hasQueue(classifierMap, false)) {
            throw new CodegenException(bundle.getString("MSMQQReaderCodegen.NoSourceQueue.msg.txt"));
        }
        if (readerModel.isFileMessage()) {
            MSMQQueueReaderCodegen.buildFileReceive(cgReq, readerModel, classifierMap);
        } else if (readerModel.isTableMessage()) {
            MSMQQueueReaderCodegen.buildTableReceive(cgReq, readerModel, classifierMap);
        } else {
            MSMQQueueReaderCodegen.buildTextMsgReceive(cgReq, readerModel);
        }
        MSMQQueueReaderCodegen.genCodeConditionCheck(cgReq, classifierMap);
    }

    public static void buildTextMsgReceive(CodegenRequest cgReq, MSMQQueueModel readerModel) throws MdException, RemoteException {
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        MSMQQueueReaderCodegen.buildDeclarations(cgReq, readerModel);
        MSMQQueueReaderCodegen.buildInit(cgReq);
        MSMQQueueReaderCodegen.buildOpen(cgReq, "FETCH", "poll(timeout=2)", readerModel);
        if (readerModel.isQueuePropertiesTurnedOn()) {
            MSMQQueueReaderCodegen.buildVerifyQueueProperties(cgReq, readerModel);
        }
        cgReq.addSectionComment(bundle.getString("MSMQQReaderCodegen.LetStatements.notrans"));
        ArrayList parameterList = new ArrayList();
        cgReq.addSourceCode(MSMQQueueReaderCodegen.buildMacroValues(readerModel, parameterList));
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        if (readerModel.isTransaction()) {
            MSMQQueueReaderCodegen.buildBeginTransaction(cgReq);
            m_attrib.addSourceCode("TRANSACTION").addSourceCode(",").addSourceCode(" ");
            m_attribVal.addSourceCode("etls_transid").addSourceCode(",").addSourceCode(" ");
        }
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueReaderCodegen.buildTextMap(cgReq, readerModel, mapName);
        MSMQQueueReaderCodegen.buildAttributeList(parameterList, true, m_attrib, m_attribVal);
        cgReq.addSectionComment(bundle.getString("MSMQQReaderCodegen.ReceiveText.notrans"));
        cgReq.addSourceCode("length etls $ ").addSourceCode(String.valueOf(readerModel.getMessageLength())).addSourceCode(";\n");
        cgReq.addSourceCode("call receivemessage( etls_qid, etls_rc,\n");
        cgReq.indent().addSourceCode("etls_event, etls_attachflg,\n");
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource()).addSourceCode(", etls );\n");
        cgReq.addSourceCode("call symput( \"");
        cgReq.addSourceCode(readerModel.getMacroVariable());
        cgReq.addSourceCode("\", etls );\n");
        cgReq.unIndent();
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQReaderCodegen.ReceiveFailed.notrans"), true, "receive message");
        cgReq.addSourceCode("\n");
        if (readerModel.isTransaction()) {
            MSMQQueueReaderCodegen.buildCommitTransaction(cgReq);
        }
        MSMQQueueReaderCodegen.buildTerm(cgReq, readerModel.isDebug());
        cgReq.unIndent().addSourceCode("run;\n");
    }

    public static void buildFileMap(CodegenRequest cgReq, MSMQQueueModel readerModel, String mapName) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQReaderCodegen.BuildMap.notrans"));
        String storage = "REGISTRY";
        if (readerModel.isMapStoreDefined()) {
            storage = readerModel.getMapStore();
        }
        cgReq.addSourceCode("call setmap( '");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("', '");
        cgReq.addSourceCode(storage);
        cgReq.addSourceCode("', etls_rc, ");
        cgReq.addSourceCode("'CHAR'");
        cgReq.addSourceCode(" );\n");
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQReaderCodegen.BuildMapFailed.notrans"), "map ");
        cgReq.addSourceCode("\n");
    }

    public static void buildTextMap(CodegenRequest cgReq, MSMQQueueModel readerModel, String mapName) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQReaderCodegen.BuildMap.notrans"));
        String storage = "REGISTRY";
        if (readerModel.isMapStoreDefined()) {
            storage = readerModel.getMapStore();
        }
        cgReq.addSourceCode("call setmap( '");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("', '");
        cgReq.addSourceCode(storage);
        cgReq.addSourceCode("', etls_rc, ");
        cgReq.addSourceCode("'CHAR,,");
        cgReq.addSourceCode(String.valueOf(readerModel.getMessageLength()));
        cgReq.addSourceCode("'");
        cgReq.addSourceCode(" );\n");
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQReaderCodegen.BuildMapFailed.notrans"), "map ");
        cgReq.addSourceCode("\n");
    }

    public static void buildTableMap(CodegenRequest cgReq, MSMQQueueModel readerModel, List cList, String mapName) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQReaderCodegen.BuildMap.notrans"));
        String storage = "REGISTRY";
        if (readerModel.isMapStoreDefined()) {
            storage = readerModel.getMapStore();
        }
        cgReq.addSourceCode("call setmap( '");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("', '");
        cgReq.addSourceCode(storage);
        cgReq.addSourceCode("', etls_rc, ");
        cgReq.addSourceCode("\n");
        cgReq.indent();
        MSMQQueueReaderCodegen.buildColumnFormats(cgReq, cList);
        cgReq.addSourceCode(" );\n");
        cgReq.unIndent();
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQReaderCodegen.BuildMapFailed.notrans"), "map ");
        cgReq.addSourceCode("\n");
    }

    public static void buildTableReceive(CodegenRequest cgReq, MSMQQueueModel readerModel, ClassifierMap classifierMap) throws MdException, RemoteException {
        DataTable targetTable = cgReq.getTargetTable(classifierMap);
        cgReq.genTableDelete(targetTable);
        PhysicalTableCG targetTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
        boolean needQuotes = cgReq.getQuoting();
        String targetTableName = targetTableCG.getDataLocation(cgReq);
        AssociationList targetColumnList = readerModel.getReaderTargetTable().getColumns();
        if (targetColumnList.size() == 0) {
            throw new MdException(bundle.getString("MSMQQReaderCodegen.NoColumns.exception.txt"));
        }
        SASCodeGeneration cg = new SASCodeGeneration();
        for (int i = 0; i < targetColumnList.size(); ++i) {
            cg.genAttrib((Column)targetColumnList.get(i), true, false, false, true, needQuotes);
        }
        cgReq.addSourceCode("data ");
        cgReq.addSourceCode(targetTableName);
        cgReq.addSourceCode("(keep =\n ");
        cgReq.indent();
        SASCodeGeneration scg = new SASCodeGeneration();
        cgReq.addSourceCode(scg.makeColumnList(readerModel.getReaderTargetTable(), "", needQuotes, ""));
        cgReq.addSourceCode(");\n");
        cgReq.addCommentLine(bundle.getString("MSMQQReaderCodegen.BuildTargetColumns.notrans"));
        cgReq.addSourceCode(cg.getSource());
        MSMQQueueReaderCodegen.buildDeclarations(cgReq, readerModel);
        MSMQQueueReaderCodegen.buildInit(cgReq);
        MSMQQueueReaderCodegen.buildOpen(cgReq, "FETCH", "poll(timeout=2)", readerModel);
        if (readerModel.isQueuePropertiesTurnedOn()) {
            MSMQQueueReaderCodegen.buildVerifyQueueProperties(cgReq, readerModel);
        }
        ArrayList parameterList = new ArrayList();
        cgReq.addCommentLine(bundle.getString("MSMQQReaderCodegen.LetStatements.notrans"));
        cgReq.addSourceCode(MSMQQueueReaderCodegen.buildMacroValues(readerModel, parameterList));
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        if (readerModel.isTransaction()) {
            MSMQQueueReaderCodegen.buildBeginTransaction(cgReq);
            m_attrib.addSourceCode("TRANSACTION").addSourceCode(",").addSourceCode(" ");
            m_attribVal.addSourceCode("etls_transid").addSourceCode(",").addSourceCode(" ");
        }
        List columnList = QueueUtil.buildMessageColumnsList(readerModel.getReaderTargetTable());
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueReaderCodegen.buildTableMap(cgReq, readerModel, columnList, mapName);
        MSMQQueueReaderCodegen.buildAttributeList(parameterList, true, m_attrib, m_attribVal);
        cgReq.addSourceCode("\n");
        cgReq.addCommentLine(bundle.getString("MSMQQReaderCodegen.Receive.notrans"));
        cgReq.addSourceCode("length etls_reccount 8;\n");
        cgReq.addSourceCode("etls_reccount = 0;\n");
        cgReq.addSourceCode("length etls_limit_read 8;\n");
        if (readerModel.isDepth()) {
            cgReq.addSourceCode("etls_limit_read = ").addSourceCode(readerModel.getDepth()).addSourceCode(";\n");
        } else {
            cgReq.addSourceCode("etls_limit_read = 999999").addSourceCode(";\n");
        }
        cgReq.addSourceCode("length etls_attachflag 8;\n");
        cgReq.addSourceCode("do until (etls_event = 'NO_MESSAGE');\n");
        cgReq.indent();
        cgReq.addSectionComment(bundle.getString("MSMQQReaderCodegen.ReceiveTable.notrans"));
        cgReq.addSourceCode("call receivemessage( etls_qid, etls_rc,\n");
        cgReq.indent().addSourceCode("etls_event, etls_attachflg,\n");
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource());
        cgReq.addSourceCode(", \n");
        int sz = columnList.size();
        int j = 0;
        for (int i = 0; i < sz; ++i) {
            String[] sArrayQueueFormat = (String[])columnList.get(i);
            String sName = sArrayQueueFormat[0];
            if (needQuotes) {
                cgReq.addSourceCode(DBMSNamesUtil.getQuotedString((String)sName, (boolean)false));
            } else {
                cgReq.addSourceCode(sName);
            }
            if (i < sz - 1) {
                cgReq.addSourceCode(", ");
            }
            if (++j != 2) continue;
            cgReq.addSourceCode("\n");
            j = 0;
        }
        cgReq.addSourceCode(" );\n");
        cgReq.unIndent();
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQReaderCodegen.ReceiveFailed.notrans"), true, "receive message");
        cgReq.addSourceCode("if (etls_event ^= 'NO_MESSAGE') then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_current_reccount + 1;\n");
        cgReq.addCommentLine(bundle.getString("MSMQQReaderCodegen.EndLoop.notrans"));
        cgReq.addSourceCode("if etls_limit_read = etls_current_reccount then\n");
        cgReq.indent().addSourceCode("etls_event = 'NO_MESSAGE';\n");
        cgReq.unIndent();
        cgReq.addSourceCode("output;\n");
        cgReq.unIndent().addSourceCode("end; /* if etls_event ^= 'NO_MESSAGE' */ \n");
        cgReq.unIndent();
        cgReq.addSourceCode("end; /* do until (etls_event = 'NO_MESSAGE') */\n");
        cgReq.addSourceCode("\n");
        if (readerModel.isTransaction()) {
            MSMQQueueReaderCodegen.buildCommitTransaction(cgReq);
        }
        cgReq.unIndent();
        cgReq.addSourceCode("return;\n");
        cgReq.addSourceCode("term:\n");
        cgReq.indent();
        MSMQQueueReaderCodegen.buildTerm(cgReq, readerModel.isDebug());
        cgReq.unIndent();
        cgReq.addSourceCode("return;\n");
        cgReq.addSourceCode("run;\n");
    }

    public static void buildFileReceive(CodegenRequest cgReq, MSMQQueueModel readerModel, ClassifierMap classifierMap) throws MdException, RemoteException {
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        MSMQQueueReaderCodegen.buildDeclarations(cgReq, readerModel);
        MSMQQueueReaderCodegen.buildInit(cgReq);
        MSMQQueueReaderCodegen.buildOpen(cgReq, "FETCH", "poll(timeout=2)", readerModel);
        if (readerModel.isQueuePropertiesTurnedOn()) {
            MSMQQueueReaderCodegen.buildVerifyQueueProperties(cgReq, readerModel);
        }
        cgReq.addSectionComment(bundle.getString("MSMQQReaderCodegen.LetStatements.notrans"));
        ArrayList parameterList = new ArrayList();
        cgReq.addSourceCode(MSMQQueueReaderCodegen.buildMacroValues(readerModel, parameterList));
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueReaderCodegen.buildFileMap(cgReq, readerModel, mapName);
        MSMQQueueReaderCodegen.buildAttributeList(parameterList, true, m_attrib, m_attribVal);
        cgReq.addCommentLine(bundle.getString("MSMQQReaderCodegen.Receive.notrans"));
        cgReq.addSourceCode("length etls_attachid 8;\n");
        cgReq.addSourceCode("length etls_lastflag 8;\n");
        cgReq.addSourceCode("length etls_type $ 20;\n");
        cgReq.addSourceCode("length etls_qual1 $ 80;\n");
        cgReq.addSourceCode("length etls_qual2 $ 80;\n");
        cgReq.addSourceCode("length etls_desc $ 80;\n");
        cgReq.addSourceCode("length etls_minor 8;\n");
        cgReq.addSourceCode("length etls_major 8;\n");
        cgReq.addSourceCode("length etls_attachflag 8;\n");
        cgReq.addSourceCode("do until (etls_event = 'NO_MESSAGE');\n");
        cgReq.indent();
        cgReq.addSectionComment(bundle.getString("MSMQQReaderCodegen.ReceiveFile.notrans"));
        cgReq.addSourceCode("call receivemessage( etls_qid, etls_rc,\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_event, etls_attachflg,\n");
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource());
        cgReq.addSourceCode(" );\n");
        cgReq.unIndent();
        MSMQQueueReaderCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQReaderCodegen.ReceiveFailed.notrans"), true, "receive message");
        MSMQQueueReaderCodegen.buildAttachmentReceive(cgReq, readerModel);
        cgReq.unIndent();
        cgReq.addSourceCode("end; /* do until (etls_event = 'NO_MESSAGE') */\n");
        cgReq.addSourceCode("\n");
        MSMQQueueReaderCodegen.buildTerm(cgReq, readerModel.isDebug());
        cgReq.unIndent().addSourceCode("run;\n");
    }

    public static void buildDeclarations(CodegenRequest cgReq, MSMQQueueModel model) throws MdException, RemoteException {
        cgReq.addCommentLine(bundle.getString("MSMQQReaderCodegen.LengthStatements.notrans"));
        cgReq.addSourceCode("length etls_queue  $ 200;\n");
        if (model.isDebug()) {
            cgReq.addSourceCode("length etls_msg $ 200;\n");
        }
        cgReq.addSourceCode("length etls_qid 8;\n");
        cgReq.addSourceCode("length etls_rc 8;\n");
        cgReq.addSourceCode("length etls_tid 8;\n");
        if (model.isTransaction()) {
            cgReq.addSourceCode("length etls_transid 8;\n");
        }
        cgReq.addSourceCode("length etls_map $ 80;\n");
        cgReq.addSourceCode("length etls_msgtype 8;\n");
        cgReq.addSourceCode("length etls_event $ 10;\n");
        cgReq.addSourceCode("length etls_msg $ 200;\n");
        cgReq.addSourceCode("length etls_mqdebug $ 10;\n");
        if (model.isDebug()) {
            cgReq.addSourceCode("etls_mqdebug=\"YES\";\n");
        } else {
            cgReq.addSourceCode("etls_mqdebug=\"NO\";\n");
        }
        cgReq.addSourceCode("etls_queue = '").addSourceCode(model.getQueueName().trim()).addSourceCode("';\n");
        cgReq.addSourceCode("\n");
    }

    public static void buildAttachmentReceive(CodegenRequest cgReq, MSMQQueueModel readerModel) throws MdException, RemoteException {
        cgReq.addSourceCode("if (etls_event ^= 'NO_MESSAGE') then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_lastflag = 0;\n");
        cgReq.addSourceCode("etls_minor = 0;\n");
        cgReq.addSourceCode("etls_major = 0;\n");
        cgReq.addSourceCode("if (etls_attachflg eq 1) then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("do while (etls_lastflag eq 0);\n");
        cgReq.indent().genPutStatement(bundle.getString("MSMQQReaderCodegen.Attachment.notrans"));
        cgReq.addSourceCode("call GETATTACHMENT( etls_qid, etls_lastflag,\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_attachid, etls_type,\n");
        cgReq.addSourceCode("etls_qual1, etls_qual2,\n");
        cgReq.addSourceCode("etls_rc, etls_desc );\n");
        cgReq.unIndent();
        cgReq.addSourceCode("if (etls_rc ^= 0) then do;\n");
        cgReq.indent().addSourceCode("etls_msg = sysmsg();\n");
        cgReq.genPutStatement(bundle.getString("MSMQQReaderCodegen.AttachmentFailed.notrans"), "ERROR:", "msg", false);
        cgReq.addSourceCode("etls_lastflag = 1;\n");
        cgReq.unIndent().addSourceCode("end; /* if (etls_rc ^= 0) */\n");
        cgReq.addSourceCode("else do;\n");
        cgReq.indent().genPutStatement(bundle.getString("MSMQQReaderCodegen.AttachmentAccept.notrans"));
        cgReq.addSourceCode("FILENAME etlref ");
        cgReq.addSourceCode("\"");
        cgReq.addSourceCode(readerModel.getFileName());
        cgReq.addSourceCode("\"");
        cgReq.addSourceCode(";\n");
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("call acceptattachment(etls_qid, etls_attachid, 'fileref',\n");
        cgReq.indent();
        cgReq.addSourceCode("'etlref', etls_rc);\n");
        cgReq.unIndent();
        cgReq.addSourceCode("if etls_rc ^= 0 then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("etls_msg=sysmsg();\n");
        cgReq.genPutStatement(bundle.getString("MSMQQReaderCodegen.AttachmentAcceptFailed.notrans"), "ERROR:", "etls_msg", false);
        cgReq.unIndent().addSourceCode("end; /* else (etls_rc = 0) */\n");
        cgReq.addSourceCode("else ");
        cgReq.genPutStatement(bundle.getString("MSMQQReaderCodegen.AttachmentAcceptSuccess.notrans"));
        cgReq.genPutStatement(bundle.getString("MSMQQReaderCodegen.AttachmentType.notrans"), "NOTE:", "etls_type", false);
        cgReq.genPutStatement(bundle.getString("MSMQQReaderCodegen.AttachmentLibFile.notrans"), "NOTE:", "etls_qual1", false);
        cgReq.genPutStatement(bundle.getString("MSMQQReaderCodegen.AttachmentMember.notrans"), "NOTE:", "etls_qual2", false);
        cgReq.genPutStatement(bundle.getString("MSMQQReaderCodegen.AttachmentSenderDesc.notrans"), "NOTE:", "etls_desc", false);
        cgReq.genPutStatement(bundle.getString("MSMQQReaderCodegen.AttachmentLastFlag.notrans"), "NOTE:", "etls_lastflag", false);
        cgReq.unIndent().addSourceCode("end; /* if etls_attachflg eq 1 */\n");
        cgReq.unIndent().addSourceCode("end; /* do while (etls_lastflag eq 0) */\n");
        cgReq.unIndent().addSourceCode("end; /* if (etls_attachflg eq 1) */\n");
        cgReq.unIndent().addSourceCode("end; /* if (event ^= 'NO_MESSAGE') */\n");
    }
}

