/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.queues.MSMQQueueModel;
import com.sas.wadmin.transforms.queues.QueueModel;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;

public class MSMQQueueCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(MSMQQueueCodegen.class);
    protected static final String DELIVERY = "DELIVERY";
    protected static final String NOTE = "NOTE:";
    protected static final String ERROR = "ERROR:";
    protected static final String PREFIX = "etls_";
    protected static final String SPACE = " ";
    protected static final String LENGTH = "length ";
    protected static final String DEF_CHAR = " $ 20;\n";
    protected static final String DEF_INT = " 8;\n";
    protected static final String DEF_ID = " $ 48;\n";
    protected static final String DEF_DESC = " $ 200;\n";
    protected static final String QUOTE = "\"";
    protected static final String SUCCESS = " successful";
    protected static final String OPENATTR = "OPENATTR";
    protected static final String DEBUG = "MQDEBUG";
    protected static final String ATTACHLIST = "ATTACHLIST";
    protected static final String ALLOWREADPROTECT = "ALLOWREADPROTECT";
    protected static final String HASHALG = "HASHALG";
    protected static final String SENDERCERT = "SENDERCERT";
    protected static final String ENCRYPT = "ENCRYPT";
    protected static final String ENCRYPTALG = "ENCRYPTALG";
    protected static final String DESCRIPTION = "DESCRIPTION";
    protected static final String AUTHENTICATE = "AUTHENTICATE";
    protected static final String PERSIST = "PERSIST";
    protected static final String TIMEOUT = "TIMEOUT";
    protected static final String MSGTYPE = "MSGTYPE";
    protected static final String ADMINQUEUE = "ADMINQUEUE";
    protected static final String RESPQUEUE = "RESPQUEUE";
    protected static final String TRANSACTION = "TRANSACTION";
    protected static final String ACKNOWLEDGE = "ACKNOWLEDGE";
    protected static final String CORRELATIONID = "CORRELATIONID";
    protected static final String JOURNAL = "JOURNAL";
    protected static final String PRIORITY = "PRIORITY";
    protected static final String MSGID = "MSGID";
    protected static final String OPTIONS = "OPTIONS";
    protected static final String OPENMODE = "OPENMODE";
    protected static final String DEPTH = "LIMIT_READ";
    protected static final String INIT = "initialize queue";
    protected static final String OPEN = "open queue";
    protected static final String SENDMESSAGE = "send message";
    protected static final String RECEIVEMESSAGE = "receive message";
    protected static final String CLOSE = "close queue";
    protected static final String TERM = "terminate queue";
    protected static final String BEGINTRANS = "begin transaction";
    protected static final String FREETRANS = "free transaction";
    protected static final String COMMITTRANS = "commit transaction";
    protected static final String QUEUEPROPS = "queue properties";
    protected static final String MAP = "map ";
    protected static final String QUEUEPROP = "QUEUEPROP";
    protected static final String MAPSTORE = "MAPSTORE";
    protected static final String USERMAP = "USERMAP";
    protected static final String[] ignoreString = new String[]{"USERMAP", "MAPSTORE", "TRANSACTION", "XFILE", "LIMIT_READ", "OPENMODE", "OPENATTR", "MQDEBUG", "QUEUEPROP"};

    protected static void BuildErrorHandling(CodegenRequest cgReq, String errorMessage, String mode) {
        MSMQQueueCodegen.BuildErrorHandling(cgReq, errorMessage, false, mode, false);
    }

    protected static void BuildErrorHandling(CodegenRequest cgReq, String errorMessage, String mode, boolean terminate) {
        MSMQQueueCodegen.BuildErrorHandling(cgReq, errorMessage, false, mode, terminate);
    }

    protected static void BuildErrorHandling(CodegenRequest cgReq, String errorMessage, boolean isEvent, String mode) {
        MSMQQueueCodegen.BuildErrorHandling(cgReq, errorMessage, isEvent, mode, false);
    }

    protected static void BuildErrorHandling(CodegenRequest cgReq, String errorMessage, boolean isEvent, String mode, boolean isTerminate) {
        cgReq.addSourceCode("if etls_rc ^= 0 then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("etls_msg = sysmsg();\n");
        cgReq.genPutStatement(errorMessage, ERROR, "etls_msg", false);
        cgReq.addSourceCode("%rcSetDS( 8000 );\n");
        if (isEvent) {
            cgReq.addSourceCode("etls_event = 'NO_MESSAGE';\n");
        }
        if (isTerminate) {
            cgReq.addSourceCode("link term;\n");
            cgReq.addSourceCode("stop;\n");
        }
        cgReq.unIndent().addSourceCode("end; /* if etls_rc ^= 0 */\n");
        cgReq.addSourceCode("else;\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("%rcSetDS( etls_rc );\n");
        cgReq.addSourceCode("if etls_mqdebug = \"YES\" then\n");
        StringBuffer succMsg = new StringBuffer(mode);
        succMsg.append(SUCCESS);
        cgReq.indent().genPutStatement(succMsg.toString());
        cgReq.unIndent();
        cgReq.unIndent();
        cgReq.addSourceCode("end;/* else do */\n");
    }

    protected static void buildInit(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.Initialize.notrans"));
        cgReq.addSourceCode("call init( etls_tid, 'MSMQ', etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQueueCodegen.InitializeFailed.notrans"), INIT);
        cgReq.addSourceCode("\n");
    }

    protected static void buildOpen(CodegenRequest cgReq, String mode, MSMQQueueModel model) throws MdException, RemoteException {
        MSMQQueueCodegen.buildOpen(cgReq, mode, "", model);
    }

    protected static void buildOpen(CodegenRequest cgReq, String mode, String addOptions, MSMQQueueModel model) throws MdException, RemoteException {
        String modeActivity = model.getOpenMode();
        if (modeActivity == null) {
            modeActivity = mode;
        } else if (mode.length() == 0) {
            modeActivity = mode;
        }
        String addAttrs = model.getOpenAttr();
        if (addAttrs == null) {
            addAttrs = addOptions;
        } else if (addAttrs.length() == 0) {
            addAttrs = addOptions;
        }
        if (modeActivity.equalsIgnoreCase(DELIVERY)) {
            cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.OpenSend.notrans"));
        } else {
            cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.OpenReceive.notrans"));
        }
        cgReq.addSourceCode("call openqueue( etls_qid, etls_tid, etls_queue,\n");
        cgReq.indent();
        cgReq.addSourceCode(QUOTE);
        cgReq.addSourceCode(modeActivity);
        cgReq.addSourceCode(QUOTE);
        cgReq.addSourceCode(", etls_rc");
        if (addAttrs.length() > 0) {
            cgReq.addSourceCode(", ");
            cgReq.addSourceCode(QUOTE);
            cgReq.addSourceCode(addAttrs);
            cgReq.addSourceCode(QUOTE);
            cgReq.addSourceCode(" );\n");
        } else {
            cgReq.addSourceCode(");\n");
        }
        cgReq.unIndent();
        MSMQQueueCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQueueCodegen.OpenFailed.notrans"), OPEN);
        cgReq.addSourceCode("\n");
    }

    protected static void buildTerm(CodegenRequest cgReq, boolean debug) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.CloseQueue.notrans"));
        cgReq.addSourceCode("call closequeue( etls_qid, etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQueueCodegen.CloseFailed.notrans"), CLOSE);
        cgReq.addSourceCode("\n");
        cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.Term.notrans"));
        cgReq.addSourceCode("call term( etls_tid, etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQueueCodegen.TermFailed.notrans"), TERM);
        cgReq.addSourceCode("\n");
    }

    protected static void buildColumnFormats(CodegenRequest cgReq, List cList) {
        int sz = cList.size();
        int j = 0;
        for (int i = 0; i < sz; ++i) {
            String[] sArrayQueueFormat = (String[])cList.get(i);
            String sFormat = sArrayQueueFormat[1];
            if (i == 0) {
                cgReq.addSourceCode("'");
            }
            cgReq.addSourceCode(sFormat);
            if (i < sz - 1) {
                cgReq.addSourceCode("; ");
            } else {
                cgReq.addSourceCode("'");
            }
            if (++j != 3) continue;
            cgReq.addSourceCode("\n");
            j = 0;
        }
    }

    public static void buildBeginTransaction(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.BeginTransaction.notrans"));
        cgReq.addSourceCode("etls_transid=0;\n");
        cgReq.addSourceCode("call begintransaction( etls_transid, etls_tid, etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQueueCodegen.BeginTransFailed.notrans"), BEGINTRANS);
        cgReq.addSourceCode("\n");
    }

    public static void buildCommitTransaction(CodegenRequest cgReq) throws MdException, RemoteException {
        MSMQQueueCodegen.buildCommitTransaction(cgReq, true);
    }

    public static void buildCommitTransaction(CodegenRequest cgReq, boolean freeTransaction) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.CommitTransaction.notrans"));
        cgReq.addSourceCode("if etls_rc = 0 then call commit( etls_transid, etls_rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQueueCodegen.CommitTransFailed.notrans"), COMMITTRANS);
        cgReq.addSourceCode("\n");
        if (freeTransaction) {
            MSMQQueueCodegen.buildFreeTransaction(cgReq);
        }
    }

    public static void buildFreeTransaction(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.FreeTransaction.notrans"));
        cgReq.addSourceCode("call freetransaction( etls_transid, rc );\n");
        MSMQQueueCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQueueCodegen.FreeTransFailed.notrans"), FREETRANS);
        cgReq.addSourceCode("\n");
    }

    public static void genCodeConditionCheck(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        TransformationStep oStep = (TransformationStep)classifierMap.getSteps(false).get(0);
        AssociationList alTriggeredEvents = oStep.getTriggeredEvents();
        if (alTriggeredEvents.isEmpty()) {
            return;
        }
        cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.RCCheck.msg.notrans"));
        cgReq.addSourceCode("%macro etls_writerCheck; \n\n").indent();
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event lEvent = (Event)alTriggeredEvents.get(iEvent);
            String eventRole = lEvent.getEventRole();
            if (!eventRole.equals("Condition1") && !eventRole.equals("Condition2") && !eventRole.equals("Condition3")) continue;
            String lEventCondition = lEvent.getCondition().trim();
            cgReq.addSourceCode(lEventCondition + "\n");
            cgReq.addSourceCode("%do; \n\n").indent();
            if (lEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.notrans"));
            }
            PropertySet lTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(lEvent, true);
            AssociationList lTrueProperties = lTruePropertySet.getSetProperties();
            for (int iAction = 0; iAction < lTrueProperties.size(); ++iAction) {
                Property oAction = (Property)lTrueProperties.get(iAction);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)oStep));
            }
            cgReq.unIndent().addSourceCode("%end; \n\n");
        }
        cgReq.unIndent().addSourceCode("%mend etls_writerCheck; \n").addSourceCode("%etls_writerCheck; \n\n");
    }

    public static void buildVerifyQueueProperties(CodegenRequest cgReq, MSMQQueueModel model) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("MSMQQueueCodegen.QueueProperties.notrans"));
        cgReq.addSourceCode("length etls_ttype $ 10;\n");
        cgReq.addSourceCode("length etls_pmask 8;\n");
        cgReq.addSourceCode("length etls_depth 8;\n");
        cgReq.addSourceCode("length etls_maxdepth 8;\n");
        cgReq.addSourceCode("length etls_maxmsgl 8;\n");
        cgReq.addSourceCode("length etls_ctime $ 80;\n");
        cgReq.addSourceCode("length etls_desc $ 80;\n");
        cgReq.addSourceCode("etls_rc=0;\n");
        cgReq.addSourceCode("etls_ttype='';\n");
        cgReq.addSourceCode("etls_pmask=0;\n");
        cgReq.addSourceCode("etls_depth=0;\n");
        cgReq.addSourceCode("etls_maxdepth=0;\n");
        cgReq.addSourceCode("etls_maxmsgl=0;\n");
        cgReq.addSourceCode("etls_ctime='';\n");
        cgReq.addSourceCode("call getqueueprops(etls_qid, etls_rc,\n");
        cgReq.indent();
        cgReq.addSourceCode("etls_ttype, etls_pmask,\n");
        cgReq.addSourceCode("etls_depth, etls_maxdepth,\n");
        cgReq.addSourceCode("etls_maxmsgl, etls_ctime,\n");
        cgReq.addSourceCode("etls_desc);\n");
        cgReq.unIndent();
        MSMQQueueCodegen.BuildErrorHandling(cgReq, bundle.getString("MSMQQueueCodegen.QueuePropertiesFailed.notrans"), QUEUEPROPS);
        cgReq.addSourceCode("\n");
        cgReq.addSourceCode("if etls_ttype ne 'MSMQ' then \n");
        cgReq.indent();
        cgReq.genPutStatement(bundle.getString("MSMQQueueCodegen.QueueTypeFailed.notrans"), NOTE, "etls_ttype", false);
        cgReq.unIndent();
        cgReq.addSourceCode("else\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent().addSourceCode("if etls_pmask='1'b then \n");
        cgReq.indent().genPutStatement(bundle.getString("MSMQQueueCodegen.AuthMsg.notrans"));
        cgReq.unIndent();
        cgReq.addSourceCode("else if etls_pmask='1.'b then \n");
        cgReq.indent().genPutStatement(bundle.getString("MSMQQueueCodegen.PrivMsg.notrans"));
        cgReq.unIndent();
        cgReq.addSourceCode("else if etls_pmask='1..'b then\n");
        cgReq.indent().genPutStatement(bundle.getString("MSMQQueueCodegen.PubMsg.notrans"));
        cgReq.unIndent();
        cgReq.addSourceCode("else ");
        cgReq.genPutStatement(bundle.getString("MSMQQueueCodegen.PrivOptMsg.notrans"));
        cgReq.addSourceCode("if etls_pmask='1...'b then\n");
        cgReq.addSourceCode("do; \n");
        cgReq.indent().genPutStatement(bundle.getString("MSMQQueueCodegen.TransMsgRequired.notrans"));
        if (model.isFileMessage() || model.isTransaction()) {
            cgReq.genPutStatement(bundle.getString("MSMQQueueCodegen.TransactionRequired.notrans"));
        }
        cgReq.unIndent().addSourceCode("end; /* if etls_pmask='1...'b */\n");
        cgReq.addSourceCode("else ");
        cgReq.genPutStatement(bundle.getString("MSMQQueueCodegen.TransMsgNotPermitted.notrans"));
        cgReq.genPutStatement(bundle.getString("MSMQQueueCodegen.QueuePropertiesDepth.notrans"), NOTE, "etls_depth", false);
        cgReq.genPutStatement(bundle.getString("MSMQQueueCodegen.QueuePropertiesMaxDepth.notrans"), NOTE, "etls_maxdepth", false);
        cgReq.genPutStatement(bundle.getString("MSMQQueueCodegen.QueuePropertiesMaxMsgL.notrans"), NOTE, "etls_maxmsgl", false);
        cgReq.genPutStatement(bundle.getString("MSMQQueueCodegen.QueuePropertiesCreateTime.notrans"), NOTE, "etls_ctime", false);
        cgReq.genPutStatement(bundle.getString("MSMQQueueCodegen.QueuePropertiesDesc.notrans"), NOTE, "etls_desc", false);
        cgReq.unIndent().addSourceCode("end; /* etls_ttype eq 'MSMQ' */\n\n");
    }

    public static String buildMacroValues(QueueModel model, List parameterList) throws MdException, RemoteException {
        SASCodeGeneration letStatements = new SASCodeGeneration();
        AssociationList propList = model.getMacroPropertyHandler().getPropertyList();
        if (propList == null) {
            return "";
        }
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            String name = prop.getPropertyName();
            if (!MSMQQueueCodegen.validMacroValue(name)) continue;
            boolean isString = false;
            String propName = prop.getPropertyName();
            String propNameLower = propName.toLowerCase();
            letStatements.addSourceCode(LENGTH).addSourceCode(PREFIX).addSourceCode(propNameLower);
            parameterList.add(propName);
            if (isString) {
                if (propName.equals(CORRELATIONID) || propName.equals(MSGID)) {
                    letStatements.addSourceCode(DEF_ID);
                } else if (propName.equals(DESCRIPTION)) {
                    letStatements.addSourceCode(DEF_DESC);
                } else {
                    letStatements.addSourceCode(DEF_CHAR);
                }
            } else {
                letStatements.addSourceCode(DEF_INT);
            }
            letStatements.addSourceCode(PREFIX).addSourceCode(propNameLower);
            if (isString) {
                letStatements.addSourceCode(QUOTE);
            }
            if (isString) {
                letStatements.addSourceCode(QUOTE);
            }
            letStatements.addSourceCode(";\n");
        }
        return letStatements.getSource();
    }

    private static boolean validMacroValue(String propName) {
        int len = ignoreString.length;
        for (int i = 0; i < len; ++i) {
            if (!propName.equals(ignoreString[i])) continue;
            return false;
        }
        return true;
    }

    protected static void buildAttributeList(List parameterList, boolean isReader, SASCodeGeneration attrib, SASCodeGeneration attribVal) {
        int j = 0;
        for (int i = 0; i < parameterList.size(); ++i) {
            String nm = (String)parameterList.get(i);
            attrib.addSourceCode(nm).addSourceCode(",").addSourceCode(SPACE);
            attribVal.addSourceCode(PREFIX).addSourceCode(nm.toLowerCase()).addSourceCode(",").addSourceCode(SPACE);
            if (++j != 2) continue;
            attrib.addSourceCode("\n");
            attribVal.addSourceCode("\n");
            j = 0;
        }
        if (isReader) {
            attrib.addSourceCode(MSGTYPE).addSourceCode(",");
            attrib.addSourceCode(" MAP");
            attribVal.addSourceCode("etls_msgtype").addSourceCode(",");
            attribVal.addSourceCode(" etls_map");
        }
    }
}

