/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.queues.MQBACK;
import com.sas.wadmin.transforms.queues.MQCLOSE;
import com.sas.wadmin.transforms.queues.MQCMIT;
import com.sas.wadmin.transforms.queues.MQDISC;
import com.sas.wadmin.transforms.queues.MQGMO;
import com.sas.wadmin.transforms.queues.MQMD;
import com.sas.wadmin.transforms.queues.QueueModel;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MQROOT {
    protected static WAdminResource bundle = WAdminResource.getBundle(MQROOT.class);
    protected QueueModel m_queueModel;
    protected CodegenRequest m_cg;
    protected boolean m_bQueueWriter;
    protected HashMap m_hmUserInput;
    protected String m_ObjectHandleVersion = "";
    protected static final String EMQ_MESSAGE_LENGTH = "etls_message_length";
    protected static final String EMQ_TEXT_MESSAGE = "etls_text_message";
    protected static final String EMQ_FILENAME = "etls_filename";
    protected static final String EMQ_MACROVARIABLE = "etls_macroname";
    protected static final String EMQ_HEADERDIRECTORY = "etls_directory";
    protected static final String EMQ_SAVEHEADER = "etls_saveheader";
    protected static final String EMQ_QUEUENAME = "etls_queuename";
    protected static final String EMQ_QUEUEMANAGERNAME = "etls_queuemanagername";
    protected static final String SASVAR_CONNECTION_HANDLE = "etls_hconn";
    protected static final String SASVAR_OBJECT_HANDLE = "etls_hobj";
    protected static final String SASVAR_OPTIONS = "etls_options";
    protected static final String SASVAR_PARAMETERS = "etls_parms";
    protected static final String SASVAR_COMPLETION_CODE = "etls_compcode";
    protected static final String SASVAR_REASON_CODE = "etls_qrc";
    protected static final String SASVAR_RETURN_CODE = "etls_qrc";
    protected static final String SASVAR_ETLS_MESSAGE = "etls_qmessage";
    protected static final String SASVAR_OBJECTDESCRIPTOR_HANDLE = "etls_hod";
    protected static final String SASVAR_MESSAGEDESCRIPTOR_HANDLE = "etls_hmd";
    protected static final String SASVAR_PUTMESSAGEOPTIONS_HANDLE = "etls_hpmo";
    protected static final String SASVAR_DATADESCRIPTOR_HANDLE = "etls_hdata";
    protected static final String SASVAR_GETMESSAGEOPTIONS_HANDLE = "etls_hgmo";
    protected static final String SASVAR_MAPDESCRIPTOR_HANDLE = "etls_hmap";
    protected static final String SASVAR_LENGTHOFRECEIVEDMESSAGE = "etls_rcvmsglen";
    protected static final String SASVAR_GENERATE_ACTION = "etls_gen_";
    protected static final String SASVAR_SET_ACTION = "etls_set";
    protected static final String SASVAR_INQ_ACTION = "etls_inq";
    protected static final String SASVAR_RETURNCODE = "etls_rc";
    protected static final String ACTION_GEN = "GEN";
    protected static final String ACTION_SET = "SET";
    protected static final String ACTION_INQ = "INQ";
    protected static final String SASVAR_BUFFSIZE = "etls_buffsize";
    protected static final String SASVAR_OBJECTNAME = "etls_objectname";
    protected static final String OBJECTNAME = "OBJECTNAME";
    protected static final String EXIT_TOKEN = "etls_mqexit";
    protected static final String SASVAR_MESSAGE_READ = "etls_read";
    protected static final String MACROVAR_QUEUE_MESSAGE_STRING = "etls_qms";
    protected static final String SASVAR_RCV_MSG_LENGTH = "etls_rcv_msg_len";
    protected static final String MQMODEL = "MQMODEL";
    protected static final String LIMIT_READ = "LIMIT_READ";
    protected static final String CGEN_FORMATS = "CGEN_FORMATS";
    protected static final String ETLS_MQDEBUG_KEY = "ETLS_MQDEBUG";
    protected static final String ETLS_MQDEBUG = "etls_mqdebug";
    protected static final String ETLS_CMITFLAG = "etls_commit";
    protected static final String MQSASTBL = "MQSASTBL";
    protected static final String MQSASCNV = "MQSASCNV";
    protected static final String MQSECURE = "MQSECURE";
    protected static final String MQSIGNEE = "MQSIGNEE";
    protected static final String MQENCRYPTID = "MQENCRYPTID";
    protected static final String MQDECRYPTPW = "MQDECRYPTPW";
    protected static final String MQDEBUG = "MQDECRYPTPW";
    protected static final String MQFREEDATA = "MQFREEDATA";
    protected static final String YES = "YES";
    protected static final String NO = "NO";
    protected static final String TRUE = "TRUE";
    protected static final String FALSE = "FALSE";
    protected static final String CLIENT = "CLIENT";
    protected static final String PREFIX1 = "etls_";
    protected static final String PREFIX2 = "etls_i_";
    protected static final String PREFIX3 = "etls_s_";
    protected static final String NUM_LEN_EIGHT = "8";
    protected static final String ETLS_PARM = "etls_parm";
    protected static final String ON = "ON";
    protected static final String SEGMENT_ALLOW = "segment_allow";
    protected static final String SEGMENT = "segment";
    protected static final String LAST_SEGMENT = "last_segment";
    protected static final String GROUP = "group";
    protected static final String LAST_GROUP = "last_group";
    protected static final String SEGMENT_ALLOW_MASK = "segment_allow_mask";
    protected static final String SEGMENT_MASK = "segment_mask";
    protected static final String LAST_SEGMENT_MASK = "last_segment_mask";
    protected static final String GROUP_MASK = "group_mask";
    protected static final String LAST_GROUP_MASK = "last_group_mask";
    protected static final String QUOTE = "\"";

    public MQROOT(CodegenRequest cgReq, boolean bQueueWriter, HashMap hmUserInput) throws MdException, RemoteException {
        this.m_cg = cgReq;
        this.m_bQueueWriter = bQueueWriter;
        this.m_hmUserInput = hmUserInput;
    }

    public String getQueueManagerName() {
        return (String)this.m_hmUserInput.get(EMQ_QUEUEMANAGERNAME);
    }

    public String getQueueName() {
        return (String)this.m_hmUserInput.get(EMQ_QUEUENAME);
    }

    protected void addFailCondition(String errorMessage) {
        this.addFailCondition(errorMessage, "etls_qrc");
    }

    protected void addFailCondition(String errorMessage, String sCode) {
        this.m_cg.addSourceCode("if ");
        this.m_cg.addSourceCode(sCode);
        this.m_cg.addSourceCode(" ^= 0 then \ndo;\n");
        this.m_cg.indent();
        this.m_cg.genRCSetDSCall("8000", true);
        this.m_cg.addSourceCode(SASVAR_ETLS_MESSAGE);
        this.m_cg.addSourceCode(" = sysmsg();\n");
        this.m_cg.genPutStatement(errorMessage, "ERROR:", SASVAR_ETLS_MESSAGE, false);
        this.addExitLine();
        this.m_cg.unIndent().addSourceCode("end;\n");
    }

    protected static void buildRcset(CodegenRequest cgReq) {
        cgReq.addSourceCode("if rc ne 0 then rc=8000;\n");
        cgReq.addSourceCode("%rcSet(rc);\n");
    }

    protected void buildFunctionCall(List list) {
        int iPreviousLength = 0;
        this.addCall();
        this.openParenthesis();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (sb.toString().length() - iPreviousLength > 78) {
                sb.append("\n          ");
                iPreviousLength = sb.toString().length();
            }
            sb.append((String)list.get(i));
        }
        this.m_cg.addSourceCode(sb);
        this.closeParenthesis();
        this.addCloseLine();
        this.addBlankLine();
        if (this.isDebugModeOn()) {
            this.addPutStatmentsForAPICall(list);
        }
    }

    private void addPutStatmentsForAPICall(List list) {
        StringBuffer sb = new StringBuffer();
        String fullName = this.getClass().getName().toLowerCase();
        this.m_cg.genPutStatement(bundle.getString("MQROOT.LineSeparator.txt.notrans"), "NOTE:");
        String sClassName = fullName.substring(fullName.lastIndexOf(".") + 1);
        this.m_cg.genPutStatement(bundle.getString("MQROOT.APICall.txt.notrans") + sClassName, "NOTE:");
        for (int i = 0; i < list.size(); ++i) {
            sb.append("put 'NOTE: ");
            String sObject = (String)list.get(i);
            sb.append(sObject);
            sb.append(" : ' ");
            sObject = sObject.replaceAll(",", " ");
            sb.append(sObject);
            sb.append(";\n");
        }
        this.beginDebug();
        this.m_cg.addSourceCode(sb);
        this.endDebug();
    }

    protected void beginDebug() {
        this.m_cg.addSourceCode("\n");
        this.m_cg.addSourceCode("if &");
        this.m_cg.addSourceCode(ETLS_MQDEBUG);
        this.m_cg.addSourceCode("=1");
        this.m_cg.addSourceCode(" then \ndo;\n");
        this.m_cg.indent();
    }

    protected void endDebug() {
        this.m_cg.unIndent();
        this.m_cg.addSourceCode("end;\n");
        this.addBlankLine();
    }

    protected void addCall() {
        this.m_cg.addSourceCode("call ");
        this.m_cg.addSourceCode(this.getClassName());
    }

    protected String getClassName() {
        String fullName = this.getClass().getName().toLowerCase();
        return fullName.substring(fullName.lastIndexOf(".") + 1);
    }

    protected void quote(String sValue) {
        this.m_cg.addSourceCode(QUOTE);
        this.m_cg.addSourceCode(sValue);
        this.m_cg.addSourceCode(QUOTE);
    }

    protected void openParenthesis() {
        this.m_cg.addSourceCode("(");
    }

    protected void closeParenthesis() {
        this.m_cg.addSourceCode(")");
    }

    protected void commaSpace() {
        this.m_cg.addSourceCode(", ");
    }

    protected void addBlankLine() {
        this.m_cg.addSourceCode("\n");
    }

    protected void addCloseLine() {
        this.m_cg.addSourceCode(";\n");
    }

    protected void addString(String sValue) {
        this.m_cg.addSourceCode(sValue);
    }

    protected void addLengthStatement(String sValue, boolean bNumeric, String sLength) {
        this.m_cg.addSourceCode("length ");
        this.m_cg.addSourceCode(sValue);
        if (!bNumeric) {
            this.m_cg.addSourceCode(" $");
        }
        this.m_cg.addSourceCode(" ");
        this.m_cg.addSourceCode(sLength);
        this.m_cg.addSourceCode(";\n");
    }

    protected void addRBComment(String sComment) {
        String sComment2 = bundle.getString("MQROOT." + sComment + ".txt");
        this.m_cg.addCommentLine(sComment2);
    }

    public boolean isDebugModeOn() {
        String sDebug;
        boolean bDebugMode = false;
        if (this.m_hmUserInput.containsKey(ETLS_MQDEBUG_KEY) && (sDebug = (String)this.m_hmUserInput.get(ETLS_MQDEBUG_KEY)).compareToIgnoreCase(YES) == 0) {
            bDebugMode = true;
        }
        return bDebugMode;
    }

    public void assignMacroVariable(String sComment, String sVarName, String sVarValue, boolean bQuoteValue) {
        this.addBlankLine();
        if (sComment != null) {
            this.addRBComment(sComment);
        }
        this.addString("%let ");
        this.addString(sVarName);
        this.addString("=");
        if (bQuoteValue) {
            this.addString(QUOTE);
        }
        this.addString(sVarValue);
        if (bQuoteValue) {
            this.addString(QUOTE);
        }
        this.addString(";\n");
    }

    public void assignVariable(String sComment, String sVarName, String sVarValue, boolean bQuoteValue) {
        if (sComment != null) {
            this.addRBComment(sComment);
        }
        this.addString(sVarName);
        this.addString("=");
        if (bQuoteValue) {
            this.addString(QUOTE);
        }
        if (sVarValue.length() == 0 && !bQuoteValue) {
            this.addString("0");
        } else {
            this.addString(sVarValue);
        }
        if (bQuoteValue) {
            this.addString(QUOTE);
        }
        this.addString(";\n");
    }

    public void assignVariable(String sVarName, String sVarValue, boolean bQuoteValue) {
        this.assignVariable(null, sVarName, sVarValue, bQuoteValue);
    }

    public void assignVariable(String sComment, String sVarName, String sVarValue) {
        this.assignVariable(sComment, sVarName, sVarValue, false);
    }

    public void assignVariable(String sVarName, String sVarValue) {
        this.assignVariable(null, sVarName, sVarValue);
    }

    protected void addExitLine() {
        this.addString("goto ");
        this.addString(EXIT_TOKEN);
        this.addString(";\n");
    }

    protected void freeHandles() throws MdException, RemoteException {
        MQCLOSE mqclose = new MQCLOSE(this.m_cg, this.m_bQueueWriter, this.m_hmUserInput);
        mqclose.generateSASCode();
        MQDISC mqdisc = new MQDISC(this.m_cg, this.m_bQueueWriter, this.m_hmUserInput);
        mqdisc.generateSASCode();
        this.addFreeHandle(SASVAR_OBJECTDESCRIPTOR_HANDLE, bundle.getString("MQROOT.Free_hod.txt.notrans"));
        this.addFreeHandle(SASVAR_PUTMESSAGEOPTIONS_HANDLE, bundle.getString("MQROOT.Free_hpmo.txt.notrans"));
        this.addFreeHandle(SASVAR_MESSAGEDESCRIPTOR_HANDLE, bundle.getString("MQROOT.Free_hmd.txt.notrans"));
        this.addFreeHandle(SASVAR_MAPDESCRIPTOR_HANDLE, bundle.getString("MQROOT.Free_hmap.txt.notrans"));
    }

    protected void freeDataHandles(HashMap mqOptions) throws MdException, RemoteException {
        String sValue;
        if (mqOptions.containsKey(MQFREEDATA) && (sValue = (String)mqOptions.get(MQFREEDATA)).compareToIgnoreCase(NO) == 0) {
            return;
        }
        this.addFreeHandle(SASVAR_MESSAGEDESCRIPTOR_HANDLE, bundle.getString("MQROOT.Free_hmd.txt.notrans"));
        this.addFreeHandle(SASVAR_MAPDESCRIPTOR_HANDLE, bundle.getString("MQROOT.Free_hmap.txt.notrans"));
        this.addFreeHandle(SASVAR_DATADESCRIPTOR_HANDLE, "Free Data handle");
    }

    private void addFreeHandle(String sHandle, String sMessage) {
        this.addString("if ");
        this.addString(sHandle);
        this.addString(" ^=0 then \ndo;\n");
        this.m_cg.indent();
        this.m_cg.addCommentLine(sMessage);
        this.addString("CALL MQFREE(");
        this.addString(sHandle);
        this.addString(");\n");
        this.m_cg.unIndent();
        this.addString("end;\n");
    }

    public boolean isTextOptionSelected() {
        return (Boolean)this.m_hmUserInput.get("etls_text");
    }

    public boolean isTableOptionSelected() {
        return (Boolean)this.m_hmUserInput.get("etls_table");
    }

    public boolean isFileOptionSelected() {
        return (Boolean)this.m_hmUserInput.get("etls_file");
    }

    protected void addFailWithReason(String errorMessage) {
        this.addFailWithReason(errorMessage, "etls_qrc", true);
    }

    protected void addFailWithReason(String errorMessage, String sCode) {
        this.addFailWithReason(errorMessage, sCode, true);
    }

    protected void addFailWithReason(String errorMessage, String sCode, boolean bAddExitLine) {
        this.m_cg.addSourceCode("if ");
        this.m_cg.addSourceCode(sCode);
        this.m_cg.addSourceCode(" ^= 0 then \ndo;\n");
        this.m_cg.indent();
        this.m_cg.genRCSetDSCall("8000", true);
        this.m_cg.addSourceCode("put 'ERROR:").addSourceCode(errorMessage);
        this.m_cg.addSourceCode("' ");
        this.m_cg.addSourceCode("etls_qrc");
        this.m_cg.addSourceCode(" ;\n");
        this.m_cg.addSourceCode(SASVAR_ETLS_MESSAGE);
        this.m_cg.addSourceCode(" = sysmsg();\n");
        this.m_cg.addSourceCode("put ");
        this.m_cg.addSourceCode(SASVAR_ETLS_MESSAGE);
        this.m_cg.addSourceCode(" ;\n");
        if (bAddExitLine) {
            this.addExitLine();
        }
        this.m_cg.unIndent();
        this.m_cg.addSourceCode("end;\n");
    }

    public String getObjectHandleVersion() {
        return this.m_ObjectHandleVersion;
    }

    public void setObjectHandleVersion(String objectHandleVersion) {
        this.m_ObjectHandleVersion = objectHandleVersion;
    }

    public String getObjectHandle() {
        return SASVAR_OBJECT_HANDLE + this.getObjectHandleVersion();
    }

    protected void generateLengthStatements(HashMap parms, String sVersion) {
        Set set = parms.entrySet();
        Iterator it = set.iterator();
        int iCounter = 0;
        int iPreviousLength = 0;
        StringBuffer sbLengthStatement = new StringBuffer();
        StringBuffer sbInitializations = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            ArrayList list = (ArrayList)e.getValue();
            if (!((Boolean)list.get(0)).booleanValue()) continue;
            if (sbLengthStatement.toString().length() - iPreviousLength > 78) {
                sbLengthStatement.append("\n          ");
                iPreviousLength = sbLengthStatement.toString().length();
            }
            if (iCounter == 0) {
                this.m_cg.addCommentLine(bundle.getString("MQROOT.LengthStmt.txt.notrans"));
                sbLengthStatement.append("length");
            }
            ++iCounter;
            sbLengthStatement.append(" ");
            String sParameter = (String)e.getKey() + sVersion;
            if (((Boolean)list.get(2)).booleanValue()) {
                sbInitializations.append(PREFIX1);
                sbInitializations.append(sParameter);
                if (list.get(1) != null) {
                    sbInitializations.append("=\"");
                    sbInitializations.append((String)list.get(1));
                    sbInitializations.append("\";\n");
                } else {
                    sbInitializations.append("=\"\";\n");
                }
                sbLengthStatement.append(PREFIX1);
                sbLengthStatement.append(sParameter);
                sbLengthStatement.append(" $ ");
                if ((Integer)list.get(3) <= 0) continue;
                sbLengthStatement.append(((Integer)list.get(3)).toString());
                continue;
            }
            sbInitializations.append(PREFIX1);
            sbInitializations.append(sParameter);
            if (list.get(1) != null) {
                sbInitializations.append("=");
                sbInitializations.append((String)list.get(1));
                sbInitializations.append(";\n");
            } else {
                sbInitializations.append("=0;\n");
            }
            sbLengthStatement.append(PREFIX1);
            sbLengthStatement.append(sParameter);
            if ((Integer)list.get(3) > 0) {
                sbLengthStatement.append(" ");
                sbLengthStatement.append(((Integer)list.get(3)).toString());
                continue;
            }
            sbLengthStatement.append(" 8");
        }
        this.m_cg.addSourceCode(sbLengthStatement.toString());
        if (sbLengthStatement.toString().length() > 0) {
            this.addCloseLine();
        }
    }

    public static void setDefaultMacroOptions(HashMap mqOptions) {
        if (!mqOptions.containsKey(MQMD.MSGTYPE)) {
            mqOptions.put(MQMD.MSGTYPE, NUM_LEN_EIGHT);
        } else if (!mqOptions.containsKey(MQMD.CORRELID)) {
            mqOptions.put(MQMD.CORRELID, "");
        }
    }

    public static void setMQGlobalVariables(CodegenRequest cgReq, HashMap mqOptions) {
        String sDebug;
        String sSyncPoint;
        String sValue;
        if (mqOptions.containsKey(MQMODEL) && (sValue = (String)mqOptions.get(MQMODEL)).compareToIgnoreCase(CLIENT) == 0) {
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("MQROOT.MQSASDiff.txt.notrans"));
            cgReq.addSourceCode("%let MQMODEL=CLIENT;\n");
        }
        if (mqOptions.containsKey(MQSASTBL)) {
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("MQROOT.OverrideTRANTAB.txt.notrans"));
            cgReq.addSourceCode("%let MQSASTBL=");
            cgReq.addSourceCode((String)mqOptions.get(MQSASTBL));
            cgReq.addSourceCode(";\n");
        }
        if (mqOptions.containsKey(MQSECURE)) {
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("MQROOT.EnableMQSecure.txt.notrans"));
            cgReq.addSourceCode("%let MQSECURE=");
            cgReq.addSourceCode((String)mqOptions.get(MQSECURE));
            cgReq.addSourceCode(";\n");
        }
        if (mqOptions.containsKey(MQSIGNEE)) {
            cgReq.addSourceCode("%let MQSIGNEE=");
            cgReq.addSourceCode((String)mqOptions.get(MQSIGNEE));
            cgReq.addSourceCode(";\n");
        }
        if (mqOptions.containsKey(MQENCRYPTID)) {
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("MQROOT.Userid.txt.notrans"));
            cgReq.addSourceCode("%let MQENCRYPTID=");
            cgReq.addSourceCode((String)mqOptions.get(MQENCRYPTID));
            cgReq.addSourceCode(";\n");
        }
        if (mqOptions.containsKey("MQDECRYPTPW")) {
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("MQROOT.Password.txt.notrans"));
            cgReq.addSourceCode("%let MQDECRYPTPW=");
            cgReq.addSourceCode((String)mqOptions.get("MQDECRYPTPW"));
            cgReq.addSourceCode(";\n");
        }
        if (mqOptions.containsKey(MQGMO.SYNCPOINT) && (sSyncPoint = (String)mqOptions.get(MQGMO.SYNCPOINT)).compareToIgnoreCase(YES) == 0) {
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine("Flag to control commit and rollback");
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(ETLS_CMITFLAG);
            cgReq.addSourceCode("=1;\n");
        }
        if (mqOptions.containsKey(MQSASCNV) && ((sValue = (String)mqOptions.get(MQSASCNV)).compareToIgnoreCase(NO) == 0 || sValue.compareToIgnoreCase(FALSE) == 0)) {
            cgReq.addCommentLine(bundle.getString("MQROOT.TurnoffDataConv.txt.notrans"));
            cgReq.addSourceCode("%let MQSASCNV=OFF;\n");
        }
        if (mqOptions.containsKey(ETLS_MQDEBUG_KEY) && mqOptions.containsKey(ETLS_MQDEBUG_KEY) && (sDebug = (String)mqOptions.get(ETLS_MQDEBUG_KEY)).compareToIgnoreCase(YES) == 0) {
            cgReq.addSourceCode("\n");
            cgReq.addCommentLine(bundle.getString("MQROOT.DebugMode.txt.notrans"));
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(ETLS_MQDEBUG);
            cgReq.addSourceCode("=1;\n");
        }
    }

    public void generateRetainStatement() {
        this.addBlankLine();
        this.m_cg.addCommentLine("retain handles");
        this.m_cg.addSourceCode("retain ");
        this.m_cg.addSourceCode(SASVAR_CONNECTION_HANDLE);
        this.m_cg.addSourceCode(" ");
        this.m_cg.addSourceCode(SASVAR_OBJECT_HANDLE);
        this.m_cg.addSourceCode(" ");
        this.m_cg.addSourceCode(SASVAR_MESSAGEDESCRIPTOR_HANDLE);
        this.m_cg.addSourceCode(" ");
        this.m_cg.addSourceCode(SASVAR_PUTMESSAGEOPTIONS_HANDLE);
        this.m_cg.addSourceCode(" ");
        this.m_cg.addSourceCode(SASVAR_DATADESCRIPTOR_HANDLE);
        this.addCloseLine();
    }

    public static void setV51SendMacroVars(CodegenRequest cgReq, HashMap mqOptions) {
        cgReq.addCommentLine(bundle.getString("MQROOT.bits.txt.notrans"));
        String sKey = SEGMENT_ALLOW;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("=1;\n");
        }
        sKey = SEGMENT;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("=2;\n");
        }
        sKey = LAST_SEGMENT;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("=4;\n");
        }
        sKey = GROUP;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("=8;\n");
        }
        sKey = LAST_GROUP;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("=16;\n");
        }
    }

    public static void setV51ReceiveMacroVars(CodegenRequest cgReq, HashMap mqOptions) {
        cgReq.addCommentLine("MQROOT.bittestmacro.txt.notrans");
        String sKey = SEGMENT_ALLOW_MASK;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("='.......1'b;\n");
        }
        sKey = SEGMENT_MASK;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("='......1.'b;\n");
        }
        sKey = LAST_SEGMENT_MASK;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("='.....1..'b;\n");
        }
        sKey = GROUP_MASK;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("='....1...'b;\n");
        }
        sKey = LAST_GROUP_MASK;
        if (mqOptions.containsKey(sKey)) {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode(" = ");
            cgReq.addSourceCode((String)mqOptions.get(sKey));
        } else {
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(sKey);
            cgReq.addSourceCode("='...1....'b;\n");
        }
    }

    public boolean isSyncPointOn() {
        String sSyncPoint;
        return this.m_hmUserInput.containsKey(MQGMO.SYNCPOINT) && (sSyncPoint = (String)this.m_hmUserInput.get(MQGMO.SYNCPOINT)).compareToIgnoreCase(YES) == 0;
    }

    protected void generateSyncPointCode() throws MdException, RemoteException {
        if (this.isSyncPointOn()) {
            this.addBlankLine();
            this.m_cg.addCommentLine(bundle.getString("MQROOT.commitrollback.txt.notrans"));
            this.generateMQBACKCode();
            this.generateMQCMITCode();
        }
    }

    protected void generateMQBACKCode() throws MdException, RemoteException {
        this.m_cg.addSourceCode("if etls_qrc ^= 0 and etls_qrc ^=2033 then \ndo;\n");
        this.m_cg.indent();
        MQBACK mqback = new MQBACK(this.m_cg, true, this.m_hmUserInput);
        mqback.generateSASCode();
        this.m_cg.addSourceCode("STOP;\n");
        this.m_cg.unIndent();
        this.m_cg.addSourceCode("end;\n");
    }

    protected void generateMQCMITCode() throws MdException, RemoteException {
        this.addBlankLine();
        MQCMIT mqcmit = new MQCMIT(this.m_cg, true, this.m_hmUserInput);
        this.m_cg.addSourceCode("else \ndo;\n");
        this.m_cg.indent();
        mqcmit.generateSASCode();
        this.m_cg.unIndent();
        this.m_cg.addSourceCode("end;\n");
    }

    protected void addLengthForParametersAndOptions() {
        this.m_cg.addCommentLine(bundle.getString("MQROOT.LengthParms.txt.notrans"));
        this.m_cg.addSourceCode("length etls_parms etls_options $ 256;\n");
    }

    protected void addTags() {
        int locn;
        StringBuffer sbSourceCode = this.m_cg.getSourceBuffer();
        StringBuffer sbLC = new StringBuffer(sbSourceCode.toString().toLowerCase());
        int[] iArrayDos = new int[1000];
        int[] iArrayEnds = new int[1000];
        int iIndex = 0;
        int startAt = 0;
        boolean bCondition = true;
        while (bCondition) {
            locn = sbLC.indexOf("do", startAt);
            if (locn < 0) {
                bCondition = false;
                continue;
            }
            String sTemp = sbLC.substring(locn, locn + 3);
            startAt = locn + 1;
            if (sTemp.compareToIgnoreCase("do;") != 0 && sTemp.compareToIgnoreCase("do ") != 0) continue;
            iArrayDos[iIndex++] = locn;
        }
        iIndex = 0;
        startAt = 0;
        bCondition = true;
        while (bCondition) {
            locn = sbLC.indexOf("end;", startAt);
            if (locn < 0) {
                bCondition = false;
                continue;
            }
            startAt = locn + 1;
            if (sbLC.substring(locn - 1, locn + 3).compareToIgnoreCase("MEND") == 0) continue;
            iArrayEnds[iIndex++] = locn;
        }
        iIndex = 0;
        int iEndsIndex = 0;
        int iCharsAdded = 0;
        int iTagCounter = 1;
        String sComment = "/****/";
        StringBuffer sbTag = new StringBuffer(sComment);
        while (iArrayDos[iIndex] > 0) {
            String sTag = sbTag.insert(3, Integer.toString(iTagCounter)).toString();
            ++iTagCounter;
            sbSourceCode = sbSourceCode.insert(iArrayDos[iIndex++] + iCharsAdded + 3, sTag);
            sbTag = new StringBuffer(sComment);
            iCharsAdded += sTag.length();
            while ((iArrayEnds[iEndsIndex] < iArrayDos[iIndex] || iArrayDos[iIndex] == 0) && iArrayEnds[iEndsIndex] > 0) {
                sTag = sbTag.insert(3, Integer.toString(--iTagCounter)).toString();
                sbSourceCode = sbSourceCode.insert(iArrayEnds[iEndsIndex++] + iCharsAdded + 4, sTag);
                sbTag = new StringBuffer(sComment);
                iCharsAdded += sTag.length();
            }
        }
        this.m_cg.clearSourceCode();
        this.m_cg.addSourceCode(sbSourceCode);
    }
}

