/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.queues.QueueModel;
import com.sas.wadmin.transforms.queues.QueueUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class MQOptionsLoader {
    protected QueueModel m_queueModel;
    protected ClassifierMap m_cm;
    protected boolean m_bQueueWriter;
    protected HashMap m_hmUserInput;
    protected static final String EMQ_TEXTOPTION = "etls_text";
    protected static final String EMQ_TABLEOPTION = "etls_table";
    protected static final String EMQ_FILEOPTION = "etls_file";
    protected static final String EMQ_DELIMITER = ";";

    public MQOptionsLoader(ClassifierMap classifierMap, boolean bQueueWriter) throws MdException, RemoteException {
        this.m_cm = classifierMap;
        this.m_bQueueWriter = bQueueWriter;
        this.loadOptions();
    }

    protected void loadOptions() throws MdException, RemoteException {
        this.m_hmUserInput = new HashMap();
        this.m_queueModel = new QueueModel((TransformationStep)this.m_cm.getSteps().get(0), "IBMWSMQ", !this.m_bQueueWriter);
        this.m_queueModel.moveDataToModel();
        PropertyHandler queuePropertyHandler = this.m_queueModel.getMacroPropertyHandler();
        AssociationList alProperties = queuePropertyHandler.getPropertyList();
        if (alProperties != null) {
            for (int i = 0; i < alProperties.size(); ++i) {
                Property property = (Property)alProperties.get(i);
                this.addOption(property.getPropertyName(), queuePropertyHandler.getSpecificOptionValue(property.getPropertyName()));
                if (!property.getPropertyName().toUpperCase().equals("ADDLOPTIONS")) continue;
                this.doProcessAddlOptions(property);
            }
        }
        this.m_hmUserInput.put("etls_message_length", Integer.toString(this.m_queueModel.getMessageLength()));
        this.m_hmUserInput.put("etls_filename", this.m_queueModel.getFileName());
        this.m_hmUserInput.put(EMQ_FILEOPTION, this.m_queueModel.isFileMessage());
        this.m_hmUserInput.put(EMQ_TABLEOPTION, this.m_queueModel.isTableMessage());
        this.m_hmUserInput.put(EMQ_TEXTOPTION, this.m_queueModel.isTextMessage());
        String[] queue = QueueUtil.getQueue(this.m_cm, this.m_bQueueWriter);
        this.m_hmUserInput.put("etls_queuename", queue[0]);
        this.m_hmUserInput.put("etls_queuemanagername", queue[1]);
        if (this.m_bQueueWriter) {
            this.m_hmUserInput.put("etls_text_message", this.m_queueModel.getTextContent());
        } else {
            this.m_hmUserInput.put("etls_macroname", this.m_queueModel.getMacroVariable());
            this.m_hmUserInput.put("etls_directory", this.m_queueModel.getDirectory());
            this.m_hmUserInput.put("etls_saveheader", Boolean.toString(this.m_queueModel.isSaveHeader()));
        }
    }

    private void doProcessAddlOptions(Property property) throws MdException {
        try {
            PropertyHandler queuePropertyHandler = this.m_queueModel.getMacroPropertyHandler();
            String sAddlOptions = queuePropertyHandler.getSpecificOptionValue(property.getPropertyName());
            StringTokenizer st = new StringTokenizer(sAddlOptions, EMQ_DELIMITER);
            ArrayList<String> alNameValue = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                alNameValue.add(st.nextToken());
            }
            for (int iAddlOption = 0; iAddlOption < alNameValue.size(); ++iAddlOption) {
                String sNameValue = (String)alNameValue.get(iAddlOption);
                StringTokenizer st2 = new StringTokenizer(sNameValue, "=");
                int iCounter = 0;
                String sName = "";
                String sValue = "";
                while (st2.hasMoreTokens()) {
                    if (iCounter == 0) {
                        sName = st2.nextToken();
                        sName = sName.trim();
                    } else if (iCounter == 1) {
                        sValue = st2.nextToken();
                        this.addOption(sName, sValue);
                    } else {
                        sValue = st2.nextToken();
                    }
                    ++iCounter;
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void addOption(String sName, String sValue) {
        this.m_hmUserInput.put(sName.toUpperCase(), sValue);
        Workspace.getDefaultLogger().debug((Object)("Name = " + sName + "   Value = " + sValue));
    }

    public HashMap getOptions() {
        return this.m_hmUserInput;
    }
}

