/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.queues;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.queues.MQROOT;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MQCONN
extends MQROOT {
    public MQCONN(CodegenRequest cgReq, boolean bQueueWriter, HashMap hmUserInput) throws MdException, RemoteException {
        super(cgReq, bQueueWriter, hmUserInput);
    }

    public void generateLengthStatements() {
        this.addBlankLine();
        this.addRBComment("SASVAR_CONNECTION_HANDLE");
        this.addLengthStatement("etls_hconn", true, "8");
        this.addBlankLine();
        this.addRBComment("SASVAR_COMPLETION_CODE");
        this.addLengthStatement("etls_compcode", true, "8");
        this.addBlankLine();
        this.addRBComment("SASVAR_REASON_CODE");
        this.addLengthStatement("etls_qrc", true, "8");
    }

    public void generateAssignmentStatements() {
        this.addBlankLine();
        this.assignVariable("EMQ_QUEUEMANAGERNAME", "etls_queuemanagername", this.getQueueManagerName(), true);
        this.addBlankLine();
    }

    public void generateFunctionCall() {
        this.addBlankLine();
        this.m_cg.addCommentLine(bundle.getString("MQCONN.Connect.Comment.notrans"));
        this.buildFunctionCall(this.getFunctionParms());
        this.addFailConditions();
    }

    public List getFunctionParms() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("etls_queuemanagername");
        list.add("etls_hconn");
        list.add("etls_compcode");
        list.add("etls_qrc");
        return list;
    }

    private void addFailConditions() {
        this.m_cg.addCommentLine(bundle.getString("MQCONN.Failure.Comment.notrans"));
        this.addString("if ");
        this.addString("etls_compcode");
        this.addString(" ^= 0 then \ndo;\n");
        this.m_cg.indent();
        this.m_cg.genRCSetDSCall("8000", true);
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2002 then \ndo; \n");
        String msgString = bundle.formatString("MQROOT.REASONCODE2002.Error.fmt.txt", (Object)this.getQueueManagerName());
        this.m_cg.indent();
        this.m_cg.genPutStatement(msgString, "ERROR:");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \n");
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2018 then \ndo;\n");
        this.m_cg.indent();
        msgString = bundle.formatString("MQROOT.REASONCODE2018.Error.txt", (Object)this.getQueueManagerName());
        this.m_cg.genPutStatement(msgString, "ERROR:");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \n");
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2035 then \ndo;\n");
        this.m_cg.indent();
        msgString = bundle.formatString("MQROOT.REASONCODE2035.Error.txt", (Object)this.getQueueManagerName());
        this.m_cg.genPutStatement(msgString, "ERROR:");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \n");
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2058 then \ndo;\n");
        this.m_cg.indent();
        msgString = bundle.formatString("MQROOT.REASONCODE2058.Error.fmt.txt", (Object)this.getQueueManagerName());
        this.m_cg.genPutStatement(msgString, "ERROR:");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \n");
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2059 then \ndo;\n");
        this.m_cg.indent();
        msgString = bundle.formatString("MQROOT.REASONCODE2059.Error.fmt.txt", (Object)this.getQueueManagerName());
        this.m_cg.genPutStatement(msgString, "ERROR:");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \ndo;\n");
        this.m_cg.indent();
        msgString = bundle.getString("MQROOT.REASONCODEOTHER.Error.fmt.txt");
        this.m_cg.genPutStatement(msgString, "ERROR:", "etls_qrc", false);
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addBlankLine();
        this.m_cg.addSourceCode("etls_qmessage");
        this.m_cg.addSourceCode(" = sysmsg();\n");
        this.m_cg.addSourceCode("put \"ERROR: \" ");
        this.m_cg.addSourceCode("etls_qmessage");
        this.m_cg.addSourceCode(" ;\n");
        this.m_cg.genPutStatement(bundle.getString("MQCONN.ErrorConnecting.Error.txt"), "ERROR:", "etls_qmessage", false);
        this.addExitLine();
        this.m_cg.unIndent();
        this.addString("end;\n");
    }
}

