/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.oraclebulkloader;

import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public class OracleNameValueComboBoxModel
extends DefaultComboBoxModel {
    private WAdminResource m_bundle;
    private String m_bundleKey;
    private boolean m_bSorted = false;

    public OracleNameValueComboBoxModel(WAdminResource bundle, String bundleKey, boolean sorted) {
        this.m_bundle = bundle;
        this.m_bundleKey = bundleKey;
        this.m_bSorted = sorted;
    }

    public OracleNameValueComboBoxModel addItem(String value) {
        String name = this.m_bundle.getRawString(this.m_bundleKey + "." + value + ".txt");
        if (name == null) {
            name = "";
        }
        NameValueObject object = new NameValueObject(value, name);
        if (this.m_bSorted) {
            int x;
            int iElement;
            String sObject = object.toString();
            int nElements = this.getSize();
            for (iElement = 0; iElement < nElements && (x = sObject.compareToIgnoreCase(this.getElementAt(iElement).toString())) >= 0; ++iElement) {
            }
            super.insertElementAt(object, iElement);
        } else {
            super.addElement(object);
        }
        return this;
    }

    public OracleNameValueComboBoxModel addItemList(List values) {
        for (int t = 0; t < values.size(); ++t) {
            String value = (String)values.get(t);
            String name = this.m_bundle.getRawString(this.m_bundleKey + "." + value + ".txt");
            if (name == null) {
                name = "";
            }
            NameValueObject object = new NameValueObject(value, name);
            if (this.m_bSorted) {
                int x;
                int iElement;
                String sObject = object.toString();
                int nElements = this.getSize();
                for (iElement = 0; iElement < nElements && (x = sObject.compareToIgnoreCase(this.getElementAt(iElement).toString())) >= 0; ++iElement) {
                }
                super.insertElementAt(object, iElement);
                continue;
            }
            super.addElement(object);
        }
        return this;
    }

    public OracleNameValueComboBoxModel removeItem(String value) {
        String name = this.m_bundle.getRawString(this.m_bundleKey + "." + value + ".txt");
        if (name == null) {
            name = "";
        }
        for (int i = 0; i < this.getSize(); ++i) {
            NameValueObject objInd = (NameValueObject)this.getElementAt(i);
            if (!objInd.getValue().equals(value)) continue;
            this.removeElementAt(i);
        }
        return this;
    }

    public String getSelectedValue() {
        if (this.getSelectedItem() instanceof NameValueObject) {
            return ((NameValueObject)this.getSelectedItem()).getValue();
        }
        if (this.getSelectedItem() != null) {
            return this.getSelectedItem().toString();
        }
        return "";
    }

    public void setSelectedValue(String value) {
        String strValue = value;
        for (int i = 0; i < this.getSize(); ++i) {
            NameValueObject n = (NameValueObject)this.getElementAt(i);
            if (!strValue.equals(n.getValue())) continue;
            super.setSelectedItem(n);
            return;
        }
    }

    public boolean isValueInList(String value) {
        for (int i = 0; i < this.getSize(); ++i) {
            NameValueObject n = (NameValueObject)this.getElementAt(i);
            if (!value.equals(n.getValue())) continue;
            return true;
        }
        return false;
    }

    public void setElementNameAt(int i, String name) {
        NameValueObject n = (NameValueObject)this.getElementAt(i);
        n.m_name = name;
    }

    public String getElementValueAt(int i) {
        NameValueObject n = (NameValueObject)this.getElementAt(i);
        return n.m_value;
    }

    public List getValueList() {
        ArrayList<String> valueList = new ArrayList<String>();
        for (int i = 0; i < this.getSize(); ++i) {
            valueList.add(((NameValueObject)this.getElementAt(i)).getValue());
        }
        return valueList;
    }

    public String getBundleKey() {
        return this.m_bundleKey;
    }

    public void setBundleKey(String key) {
        this.m_bundleKey = key;
    }

    private class NameValueObject {
        private String m_name;
        private String m_value;

        public NameValueObject(String value, String name) {
            this.m_name = name;
            this.m_value = value;
        }

        public String toString() {
            return this.m_name;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

