/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.miningresults;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.miningresults.IMiningResult;
import com.sas.etl.models.job.transforms.miningresults.impl.MiningResultsTransformModel;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsActionContext;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.AbstractTreeModel;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.dualselector.PanelListSelector;
import com.sas.workspace.visuals.dualselector.SelectorPanel;
import com.sas.workspace.visuals.tree.AbstractBaseTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class MiningResultTargetColumnsTab
extends WAPropertyTab {
    private static WAdminResource m_bundle = WAdminResource.getBundle(MiningResultTargetColumnsTab.class);
    private boolean m_bUpdateDataChanged;
    private boolean m_bFirstTime;
    private cTargetSelectTree m_treeTargetSelect;
    private cTargetSelectTreeModel m_mdlTargetSelect;
    private cTreeSelectionListener m_treeSelectionListener;
    private IMiningResult m_oMiningResult;
    private SelectorPanel m_treePanel;
    private cPanelListSelector m_selectorPanel;
    private MiningResultsTransformModel m_model;
    private IModelListener m_lsnrModel;

    public MiningResultTargetColumnsTab(MiningResultsTransformModel model) {
        this.m_model = model;
        this.m_bEditable = true;
        this.initialize();
        this.m_lsnrModel = new ModelListener();
        this.m_model.getModel().addModelListener(this.m_lsnrModel);
        this.setHelpProduct("wdb");
        this.setHelpTopic("propagate_model_cols_tab");
    }

    public void saveSettingsAndCleanUp() {
        this.m_model.getModel().removeModelListener(this.m_lsnrModel);
        this.m_treePanel.removeSelectionChangedListener((WsSelectionChangedListener)this.m_treeSelectionListener);
        this.m_treeTargetSelect.dispose();
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        ITable oTargetTable;
        this.setListeningForChanges(false);
        if (!this.m_bFirstTime && this.m_model.getMiningResult() == null && this.m_oMiningResult == null || this.m_model.getMiningResult() != null && this.m_model.getMiningResult() == this.m_oMiningResult) {
            return;
        }
        ArrayList<Object> lTables = new ArrayList<Object>();
        if (this.m_model.getDataSourcesCount() > 0) {
            lTables.addAll(this.m_model.getDataSourceList());
        }
        if (this.m_model.getMiningResult() != null) {
            if (this.m_model.getMiningResult().getOutputTable() != null) {
                lTables.add(this.m_model.getMiningResult().getOutputTable());
            }
            lTables.add(this.createGeneratedColumnsTable(this.m_model.getMiningResult().getModelKey()));
        }
        this.m_mdlTargetSelect.removeAllChildren((ITreeNode)this.m_mdlTargetSelect.getRoot());
        this.m_mdlTargetSelect.addTables((IDataObject[])lTables.toArray(new ITable[lTables.size()]));
        List targets = this.m_model.getDataTargetList();
        ITable iTable = oTargetTable = targets.isEmpty() ? null : (ITable)targets.get(0);
        if (oTargetTable != null && oTargetTable.getColumnCount() > 0) {
            this.m_treeTargetSelect.selectObjects((SimpleObject[])oTargetTable.getColumns());
            this.m_selectorPanel.transferSourceItems();
            this.m_treeTargetSelect.clearSelection();
            this.m_bUpdateDataChanged = false;
        }
        this.m_oMiningResult = this.m_model.getMiningResult();
        this.m_bFirstTime = false;
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    protected ITable createGeneratedColumnsTable(String sModelKey) throws MdException, RemoteException {
        this.m_model.getModel().startCompoundUndoable();
        try {
            ITable iTable = this.m_model.createGeneratedColumnsTable(sModelKey);
            return iTable;
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
    }

    public static String getDataTableDisplayName(DataTable oDataTable) {
        try {
            if (oDataTable instanceof PhysicalTable) {
                return ((PhysicalTable)oDataTable).getSASTableName();
            }
            return oDataTable.getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateData() {
        if (!this.m_bUpdateDataChanged) {
            return true;
        }
        ListModel mdlTarget = this.m_selectorPanel.getTargetModel();
        this.m_model.getModel().startCompoundUndoable();
        try {
            int iColumn;
            ITable dataTarget = (ITable)this.m_model.getDataTargets()[0];
            IColumn[] aOldColumns = dataTarget.getColumns();
            boolean bRemoveAll = false;
            if (mdlTarget.getSize() == 0 && aOldColumns.length != 0) {
                bRemoveAll = true;
            }
            for (iColumn = 0; iColumn < aOldColumns.length; ++iColumn) {
                int iTargetColumn;
                boolean bFound = false;
                for (iTargetColumn = 0; iTargetColumn < mdlTarget.getSize(); iTargetColumn += 1) {
                    IColumn column = (IColumn)mdlTarget.getElementAt(iTargetColumn);
                    if (!column.getName().equals(aOldColumns[iColumn].getName())) continue;
                    bFound = true;
                    break;
                }
                if (bFound && !bRemoveAll) continue;
                if (dataTarget instanceof IPhysicalTable && ((IPhysicalTable)dataTarget).isColumnUsedInConstraint(aOldColumns[iColumn])) {
                    MessageUtil.displayMessage((String)m_bundle.formatString("MiningResultTargetColumnsTab.ColumnInIndex.txt", (Object)aOldColumns[iColumn].getName()), (int)1);
                    iTargetColumn = 0;
                    return iTargetColumn != 0;
                }
                dataTarget.removeColumn(aOldColumns[iColumn]);
            }
            for (iColumn = 0; iColumn < mdlTarget.getSize(); ++iColumn) {
                boolean bNameMatch = false;
                IColumn column = (IColumn)mdlTarget.getElementAt(iColumn);
                for (int iTargetColumn = 0; iTargetColumn < aOldColumns.length; ++iTargetColumn) {
                    if (!column.getName().equals(aOldColumns[iTargetColumn].getName())) continue;
                    bNameMatch = true;
                    break;
                }
                if (bNameMatch) continue;
                IColumn columnNew = this.m_model.getModel().getObjectFactory().createNewColumn(dataTarget.getID());
                column.deepCopy(columnNew);
                dataTarget.addColumn(columnNew);
            }
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
        return true;
    }

    protected void initialize() {
        this.setName(m_bundle.getString("MiningResultTargetColumnsTab.Title.txt"));
        this.m_bFirstTime = true;
        this.m_treeTargetSelect = this.createTargetSelectTree();
        this.m_treeTargetSelect.getSelectionModel().setSelectionMode(4);
        this.m_treePanel = new cTreePanel(this.m_treeTargetSelect);
        this.m_treeSelectionListener = new cTreeSelectionListener();
        this.m_treePanel.addSelectionChangedListener((WsSelectionChangedListener)new cTreeSelectionListener());
        this.m_selectorPanel = new cPanelListSelector((JPanel)this.m_treePanel);
        this.m_selectorPanel.setTargetCellRenderer(new cListCellRenderer());
        this.m_selectorPanel.setCopyModeEnabled(true);
        this.m_selectorPanel.setCopyModeDuplicatesAllowed(false);
        this.m_selectorPanel.setDragAndDropEnabled(false);
        this.m_selectorPanel.setTransferAllControlsVisible(false);
        this.m_treeTargetSelect.setUserDefaultAction((Action)((Object)new defaultAction()));
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.m_selectorPanel), "Center");
    }

    protected cTargetSelectTree createTargetSelectTree() {
        this.m_mdlTargetSelect = new cTargetSelectTreeModel();
        cTargetSelectTree treeTarget = new cTargetSelectTree((ITreeModel)this.m_mdlTargetSelect);
        treeTarget.setScrollsOnExpand(true);
        treeTarget.setEditable(false);
        treeTarget.setRootVisible(false);
        return treeTarget;
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (obj == MiningResultTargetColumnsTab.this.m_model && sType.equals("MiningResultTransformModel:MiningResultChanged")) {
                MiningResultTargetColumnsTab.this.m_model.getModel().undoableEditHappened((UndoableEdit)new RemoveFromListUndoable(MiningResultTargetColumnsTab.this.m_selectorPanel.getTargetAdapter().getAllItems(), MiningResultTargetColumnsTab.this.m_selectorPanel.getTargetAdapter()));
                MiningResultTargetColumnsTab.this.m_selectorPanel.getTargetAdapter().removeItems(MiningResultTargetColumnsTab.this.m_selectorPanel.getTargetAdapter().getAllItems());
            }
        }
    }

    private class AddToListUndoable
    extends AbstractUndoableEdit {
        private List m_lColumns;
        private DualSelectorInterface m_adapter;

        public AddToListUndoable(List lColumns, DualSelectorInterface adapter) {
            this.m_lColumns = lColumns;
            this.m_adapter = adapter;
        }

        @Override
        public void undo() {
            super.undo();
            this.m_adapter.removeItems(this.m_lColumns);
        }

        @Override
        public void redo() {
            super.redo();
            this.m_adapter.addItems(this.m_lColumns);
        }
    }

    private class RemoveFromListUndoable
    extends AbstractUndoableEdit {
        private List m_lColumns;
        private DualSelectorInterface m_adapter;

        public RemoveFromListUndoable(List lColumns, DualSelectorInterface adapter) {
            this.m_lColumns = lColumns;
            this.m_adapter = adapter;
        }

        @Override
        public void undo() {
            super.undo();
            this.m_adapter.addItems(this.m_lColumns);
        }

        @Override
        public void redo() {
            super.redo();
            this.m_adapter.removeItems(this.m_lColumns);
        }
    }

    private class defaultAction
    extends WsAbstractAction {
        public void actionPerformed(ActionEvent ev) {
            MiningResultTargetColumnsTab.this.m_selectorPanel.transferSourceItems();
        }
    }

    public class cListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int iRow, boolean bSelected, boolean bHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, iRow, bSelected, bHasFocus);
            if (value instanceof IColumn) {
                IColumn column = (IColumn)value;
                this.setIcon(ColumnUIUtilities.getTypeIcon(column.getType()));
                this.setText(column.getName());
            }
            return this;
        }
    }

    public class cTreePanel
    extends JPanel
    implements SelectorPanel {
        private cTargetSelectTree m_tree;

        public cTreePanel(cTargetSelectTree tree) {
            this.m_tree = tree;
            this.initialize();
        }

        protected void initialize() {
            JScrollPane scrObjectSelector = new JScrollPane((Component)((Object)MiningResultTargetColumnsTab.this.m_treeTargetSelect));
            scrObjectSelector.setPreferredSize(new Dimension(200, 200));
            this.setLayout(new BorderLayout());
            this.add((Component)scrObjectSelector, "Center");
        }

        public void clearSelection() {
            this.m_tree.clearSelection();
        }

        public int getItemCount() {
            return this.m_tree.getRowCount();
        }

        public int getSelectedItemsCount() {
            return this.m_tree.getSelectedObjects().length;
        }

        public int getLastSelectedIndex() {
            int[] aRows = this.m_tree.getSelectionRows();
            return aRows.length == 0 ? -1 : aRows[aRows.length - 1];
        }

        public void setSelectedIndex(int index) {
            this.m_tree.setSelectionRow(index);
        }

        public List getSelectedItems() {
            return new ArrayList<Object>(Arrays.asList(this.getSelectedObjects()));
        }

        public List getAllItems() {
            TreeModel model = this.m_tree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
            return Collections.list(root.breadthFirstEnumeration());
        }

        public List getAllMoveableItems() {
            return this.getAllItems();
        }

        public void addItems(List newItems) {
            throw new UnsupportedOperationException("Adding items is not supported.");
        }

        public void removeItems(List removeItems) {
            throw new UnsupportedOperationException("Removing items is not supported.");
        }

        public boolean containsItem(Object item) {
            String sID;
            if (!(item instanceof SimpleObject) || (sID = ((SimpleObject)item).getID()) != null) {
                // empty if block
            }
            return false;
        }

        public Object[] getSelectedObjects() {
            ArrayList<Object> lSelectedObjects = new ArrayList<Object>();
            IDataTreeNode[] nodes = this.m_tree.getSelectedDataNodes();
            for (int iNode = 0; iNode < nodes.length; ++iNode) {
                IDataTreeNode node = nodes[iNode];
                if (node.getAllowsChildren()) {
                    node.expand();
                    Enumeration childNodes = node.children();
                    while (childNodes.hasMoreElements()) {
                        IDataTreeNode childNode = (IDataTreeNode)childNodes.nextElement();
                        if (lSelectedObjects.indexOf(childNode.getData()) != -1) continue;
                        lSelectedObjects.add(childNode.getData());
                    }
                    continue;
                }
                if (lSelectedObjects.indexOf(node.getData()) != -1) continue;
                lSelectedObjects.add(node.getData());
            }
            return lSelectedObjects.toArray();
        }

        public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
            this.m_tree.addSelectionChangedListener(lsnr);
        }

        public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
            this.m_tree.removeSelectionChangedListener(lsnr);
        }

        public void dispose() {
            this.m_tree.dispose();
        }
    }

    protected class cPanelListSelector
    extends PanelListSelector {
        public cPanelListSelector(JPanel panel) {
            super(panel);
        }

        public DualSelectorInterface getTargetAdapter() {
            return this.targetAdapter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List lItems) {
            if (MiningResultTargetColumnsTab.this.m_model.getDataTargetsCount() == 0) {
                MessageUtil.displayMessage((String)m_bundle.getString("MiningResultTargetColumnsTab.NoTargetTable.txt"), (int)1);
                return;
            }
            if (lItems == null) {
                lItems = fromAdapter.getSelectedItems();
            }
            MiningResultTargetColumnsTab.this.m_bUpdateDataChanged = true;
            if (MiningResultTargetColumnsTab.this.isListeningForChanges() && !MiningResultTargetColumnsTab.this.m_bFirstTime) {
                MiningResultTargetColumnsTab.this.setDataChanged(true);
            }
            if (lItems.size() > 0) {
                DualSelectorInterface dualSelectorInterface = fromAdapter;
                synchronized (dualSelectorInterface) {
                    DualSelectorInterface dualSelectorInterface2 = toAdapter;
                    synchronized (dualSelectorInterface2) {
                        if (fromAdapter == this.sourceAdapter) {
                            List lTargets = toAdapter.getAllItems();
                            if (lItems.isEmpty()) {
                                return;
                            }
                            this.filterDuplicates(lItems, lTargets);
                            if (lItems.size() > 0) {
                                MiningResultTargetColumnsTab.this.m_model.getModel().undoableEditHappened((UndoableEdit)new AddToListUndoable(lItems, this.targetAdapter));
                                if (!this.copyModeEnabled) {
                                    fromAdapter.removeItems(lItems);
                                }
                                toAdapter.addItems(lItems);
                            }
                        } else {
                            fromAdapter.removeItems(lItems);
                            MiningResultTargetColumnsTab.this.m_model.getModel().undoableEditHappened((UndoableEdit)new RemoveFromListUndoable(lItems, fromAdapter));
                            if (!this.copyModeEnabled) {
                                toAdapter.addItems(lItems);
                            }
                        }
                        this.ensureButtonsEnabled();
                        this.firePropertyChange("sourceItems", null, null);
                        this.firePropertyChange("targetItems", null, null);
                        this.selectedItems = null;
                    }
                }
            }
        }

        protected void filterDuplicates(List lSources, List lTargets) {
            SimpleObject oSource;
            ArrayList<String> lDuplicates = new ArrayList<String>();
            block0: for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                oSource = (SimpleObject)lSources.get(iSource);
                for (int iOtherSource = 0; iOtherSource < lSources.size(); ++iOtherSource) {
                    SimpleObject oOtherSource;
                    if (iSource == iOtherSource || !this.objectsAreDuplicates(oSource, oOtherSource = (SimpleObject)lSources.get(iOtherSource))) continue;
                    lDuplicates.add(oSource.getName());
                    lSources.remove(iSource++);
                    continue block0;
                }
            }
            Iterator iterSources = lSources.iterator();
            block2: while (iterSources.hasNext()) {
                oSource = (SimpleObject)iterSources.next();
                for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
                    SimpleObject oTarget = (SimpleObject)lTargets.get(iTarget);
                    if (!this.objectsAreDuplicates(oSource, oTarget)) continue;
                    lDuplicates.add(oSource.getName());
                    iterSources.remove();
                    continue block2;
                }
            }
            if (lDuplicates.size() > 0) {
                MessageUtil.displayListMessage((String)m_bundle.getString("MiningResultTargetColumnsTab.DuplicatesError.txt"), lDuplicates, (int)0);
            }
        }

        private boolean objectsAreDuplicates(SimpleObject oSource, SimpleObject oTarget) {
            SimpleObject c1 = oSource;
            SimpleObject c2 = oTarget;
            String c1Name = c1.getName();
            String c2Name = c2.getName();
            return c1Name.equalsIgnoreCase(c2Name);
        }
    }

    public class cTargetSelectTreeModel
    extends AbstractTreeModel {
        public cTargetSelectTreeModel() {
            super(Workspace.getWorkspace().getUserContext(), null);
            cRootNode treeRoot = new cRootNode();
            treeRoot.setTreeModel((ITreeModel)this);
            treeRoot.setSorted(false);
            this.setRoot((TreeNode)((Object)treeRoot));
        }

        public void moveDataToModel() {
            this.removeAllChildren((ITreeNode)this.getRoot());
        }

        public List findNodes(DefaultMutableTreeNode startingNode, String sName) {
            ArrayList<ITreeNode> lNodes = new ArrayList<ITreeNode>();
            Enumeration<TreeNode> enumNodes = startingNode.breadthFirstEnumeration();
            while (enumNodes.hasMoreElements()) {
                ITreeNode nodeCurrent = (ITreeNode)enumNodes.nextElement();
                if (!(nodeCurrent instanceof IDataTreeNode) || !sName.equals(((IDataTreeNode)nodeCurrent).getName())) continue;
                lNodes.add(nodeCurrent);
            }
            return lNodes;
        }

        public void addTables(IDataObject[] aTable) {
            for (int iTable = 0; iTable < aTable.length; ++iTable) {
                this.addTable(aTable[iTable]);
            }
        }

        public void addTable(IDataObject oTable) {
            cRootNode rootNode = (cRootNode)((Object)this.getRoot());
            if (oTable instanceof ITable) {
                cTableNode tableNode = new cTableNode((ITable)oTable);
                this.addChild((ITreeNode)tableNode, (ITreeNode)rootNode);
                tableNode.addChildren();
            }
        }

        public void addChild(IDataTreeNode newNode) {
        }

        public void addChildren(ITreeNode parentNode) {
        }

        public List findParentNodes(SimpleBrowseObject object) {
            return null;
        }

        public boolean isValidParent(ITreeNode parentNode, ITreeNode childNode) {
            return false;
        }

        protected class cColumnNode
        extends AbstractTreeNode
        implements IDataTreeNode {
            private IColumn m_column;
            private ITable m_table;

            public cColumnNode(IColumn oColumn, ITable oTable) {
                super((Object)oColumn.getName());
                this.setAllowsChildren(false);
                this.m_column = oColumn;
                this.m_table = oTable;
            }

            public Icon getIcon() {
                Icon icon = ColumnUIUtilities.getTypeIcon(this.m_column.getType());
                return icon != null ? icon : WorkspaceTree.getDefaultLeafIcon();
            }

            public boolean isFolder() {
                return false;
            }

            public String getType() {
                return "" + this.m_column.getType();
            }

            public boolean isEditable() {
                return false;
            }

            public boolean isValidDragSource() {
                return true;
            }

            public boolean isValidDropTarget() {
                return false;
            }

            public boolean delete() {
                return false;
            }

            public Object getData() {
                return this.m_column;
            }

            public String getID() {
                return this.m_column.getID();
            }

            public boolean isDeleteAllowed() {
                return false;
            }

            public boolean isRenameAllowed() {
                return false;
            }

            public boolean isValidName(String sNewName) {
                return false;
            }

            public void rename(String sNewName) {
            }

            public void update() {
            }

            public ITable getTable() {
                return this.m_table;
            }
        }

        protected class cTableNode
        extends AbstractTreeNode
        implements IDataTreeNode {
            private ITable m_table;

            public cTableNode(ITable oTable) {
                super((Object)oTable.getName(), true);
                this.m_table = oTable;
            }

            public void addChildren() {
                IColumn[] aColumn = this.m_table.getColumns();
                for (int iColumn = 0; iColumn < this.m_table.getColumnCount(); ++iColumn) {
                    cTargetSelectTreeModel.this.addChild((ITreeNode)new cColumnNode(aColumn[iColumn], this.m_table), (ITreeNode)this);
                }
            }

            public Icon getIcon() {
                return WsAbstractIconFactory.getInstance().getDecoratableIconForSimpleObject((SimpleObject)this.m_table);
            }

            public boolean isFolder() {
                return false;
            }

            public String getType() {
                return this.m_table.getMetadataType();
            }

            public boolean isEditable() {
                return false;
            }

            public boolean isValidDragSource() {
                return false;
            }

            public boolean isValidDropTarget() {
                return false;
            }

            public boolean delete() {
                return false;
            }

            public Object getData() {
                return this.m_table;
            }

            public String getID() {
                return this.m_table.getID();
            }

            public boolean isDeleteAllowed() {
                return false;
            }

            public boolean isRenameAllowed() {
                return false;
            }

            public boolean isValidName(String sNewName) {
                return false;
            }

            public void rename(String sNewName) {
            }

            public void update() {
            }
        }

        private class cRootNode
        extends AbstractTreeNode {
            public cRootNode() {
                super((Object)"TargetRoot");
            }

            public Icon getIcon() {
                return null;
            }

            public boolean isFolder() {
                return true;
            }
        }
    }

    public class cTargetSelectTree
    extends AbstractBaseTree {
        public static final String TARGET_SELECT_TREE_CONTEXT = "TargetSelectTree";

        public cTargetSelectTree(ITreeModel model) {
            super(model);
            this.setShowsRootHandles(true);
            this.setContextMenusEnabled(false);
            this.expandRoot();
        }

        protected WsActionContextInterface createActionContext() {
            return new WsActionContext(TARGET_SELECT_TREE_CONTEXT, (WsSelectionProvider)this);
        }

        public void selectObjects(SimpleObject[] aSimpleObjects) {
            this.clearSelection();
            for (int i = 0; i < aSimpleObjects.length; ++i) {
                String sName = aSimpleObjects[i].getName();
                List lNodes = ((ITreeModel)this.getModel()).findNodes(sName);
                for (int j = 0; j < lNodes.size(); ++j) {
                    this.addSelectionPath(this.getPathFor((ITreeNode)lNodes.get(j)));
                }
            }
            this.scrollPathToVisible(this.getLeadSelectionPath());
        }
    }

    class cTreeSelectionListener
    implements WsSelectionChangedListener {
        cTreeSelectionListener() {
        }

        public void selectionChanged(WsSelectionChangedEvent ev) {
            if (!MiningResultTargetColumnsTab.this.isListeningForChanges()) {
                return;
            }
            if (MiningResultTargetColumnsTab.this.m_bUpdateDataChanged) {
                MiningResultTargetColumnsTab.this.setDataChanged(true);
            }
        }
    }
}

