/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.miningresults;

import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.job.transforms.miningresults.IMiningResult;
import com.sas.etl.models.job.transforms.miningresults.impl.MiningResultsTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.model.LogicalPublicTypeFilter;
import com.sas.wadmin.transforms.miningresults.MiningResultInfoPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.InventoryTreeModel;
import com.sas.workspace.visuals.tree.InventoryTree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class MiningResultSelectorTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(MiningResultSelectorTab.class);
    private IMiningResult m_mdMR;
    private MiningResultsTransformModel m_model;
    private InventoryTree m_inventoryTree;
    private MiningResultInfoPanel m_pnlMRInfo;

    public MiningResultSelectorTab(MiningResultsTransformModel model) {
        this.m_model = model;
        this.initialize();
        this.setHelpProduct("wdb");
        this.setHelpTopic("mining_results_query_tab");
    }

    protected void initialize() {
        this.setName(bundle.getString("MiningResultSelectorTab.Title.txt"));
        InventoryTreeModel inventoryTreeModel = new InventoryTreeModel(Workspace.getWorkspace().getUserContext());
        inventoryTreeModel.setCategoryFilter((IPublicTypeFilter)new cMiningResultPublicTypeInventoryFilter());
        this.m_inventoryTree = new InventoryTree((ITreeModel)inventoryTreeModel);
        this.m_inventoryTree.setContextMenusEnabled(false);
        this.m_inventoryTree.setEditable(false);
        this.m_inventoryTree.setDraggingEnabled(false);
        this.m_inventoryTree.getSelectionModel().setSelectionMode(1);
        this.m_inventoryTree.addSelectionChangedListener((WsSelectionChangedListener)new cTreeSelectionListener());
        this.m_inventoryTree.setUserDefaultAction((Action)((Object)new defaultAction()));
        JScrollPane scrObjectSelector = new JScrollPane((Component)this.m_inventoryTree);
        scrObjectSelector.setPreferredSize(new Dimension(200, 200));
        this.m_pnlMRInfo = new MiningResultInfoPanel(true);
        this.setLayout(new GridBagLayout());
        this.add(scrObjectSelector, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlMRInfo), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdMR = this.m_model.getMiningResult();
        this.m_inventoryTree.expandAllUnderNode((ITreeNode)this.m_inventoryTree.getModel().getRoot());
        if (this.m_mdMR != null) {
            this.m_inventoryTree.selectObjects(new SimpleObject[]{(SimpleObject)this.m_mdMR});
        }
        this.m_pnlMRInfo.setMiningResult(this.m_mdMR);
        this.setListeningForChanges(true);
    }

    public boolean validateData() {
        if (this.isListeningForChanges()) {
            this.m_model.getModel().startCompoundUndoable();
            try {
                boolean Valid = true;
                try {
                    Valid = this.validateModelChange();
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                if (Valid) {
                    this.updateInfoPanel();
                    this.setDataChanged(true);
                }
            }
            finally {
                this.m_model.getModel().endCompoundUndoable();
            }
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_inventoryTree.dispose();
    }

    public boolean validateModelChange() throws MdException, RemoteException {
        if (this.m_mdMR == null && this.m_model.getMiningResult() != null || this.m_mdMR != null && !this.m_mdMR.equals(this.m_model.getMiningResult())) {
            if (this.m_model.getDataTargets().length > 0 && ((ITable)this.m_model.getDataTargetList().get(0)).getColumnCount() > 0) {
                int eAnswer = MessageUtil.displayMessage((String)bundle.getString("MiningResultSelectorTab.ChangedMiningResultsModelMessage.txt"), (String)bundle.getString("MiningResultSelectorTab.ChangedMiningResultsModelTitle.txt"), (int)2, (int)0);
                if (eAnswer == 0) {
                    this.m_model.setMiningResult(this.m_mdMR);
                    ITable table = (ITable)this.m_model.getDataTargetList().get(0);
                    IColumn[] aOldColumns = ((ITable)this.m_model.getDataTargetList().get(0)).getColumns();
                    if (table instanceof IPhysicalTable) {
                        ((IPhysicalTable)table).getIndexesList().clear();
                        ((IPhysicalTable)table).getKeysList().clear();
                        ((IPhysicalTable)table).getForeignKeysList().clear();
                    }
                    for (int iColumn = 0; iColumn < aOldColumns.length; ++iColumn) {
                        table.removeColumn(aOldColumns[iColumn]);
                    }
                    return true;
                }
                this.m_inventoryTree.clearSelection();
                this.m_mdMR = this.m_model.getMiningResult();
                return false;
            }
            if (this.m_mdMR != this.m_model.getMiningResult()) {
                this.m_model.setMiningResult(this.m_mdMR);
            }
        } else {
            return false;
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_inventoryTree.setEnabled(bEditable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInfoPanel() {
        try {
            Object[] objects = this.m_inventoryTree.getSelectedObjects();
            if (objects == null || objects.length == 0 || !(objects[0] instanceof SimpleObject)) {
                this.m_mdMR = null;
                this.m_pnlMRInfo.setMiningResult(null);
                return;
            }
            SimpleObject simpleObj = (SimpleObject)objects[0];
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "MiningResultSelectorTab:LoadMiningResult");
            try {
                Root mdObj = ObjectConverter.getInstance().convertToJOMAObject(store, simpleObj);
                IMiningResult miningResult = (IMiningResult)((DesignTimeJobModel)this.m_model.getModel()).getObjectFactory().createObjectFromOMRObject(mdObj);
                ((DesignTimeJobModel)this.m_model.getModel()).loadFromOMR((IOMRPersistable)miningResult, Workspace.getMdFactory());
                this.m_model.getModel().undoableEditHappened((UndoableEdit)new ChangeMiningResultUndoable(this.m_mdMR, miningResult));
                this.m_mdMR = miningResult;
                this.m_pnlMRInfo.setMiningResult(this.m_mdMR);
            }
            finally {
                store.dispose();
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            return;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return;
        }
    }

    private class ChangeMiningResultUndoable
    extends AbstractUndoableEdit {
        private IMiningResult m_oldMiningResult;
        private IMiningResult m_newMiningResult;

        public ChangeMiningResultUndoable(IMiningResult oldMiningResult, IMiningResult newMiningResult) {
            this.m_oldMiningResult = oldMiningResult;
            this.m_newMiningResult = newMiningResult;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_oldMiningResult != null) {
                MiningResultSelectorTab.this.m_inventoryTree.selectObjects(new SimpleObject[]{(SimpleObject)this.m_oldMiningResult});
            } else {
                MiningResultSelectorTab.this.m_inventoryTree.clearSelection();
            }
            MiningResultSelectorTab.this.updateInfoPanel();
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_newMiningResult != null) {
                MiningResultSelectorTab.this.m_inventoryTree.selectObjects(new SimpleObject[]{(SimpleObject)this.m_newMiningResult});
            } else {
                MiningResultSelectorTab.this.m_inventoryTree.clearSelection();
            }
            MiningResultSelectorTab.this.updateInfoPanel();
        }
    }

    private class defaultAction
    extends WsAbstractAction {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    public class cMiningResultPublicTypeInventoryFilter
    extends LogicalPublicTypeFilter {
        @Override
        public boolean accept(String sPublicType) {
            if (sPublicType == null || !sPublicType.equals("MiningResults")) {
                return false;
            }
            return super.accept(sPublicType);
        }
    }

    class cTreeSelectionListener
    implements WsSelectionChangedListener {
        cTreeSelectionListener() {
        }

        public void selectionChanged(WsSelectionChangedEvent ev) {
            if (!MiningResultSelectorTab.this.isListeningForChanges()) {
                return;
            }
            MiningResultSelectorTab.this.updateInfoPanel();
            MiningResultSelectorTab.this.setDataChanged(true);
        }
    }
}

