/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.lookup.visuals;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.lookup.LookupMapping;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.transforms.lookup.visuals.ExceptionsTab;
import com.sas.wadmin.transforms.lookup.visuals.LookupTableModel;
import com.sas.wadmin.visuals.common.ExpressionBuilderTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAbstractTablePropertyTab;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class LookupTab
extends WsAbstractTablePropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(LookupTab.class);
    private LookupTransformModel m_lookup;
    private JButton m_btnProperties;
    private WsAbstractAction m_actProperties;

    public LookupTab(LookupTransformModel lookup) {
        this.m_lookup = lookup;
        ((LookupTableModel)this.m_mdl).setLookupModel(lookup);
        this.setHelpProduct("wdb");
        this.setHelpTopic("lookups_tab");
        this.setName(bundle.getString("LookupTab.Title.txt"));
    }

    protected void createActions() {
        super.createActions();
        this.m_actProperties = new cPropertiesAction();
    }

    protected void createTable() {
        super.createTable();
        this.m_tbl.setColumnHidingEnabled(false);
        this.m_tbl.setColumnHoldingEnabled(false);
        this.m_tbl.setRowHeaderVisible(false);
        this.m_tbl.setViewportPopupMenuEnabled(false);
        this.m_tbl.setCellSelectionEnabled(false);
        this.m_tbl.setRowSelectionAllowed(true);
        this.m_tbl.setAutoResizeMode(4);
        this.m_tbl.setSelectionMode(0);
        this.m_tbl.addMouseListener((MouseListener)new cTableMouseListener());
        this.m_tbl.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new cWsPopupMenuRequestListener());
        this.m_tbl.getRowModel().getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        this.setWAUndoManager(new WAUndoManager());
        this.setTableToolTip(bundle.getString("LookupTab.Table.ToolTip.txt"));
    }

    protected WsAbstractTableModel createTableModel(Root oData) {
        this.m_mdl = new LookupTableModel(this.m_lookup);
        return this.m_mdl;
    }

    protected void createButtonsPanel() {
        this.m_btnProperties = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actProperties);
        this.m_pnlButtons = new JPanel((LayoutManager)new WsButtonsLayout());
        this.m_pnlButtons.add(this.m_btnProperties);
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_mdl.populateStore();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_lookup.getLookupTables().isEmpty()) {
            MessageUtil.displayMessage((String)bundle.getString("LookupTab.NoLookupTables.txt"), (int)0);
            return;
        }
        this.m_mdl.moveDataToModel();
        if (this.m_mdl.getRowCount() > 0) {
            this.m_tbl.selectRow(0);
        }
        this.setListeningForChanges(true);
    }

    protected void updateActions() {
        int iSelectedRow = this.m_tbl.getSelectedRow();
        this.m_actProperties.setEnabled(iSelectedRow != -1);
    }

    protected void launchPropertiesDialog() {
        int iRow = this.m_tbl.getSelectedRow();
        iRow = this.m_tbl.convertRowIndexToModel(iRow);
        LookupMapping lookupMapping = ((LookupTableModel)this.m_mdl).getLookupMapping(iRow);
        IPhysicalTable lookupTable = lookupMapping.getLookupTable();
        IMappingsContainer keyMappings = lookupMapping.getKeyMappings();
        IMappingsContainer dataMappings = lookupMapping.getDataMappings();
        WATabbedPanel pnlTabs = new WATabbedPanel();
        MappingsTab.Configuration keyMappingsConfig = new MappingsTab.Configuration();
        keyMappingsConfig.setPropagationActionsVisible(2);
        keyMappingsConfig.setSettingsActionVisible(false);
        keyMappingsConfig.setSourceTablesEditable(false);
        keyMappingsConfig.setTargetTablesEditable(false);
        keyMappingsConfig.setExpressionActionsVisible(false);
        keyMappingsConfig.setDragMultipleSourceColumnsEnabled(false);
        keyMappingsConfig.setDragMultipleTargetColumnsEnabled(false);
        keyMappingsConfig.setTargetTableLabel(bundle.getString("LookupTab.LookupTableLabel.txt"));
        keyMappingsConfig.setSettingsKeyPrefix("Lookup_SourceToLookup");
        keyMappingsConfig.setMappingsFilter(new cLookupKeyMappingsFilter());
        int[] aOrigKeyHiddenColumns = keyMappingsConfig.getHiddenColumnsInTargetColumnsTable();
        int[] aNewKeyHiddenColumns = new int[aOrigKeyHiddenColumns.length + 3];
        System.arraycopy(aOrigKeyHiddenColumns, 0, aNewKeyHiddenColumns, 0, aOrigKeyHiddenColumns.length);
        aNewKeyHiddenColumns[aNewKeyHiddenColumns.length - 3] = 0;
        aNewKeyHiddenColumns[aNewKeyHiddenColumns.length - 2] = 1;
        aNewKeyHiddenColumns[aNewKeyHiddenColumns.length - 1] = 4;
        keyMappingsConfig.setHiddenColumnsInTargetColumnsTable(aNewKeyHiddenColumns);
        MappingsTab keyMappingsTab = new MappingsTab(keyMappings, keyMappingsConfig);
        keyMappingsTab.setHelpProduct("wdb");
        keyMappingsTab.setHelpTopic("lookup_mapping_source");
        pnlTabs.addTab(bundle.getString("LookupTab.SourceToLookupTab.Title.txt"), (WAPropertyTab)keyMappingsTab);
        MappingsTab.Configuration dataMappingsConfig = new MappingsTab.Configuration();
        dataMappingsConfig.setPropagationActionsVisible(1);
        dataMappingsConfig.setSettingsActionVisible(false);
        dataMappingsConfig.setSourceTablesEditable(false);
        dataMappingsConfig.setExpressionActionsVisible(false);
        dataMappingsConfig.setDragMultipleSourceColumnsEnabled(false);
        dataMappingsConfig.setDragMultipleTargetColumnsEnabled(false);
        dataMappingsConfig.setSourceTableLabel(bundle.getString("LookupTab.LookupTableLabel.txt"));
        dataMappingsConfig.setSettingsKeyPrefix("Lookup_LookupToTarget");
        dataMappingsConfig.setMappingsFilter(new cLookupDataMappingsFilter());
        int[] aOrigDataHiddenColumns = dataMappingsConfig.getHiddenColumnsInTargetColumnsTable();
        int[] aNewDataHiddenColumns = new int[aOrigDataHiddenColumns.length + 3];
        System.arraycopy(aOrigDataHiddenColumns, 0, aNewDataHiddenColumns, 0, aOrigDataHiddenColumns.length);
        aNewDataHiddenColumns[aNewDataHiddenColumns.length - 3] = 0;
        aNewDataHiddenColumns[aNewDataHiddenColumns.length - 2] = 1;
        aNewDataHiddenColumns[aNewDataHiddenColumns.length - 1] = 4;
        dataMappingsConfig.setHiddenColumnsInTargetColumnsTable(aNewDataHiddenColumns);
        MappingsTab dataMappingsTab = new MappingsTab(dataMappings, dataMappingsConfig);
        dataMappingsTab.setHelpProduct("wdb");
        dataMappingsTab.setHelpTopic("lookup_mapping_target");
        pnlTabs.addTab(bundle.getString("LookupTab.LookupToTargetTab.Title.txt"), (WAPropertyTab)dataMappingsTab);
        ITable[] aLookupTable = new ITable[]{lookupTable};
        ExpressionBuilderTab whereTab = new ExpressionBuilderTab(null, aLookupTable, true);
        IExpression expression = lookupMapping.getExpression();
        try {
            if (expression != null && expression.getExpressionType().equalsIgnoreCase("DERIVED")) {
                whereTab.setExpression(((ITextExpression)expression).getText(null, this.m_lookup.isQuotingNeeded(), false));
            }
        }
        catch (RemoteException e1) {
            Workspace.handleRemoteException((RemoteException)e1);
        }
        catch (CodegenException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (MdException e1) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
        }
        catch (BadServerDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (ServerException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        whereTab.setUseQuotes(lookupTable.isQuoted());
        whereTab.setHelpProduct("wdb");
        whereTab.setHelpTopic("where_tab");
        pnlTabs.addTab(bundle.getString("LookupTab.WhereTab.Title.txt"), (WAPropertyTab)whereTab);
        pnlTabs.addTab(bundle.getString("LookupTab.ExceptionsTab.Title.txt"), (WAPropertyTab)new ExceptionsTab(this.m_lookup, lookupMapping));
        int iRC = ModelUIUtilities.showDialog((IObject)lookupMapping, bundle.formatString("LookupTab.PropertiesDialog.Title.fmt", (Object)lookupTable.getName()), (WAPanel)pnlTabs);
        if (iRC == 1) {
            this.setDataChanged(true);
            if (expression == null || expression.getExpressionType().equalsIgnoreCase("DERIVED")) {
                expression = lookupMapping.createNewExpression();
                expression.setUseSQLSyntax(false);
                lookupMapping.setExpression(expression);
            }
            ((ITextExpression)expression).setText(whereTab.getExpression(), (IObject[])lookupTable.getColumns());
        }
    }

    public boolean validateData() {
        return true;
    }

    private class cWsPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private cWsPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)LookupTab.this.m_actProperties));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class cTableMouseListener
    extends MouseAdapter {
        private cTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getClickCount() == 2 && LookupTab.this.m_tbl.getSelectedRow() != -1) {
                LookupTab.this.launchPropertiesDialog();
            }
        }
    }

    private class cPropertiesAction
    extends WsAbstractAction {
        public cPropertiesAction() {
            super(bundle, "LookupTab.Properties", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            LookupTab.this.launchPropertiesDialog();
        }
    }

    private class cLookupDataMappingsFilter
    implements IFilter {
        private cLookupDataMappingsFilter() {
        }

        public boolean pass(Object obj) {
            return "lookup data".equals(((IMapping)obj).getType());
        }
    }

    private class cLookupKeyMappingsFilter
    implements IFilter {
        private cLookupKeyMappingsFilter() {
        }

        public boolean pass(Object obj) {
            return "lookup key".equals(((IMapping)obj).getType());
        }
    }
}

