/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.lookup.visuals;

import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.lookup.LookupMapping;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.lookup.visuals.ChooseColumnsPanel;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.ExpressionBuilderTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ExceptionsTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ChooseColumnsPanel.class);
    private LookupTransformModel m_lookup;
    private LookupMapping m_lookupMapping;
    private cConditionActionsTab m_conditionsTab;
    private WsAbstractAction m_actSaveAsDefaults;
    private WsAbstractAction m_actLoadDefaults;

    public ExceptionsTab(LookupTransformModel lookup, LookupMapping lookupMapping) {
        this.m_lookup = lookup;
        this.m_lookupMapping = lookupMapping;
        this.initialize();
    }

    protected void initialize() {
        this.setHelpProduct("wdb");
        this.setHelpTopic("exceptions_tab");
        this.m_conditionsTab = new cConditionActionsTab((IConditionActionSetContainer)this.m_lookupMapping);
        this.m_actSaveAsDefaults = new cSaveAsDefaultsAction();
        this.m_actLoadDefaults = new cLoadDefaultsAction();
        JButton btnSaveAsDefaults = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actSaveAsDefaults);
        JButton btnLoadDefaults = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actLoadDefaults);
        JPanel pnlDefaults = new JPanel();
        pnlDefaults.setLayout((LayoutManager)new WsButtonsLayout(0, 2));
        pnlDefaults.add(btnSaveAsDefaults);
        pnlDefaults.add(btnLoadDefaults);
        this.setLayout(new GridBagLayout());
        this.add(pnlDefaults, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.m_conditionsTab), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_conditionsTab.populateStore();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_conditionsTab.moveDataToView();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_conditionsTab.moveDataToStore();
        String sMessage = null;
        if (this.m_lookup.getErrorTable() == null && this.m_conditionsTab.isActionActive("DIS_WRITEERROR")) {
            sMessage = bundle.getString("ExceptionsTab.ErrorTableWarning.txt");
        }
        if (this.m_lookup.getExceptionTable() == null && this.m_conditionsTab.isActionActive("DIS_WRITEEXCEPTION")) {
            String string = sMessage = sMessage == null ? bundle.getString("ExceptionsTab.ExceptionTableWarning.txt") : bundle.getString("ExceptionsTab.BothTablesWarning.txt");
        }
        if (sMessage != null) {
            MessageUtil.displayMessage(sMessage);
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_conditionsTab.saveSettingsAndCleanUp();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_conditionsTab.setEditable(bEditable);
        this.m_actLoadDefaults.setEnabled(bEditable);
    }

    public boolean validateData() {
        return this.m_conditionsTab.validateData();
    }

    private class cConditionActionsTab
    extends ConditionActionsTab {
        public cConditionActionsTab(IConditionActionSetContainer container) {
            super(container);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void showActionOptionsDialog() {
            block20: {
                if (!this.m_tblConditionActions.stopCellEditing()) {
                    return;
                }
                int iSelectedRow = this.m_tblConditionActions.convertRowIndexToModel(this.m_tblConditionActions.getCurrentRow());
                IConditionActionSet oCAS = this.m_mdlConditionActions.getConditionActionSetForRow(iSelectedRow);
                IConditionAction[] aConditionActions = oCAS.getActions();
                this.m_container.getModel().startCompoundUndoable();
                try {
                    if (aConditionActions.length > 0 && "DIS_SETTARGETCOL".equals(aConditionActions[0].getUniqueIdentifier())) {
                        ITable[] iTableArray;
                        IPhysicalTable targetTable = ExceptionsTab.this.m_lookup.getTargetTable();
                        if (targetTable == null) {
                            iTableArray = new ITable[]{};
                        } else {
                            ITable[] iTableArray2 = new ITable[1];
                            iTableArray = iTableArray2;
                            iTableArray2[0] = targetTable;
                        }
                        ExpressionBuilderTab expressionPanel = new ExpressionBuilderTab(null, iTableArray, false);
                        IConditionAction action = aConditionActions[0];
                        ITextOperand oOriginalExpression = null;
                        IProperty actionProperty = null;
                        if (action.getActionPropertiesList().size() > 0) {
                            actionProperty = action.getActionProperty(0);
                            oOriginalExpression = actionProperty.getExpression();
                        }
                        try {
                            if (oOriginalExpression != null) {
                                expressionPanel.setExpression(oOriginalExpression.getText(null, ExceptionsTab.this.m_lookup.isQuotingNeeded(), false));
                            }
                        }
                        catch (RemoteException e1) {
                            Workspace.handleRemoteException((RemoteException)e1);
                        }
                        catch (CodegenException e1) {
                            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                        }
                        catch (MdException e1) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                        }
                        catch (BadServerDefinitionException e1) {
                            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                        }
                        catch (BadLibraryDefinitionException e1) {
                            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                        }
                        catch (ServerException e1) {
                            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                        }
                        if (targetTable != null) {
                            expressionPanel.setUseQuotes(targetTable.isQuoted());
                        }
                        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ExceptionsTab.ExprOptionsDialogTitle.txt"), true, (WAPanel)expressionPanel);
                        dlg.setResizable(true);
                        dlg.show();
                        if (dlg.getReturnValue() == 1) {
                            String exprText = expressionPanel.getExpression().trim();
                            if (oOriginalExpression == null) {
                                ITextOperand operand = ExceptionsTab.this.m_lookupMapping.getModel().getObjectFactory().createNewTextOperand(actionProperty.getID());
                                operand.setName("lookupvalue");
                                operand.setUseSQLSyntax(false);
                                operand.setText(exprText, (IObject[])(targetTable == null ? null : targetTable.getColumns()));
                                actionProperty.setExpression(operand);
                            } else {
                                oOriginalExpression.setText(exprText, (IObject[])targetTable.getColumns());
                            }
                        }
                        break block20;
                    }
                    super.showActionOptionsDialog();
                }
                finally {
                    this.m_container.getModel().endCompoundUndoable();
                }
            }
        }

        public boolean isActionActive(String sActionId) {
            IConditionActionSet[] aCASets = this.getConditionActionSets();
            for (int iSet = 0; iSet < aCASets.length; ++iSet) {
                IConditionAction[] aActions = aCASets[iSet].getActions();
                if (aActions.length <= 0 || !sActionId.equals(aActions[0].getUniqueIdentifier())) continue;
                return true;
            }
            return false;
        }

        public IConditionActionSet[] getConditionActionSets() {
            int iRowCount = this.m_tblConditionActions.getRowCount();
            IConditionActionSet[] aCASets = new IConditionActionSet[iRowCount];
            for (int iRow = 0; iRow < iRowCount; ++iRow) {
                int iModelRow = this.m_tblConditionActions.convertRowIndexToModel(iRow);
                aCASets[iRow] = this.m_mdlConditionActions.getConditionActionSetForRow(iModelRow);
            }
            return aCASets;
        }
    }

    private class cLoadDefaultsAction
    extends WsAbstractAction {
        public cLoadDefaultsAction() {
            super(bundle, "ExceptionsTab.actLoadDefaults", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            int iRC = MessageUtil.displayMessage((String)bundle.getString("ExceptionsTab.LoadMessage.txt"), (String)bundle.getString("ExceptionsTab.LoadTitle.txt"), (int)1, (int)0);
            if (iRC != 0) {
                return;
            }
            ExceptionsTab.this.m_lookup.getModel().startCompoundUndoable();
            try {
                ExceptionsTab.this.m_lookupMapping.getConditionActionSetsList().clear();
                ExceptionsTab.this.m_lookupMapping.addConditions(LookupMapping.loadDefaultConditions());
                ExceptionsTab.this.m_conditionsTab.moveDataToView();
                ExceptionsTab.this.m_conditionsTab.setDataChanged(true);
            }
            finally {
                ExceptionsTab.this.m_lookup.getModel().endCompoundUndoable();
            }
        }
    }

    private class cSaveAsDefaultsAction
    extends WsAbstractAction {
        public cSaveAsDefaultsAction() {
            super(bundle, "ExceptionsTab.actSaveAsDefaults", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            int iRC = MessageUtil.displayMessage((String)bundle.getString("ExceptionsTab.SaveMessage.txt"), (String)bundle.getString("ExceptionsTab.SaveTitle.txt"), (int)1, (int)0);
            if (iRC != 0) {
                return;
            }
            ArrayList lDefaults = new ArrayList();
            IConditionActionSet[] aCASets = ExceptionsTab.this.m_conditionsTab.getConditionActionSets();
            for (int iSet = 0; iSet < aCASets.length; ++iSet) {
                ArrayList<Object> lDefaultCASet = new ArrayList<Object>();
                lDefaultCASet.add(aCASets[iSet].getUniqueIdentifier());
                IConditionAction action = aCASets[iSet].getActions()[0];
                lDefaultCASet.add(action.getUniqueIdentifier());
                IProperty[] aOptions = action.getActionProperties();
                if (aOptions != null && aOptions.length > 0) {
                    ArrayList<String> lDefaultOptions = new ArrayList<String>(aOptions.length);
                    for (int iOption = 0; iOption < aOptions.length; ++iOption) {
                        String sOption = aOptions[iOption].getDefaultValue();
                        if ("DIS_SETTARGETCOL".equals(action.getUniqueIdentifier())) {
                            IPhysicalTable targetTable = ExceptionsTab.this.m_lookup.getTargetTable();
                            boolean bNeedsQuotes = targetTable == null ? false : targetTable.isQuoted();
                            try {
                                sOption = aOptions[iOption].getExpression().getText(null, bNeedsQuotes);
                            }
                            catch (RemoteException e1) {
                                Workspace.handleRemoteException((RemoteException)e1);
                            }
                            catch (CodegenException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                            catch (MdException e1) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                            }
                            catch (BadServerDefinitionException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                            catch (BadLibraryDefinitionException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                            catch (ServerException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                        }
                        lDefaultOptions.add(sOption);
                    }
                    lDefaultCASet.add(lDefaultOptions);
                }
                lDefaults.add(lDefaultCASet);
            }
            LookupMapping.saveDefaultConditions(lDefaults);
        }
    }
}

