/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.lookup.visuals;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.TreeListSelector;
import com.sas.wadmin.transforms.lookup.visuals.TempColumn;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ChooseColumnsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ChooseColumnsPanel.class);
    private LookupTransformModel m_lookup;
    private IPhysicalTable m_table;
    private cTreeListSelector m_columnSelector;
    private JTree m_tree;
    private int m_iTableType;

    public ChooseColumnsPanel(LookupTransformModel lookup, IPhysicalTable table, int iTableType) {
        this.m_lookup = lookup;
        this.m_table = table;
        this.m_iTableType = iTableType;
        this.initialize();
    }

    protected void initialize() {
        this.setHelpProduct("wdb");
        this.setHelpTopic("select_column_win");
        this.m_columnSelector = new cTreeListSelector();
        this.m_columnSelector.setCopyModeEnabled(true);
        this.m_columnSelector.setParentNodesMoveable(false);
        this.m_columnSelector.setSourceRootVisible(false);
        this.m_columnSelector.setTargetControlsVisible(true);
        this.m_columnSelector.setSourceCellRenderer(new cTreeCellRenderer());
        this.m_columnSelector.setTargetCellRenderer(new cListCellRenderer());
        this.m_tree = (JTree)this.m_columnSelector.getSourceComponent();
        this.m_tree.setShowsRootHandles(false);
        this.m_tree.setToggleClickCount(0);
        this.m_tree.addTreeSelectionListener(new cTreeSelectionListener());
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        JLabel label = (JLabel)this.m_columnSelector.getSourceLabelComponent();
        label.setText(bundle.getString("ChooseColumnsPanel.SourceLabel.txt"));
        label.setDisplayedMnemonic(bundle.getString("ChooseColumnsPanel.SourceLabel.mnem").charAt(0));
        label = (JLabel)this.m_columnSelector.getTargetLabelComponent();
        label.setText(bundle.getString("ChooseColumnsPanel.TargetLabel.txt"));
        label.setDisplayedMnemonic(bundle.getString("ChooseColumnsPanel.TargetLabel.mnem").charAt(0));
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_columnSelector), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void populateStore() {
        this.setStorePopulated(true);
    }

    public void moveDataToView() {
        DefaultTreeModel model = (DefaultTreeModel)this.m_columnSelector.getModel();
        IPhysicalTable sourceTable = this.m_lookup.getSourceTable();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        cHeadingTreeNode genNode = new cHeadingTreeNode(bundle.getString("ChooseColumnsPanel.GeneratedHeaderName.txt"), bundle.getString("ChooseColumnsPanel.GeneratedHeaderDesc.txt"), WAdminResource.getTypeIcon((String)"Tree", (boolean)true));
        genNode.add(new cTempColumnTreeNode(new TempColumn("etls_source_row")));
        if (this.m_iTableType == 1) {
            genNode.add(new cTempColumnTreeNode(new TempColumn("etls_lookup_table")));
            genNode.add(new cTempColumnTreeNode(new TempColumn("etls_exception_cond")));
            genNode.add(new cTempColumnTreeNode(new TempColumn("etls_exception_action")));
        }
        rootNode.add(genNode);
        cHeadingTreeNode sourceNode = null;
        if (sourceTable != null) {
            sourceNode = new cHeadingTreeNode(bundle.formatString("ChooseColumnsPanel.SourceHeaderName.fmt", (Object)sourceTable.getName()), bundle.getString("ChooseColumnsPanel.SourceHeaderDesc.txt"), WAdminResource.getTypeIcon((String)"PhysicalTable", (boolean)true));
            IColumn[] aSourceColumns = sourceTable.getColumns();
            for (int i = 0; i < aSourceColumns.length; ++i) {
                sourceNode.add(new cIColumnTreeNode(aSourceColumns[i]));
            }
            rootNode.add(sourceNode);
        }
        model.setRoot(rootNode);
        this.m_tree.expandPath(new TreePath(genNode.getPath()));
        if (sourceNode != null) {
            this.m_tree.expandPath(new TreePath(sourceNode.getPath()));
        }
        IColumn[] aColumns = this.m_table.getColumns();
        List lSourceObjects = this.m_columnSelector.getMatchingSourceItems(Arrays.asList(aColumns));
        this.m_columnSelector.transferToTargetModel(lSourceObjects.toArray());
    }

    public void moveDataToStore() {
        DefaultListModel mdlTarget = (DefaultListModel)this.m_columnSelector.getTargetModel();
        ArrayList lColumns = new ArrayList(mdlTarget.size());
        for (int i = 0; i < mdlTarget.getSize(); ++i) {
            lColumns.add(mdlTarget.getElementAt(i));
        }
        this.updateTableColumns(this.m_table, lColumns);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_columnSelector.setEnabled(bEditable);
    }

    public boolean validateData() {
        return true;
    }

    private void updateTableColumns(IPhysicalTable table, List lColumns) {
        int nColumns = lColumns.size();
        for (int iIndex = 0; iIndex < nColumns; ++iIndex) {
            TreePath path = (TreePath)lColumns.get(iIndex);
            DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
            Object tempColumn = node.getColumnObject();
            int iMatchingIndex = this.findMatchingColumnInList(table.getColumns(), tempColumn);
            if (iMatchingIndex == iIndex) continue;
            if (iMatchingIndex == -1) {
                IColumn newColumn;
                if (tempColumn instanceof IColumn) {
                    newColumn = this.m_lookup.getModel().getObjectFactory().createNewColumn(table.getID());
                    ((IColumn)tempColumn).copy(newColumn);
                    table.addColumn(iIndex, newColumn);
                    continue;
                }
                if (!(tempColumn instanceof TempColumn)) continue;
                newColumn = this.m_lookup.getModel().getObjectFactory().createNewColumn(table.getID());
                ((TempColumn)tempColumn).setColumnAttributes(newColumn);
                table.addColumn(iIndex, newColumn);
                continue;
            }
            table.moveColumn(table.getColumns()[iMatchingIndex], iIndex);
        }
        while (nColumns < table.getColumnCount()) {
            table.removeColumn(table.getColumns()[nColumns]);
        }
    }

    private int findMatchingColumnInList(IColumn[] aOldColumns, Object newColumn) {
        for (int i = 0; i < aOldColumns.length; ++i) {
            TempColumn tempColumn;
            IColumn oldColumn = aOldColumns[i];
            if (newColumn instanceof IColumn) {
                IColumn newIColumn = (IColumn)newColumn;
                if (!oldColumn.getName().equals(newIColumn.getName()) || oldColumn.getType() != newIColumn.getType() || oldColumn.getLength() != newIColumn.getLength()) continue;
                return i;
            }
            if (!(newColumn instanceof TempColumn) || !(tempColumn = (TempColumn)newColumn).equals(oldColumn)) continue;
            return i;
        }
        return -1;
    }

    private class cTreeSelectionListener
    implements TreeSelectionListener {
        private cTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ChooseColumnsPanel.this.m_tree.scrollPathToVisible(ChooseColumnsPanel.this.m_tree.getSelectionPath());
        }
    }

    private class cListCellRenderer
    extends DefaultListCellRenderer {
        private cListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            TreeNode node = (TreeNode)((TreePath)value).getLastPathComponent();
            this.setText(node.toString());
            if (node instanceof DisableableTreeNode) {
                this.setIcon(((DisableableTreeNode)((Object)node)).getIcon());
                this.setToolTipText(((DisableableTreeNode)((Object)node)).getToolTip());
            }
            return this;
        }
    }

    private class cTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private cTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bFocused) {
            super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bFocused);
            if (node instanceof DisableableTreeNode) {
                this.setIcon(((DisableableTreeNode)node).getIcon());
                this.setToolTipText(((DisableableTreeNode)node).getToolTip());
                if (!(node instanceof cHeadingTreeNode)) {
                    this.setEnabled(((DisableableTreeNode)node).isEnabled());
                }
            }
            return this;
        }
    }

    private class cTreeListSelector
    extends TreeListSelector {
        private HashMap m_hmSources;

        private cTreeListSelector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List lItems) {
            if (lItems == null) {
                lItems = fromAdapter.getSelectedItems();
            }
            int iIndex = fromAdapter.getLastSelectedIndex();
            if (lItems.size() > 0) {
                DualSelectorInterface dualSelectorInterface = fromAdapter;
                synchronized (dualSelectorInterface) {
                    DualSelectorInterface dualSelectorInterface2 = toAdapter;
                    synchronized (dualSelectorInterface2) {
                        if (fromAdapter == this.sourceAdapter) {
                            List lTargetItems = toAdapter.getAllMoveableItems();
                            Iterator iter = lItems.iterator();
                            block6: while (iter.hasNext()) {
                                Object item = iter.next();
                                for (int i = 0; i < lTargetItems.size(); ++i) {
                                    if (!item.equals(lTargetItems.get(i))) continue;
                                    iter.remove();
                                    continue block6;
                                }
                            }
                            toAdapter.addItems(lItems);
                            for (int i = 0; i < lItems.size(); ++i) {
                                TreePath path = (TreePath)lItems.get(i);
                                DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                                node.setEnabled(false);
                            }
                        } else {
                            fromAdapter.removeItems(lItems);
                            List lSourceItems = toAdapter.getAllMoveableItems();
                            for (int i = 0; i < lItems.size(); ++i) {
                                for (int j = 0; j < lSourceItems.size(); ++j) {
                                    if (!lItems.get(i).equals(lSourceItems.get(j))) continue;
                                    TreePath path = (TreePath)lSourceItems.get(j);
                                    DisableableTreeNode sourceNode = (DisableableTreeNode)path.getLastPathComponent();
                                    sourceNode.setEnabled(true);
                                }
                            }
                        }
                        this.setHeadingsStatus();
                        this.selectNextEnabledItem(fromAdapter, iIndex);
                        this.ensureButtonsEnabled();
                        this.firePropertyChange("sourceItems", null, null);
                        this.firePropertyChange("targetItems", null, null);
                        this.selectedItems = null;
                        ChooseColumnsPanel.this.m_tree.repaint();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferAllItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            DualSelectorInterface dualSelectorInterface = fromAdapter;
            synchronized (dualSelectorInterface) {
                DualSelectorInterface dualSelectorInterface2 = toAdapter;
                synchronized (dualSelectorInterface2) {
                    List lAllItems = fromAdapter.getAllMoveableItems();
                    this.transferItems(fromAdapter, toAdapter, lAllItems);
                }
            }
        }

        public boolean canTransferSelectedSourceItems() {
            if (super.canTransferSelectedSourceItems()) {
                List lItems = this.sourceAdapter.getSelectedItems();
                for (int iItem = 0; iItem < lItems.size(); ++iItem) {
                    TreePath path = (TreePath)lItems.get(iItem);
                    DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                    if (!node.isEnabled()) continue;
                    return true;
                }
            }
            return false;
        }

        private void setHeadingsStatus() {
            List lItems = this.sourceAdapter.getAllItems();
            block0: for (int i = 1; i < lItems.size(); ++i) {
                TreePath path = (TreePath)lItems.get(i);
                DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                if (!(node instanceof cHeadingTreeNode)) continue;
                cHeadingTreeNode headingNode = (cHeadingTreeNode)node;
                for (int iChild = 0; iChild < headingNode.getChildCount(); ++iChild) {
                    DisableableTreeNode childNode = (DisableableTreeNode)((Object)headingNode.getChildAt(iChild));
                    if (!childNode.isEnabled()) continue;
                    headingNode.setEnabled(true);
                    continue block0;
                }
                headingNode.setEnabled(false);
            }
        }

        private void selectNextEnabledItem(DualSelectorInterface adapter, int iStartIndex) {
            if (iStartIndex == -1) {
                return;
            }
            List lItems = adapter.getAllItems();
            if (adapter == this.sourceAdapter) {
                DisableableTreeNode node;
                TreePath path;
                int i;
                for (i = ++iStartIndex; i < lItems.size(); ++i) {
                    path = (TreePath)lItems.get(i);
                    node = (DisableableTreeNode)path.getLastPathComponent();
                    if (!node.isEnabled()) continue;
                    adapter.setSelectedIndex(i - 1);
                    return;
                }
                for (i = iStartIndex - 1; i > 0 && i < lItems.size(); --i) {
                    path = (TreePath)lItems.get(i);
                    node = (DisableableTreeNode)path.getLastPathComponent();
                    if (!node.isEnabled()) continue;
                    adapter.setSelectedIndex(i - 1);
                    return;
                }
                adapter.setSelectedIndex(-1);
            } else {
                adapter.setSelectedIndex(Math.min(iStartIndex, lItems.size() - 1));
            }
        }

        public HashMap getSourceColumnMap() {
            if (this.m_hmSources != null) {
                return this.m_hmSources;
            }
            List lSourceItems = this.sourceAdapter.getAllMoveableItems();
            this.m_hmSources = new HashMap(lSourceItems.size());
            for (int i = 0; i < lSourceItems.size(); ++i) {
                TreePath path = (TreePath)lSourceItems.get(i);
                DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                Object oColumn = node.getColumnObject();
                String sColumnName = oColumn instanceof IColumn ? ((IColumn)oColumn).getName() : ((TempColumn)oColumn).getName();
                this.m_hmSources.put(sColumnName, path);
            }
            return this.m_hmSources;
        }

        public List getMatchingSourceItems(List lItems) {
            ArrayList lTreePaths = new ArrayList();
            HashMap hmSources = this.getSourceColumnMap();
            for (int i = 0; i < lItems.size(); ++i) {
                IColumn column = (IColumn)lItems.get(i);
                if (!hmSources.containsKey(column.getName())) continue;
                lTreePaths.add(hmSources.get(column.getName()));
            }
            return lTreePaths;
        }
    }

    private class cTempColumnTreeNode
    extends DefaultMutableTreeNode
    implements DisableableTreeNode {
        private boolean m_bEnabled;

        public cTempColumnTreeNode(Object oObject) {
            super(oObject);
            this.m_bEnabled = true;
        }

        public String getName() {
            return ((TempColumn)this.userObject).getDisplayName();
        }

        @Override
        public Icon getIcon() {
            return ((TempColumn)this.userObject).getIcon();
        }

        @Override
        public String getToolTip() {
            return ((TempColumn)this.userObject).getToolTip();
        }

        @Override
        public boolean isEnabled() {
            return this.m_bEnabled;
        }

        @Override
        public void setEnabled(boolean bEnabled) {
            this.m_bEnabled = bEnabled;
        }

        @Override
        public Object getColumnObject() {
            return this.userObject;
        }
    }

    private class cIColumnTreeNode
    extends DefaultMutableTreeNode
    implements DisableableTreeNode {
        private IColumn m_column;
        private boolean m_bEnabled;

        public cIColumnTreeNode(IColumn column) {
            super(column.getName());
            this.m_bEnabled = true;
            this.m_column = column;
        }

        @Override
        public Icon getIcon() {
            return ColumnUIUtilities.getTypeIcon(this.m_column);
        }

        @Override
        public String getToolTip() {
            return bundle.formatString("ChooseColumnsPanel.GetColumnType.txt", (Object)this.m_column.getID());
        }

        @Override
        public boolean isEnabled() {
            return this.m_bEnabled;
        }

        @Override
        public void setEnabled(boolean bEnabled) {
            this.m_bEnabled = bEnabled;
        }

        @Override
        public Object getColumnObject() {
            return this.m_column;
        }
    }

    private class cHeadingTreeNode
    extends DefaultMutableTreeNode
    implements DisableableTreeNode {
        private String m_sToolTip;
        private Icon m_icon;
        private boolean m_bEnabled;

        public cHeadingTreeNode(String sName, String sToolTip, Icon icon) {
            super(sName);
            this.m_bEnabled = true;
            this.m_sToolTip = sToolTip;
            this.m_icon = icon;
        }

        @Override
        public Icon getIcon() {
            return this.m_icon;
        }

        @Override
        public String getToolTip() {
            return this.m_sToolTip;
        }

        @Override
        public boolean isEnabled() {
            return this.m_bEnabled;
        }

        @Override
        public void setEnabled(boolean bEnabled) {
            this.m_bEnabled = bEnabled;
        }

        @Override
        public Object getColumnObject() {
            return this.userObject;
        }
    }

    private static interface DisableableTreeNode {
        public boolean isEnabled();

        public void setEnabled(boolean var1);

        public Icon getIcon();

        public String getToolTip();

        public Object getColumnObject();
    }
}

