/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.loader;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.loader.TableLoaderLoadTechniquePropertyTab;
import com.sas.wadmin.visuals.CodeConditionPropertyTab;
import com.sas.wadmin.visuals.MappingsPropertyTab;
import com.sas.wadmin.visuals.ProcessSourcePropertyTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.wadmin.visuals.WANotesPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.TransformUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class TableLoaderTransformationStepView
extends WorkspaceOMAView {
    private static WAdminResource bundle = WAdminResource.getBundle(TableLoaderTransformationStepView.class);

    public WAPropertyTabGroup createView() {
        super.createView();
        ArrayList<String> CodeConditions = new ArrayList<String>();
        CodeConditions.add(bundle.getString("TableLoaderTransformationStepView.CodeActionCombo4.notrans"));
        CodeConditions.add(bundle.getString("TableLoaderTransformationStepView.CodeActionCombo5.notrans"));
        CodeConditions.add(bundle.getString("TableLoaderTransformationStepView.CodeActionCombo6.notrans"));
        CodeConditions.add(bundle.getString("TableLoaderTransformationStepView.CodeActionCombo7.notrans"));
        CodeConditions.add(bundle.getString("TableLoaderTransformationStepView.CodeActionCombo8.notrans"));
        CodeConditions.add(bundle.getString("TableLoaderTransformationStepView.CodeActionCombo1.notrans"));
        CodeConditions.add(bundle.getString("TableLoaderTransformationStepView.CodeActionCombo2.notrans"));
        CodeConditions.add(bundle.getString("TableLoaderTransformationStepView.CodeActionCombo3.notrans"));
        MappingsPropertyTab tabMappings = new MappingsPropertyTab((TransformationStep)this.m_metadata, 5);
        tabMappings.setEditNonWorkTables(true);
        tabMappings.setFlushNonWorkTables(true);
        WAPropertyTabGroup tabs = new WAPropertyTabGroup();
        tabs.addTab(bundle.getString("WAGeneralPropertyTab.Title.txt"), (WAPropertyTab)new WAGeneralPropertyTab((CMetadata)this.m_metadata));
        tabs.addTab(bundle.getString("TableLoader.LoadTechniquePropertyTab.Title.txt"), (WAPropertyTab)new TableLoaderLoadTechniquePropertyTab((TransformationStep)this.m_metadata));
        tabs.addTab(bundle.getString("ProcessSourcePropertyTab.Title.txt"), (WAPropertyTab)new ProcessSourcePropertyTab((CMetadata)this.m_metadata, true, "Hide", false, true));
        tabs.addTab(bundle.getString("MappingsPropertyTab.Title.txt"), (WAPropertyTab)tabMappings);
        tabs.addTab(bundle.getString("StatusHandlingPropertyTab.Title.txt"), (WAPropertyTab)new CodeConditionPropertyTab((CMetadata)this.m_metadata, CodeConditions));
        tabs.addTab(bundle.getString("WANotesPropertyTab.Title.txt"), (WAPropertyTab)new WANotesPropertyTab((CMetadata)this.m_metadata));
        if (this.getShouldShowAdvancedTabs()) {
            tabs.addTab(bundle.getString("WAExtAttrPropertyTab.Title.txt"), (WAPropertyTab)new WAExtAttrPropertyTab((CMetadata)this.m_metadata));
            tabs.addTab(bundle.getString("WsGenericGeneralPropertyTab.Title.txt"), (WAPropertyTab)new WsGenericGeneralPropertyTab((CMetadata)this.m_metadata));
            this.addAuthorizationTab(tabs, (CMetadata)this.m_metadata);
        }
        return tabs;
    }

    public String getFrameTitle() {
        try {
            String title = super.getFrameTitle();
            if (this.m_metadata instanceof TransformationStep) {
                TransformationStep tStep = (TransformationStep)this.m_metadata;
                AssociationList transformations = null;
                try {
                    transformations = tStep.getTransformations();
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                if (!transformations.isEmpty()) {
                    ClassifierMap cMap = (ClassifierMap)transformations.get(0);
                    AssociationList classifierTargets = null;
                    try {
                        classifierTargets = cMap.getClassifierTargets();
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    if (!classifierTargets.isEmpty()) {
                        PhysicalTable pTable = (PhysicalTable)classifierTargets.get(0);
                        String tableName = pTable.getSASTableName();
                        if (tableName == null || tableName.length() == 0) {
                            tableName = bundle.getString("TableLoaderTransformationStepView.NoTableName.txt");
                        }
                        title = title + " : " + tableName;
                        RelationalSchema schema = null;
                        try {
                            schema = pTable.getTablePackage();
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException((RemoteException)re);
                        }
                        String dbmsName = "";
                        if (schema != null) {
                            try {
                                dbmsName = TransformUtil.getDBMSProductName((PhysicalTable)pTable);
                            }
                            catch (MdException exc) {
                                dbmsName = bundle.getString("TableLoaderTransformationStepView.NoDeployedComponents.txt");
                            }
                            catch (RemoteException re) {
                                Workspace.handleRemoteException((RemoteException)re);
                            }
                            title = title + " : " + dbmsName;
                        } else {
                            title = title + " : " + bundle.getString("TableLoaderTransformationStepView.NoLibrary.txt");
                        }
                        this.getFrame().setTitle(title);
                    }
                }
            }
            return title;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }
}

