/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.loader;

import com.sas.codegen.TableLoaderModel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.TransformationStep;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsUIUtilities;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TableLoaderLoadTechniquePropertyTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(TableLoaderLoadTechniquePropertyTab.class);
    private TransformationStep m_metadata;
    private ClassifierMap m_classifierMap;
    private PhysicalTable m_physicalTable;
    private TableLoaderModel m_model;
    private JLabel m_lblLoadStyle;
    private WAComboBox m_cmbLoadStyle;
    private WsAbstractAction m_actAdvanced;
    private JLabel m_lblReplaceType;
    private WAComboBox m_cmbReplaceType;
    private JCheckBox m_chkForce;
    private WAPanel m_pnlTechniques;
    private JLabel m_lblMatchingRows;
    private WAComboBox m_cmbMatchingRows;
    private JCheckBox m_chkNoMissingCheck;
    private JLabel m_lblNewRows;
    private WAComboBox m_cmbNewRows;
    private WAPanel m_pnlAdditionalCActions;
    private JLabel m_lblConstraintBefore;
    private WAComboBox m_cmbConstraintBefore;
    private JLabel m_lblConstraintAfter;
    private WAComboBox m_cmbConstraintAfter;
    private WAPanel m_pnlAdditionalIActions;
    private JLabel m_lblIndexBefore;
    private WAComboBox m_cmbIndexBefore;
    private JLabel m_lblIndexAfter;
    private WAComboBox m_cmbIndexAfter;
    private WAPanel m_pnlUpdateLayout;
    private CardLayout m_crdUpdateLayout;
    private WAPanel m_pnlModifyIndex;
    private JLabel m_lblModifyIndex;
    private WAComboBox m_cmbModifyIndex;
    private JCheckBox m_chkModifyUnique;
    private WAPanel m_pnlMatchColumns;
    private DualListSelector m_dlsColumns;
    private CollectionToListModelAdapter m_adpAvailable;
    private CollectionToListModelAdapter m_adpSelected;
    private JButton m_btnAdvanced;
    private JButton m_btnReset;

    public TableLoaderLoadTechniquePropertyTab(TransformationStep metadata) {
        this.m_metadata = metadata;
        try {
            this.populateStore();
            this.m_model = new TableLoaderModel(this.m_classifierMap);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.setHelpTopic("load_technique2_tab");
        this.initialize();
    }

    public void initialize() {
        this.m_cmbLoadStyle = new WAComboBox();
        this.m_lblLoadStyle = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbLoadStyle, (WAdminResource)bundle, (String)"TableLoader.LoadStyle");
        this.m_cmbLoadStyle.setSorted(true);
        this.m_cmbLoadStyle.addActionListener((ActionListener)new cLoadStyleListener());
        this.listenForDataChangesTo((JComboBox)this.m_cmbLoadStyle);
        this.m_cmbReplaceType = new WAComboBox();
        this.m_lblReplaceType = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbReplaceType, (WAdminResource)bundle, (String)"TableLoader.ReplaceType");
        this.m_cmbReplaceType.setSorted(true);
        this.m_cmbReplaceType.addActionListener((ActionListener)new cReplaceTypeListener());
        this.listenForDataChangesTo((JComboBox)this.m_cmbReplaceType);
        this.m_chkForce = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"TableLoader.Force");
        this.m_chkForce.setVisible(false);
        this.listenForDataChangesTo(this.m_chkForce);
        this.m_pnlTechniques = new WAPanel();
        this.m_pnlTechniques.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("TableLoader.Techniques.title.txt")));
        this.m_pnlTechniques.setLayout((LayoutManager)new GridBagLayout());
        this.m_cmbMatchingRows = new WAComboBox();
        this.m_lblMatchingRows = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbMatchingRows, (WAdminResource)bundle, (String)"TableLoader.MatchingRows");
        this.m_cmbMatchingRows.addActionListener((ActionListener)new cMatchingRowsListener());
        this.listenForDataChangesTo((JComboBox)this.m_cmbMatchingRows);
        this.m_chkNoMissingCheck = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"TableLoader.NoMissingCheck");
        this.listenForDataChangesTo(this.m_chkNoMissingCheck);
        this.m_cmbNewRows = new WAComboBox();
        this.m_lblNewRows = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbNewRows, (WAdminResource)bundle, (String)"TableLoader.NewRows");
        this.m_cmbNewRows.addActionListener((ActionListener)new cNewRowsListener());
        this.listenForDataChangesTo((JComboBox)this.m_cmbNewRows);
        this.m_pnlTechniques.add((Component)this.m_lblMatchingRows, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlTechniques.add((Component)this.m_cmbMatchingRows, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlTechniques.add((Component)this.m_chkNoMissingCheck, (Object)new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.m_pnlTechniques.add((Component)this.m_lblNewRows, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlTechniques.add((Component)this.m_cmbNewRows, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlAdditionalCActions = new WAPanel();
        this.m_pnlAdditionalCActions.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("TableLoader.AdditionalCActions.title.txt")));
        this.m_pnlAdditionalCActions.setLayout((LayoutManager)new GridBagLayout());
        this.m_cmbConstraintBefore = new WAComboBox();
        this.m_lblConstraintBefore = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbConstraintBefore, (WAdminResource)bundle, (String)"TableLoader.ConstraintBefore");
        this.m_cmbConstraintBefore.addActionListener((ActionListener)new cConstraintBeforeListener());
        this.listenForDataChangesTo((JComboBox)this.m_cmbConstraintBefore);
        this.m_cmbConstraintAfter = new WAComboBox();
        this.m_lblConstraintAfter = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbConstraintAfter, (WAdminResource)bundle, (String)"TableLoader.ConstraintAfter");
        this.m_pnlAdditionalIActions = new WAPanel();
        this.m_pnlAdditionalIActions.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("TableLoader.AdditionalIActions.title.txt")));
        this.m_pnlAdditionalIActions.setLayout((LayoutManager)new GridBagLayout());
        this.listenForDataChangesTo((JComboBox)this.m_cmbConstraintAfter);
        this.m_cmbIndexBefore = new WAComboBox();
        this.m_lblIndexBefore = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbIndexBefore, (WAdminResource)bundle, (String)"TableLoader.IndexBefore");
        this.m_cmbIndexBefore.addActionListener((ActionListener)new cIndexBeforeListener());
        this.listenForDataChangesTo((JComboBox)this.m_cmbIndexBefore);
        this.m_cmbIndexAfter = new WAComboBox();
        this.m_lblIndexAfter = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbIndexAfter, (WAdminResource)bundle, (String)"TableLoader.IndexAfter");
        this.listenForDataChangesTo((JComboBox)this.m_cmbIndexAfter);
        this.m_pnlAdditionalCActions.add((Component)this.m_lblConstraintBefore, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlAdditionalCActions.add((Component)this.m_cmbConstraintBefore, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlAdditionalCActions.add((Component)this.m_lblConstraintAfter, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlAdditionalCActions.add((Component)this.m_cmbConstraintAfter, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlAdditionalIActions.add((Component)this.m_lblIndexBefore, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlAdditionalIActions.add((Component)this.m_cmbIndexBefore, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlAdditionalIActions.add((Component)this.m_lblIndexAfter, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlAdditionalIActions.add((Component)this.m_cmbIndexAfter, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlModifyIndex = new WAPanel();
        this.m_pnlModifyIndex.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("TableLoader.ModifyUsingIndex.title.txt")));
        this.m_pnlModifyIndex.setLayout((LayoutManager)new GridBagLayout());
        this.m_cmbModifyIndex = new WAComboBox();
        this.m_lblModifyIndex = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbModifyIndex, (WAdminResource)bundle, (String)"TableLoader.ModifyUsingIndex");
        this.listenForDataChangesTo((JComboBox)this.m_cmbModifyIndex);
        this.m_chkModifyUnique = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"TableLoader.ModifyUnique");
        this.listenForDataChangesTo(this.m_chkModifyUnique);
        this.m_pnlModifyIndex.add((Component)this.m_lblModifyIndex, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pnlModifyIndex.add((Component)this.m_cmbModifyIndex, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.m_pnlModifyIndex.add((Component)this.m_chkModifyUnique, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlMatchColumns = new WAPanel();
        this.m_pnlMatchColumns.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("TableLoader.MatchColumns.title.txt")));
        this.m_pnlMatchColumns.setLayout((LayoutManager)new GridBagLayout());
        this.m_dlsColumns = new DualListSelector();
        this.m_dlsColumns.setPreferredSize(new Dimension(100, 150));
        this.m_adpAvailable = new CollectionToListModelAdapter();
        this.m_adpSelected = new CollectionToListModelAdapter();
        this.m_adpAvailable.addListDataListener((ListDataListener)new DualListener());
        this.m_adpSelected.addListDataListener((ListDataListener)new DualListener());
        this.m_dlsColumns.setTargetControlsVisible(true);
        this.m_dlsColumns.setAlternatingSingleButtonStyle(false);
        this.m_dlsColumns.setModel((ListModel)this.m_adpAvailable);
        this.m_dlsColumns.setSourceCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_dlsColumns.setTargetCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_dlsColumns.setTargetModel((ListModel)this.m_adpSelected);
        this.m_dlsColumns.setSourceLabel(bundle.getString("TableLoaderLoadTechniquePropertyTab.AvailableColumns.txt"));
        this.m_dlsColumns.getSourceComponent().setToolTipText(bundle.getString("TableLoaderLoadTechniquePropertyTab.AvailableColumns.tip"));
        ((JLabel)this.m_dlsColumns.getSourceLabelComponent()).setDisplayedMnemonic(bundle.getString("TableLoaderLoadTechniquePropertyTab.AvailableColumns.mnem").charAt(0));
        this.m_dlsColumns.setTargetLabel(bundle.getString("TableLoaderLoadTechniquePropertyTab.SelectedColumns.txt"));
        this.m_dlsColumns.getTargetComponent().setToolTipText(bundle.getString("TableLoaderLoadTechniquePropertyTab.SelectedColumns.tip"));
        ((JLabel)this.m_dlsColumns.getTargetLabelComponent()).setDisplayedMnemonic(bundle.getString("TableLoaderLoadTechniquePropertyTab.SelectedColumns.mnem").charAt(0));
        this.m_pnlMatchColumns.add((Component)this.m_dlsColumns, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.m_pnlUpdateLayout = new WAPanel();
        this.m_crdUpdateLayout = new CardLayout();
        this.m_pnlUpdateLayout.setLayout((LayoutManager)this.m_crdUpdateLayout);
        this.m_pnlUpdateLayout.add((Component)new JPanel(), (Object)"");
        this.m_pnlUpdateLayout.add((Component)this.m_pnlMatchColumns, (Object)"ModifyByColumn");
        this.m_pnlUpdateLayout.add((Component)this.m_pnlModifyIndex, (Object)"ModifyUsingIndex");
        this.m_actAdvanced = new cAdvancedAction();
        this.m_btnAdvanced = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAdvanced);
        this.m_btnReset = WsUIUtilities.createTextButton((WsAbstractAction)new cResetDefaultsAction());
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblLoadStyle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.m_cmbLoadStyle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.m_lblReplaceType, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.m_cmbReplaceType, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.m_chkForce, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_pnlTechniques, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlAdditionalCActions, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlAdditionalIActions, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlUpdateLayout, new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_btnAdvanced, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_btnReset, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        bEditable = bEditable && this.m_physicalTable != null;
        this.setReplaceTypeEnabled();
        this.setMatchingRowsEnabled();
        this.setNoMissingCheckEnabled();
        this.m_cmbNewRows.setEnabled(bEditable && this.m_model.isNewRowsEnabled());
        this.m_cmbLoadStyle.setEnabled(bEditable);
        this.m_chkForce.setEnabled(bEditable);
        boolean constraintEnabled = false;
        boolean indexEnabled = false;
        try {
            constraintEnabled = this.m_model.isConstraintEnabled();
            indexEnabled = this.m_model.isIndexEnabled();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_cmbIndexBefore.setEnabled(bEditable && indexEnabled);
        this.m_cmbIndexAfter.setEnabled(bEditable && indexEnabled);
        this.m_cmbConstraintBefore.setEnabled(bEditable && constraintEnabled);
        this.m_cmbConstraintAfter.setEnabled(bEditable && constraintEnabled);
        this.m_btnReset.setEnabled(bEditable);
        this.m_btnAdvanced.setEnabled(bEditable);
        this.m_chkModifyUnique.setEnabled(bEditable);
        this.m_dlsColumns.setEnabled(bEditable);
        this.m_cmbModifyIndex.setEnabled(bEditable);
    }

    private void setMatchingRowsEnabled() {
        this.m_cmbMatchingRows.setEnabled(this.isEnabled() && this.m_model.isMatchingRowsEnabled());
    }

    private void setReplaceTypeEnabled() {
        try {
            boolean refresh = this.isEditable() && this.m_model.isReplaceTypeEnabled();
            this.m_cmbReplaceType.setEnabled(refresh);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void setNoMissingCheckEnabled() {
        this.m_chkNoMissingCheck.setEnabled(this.isEnabled() && this.m_model.isNoMissingCheckEnabled());
    }

    private void setUpdatePanelVisible() {
        this.m_crdUpdateLayout.show((Container)this.m_pnlUpdateLayout, this.m_model.getModifyPanel());
    }

    public boolean validateData() {
        try {
            this.moveDataToModel();
            return this.m_model.validateData();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        AssociationList transList = this.m_metadata.getTransformations(false);
        if (!transList.isEmpty()) {
            this.m_classifierMap = (ClassifierMap)transList.get(0);
            if (!this.m_classifierMap.getClassifierTargets().isEmpty()) {
                this.m_physicalTable = (PhysicalTable)this.m_classifierMap.getClassifierTargets().get(0);
            }
            this.setStorePopulated(true);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_model.moveDataToModel();
        this.m_cmbLoadStyle.setModel((ComboBoxModel)this.m_model.getLoadStyleModel());
        this.m_cmbReplaceType.setModel((ComboBoxModel)this.m_model.getReplaceTypeModel());
        this.m_adpAvailable.setModel((Collection)this.m_model.getAvailableMatchColumns());
        this.m_adpSelected.setModel((Collection)this.m_model.getSelectedMatchColumns());
        this.m_cmbModifyIndex.setModel((ComboBoxModel)this.m_model.getMatchIndexModel());
        this.m_chkNoMissingCheck.setSelected(this.m_model.getNoMissingCheck());
        this.m_cmbMatchingRows.setModel((ComboBoxModel)this.m_model.getMatchingRowsModel());
        this.m_cmbNewRows.setModel((ComboBoxModel)this.m_model.getNewRowsModel());
        this.m_cmbConstraintBefore.setModel((ComboBoxModel)this.m_model.getConstraintBeforeModel());
        this.m_cmbConstraintAfter.setModel((ComboBoxModel)this.m_model.getConstraintAfterModel());
        this.m_cmbIndexBefore.setModel((ComboBoxModel)this.m_model.getIndexBeforeModel());
        this.m_cmbIndexAfter.setModel((ComboBoxModel)this.m_model.getIndexAfterModel());
        this.m_chkModifyUnique.setSelected(this.m_model.getIndexUniqueValue());
        this.setUpdatePanelVisible();
        this.setEditable(this.isEnabled());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        this.moveDataToModel();
        this.m_model.moveDataToStore();
        this.setDataChanged(false);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.m_model.setSelectedMatchColumns(new ArrayList(this.m_adpSelected.getModel()));
        this.m_model.setModifyUsingIndex((Index)this.m_cmbModifyIndex.getSelectedItem());
        this.m_model.setNoMissingCheck(this.m_chkNoMissingCheck.isSelected());
        this.m_model.setIndexUniqueValue(this.m_chkModifyUnique.isSelected());
    }

    private void resetToDefaultValues() {
        this.m_model.resetModelDefaults();
    }

    private class cAdvancedAction
    extends WsAbstractAction {
        public cAdvancedAction() {
            super(bundle, "TableLoader.Action.AdvancedOptions", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!TableLoaderLoadTechniquePropertyTab.this.validateData()) {
                return;
            }
            try {
                TableLoaderLoadTechniquePropertyTab.this.moveDataToStore();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("TableLoader.AdvancedOptionsDialog.Title.txt"), true);
        }
    }

    private class cNewRowsListener
    implements ActionListener {
        private cNewRowsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TableLoaderLoadTechniquePropertyTab.this.setUpdatePanelVisible();
        }
    }

    private class cIndexBeforeListener
    implements ActionListener {
        private cIndexBeforeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TableLoaderLoadTechniquePropertyTab.this.m_cmbIndexBefore.getModel().getSize() > 0) {
                TableLoaderLoadTechniquePropertyTab.this.m_model.resetIndexAfterModel();
                TableLoaderLoadTechniquePropertyTab.this.setUpdatePanelVisible();
            }
        }
    }

    private class cConstraintBeforeListener
    implements ActionListener {
        private cConstraintBeforeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TableLoaderLoadTechniquePropertyTab.this.m_cmbConstraintBefore.getModel().getSize() > 0) {
                TableLoaderLoadTechniquePropertyTab.this.m_model.resetConstraintAfterModel();
                TableLoaderLoadTechniquePropertyTab.this.setUpdatePanelVisible();
            }
        }
    }

    private class cMatchingRowsListener
    implements ActionListener {
        private cMatchingRowsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TableLoaderLoadTechniquePropertyTab.this.setNoMissingCheckEnabled();
            TableLoaderLoadTechniquePropertyTab.this.m_model.resetNewRowsModel();
            TableLoaderLoadTechniquePropertyTab.this.setUpdatePanelVisible();
        }
    }

    private class cReplaceTypeListener
    implements ActionListener {
        private cReplaceTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TableLoaderLoadTechniquePropertyTab.this.m_model.resetIndexBeforeModel();
            TableLoaderLoadTechniquePropertyTab.this.m_model.resetConstraintBeforeModel();
            TableLoaderLoadTechniquePropertyTab.this.setUpdatePanelVisible();
        }
    }

    private class cLoadStyleListener
    implements ActionListener {
        private cLoadStyleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TableLoaderLoadTechniquePropertyTab.this.setReplaceTypeEnabled();
            TableLoaderLoadTechniquePropertyTab.this.setMatchingRowsEnabled();
            TableLoaderLoadTechniquePropertyTab.this.setNoMissingCheckEnabled();
            TableLoaderLoadTechniquePropertyTab.this.m_model.resetNewRowsModel();
            JCheckBox jCheckBox = TableLoaderLoadTechniquePropertyTab.this.m_chkNoMissingCheck;
            TableLoaderLoadTechniquePropertyTab.this.m_model;
            jCheckBox.setSelected(true);
            TableLoaderLoadTechniquePropertyTab.this.m_model.resetConstraintBeforeModel();
            TableLoaderLoadTechniquePropertyTab.this.m_model.resetIndexBeforeModel();
            TableLoaderLoadTechniquePropertyTab.this.setUpdatePanelVisible();
        }
    }

    private class DualListener
    implements ListDataListener {
        private DualListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            TableLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            TableLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            TableLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }
    }

    private class cListCellRenderer
    extends DefaultListCellRenderer {
        private cListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            try {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                WsCompoundIcon iconCompound = new WsCompoundIcon();
                iconCompound.setIconGap(1);
                String sType = WsColumnMetadataUtil.convertColumnTypeToView((String)((Column)value).getSASColumnType());
                iconCompound.addIcon(WsColumnMetadataUtil.getColumnViewTypeIcon((String)sType));
                if (iconCompound.getIconCount() == 0) {
                    this.setIcon(null);
                } else {
                    this.setIcon((Icon)iconCompound);
                }
                return this;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }
    }

    private class cResetDefaultsAction
    extends WsAbstractAction {
        public cResetDefaultsAction() {
            super(bundle, "TableLoader.Reset");
        }

        public void actionPerformed(ActionEvent event) {
            TableLoaderLoadTechniquePropertyTab.this.resetToDefaultValues();
        }
    }
}

