/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.infomap;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class InfoMapHandler {
    public static String PROPERTYSET_ROLE_FILTER = "InfoMapFilters";
    public static String PROPERTYSET_ROLE_OPTION = "InfoMapOptions";
    public static String INFOMAP_NAME = "InfoMapName";
    public static String INFOMAP_PATH = "InfoMapPath";
    private static String m_XML = null;
    private Root m_meta = null;
    private HashMap _allPropertySets = new HashMap();
    private ArrayList _allFilters = new ArrayList();
    private HashMap _allOptions = new HashMap();

    public InfoMapHandler(Root meta) throws MdException, RemoteException {
        if (meta instanceof ClassifierMap) {
            TransformationStep step = (TransformationStep)((ClassifierMap)meta).getSteps(false).get(0);
            this.m_meta = step;
        } else {
            this.m_meta = meta;
        }
        this.loadPropertySet();
    }

    public void loadPropertySet() throws MdException, RemoteException {
        this._allPropertySets.put(PROPERTYSET_ROLE_FILTER, null);
        this._allPropertySets.put(PROPERTYSET_ROLE_OPTION, null);
        AssociationList lSets = this.m_meta.getPropertySets();
        if (lSets == null) {
            return;
        }
        for (int i = 0; i < lSets.size(); ++i) {
            PropertySet propSet = (PropertySet)lSets.get(i);
            if (propSet.getSetRole().compareToIgnoreCase(PROPERTYSET_ROLE_FILTER) == 0) {
                this._allPropertySets.put(PROPERTYSET_ROLE_FILTER, propSet);
                continue;
            }
            if (propSet.getSetRole().compareToIgnoreCase(PROPERTYSET_ROLE_OPTION) != 0) continue;
            this._allPropertySets.put(PROPERTYSET_ROLE_OPTION, propSet);
        }
    }

    public ArrayList getAllFIlters() throws MdException, RemoteException {
        this._allFilters.clear();
        PropertySet propSet = (PropertySet)this._allPropertySets.get(PROPERTYSET_ROLE_FILTER);
        if (propSet == null) {
            return this._allFilters;
        }
        AssociationList lProps = propSet.getProperties();
        if (lProps == null) {
            return this._allFilters;
        }
        int nFilters = lProps.size();
        for (int i = 0; i < nFilters; ++i) {
            String[] filter = new String[3];
            Property filterProperty = (Property)lProps.get(i);
            filter[0] = filterProperty.getName().trim();
            filter[1] = filterProperty.getDefaultValue().trim();
            filter[2] = filterProperty.getDesc().trim();
            this._allFilters.add(filter);
        }
        return this._allFilters;
    }

    public int validateFilter(String[] filter) {
        String infoMapFilterName = filter[0];
        String infoMapFilterCondition = filter[1];
        if (infoMapFilterName.length() <= 0) {
            return 1;
        }
        if (infoMapFilterCondition.length() <= 0) {
            return 2;
        }
        return 0;
    }

    public HashMap getAllOptions() throws MdException, RemoteException {
        this._allOptions.clear();
        this._allOptions.put(INFOMAP_NAME, null);
        this._allOptions.put(INFOMAP_PATH, null);
        PropertySet propSet = (PropertySet)this._allPropertySets.get(PROPERTYSET_ROLE_OPTION);
        if (propSet == null) {
            return this._allOptions;
        }
        AssociationList lProps = propSet.getProperties();
        if (lProps == null) {
            return this._allOptions;
        }
        int nFilters = lProps.size();
        for (int i = 0; i < nFilters; ++i) {
            Property oProperty = (Property)lProps.get(i);
            if (oProperty.getName().trim().equalsIgnoreCase(INFOMAP_NAME)) {
                this._allOptions.put(INFOMAP_NAME, oProperty.getDefaultValue());
                continue;
            }
            if (!oProperty.getName().trim().equalsIgnoreCase(INFOMAP_PATH)) continue;
            this._allOptions.put(INFOMAP_PATH, oProperty.getDefaultValue());
        }
        return this._allOptions;
    }

    public static String getXML(String optionsMetadataType) {
        if (m_XML == null && !InfoMapHandler.loadXML(optionsMetadataType)) {
            return null;
        }
        return m_XML;
    }

    private static boolean loadXML(String optionsMetadataType) {
        WAdminResource bundle = new WAdminResource(InfoMapHandler.class);
        String m_prototypeType = optionsMetadataType;
        String location = bundle.getString("ImageLocation.notrans");
        String m_prototypeFileName = bundle.getString("InfoMapHandler.Options.PrototypeFileName.notrans");
        if (m_prototypeFileName == null) {
            MessageUtil.displayMessage((String)bundle.formatString("InfoMapHandler.MissingPrototypeFilename.msg.txt", (Object)m_prototypeType), (int)0);
            return false;
        }
        try {
            String fileName = location + m_prototypeFileName;
            Locale loc = Locale.getDefault();
            URL url = XMLUtility.urlFromFile((String)fileName, (Locale)loc);
            Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
            m_XML = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

