/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.infomap;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.transforms.infomap.InfoMapFiltersTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.UndoManager;

public class InfoMapFiltersPanel
extends WAPanel {
    private static WAdminResource bundle = new WAdminResource(InfoMapFiltersPanel.class);
    protected Root m_metadata = null;
    protected InfoMapFiltersTableModel m_filtersTableModel;
    protected WsTable m_wsTableFilter;
    protected JScrollPane m_JScrollPane;
    protected JPanel m_pnlButtons;
    protected JButton m_btnNew;
    protected JButton m_btnDelete;
    protected JButton m_btnMoveUp;
    protected JButton m_btnMoveDown;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actMoveUp;
    protected WsAbstractAction m_actMoveDown;
    protected boolean m_bOrderChanged;

    public InfoMapFiltersPanel(CMetadata metaObject) {
        this.m_metadata = (Root)metaObject;
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        this.createActions();
        this.createFiltersTable();
        this.createButtonsPanel();
    }

    protected void createFiltersTable() {
        this.m_filtersTableModel = new InfoMapFiltersTableModel();
        this.m_filtersTableModel.setMetadataObject(this.m_metadata);
        this.m_filtersTableModel.addTableModelListener(this.createTableModelListener());
        this.m_wsTableFilter = new WsTable((WsAbstractTableModel)this.m_filtersTableModel);
        this.m_wsTableFilter.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        this.m_wsTableFilter.setUndoManager((UndoManager)this.getWAUndoManager());
        this.m_wsTableFilter.setColumnsReorderable(false);
        this.m_wsTableFilter.setColumnHoldingEnabled(false);
        this.m_wsTableFilter.setColumnHidingEnabled(false);
        this.m_wsTableFilter.setRowHoldingEnabled(false);
        this.m_wsTableFilter.setAutoResizeMode(3);
        this.m_wsTableFilter.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_wsTableFilter.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.m_wsTableFilter.restoreSettings("InfoMapFiltersPanel");
        this.m_wsTableFilter.setRowHeaderPopupMenuRequestListener(this.createRowHeaderPopupMenuRequestListener());
        this.m_wsTableFilter.setTablePopupMenuRequestListener(this.createTablePopupMenuRequestListener());
        this.m_wsTableFilter.setViewportPopupMenuRequestListener(this.createViewportPopupMenuRequestListener());
        this.m_wsTableFilter.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        this.m_filtersTableModel.addTableModelListener(this.createTableModelListener());
        ((WsDefaultTableRowModel)this.m_wsTableFilter.getRowModel()).addRowModelListener(this.createTableRowModelListener());
        this.m_JScrollPane = new JScrollPane((Component)this.m_wsTableFilter);
    }

    protected void createButtonsPanel() {
        this.m_btnMoveUp = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveDown);
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        JPanel pnlLeft = new JPanel((LayoutManager)new WsButtonsLayout());
        JPanel pnlRight = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlLeft.add(this.m_btnMoveUp);
        pnlLeft.add(this.m_btnMoveDown);
        pnlRight.add(this.m_btnNew);
        pnlRight.add(this.m_btnDelete);
        this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
        this.m_pnlButtons.add((Component)pnlLeft, "West");
        this.m_pnlButtons.add((Component)pnlRight, "East");
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        String borderTitle = bundle.getString("InfoMapFiltersPanel.FilltersBorder.Title.txt");
        TitledBorder outsideBorder = BorderFactory.createTitledBorder(borderTitle);
        Border insideBorder = BorderFactory.createEmptyBorder(0, 10, 5, 10);
        this.setBorder(new CompoundBorder(outsideBorder, insideBorder));
        this.add(this.m_JScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_pnlButtons, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        TableCellEditor editor = this.m_wsTableFilter.getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            return false;
        }
        String filterName = this.m_filtersTableModel.validateFilterExpressions();
        if (filterName != null) {
            String sMessage = bundle.formatString("InfoMapFiltersPanel.NoFilterExpression.msg.fmt", (Object)filterName);
            JOptionPane.showMessageDialog((Component)((Object)this), sMessage, bundle.getString("InfoMapFiltersPanel.NeedFilterExpression.msg.fmt"), 1);
            return false;
        }
        if (this.m_bOrderChanged && !this.m_wsTableFilter.isOriginalOrder()) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("InfoMapFiltersPanel.SaveOrderMessage.txt"), (String)bundle.getString("InfoMapFiltersPanel.SaveOrderTitle.txt"), (int)2, (int)0);
            switch (eAnswer) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_wsTableFilter.getRowModel();
        this.m_filtersTableModel.setRowMappings(mdlRows.getRowMappings());
        return true;
    }

    public void setStorePopulated(boolean bStorePopulated) {
        super.setStorePopulated(bStorePopulated);
        if (!bStorePopulated) {
            this.m_filtersTableModel.setStorePopulated(bStorePopulated);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_filtersTableModel.populateStore();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_filtersTableModel.moveDataToModel();
        if (this.m_filtersTableModel.getRowCount() > 0) {
            this.m_wsTableFilter.selectCell(0, 0);
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_filtersTableModel.moveDataToStore();
        this.m_filtersTableModel.setRowMappings(null);
        this.setDataChanged(false);
        this.m_bOrderChanged = false;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
        this.m_actDelete.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_wsTableFilter.setEditable(bEditable);
        this.m_wsTableFilter.setSortingEnabled(bEditable);
        this.m_wsTableFilter.setRowsReorderable(bEditable);
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        this.m_wsTableFilter.saveSettings("InfoMapFiltersPanel");
    }

    public void setWAUndoManager(WAUndoManager mgrUndo) {
        super.setWAUndoManager(mgrUndo);
        this.m_wsTableFilter.setUndoManager((UndoManager)mgrUndo);
    }

    protected String showExpressionBuilderDialog(int iRow, String sExpression) {
        ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab((CMetadata)this.m_metadata, false, false, false);
        tabExpressionBuilder.setExpression(sExpression);
        tabExpressionBuilder.setUseQuotes(false);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("InfoMapFiltersPanel.ExpressionBuilder.Title.txt"), true, (WAPanel)tabExpressionBuilder);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            dialog.dispose();
            return tabExpressionBuilder.getExpression();
        }
        dialog.dispose();
        return null;
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected WsTableRowModelListener createTableRowModelListener() {
        return new cTableRowModelListener();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected WsPopupMenuRequestListener createRowHeaderPopupMenuRequestListener() {
        return new cRowHeaderPopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createTablePopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createViewportPopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actMoveUp = this.createMoveUpAction();
        this.m_actMoveDown = this.createMoveDownAction();
    }

    protected void updateActions() {
        boolean bSelected;
        int[] aSelectedRows = this.m_wsTableFilter.getSelectedRowsFromSelectedCells();
        boolean bEditable = this.isEditable();
        boolean bNotFirst = bSelected = aSelectedRows.length > 0;
        boolean bNotLast = bSelected;
        int iLastRow = this.m_wsTableFilter.getRowCount() - 1;
        int nSelectedRows = aSelectedRows.length;
        for (int iSelectedRow = 0; iSelectedRow < nSelectedRows; ++iSelectedRow) {
            if (aSelectedRows[iSelectedRow] == 0) {
                bNotFirst = false;
            }
            if (aSelectedRows[iSelectedRow] != iLastRow) continue;
            bNotLast = false;
        }
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actNew.setEnabled(bEditable);
        this.m_actMoveUp.setEnabled(bEditable && bNotFirst);
        this.m_actMoveDown.setEnabled(bEditable && bNotLast);
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createMoveUpAction() {
        return new cMoveUpAction();
    }

    protected WsAbstractAction createMoveDownAction() {
        return new cMoveDownAction();
    }

    protected WsAbstractAction createExpressionAction() {
        return new cExpressionAction();
    }

    protected class cExpressionAction
    extends WsAbstractAction {
        public cExpressionAction() {
            super(bundle, "InfoMapFiltersPanel.Expression", true);
            this.setMenuSupportId("expression");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = InfoMapFiltersPanel.this.m_wsTableFilter.getSelectedRowsFromSelectedCells();
            int iRow = InfoMapFiltersPanel.this.m_wsTableFilter.convertRowIndexToModel(aSelectedRows[0]);
            String sExpression = (String)InfoMapFiltersPanel.this.m_wsTableFilter.getValueAt(iRow, 1);
            if ((sExpression = InfoMapFiltersPanel.this.showExpressionBuilderDialog(iRow, sExpression)) != null) {
                InfoMapFiltersPanel.this.m_filtersTableModel.setValueAt(sExpression, iRow, 1);
                InfoMapFiltersPanel.this.m_wsTableFilter.selectCell(InfoMapFiltersPanel.this.m_wsTableFilter.convertRowIndexToView(iRow), InfoMapFiltersPanel.this.m_wsTableFilter.convertColumnIndexToView(1));
            }
        }
    }

    protected class cMoveDownAction
    extends WsAbstractAction {
        public cMoveDownAction() {
            super(bundle, "InfoMapFiltersPanel.MoveDown", true);
        }

        public void actionPerformed(ActionEvent e) {
            InfoMapFiltersPanel.this.m_wsTableFilter.undoableMoveSelectedRows(1);
            InfoMapFiltersPanel.this.setDataChanged(true);
            InfoMapFiltersPanel.this.m_bOrderChanged = true;
        }
    }

    protected class cMoveUpAction
    extends WsAbstractAction {
        public cMoveUpAction() {
            super(bundle, "InfoMapFiltersPanel.MoveUp", true);
        }

        public void actionPerformed(ActionEvent e) {
            InfoMapFiltersPanel.this.m_wsTableFilter.undoableMoveSelectedRows(-1);
            InfoMapFiltersPanel.this.setDataChanged(true);
            InfoMapFiltersPanel.this.m_bOrderChanged = true;
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "InfoMapFiltersPanel.Delete", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            InfoMapFiltersPanel.this.m_wsTableFilter.undoableDeleteSelectedRows();
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "InfoMapFiltersPanel.New", true);
            this.setMenuSupportId("new");
        }

        public void actionPerformed(ActionEvent e) {
            InfoMapFiltersPanel.this.m_wsTableFilter.undoableInsertNewRowAfterLastSelectedRow();
        }
    }

    public class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)InfoMapFiltersPanel.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)InfoMapFiltersPanel.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public class cRowHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = InfoMapFiltersPanel.this.m_wsTableFilter.createRowHeaderPopupMenu();
            WsUIUtilities.addSpaceIconToPopupMenu((JPopupMenu)mnuPopup);
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.addSeparator();
            }
            mnuPopup.add(new JMenuItem((Action)InfoMapFiltersPanel.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)InfoMapFiltersPanel.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (InfoMapFiltersPanel.this.isListeningForChanges()) {
                InfoMapFiltersPanel.this.setDataChanged(true);
            }
        }
    }

    protected class cTableRowModelListener
    implements WsTableRowModelListener {
        protected cTableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            InfoMapFiltersPanel.this.setDataChanged(true);
            InfoMapFiltersPanel.this.m_bOrderChanged = true;
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            InfoMapFiltersPanel.this.setDataChanged(true);
            InfoMapFiltersPanel.this.m_bOrderChanged = true;
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            InfoMapFiltersPanel.this.updateActions();
        }
    }

    protected class cExpressionDialog
    implements WsDialogTableCellEditorInterface {
        protected cExpressionDialog() {
        }

        public String showDialog(JTable tbl, int iRow, int iCol, String sValue) {
            iRow = ((WsTable)tbl).convertRowIndexToModel(iRow);
            return InfoMapFiltersPanel.this.showExpressionBuilderDialog(iRow, sValue);
        }
    }
}

