/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.infomap;

import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.plugins.PluginResourceBundle;
import com.sas.util.SasPasswordString;
import com.sas.wadmin.transforms.infomap.InfoMapHandler;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsRepositoryUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InfoMapCodeGen {
    private static final String WORKSPACE_USERNAME = "Username";
    private static final String WORKSPACE_PASSWORD = "Password";

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap iMeta) throws MdException, RemoteException {
        PluginResourceBundle bundle = new PluginResourceBundle(InfoMapCodeGen.class);
        StringBuffer infoMapVariables = new StringBuffer();
        StringBuffer infoMapProc = new StringBuffer("PROC INFOMAPS \n");
        StringBuffer infoMapDeleteStmt = new StringBuffer("DELETE INFOMAP ");
        StringBuffer infoMapOpenStmt = new StringBuffer("OPEN INFOMAP ");
        StringBuffer[] infoMapDataSourceStmts = null;
        StringBuffer[] infoMapFilterStmts = null;
        String infoMapPath = "";
        String infoMapName = "";
        String metaUser = "";
        String metaPassword = "";
        try {
            int i;
            CMetadata defaultRepository = Workspace.getWorkspace().getDefaultRepository();
            IOMI omiConnection = Workspace.getMdFactory().getConnection().getCMRHandle();
            if (omiConnection == null) {
                throw new CodegenException(bundle.getString("InfoMapCodeGen.OMIConnectionFail.msg.txt"));
            }
            boolean isBIPTreeExists = WsRepositoryUtil.BIPTreeExists((String)defaultRepository.getFQID());
            if (!isBIPTreeExists) {
                throw new CodegenException(bundle.getString("InfoMapCodeGen.NoBIPTreeSupport.msg.txt"));
            }
            Map creds = Workspace.getMdFactory().getConnection().getCredentialMap();
            Set keys = creds.keySet();
            if (keys.size() <= 0 || !keys.contains(WORKSPACE_USERNAME) || !keys.contains(WORKSPACE_PASSWORD)) {
                throw new CodegenException(bundle.getString("InfoMapCodeGen.InvalidCredential.msg.txt"));
            }
            metaUser = (String)creds.get(WORKSPACE_USERNAME);
            metaPassword = (String)creds.get(WORKSPACE_PASSWORD);
            if (metaUser == null || metaPassword == null) {
                throw new CodegenException(bundle.getString("InfoMapCodeGen.InvalidUser.msg.txt"));
            }
            if (metaUser.equalsIgnoreCase("sasadm")) {
                String sMessage = bundle.messageString("InfoMapCodeGen.RestrictSasadm.msg.fmt", (Object)metaUser);
                throw new CodegenException(sMessage);
            }
            if ((metaPassword = SasPasswordString.encode((String)"sas001", (String)metaPassword)) == null) {
                throw new CodegenException(bundle.getString("InfoMapCodeGen.InvalidUser.msg.txt"));
            }
            InfoMapHandler infoMapHandler = new InfoMapHandler((Root)iMeta);
            HashMap allOptions = infoMapHandler.getAllOptions();
            infoMapName = (String)allOptions.get(InfoMapHandler.INFOMAP_NAME);
            infoMapPath = (String)allOptions.get(InfoMapHandler.INFOMAP_PATH);
            if (infoMapName == null || infoMapName.length() <= 0) {
                throw new CodegenException(bundle.getString("InfoMapCodeGen.NoInfoMapName.msg.txt"));
            }
            if (infoMapPath == null || infoMapPath.length() <= 0) {
                throw new CodegenException(bundle.getString("InfoMapCodeGen.NoMapPath.msg.txt"));
            }
            InfoMapCodeGen.addVariable(1, metaUser, infoMapVariables);
            InfoMapCodeGen.addVariable(2, metaPassword, infoMapVariables);
            InfoMapCodeGen.addVariable(3, infoMapName, infoMapVariables);
            InfoMapCodeGen.addVariable(4, infoMapPath, infoMapVariables);
            int classifierSourcesSize = iMeta.getClassifierSources().size();
            if (classifierSourcesSize <= 0) {
                throw new CodegenException(bundle.getString("InfoMapCodeGen.NoInputs.msg.txt"));
            }
            infoMapDataSourceStmts = new StringBuffer[classifierSourcesSize];
            for (int i2 = 0; i2 < classifierSourcesSize; ++i2) {
                PhysicalTable phyInputTable = (PhysicalTable)iMeta.getClassifierSources().get(i2);
                RelationalSchema relationalSchema = phyInputTable.getTablePackage();
                if (!(relationalSchema instanceof SASLibrary)) {
                    throw new CodegenException(bundle.getString("InfoMapCodeGen.NoSASLibrary.msg.txt"));
                }
                SASLibrary sasLibrary = (SASLibrary)phyInputTable.getTablePackage();
                String srcTable_LibName = sasLibrary.getName();
                String srcTable_Name = phyInputTable.getSASTableName();
                infoMapDataSourceStmts[i2] = new StringBuffer("INSERT DATASOURCE ");
                infoMapDataSourceStmts[i2].append("sasServer = \"&IOMServer\" ");
                infoMapDataSourceStmts[i2].append("table = ");
                infoMapDataSourceStmts[i2].append("\"" + srcTable_LibName + "\".");
                infoMapDataSourceStmts[i2].append("\"" + srcTable_Name + "\"");
                infoMapDataSourceStmts[i2].append(" _ALL_; \n");
            }
            ArrayList allFilters = infoMapHandler.getAllFIlters();
            int nFilters = allFilters.size();
            infoMapFilterStmts = new StringBuffer[nFilters];
            for (i = 0; i < nFilters; ++i) {
                String[] filter = (String[])allFilters.get(i);
                int validateFilter = infoMapHandler.validateFilter(filter);
                if (validateFilter == 1) {
                    throw new CodegenException(bundle.getString("InfoMapCodeGen.NoFilterName.msg.txt"));
                }
                if (validateFilter == 2) {
                    String sMessage = bundle.messageString("InfoMapCodeGen.NoFilterCondition.msg.fmt", (Object)filter[0]);
                    throw new CodegenException(sMessage);
                }
                infoMapFilterStmts[i] = new StringBuffer("INSERT FILTER ");
                infoMapFilterStmts[i].append("'" + filter[0] + "'");
                infoMapFilterStmts[i].append(" condition = ");
                infoMapFilterStmts[i].append("'" + filter[1] + "'");
                infoMapFilterStmts[i].append(" description = ");
                infoMapFilterStmts[i].append("\"" + filter[2] + "\"; \n");
            }
            infoMapProc.append("metaUser = &infoMapMetaUser \n");
            infoMapProc.append("metaPass = &infoMapMetaPassword \n");
            infoMapProc.append("metaServer = \"&metaServer\" \n");
            infoMapProc.append("metaPort = &metaPort \n");
            infoMapProc.append("metaRepository = \"&metaRepository\" \n");
            infoMapProc.append("mappath = &infoMapPath; \n\n");
            infoMapDeleteStmt.append("&infoMapName; \n");
            infoMapOpenStmt.append("&infoMapName; \n");
            cgReq.addSourceCode(infoMapVariables.toString());
            cgReq.addSourceCode("\n");
            cgReq.addSourceCode(infoMapProc.toString());
            cgReq.addSourceCode(infoMapOpenStmt.toString());
            cgReq.addSourceCode("SAVE;\n");
            cgReq.addSourceCode(infoMapDeleteStmt.toString());
            cgReq.addSourceCode(infoMapOpenStmt.toString());
            for (i = 0; i < infoMapDataSourceStmts.length; ++i) {
                cgReq.addSourceCode(infoMapDataSourceStmts[i].toString());
            }
            for (i = 0; i < infoMapFilterStmts.length; ++i) {
                cgReq.addSourceCode(infoMapFilterStmts[i].toString());
            }
            cgReq.addSourceCode("SAVE;\n");
            cgReq.addSourceCode("RUN;\n");
        }
        catch (Exception e) {
            if (e.getMessage().trim().length() > 0) {
                throw new CodegenException(e.getMessage());
            }
            e.printStackTrace();
            throw new CodegenException(bundle.getString("InfoMapCodeGen.UnknownError.msg.txt"));
        }
    }

    private static void addVariable(int varIndex, String value, StringBuffer infoMapVariables) {
        infoMapVariables.append("%let ");
        switch (varIndex) {
            case 1: {
                infoMapVariables.append("infoMapMetaUser = ");
                break;
            }
            case 2: {
                infoMapVariables.append("infoMapMetaPassword = ");
                break;
            }
            case 3: {
                infoMapVariables.append("infoMapName = ");
                break;
            }
            case 4: {
                infoMapVariables.append("infoMapPath = ");
                break;
            }
            case 5: {
                infoMapVariables.append("infoMapSasServer = ");
            }
        }
        infoMapVariables.append("\"");
        infoMapVariables.append(value);
        infoMapVariables.append("\"");
        infoMapVariables.append(";");
        infoMapVariables.append("\n");
    }
}

