/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hpf;

import com.sas.etl.models.job.transforms.hpf.HPFTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;

public class TargetTablePropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(TargetTablePropertyTab.class);
    HPFTransformModel m_hpf;
    private JCheckBox m_chkOut;
    private JCheckBox m_chkOutEst;
    private JCheckBox m_chkOutFor;
    private JCheckBox m_chkOutSeason;
    private JCheckBox m_chkOutStat;
    private JCheckBox m_chkOutSum;
    private JCheckBox m_chkOutTrend;
    private boolean m_OUT = false;
    private boolean m_OUTEST = false;
    private boolean m_OUTFOR = false;
    private boolean m_OUTSEASON = false;
    private boolean m_OUTSTAT = false;
    private boolean m_OUTSUM = false;
    private boolean m_OUTTREND = false;
    private boolean m_Cancel = false;
    private List m_selected;
    private List m_notSelected;

    public TargetTablePropertyTab(HPFTransformModel hpf) {
        this.m_hpf = hpf;
        this.setName(bundle.getString("TargetTablePropertyTab.Name.txt"));
        this.setHelpTopic("target_tables_tab");
        this.initialize();
    }

    protected void initialize() {
        this.m_selected = new ArrayList();
        this.m_notSelected = new ArrayList();
        this.m_chkOut = new JCheckBox(bundle.getString("TargetTablePropertyTab.Out.txt"));
        this.m_chkOut.setMnemonic(bundle.getString("TargetTablePropertyTab.Out.mnem").charAt(0));
        this.m_chkOut.setToolTipText(bundle.formatString("TargetTablePropertyTab.Out.tip", (Object)"OUT"));
        this.listenForDataChangesTo(this.m_chkOut);
        this.m_chkOutEst = new JCheckBox(bundle.getString("TargetTablePropertyTab.OutEst.txt"));
        this.m_chkOutEst.setMnemonic(bundle.getString("TargetTablePropertyTab.OutEst.mnem").charAt(0));
        this.m_chkOutEst.setToolTipText(bundle.formatString("TargetTablePropertyTab.OutEst.tip", (Object)"OUTEST"));
        this.listenForDataChangesTo(this.m_chkOutEst);
        this.m_chkOutFor = new JCheckBox(bundle.getString("TargetTablePropertyTab.OutFor.txt"));
        this.m_chkOutFor.setMnemonic(bundle.getString("TargetTablePropertyTab.OutFor.mnem").charAt(0));
        this.m_chkOutFor.setToolTipText(bundle.formatString("TargetTablePropertyTab.OutFor.tip", (Object)"OUTFOR"));
        this.listenForDataChangesTo(this.m_chkOutFor);
        this.m_chkOutSeason = new JCheckBox(bundle.getString("TargetTablePropertyTab.OutSeason.txt"));
        this.m_chkOutSeason.setMnemonic(bundle.getString("TargetTablePropertyTab.OutSeason.mnem").charAt(0));
        this.m_chkOutSeason.setToolTipText(bundle.formatString("TargetTablePropertyTab.OutSeason.tip", (Object)"OUTSEASON"));
        this.listenForDataChangesTo(this.m_chkOutSeason);
        this.m_chkOutStat = new JCheckBox(bundle.getString("TargetTablePropertyTab.OutStat.txt"));
        this.m_chkOutStat.setMnemonic(bundle.getString("TargetTablePropertyTab.OutStat.mnem").charAt(0));
        this.m_chkOutStat.setToolTipText(bundle.formatString("TargetTablePropertyTab.OutStat.tip", (Object)"OUTSTAT"));
        this.listenForDataChangesTo(this.m_chkOutStat);
        this.m_chkOutSum = new JCheckBox(bundle.getString("TargetTablePropertyTab.OutSum.txt"));
        this.m_chkOutSum.setMnemonic(bundle.getString("TargetTablePropertyTab.OutSum.mnem").charAt(0));
        this.m_chkOutSum.setToolTipText(bundle.formatString("TargetTablePropertyTab.OutSum.tip", (Object)"OUTSUM"));
        this.listenForDataChangesTo(this.m_chkOutSum);
        this.m_chkOutTrend = new JCheckBox(bundle.getString("TargetTablePropertyTab.OutTrend.txt") + " " + bundle.getString("TargetTablePropertyTab.OutTrend.Info.txt"));
        this.m_chkOutTrend.setMnemonic(bundle.getString("TargetTablePropertyTab.OutTrend.mnem").charAt(0));
        this.m_chkOutTrend.setToolTipText(bundle.formatString("TargetTablePropertyTab.OutTrend.tip", (Object)"OUTTREND"));
        this.listenForDataChangesTo(this.m_chkOutTrend);
        this.setLayout(new GridBagLayout());
        this.add(this.m_chkOut, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.add(this.m_chkOutEst, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.add(this.m_chkOutFor, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.add(this.m_chkOutSeason, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.add(this.m_chkOutStat, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.add(this.m_chkOutSum, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.add(this.m_chkOutTrend, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.add((Component)new WAPanel(), new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        try {
            this.populateStore();
            this.m_OUT = this.m_hpf.getForecastsOfVariablesTable() != null;
            this.m_OUTEST = this.m_hpf.getModelParameterEstimatesTable() != null;
            this.m_OUTFOR = this.m_hpf.getForecastTimeSeriesComponentsTable() != null;
            this.m_OUTSEASON = this.m_hpf.getSeasonalStatisticsTable() != null;
            this.m_OUTSTAT = this.m_hpf.getStatisticsOfFitTable() != null;
            this.m_OUTSUM = this.m_hpf.getSummaryStatisticsTable() != null;
            this.m_OUTTREND = this.m_hpf.getTrendStatisticsTable() != null;
            this.setupChangeLists();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        boolean enableTrend = true;
        if (this.m_hpf.getIdColumn() == null || this.m_hpf.getAccumulate().equals("NONE")) {
            enableTrend = false;
        }
        this.m_chkOut.setSelected(this.m_OUT);
        this.m_chkOutEst.setSelected(this.m_OUTEST);
        this.m_chkOutFor.setSelected(this.m_OUTFOR);
        this.m_chkOutSeason.setSelected(this.m_OUTSEASON);
        this.m_chkOutStat.setSelected(this.m_OUTSTAT);
        this.m_chkOutSum.setSelected(this.m_OUTSUM);
        this.m_chkOutTrend.setSelected(this.m_OUTTREND && enableTrend);
        this.m_chkOutTrend.setEnabled(this.isEditable() && enableTrend);
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_OUT = this.m_chkOut.isSelected();
        this.m_OUTEST = this.m_chkOutEst.isSelected();
        this.m_OUTFOR = this.m_chkOutFor.isSelected();
        this.m_OUTSEASON = this.m_chkOutSeason.isSelected();
        this.m_OUTSTAT = this.m_chkOutStat.isSelected();
        this.m_OUTSUM = this.m_chkOutSum.isSelected();
        this.m_OUTTREND = this.m_chkOutTrend.isSelected();
        this.m_selected.removeAll(this.m_selected);
        this.m_notSelected.removeAll(this.m_notSelected);
        this.setupChangeLists();
        this.updateTargets();
        this.setDataChanged(false);
    }

    private void setupChangeLists() {
        if (this.m_OUT) {
            this.m_selected.add("OUT");
        } else {
            this.m_notSelected.add("OUT");
        }
        if (this.m_OUTEST) {
            this.m_selected.add("OUTEST");
        } else {
            this.m_notSelected.add("OUTEST");
        }
        if (this.m_OUTFOR) {
            this.m_selected.add("OUTFOR");
        } else {
            this.m_notSelected.add("OUTFOR");
        }
        if (this.m_OUTSEASON) {
            this.m_selected.add("OUTSEASON");
        } else {
            this.m_notSelected.add("OUTSEASON");
        }
        if (this.m_OUTSTAT) {
            this.m_selected.add("OUTSTAT");
        } else {
            this.m_notSelected.add("OUTSTAT");
        }
        if (this.m_OUTSUM) {
            this.m_selected.add("OUTSUM");
        } else {
            this.m_notSelected.add("OUTSUM");
        }
        if (this.m_OUTTREND) {
            this.m_selected.add("OUTTREND");
        } else {
            this.m_notSelected.add("OUTTREND");
        }
    }

    private void checkTableStatus() {
    }

    public void onParentApply() {
        this.updateTargets();
    }

    public void onParentCancel() {
        this.m_Cancel = true;
    }

    private void updateTargets() {
        this.m_hpf.getModel().startCompoundUndoable();
        try {
            if (this.m_OUT && this.m_hpf.getForecastsOfVariablesTable() == null) {
                this.m_hpf.addTargetTable("OUT");
            } else if (!this.m_OUT && this.m_hpf.getForecastsOfVariablesTable() != null) {
                this.m_hpf.removeTargetTable("OUT");
            }
            if (this.m_OUTEST && this.m_hpf.getModelParameterEstimatesTable() == null) {
                this.m_hpf.addTargetTable("OUTEST");
            } else if (!this.m_OUTEST && this.m_hpf.getModelParameterEstimatesTable() != null) {
                this.m_hpf.removeTargetTable("OUTEST");
            }
            if (this.m_OUTFOR && this.m_hpf.getForecastTimeSeriesComponentsTable() == null) {
                this.m_hpf.addTargetTable("OUTFOR");
            } else if (!this.m_OUTFOR && this.m_hpf.getForecastTimeSeriesComponentsTable() != null) {
                this.m_hpf.removeTargetTable("OUTFOR");
            }
            if (this.m_OUTSEASON && this.m_hpf.getSeasonalStatisticsTable() == null) {
                this.m_hpf.addTargetTable("OUTSEASON");
            } else if (!this.m_OUTSEASON && this.m_hpf.getSeasonalStatisticsTable() != null) {
                this.m_hpf.removeTargetTable("OUTSEASON");
            }
            if (this.m_OUTSTAT && this.m_hpf.getStatisticsOfFitTable() == null) {
                this.m_hpf.addTargetTable("OUTSTAT");
            } else if (!this.m_OUTSTAT && this.m_hpf.getStatisticsOfFitTable() != null) {
                this.m_hpf.removeTargetTable("OUTSTAT");
            }
            if (this.m_OUTSUM && this.m_hpf.getSummaryStatisticsTable() == null) {
                this.m_hpf.addTargetTable("OUTSUM");
            } else if (!this.m_OUTSUM && this.m_hpf.getSummaryStatisticsTable() != null) {
                this.m_hpf.removeTargetTable("OUTSUM");
            }
            if (this.m_OUTTREND && this.m_hpf.getTrendStatisticsTable() == null) {
                this.m_hpf.addTargetTable("OUTTREND");
            } else if (!this.m_OUTTREND && this.m_hpf.getTrendStatisticsTable() != null) {
                this.m_hpf.removeTargetTable("OUTTREND");
            }
            this.m_hpf.updateForecastOfVariablesColumns();
            this.m_hpf.updateModelParameterEstimateColumns();
            this.m_hpf.updateForecastTimeSeriesColumns();
            this.m_hpf.updateSeasonalStatisticsColumns();
            this.m_hpf.updateStatisticsOfFitColumns();
            this.m_hpf.updateSummaryStatisticsColumns();
            this.m_hpf.updateTrendStatisticsColumns();
        }
        finally {
            this.m_hpf.getModel().endCompoundUndoable();
        }
    }

    public void saveSettingsAndCleanUp() {
        this.checkTableStatus();
        if (!this.m_Cancel) {
            this.updateTargets();
        }
        this.m_Cancel = false;
    }

    public boolean validateData() {
        int messageChoice;
        ArrayList<String> tablesUnselected = new ArrayList<String>();
        if (this.m_OUT && !this.m_chkOut.isSelected() && this.m_hpf.getForecastsOfVariablesTable() != null) {
            tablesUnselected.add(this.m_hpf.getForecastsOfVariablesTable().getName());
        }
        if (this.m_OUTEST && !this.m_chkOutEst.isSelected() && this.m_hpf.getModelParameterEstimatesTable() != null) {
            tablesUnselected.add(this.m_hpf.getModelParameterEstimatesTable().getName());
        }
        if (this.m_OUTFOR && !this.m_chkOutFor.isSelected() && this.m_hpf.getForecastTimeSeriesComponentsTable() != null) {
            tablesUnselected.add(this.m_hpf.getForecastTimeSeriesComponentsTable().getName());
        }
        if (this.m_OUTSEASON && !this.m_chkOutSeason.isSelected() && this.m_hpf.getSeasonalStatisticsTable() != null) {
            tablesUnselected.add(this.m_hpf.getSeasonalStatisticsTable().getName());
        }
        if (this.m_OUTSTAT && !this.m_chkOutStat.isSelected() && this.m_hpf.getStatisticsOfFitTable() != null) {
            tablesUnselected.add(this.m_hpf.getStatisticsOfFitTable().getName());
        }
        if (this.m_OUTSUM && !this.m_chkOutSum.isSelected() && this.m_hpf.getSummaryStatisticsTable() != null) {
            tablesUnselected.add(this.m_hpf.getSummaryStatisticsTable().getName());
        }
        if (this.m_OUTTREND && !this.m_chkOutTrend.isSelected() && this.m_hpf.getTrendStatisticsTable() != null) {
            tablesUnselected.add(this.m_hpf.getTrendStatisticsTable().getName());
        }
        return tablesUnselected.isEmpty() || (messageChoice = MessageUtil.displayListMessage((String)bundle.getString("TargetTablePropertyTab.RemoveTargets.msg.txt"), tablesUnselected, (String)bundle.getString("TargetTablePropertyTab.RemoveTargets.title.txt"), (int)1, (int)0)) != 1;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_chkOut.setEnabled(editable);
        this.m_chkOutEst.setEnabled(editable);
        this.m_chkOutFor.setEnabled(editable);
        this.m_chkOutSeason.setEnabled(editable);
        this.m_chkOutStat.setEnabled(editable);
        this.m_chkOutSum.setEnabled(editable);
        this.m_chkOutTrend.setEnabled(editable);
    }
}

