/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hpf;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.hpf.HPFTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.wadmin.transforms.hpf.NameValueComboBoxModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;

public class IDPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(IDPropertyTab.class);
    HPFTransformModel m_hpf;
    private JLabel m_lblDate;
    private WAComboBox m_cmbDate;
    private JCheckBox m_chkNotSorted;
    private JLabel m_lblInterval;
    private WAComboBox m_cmbInterval;
    private JLabel m_lblAccumulate;
    private WAComboBox m_cmbAccumulate;
    private JLabel m_lblSetMissing;
    private WAComboBox m_cmbSetMissing;
    private JLabel m_lblZeroMissing;
    private WAComboBox m_cmbZeroMissing;
    private JLabel m_lblStartDate;
    private WATextField m_txtStartDate;
    private JLabel m_lblEndDate;
    private WATextField m_txtEndDate;
    private JButton m_butReset;
    private NameValueComboBoxModel m_zeroMissingList;
    private NameValueComboBoxModel m_accumulateList;
    private NameValueComboBoxModel m_setMissingList;
    private cResetDefaultsAction m_resetDefaultsAction = new cResetDefaultsAction();
    private WsAbstractAction m_actAccumulate;
    private WsAbstractAction m_actDate;
    private WsAbstractAction m_actIterval;
    private WsAbstractAction m_actSetMissing;
    private WsAbstractAction m_actZeroMissing;
    private WsAbstractToggleAction m_actNotSorted;
    private IModelListener m_lsnrModel;
    private boolean m_bBadIntervalFormat;

    public IDPropertyTab(HPFTransformModel hpf) {
        this.m_hpf = hpf;
        this.setName(bundle.getString("IDPropertyTab.Name.txt"));
        this.setHelpTopic("id_tab");
        this.m_lsnrModel = new ModelListener();
        hpf.getModel().addModelListener(this.m_lsnrModel);
        this.initialize();
    }

    protected void initialize() {
        this.m_setMissingList = new NameValueComboBoxModel("IDPropertyTab.SetMissing", true);
        this.m_setMissingList.addItem("AVERAGE").addItem("FIRST").addItem("LAST").addItem("MAXIMUM").addItem("MEDIAN").addItem("MINIMUM").addItem("MISSING").addItem("NEXT").addItem("PREVIOUS");
        this.m_accumulateList = new NameValueComboBoxModel("IDPropertyTab.Accumulate", true);
        this.m_accumulateList.addItem("AVERAGE").addItem("CSS").addItem("FIRST").addItem("LAST").addItem("MAXIMUM").addItem("MEDIAN").addItem("MINIMUM").addItem("N").addItem("NMISS").addItem("NOBS").addItem("NONE").addItem("STDDEV").addItem("TOTAL").addItem("USS");
        this.m_zeroMissingList = new NameValueComboBoxModel("IDPropertyTab.ZeroMiss", true);
        this.m_zeroMissingList.addItem("BOTH").addItem("LEFT").addItem("NONE").addItem("RIGHT");
        this.createActions();
        this.m_cmbDate = new WAComboBox(true);
        this.m_lblDate = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbDate, (WAdminResource)bundle, (String)"IDPropertyTab.Date");
        this.m_cmbDate.addActionListener((ActionListener)new cDateColumnListener());
        this.listenForDataChangesTo((JComboBox)this.m_cmbDate);
        this.m_cmbDate.setRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_cmbDate.addActionListener((ActionListener)this.m_actDate);
        this.m_chkNotSorted = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actNotSorted);
        this.listenForDataChangesTo(this.m_chkNotSorted);
        this.m_cmbInterval = new WAComboBox((Object[])HPFTransformModel.IDOPTION_INTERVALS);
        this.m_lblInterval = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbInterval, (WAdminResource)bundle, (String)"IDPropertyTab.Interval");
        this.m_cmbInterval.setEditable(true);
        this.listenForDataChangesTo((JComboBox)this.m_cmbInterval);
        this.m_cmbInterval.addActionListener((ActionListener)this.m_actIterval);
        this.m_cmbAccumulate = new WAComboBox();
        this.m_cmbAccumulate.setModel((ComboBoxModel)this.m_accumulateList);
        this.m_lblAccumulate = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbAccumulate, (WAdminResource)bundle, (String)"IDPropertyTab.Accumulate");
        this.listenForDataChangesTo((JComboBox)this.m_cmbAccumulate);
        this.m_cmbAccumulate.addActionListener((ActionListener)this.m_actAccumulate);
        this.m_cmbSetMissing = new WAComboBox();
        this.m_cmbSetMissing.setModel((ComboBoxModel)this.m_setMissingList);
        this.m_lblSetMissing = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbSetMissing, (WAdminResource)bundle, (String)"IDPropertyTab.SetMissing");
        this.m_cmbSetMissing.setEditable(true);
        this.m_cmbSetMissing.setSorted(true);
        this.listenForDataChangesTo((JComboBox)this.m_cmbSetMissing);
        this.m_cmbSetMissing.addActionListener((ActionListener)this.m_actSetMissing);
        this.m_cmbZeroMissing = new WAComboBox();
        this.m_cmbZeroMissing.setModel((ComboBoxModel)this.m_zeroMissingList);
        this.m_lblZeroMissing = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbZeroMissing, (WAdminResource)bundle, (String)"IDPropertyTab.ZeroMissing");
        this.listenForDataChangesTo((JComboBox)this.m_cmbZeroMissing);
        this.m_cmbZeroMissing.addActionListener((ActionListener)this.m_actZeroMissing);
        cFocusListener focusListener = new cFocusListener();
        this.m_txtStartDate = new WATextField();
        this.m_lblStartDate = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtStartDate, (WAdminResource)bundle, (String)"IDPropertyTab.StartDate");
        this.listenForDataChangesTo((JTextComponent)this.m_txtStartDate);
        this.m_txtStartDate.addFocusListener((FocusListener)focusListener);
        this.m_txtEndDate = new WATextField();
        this.m_lblEndDate = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtEndDate, (WAdminResource)bundle, (String)"IDPropertyTab.EndDate");
        this.listenForDataChangesTo((JTextComponent)this.m_txtEndDate);
        this.m_txtEndDate.addFocusListener((FocusListener)focusListener);
        this.m_butReset = WsUIUtilities.createTextButton((WsAbstractAction)this.m_resetDefaultsAction);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblDate, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbDate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.m_chkNotSorted, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.m_lblInterval, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbInterval, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblAccumulate, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbAccumulate, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblSetMissing, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbSetMissing, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblZeroMissing, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbZeroMissing, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblStartDate, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_txtStartDate, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblEndDate, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_txtEndDate, new GridBagConstraints(1, 7, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_butReset, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 14, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    protected void createActions() {
        this.m_actDate = new cDateComboBoxAction();
        this.m_actAccumulate = new cAccumulateComboBoxAction();
        this.m_actIterval = new cIntervalComboBoxAction();
        this.m_actSetMissing = new cSetMissingComboBoxAction();
        this.m_actZeroMissing = new cZeroMissingComboBoxAction();
        this.m_actNotSorted = new cNotSortedCheckBoxAction();
    }

    public void moveDataToView() throws MdException, RemoteException {
        IColumn col;
        this.setListeningForChanges(false);
        this.m_cmbDate.removeAllItems();
        this.m_cmbDate.addItem((Object)bundle.getString("HPF.None.txt"));
        List numericColumns = this.m_hpf.getNumericSourceColumns();
        if (numericColumns != null && !numericColumns.isEmpty()) {
            this.m_cmbDate.addItems(numericColumns);
        }
        if ((col = this.m_hpf.getIdColumn()) != null && numericColumns != null && numericColumns.contains(col)) {
            this.m_cmbDate.setSelectedItem((Object)col);
        } else {
            this.m_cmbDate.setSelectedItem((Object)bundle.getString("HPF.None.txt"));
        }
        this.m_chkNotSorted.setSelected(this.m_hpf.isNotSorted());
        this.m_cmbInterval.setSelectedItem((Object)this.m_hpf.getInterval());
        this.m_accumulateList.setSelectedValue(this.m_hpf.getAccumulate());
        this.m_setMissingList.setSelectedValue(this.m_hpf.getSetMissing());
        this.m_zeroMissingList.setSelectedValue(this.m_hpf.getZeroMissing());
        this.m_txtStartDate.setText(this.m_hpf.getStartDate());
        this.m_txtEndDate.setText(this.m_hpf.getEndDate());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_hpf.setStartDate(this.m_txtStartDate.getText());
        this.m_hpf.setEndDate(this.m_txtEndDate.getText());
    }

    public boolean validateData() {
        if (!this.m_cmbDate.getSelectedItem().equals(bundle.getString("HPF.None.txt")) && this.m_cmbInterval.getSelectedItem().equals("")) {
            MessageUtil.displayMessage((String)bundle.getString("IDPropertyTab.Interval.Error.txt"), (int)0);
            this.m_cmbInterval.requestFocusInWindow();
            return false;
        }
        if (!this.m_setMissingList.getSelectedValue().equals("") && !this.m_setMissingList.getValueList().contains(this.m_setMissingList.getSelectedValue())) {
            try {
                Double.parseDouble((String)this.m_cmbSetMissing.getSelectedItem());
            }
            catch (NumberFormatException exc) {
                MessageUtil.displayMessage((String)bundle.getString("IDPropertyTab.SetMissing.Error.txt"), (int)0);
                this.m_cmbSetMissing.requestFocusInWindow();
                return false;
            }
        }
        if (this.m_bBadIntervalFormat) {
            Object selectedColumn = this.m_cmbDate.getSelectedItem();
            String colname = selectedColumn instanceof IColumn ? ((IColumn)selectedColumn).getName() : selectedColumn.toString();
            MessageUtil.displayMessage((String)bundle.formatString("IDPropertyTab.IntervalFormat.Warning.txt", (Object)colname), (int)2);
        }
        return true;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_cmbDate.setEnabled(editable);
        boolean dateColumnSelected = this.m_cmbDate.getSelectedItem() != null ? editable && !this.m_cmbDate.getSelectedItem().equals(bundle.getString("HPF.None.txt")) : editable;
        this.m_chkNotSorted.setEnabled(dateColumnSelected);
        this.m_cmbInterval.setEnabled(dateColumnSelected);
        this.m_cmbAccumulate.setEnabled(dateColumnSelected);
        this.m_cmbSetMissing.setEnabled(dateColumnSelected);
        this.m_cmbZeroMissing.setEnabled(dateColumnSelected);
        this.m_txtStartDate.setEnabled(dateColumnSelected);
        this.m_txtEndDate.setEnabled(dateColumnSelected);
        this.m_butReset.setEnabled(editable);
        this.m_resetDefaultsAction.setEnabled(editable);
    }

    private void setDateEnabledComponents() {
        this.setEditable(this.isEditable());
    }

    private void resetToDefaultValues() {
        this.m_hpf.getModel().startCompoundUndoable();
        try {
            this.m_hpf.setNotSorted(false);
            this.m_hpf.setAccumulate("NONE");
            this.m_hpf.setSetMissing("MISSING");
            this.m_hpf.setZeroMissing("NONE");
            this.m_hpf.setIdColumn(null);
            this.m_hpf.setInterval("");
            this.m_hpf.setIntervalFormat("");
            this.m_hpf.setStartDate("");
            this.m_hpf.setEndDate("");
        }
        finally {
            this.m_hpf.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIntervalFormat() {
        String format = "";
        if (!this.m_cmbInterval.getSelectedItem().equals("")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WsAppServer appServer = WsAppServer.createDefaultAppServer((boolean)true);
            try {
                StringBuffer strCode = new StringBuffer();
                strCode.append("data WORK.FMT;\n");
                strCode.append("FMT=intfmt('").append(this.m_cmbInterval.getSelectedItem()).append("','long');\n");
                strCode.append("run;\n");
                appServer.submitSASCode(strCode.toString());
                try {
                    MVAResultSet resultSet = appServer.submitSQLStatement("select FMT from WORK.FMT");
                    resultSet.next();
                    format = resultSet.getString(1).trim();
                    resultSet.close();
                }
                catch (SQLException exc) {
                    MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                }
            }
            catch (WsAppServerFailException wsfe) {
                MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerCodeException e) {
                this.showSASLogDialog(bundle.getString("QueueMessageOptionsTab.Error.SASCode.txt"), appServer);
            }
            finally {
                if (appServer != null) {
                    appServer.close();
                    appServer.dispose();
                    appServer = null;
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
        this.m_bBadIntervalFormat = format.length() == 0;
        return format;
    }

    protected void showSASLogDialog(String sMessage, WsAppServer wsAppServer) {
        int choice = MessageUtil.displayMessage((String)sMessage, (int)0, (int)0);
        if (choice == 0) {
            String sTitle = bundle.getString("IDPropertyTab.Title.Log.txt");
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), sTitle, true, wsAppServer);
            dlg.show();
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_hpf.getModel().removeModelListener(this.m_lsnrModel);
        this.m_cmbDate.removeActionListener((ActionListener)this.m_actDate);
        this.m_cmbAccumulate.removeActionListener((ActionListener)this.m_actAccumulate);
        this.m_cmbInterval.removeActionListener((ActionListener)this.m_actIterval);
        this.m_cmbSetMissing.removeActionListener((ActionListener)this.m_actSetMissing);
        this.m_cmbZeroMissing.removeActionListener((ActionListener)this.m_actZeroMissing);
        this.m_chkNotSorted.removeActionListener((ActionListener)this.m_actNotSorted);
        super.saveSettingsAndCleanUp();
    }

    protected class cNotSortedCheckBoxAction
    extends WsAbstractToggleAction {
        public cNotSortedCheckBoxAction() {
            super(bundle, "IDPropertyTab.Sorted", 0);
        }

        public void actionPerformed(ActionEvent event) {
            IDPropertyTab.this.m_hpf.setNotSorted(IDPropertyTab.this.m_chkNotSorted.isSelected());
        }
    }

    protected class cDateComboBoxAction
    extends WsAbstractAction {
        protected cDateComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!IDPropertyTab.this.isListeningForChanges()) {
                return;
            }
            Object selectedItem = IDPropertyTab.this.m_cmbDate.getSelectedItem();
            if (selectedItem == null) {
                IDPropertyTab.this.m_cmbDate.setSelectedItem((Object)bundle.getString("HPF.None.txt"));
                IDPropertyTab.this.m_hpf.setIdColumn(null);
            } else if (IDPropertyTab.this.m_cmbDate.getSelectedItem().equals(bundle.getString("HPF.None.txt"))) {
                IDPropertyTab.this.m_hpf.setIdColumn(null);
            } else {
                IDPropertyTab.this.m_hpf.setIdColumn((IColumn)IDPropertyTab.this.m_cmbDate.getSelectedItem());
            }
        }
    }

    protected class cZeroMissingComboBoxAction
    extends WsAbstractAction {
        protected cZeroMissingComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!IDPropertyTab.this.isListeningForChanges()) {
                return;
            }
            IDPropertyTab.this.m_hpf.setZeroMissing(IDPropertyTab.this.m_zeroMissingList.getSelectedValue());
        }
    }

    protected class cSetMissingComboBoxAction
    extends WsAbstractAction {
        protected cSetMissingComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!IDPropertyTab.this.isListeningForChanges()) {
                return;
            }
            IDPropertyTab.this.m_hpf.setSetMissing(IDPropertyTab.this.m_setMissingList.getSelectedValue());
        }
    }

    protected class cIntervalComboBoxAction
    extends WsAbstractAction {
        protected cIntervalComboBoxAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (!IDPropertyTab.this.isListeningForChanges()) {
                return;
            }
            IDPropertyTab.this.setCursor(Cursor.getPredefinedCursor(3));
            IDPropertyTab.this.m_hpf.getModel().startCompoundUndoable();
            try {
                IDPropertyTab.this.m_hpf.setInterval(IDPropertyTab.this.m_cmbInterval.getText());
                if (!IDPropertyTab.this.m_hpf.getModel().isUndoing()) {
                    OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace());
                    request.setDelayBeforeProgressCancelDialog(200);
                    request.setTitle(bundle.getString("IDPropertyTab.IntervalFormatProgress.Title.txt"));
                    request.setMessage(bundle.getString("IDPropertyTab.IntervalFormatProgress.Message.txt"));
                    Runnable runAnalyze = new Runnable(){

                        @Override
                        public void run() {
                            String format = IDPropertyTab.this.getIntervalFormat();
                            IDPropertyTab.this.m_hpf.setIntervalFormat(format);
                        }
                    };
                    request.execute(runAnalyze);
                }
            }
            finally {
                IDPropertyTab.this.m_hpf.getModel().endCompoundUndoable();
            }
            IDPropertyTab.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected class cAccumulateComboBoxAction
    extends WsAbstractAction {
        protected cAccumulateComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!IDPropertyTab.this.isListeningForChanges()) {
                return;
            }
            IDPropertyTab.this.m_hpf.setAccumulate(IDPropertyTab.this.m_accumulateList.getSelectedValue());
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (!IDPropertyTab.this.isListeningForChanges()) {
                return;
            }
            String sType = ev.getType();
            if (sType.compareToIgnoreCase("HPFTransform:IntervalChanged") == 0) {
                IDPropertyTab.this.m_cmbInterval.setSelectedItem((Object)IDPropertyTab.this.m_hpf.getInterval());
            } else if (sType.compareToIgnoreCase("HPFTransform:AccumulateChanged") == 0) {
                IDPropertyTab.this.m_accumulateList.setSelectedValue(IDPropertyTab.this.m_hpf.getAccumulate());
            } else if (sType.compareToIgnoreCase("HPFTransform:SetMissingChanged") == 0) {
                IDPropertyTab.this.m_setMissingList.setSelectedValue(IDPropertyTab.this.m_hpf.getSetMissing());
            } else if (sType.compareToIgnoreCase("HPFTransform:ZeroMissingChanged") == 0) {
                IDPropertyTab.this.m_zeroMissingList.setSelectedValue(IDPropertyTab.this.m_hpf.getZeroMissing());
            } else if (sType.compareToIgnoreCase("HPFTransform:NotSortedChanged") == 0) {
                IDPropertyTab.this.m_chkNotSorted.setSelected(IDPropertyTab.this.m_hpf.isNotSorted());
            } else if (sType.compareToIgnoreCase("HPFTransform:IdColumnChanged") == 0) {
                IColumn col = IDPropertyTab.this.m_hpf.getIdColumn();
                if (col != null) {
                    IDPropertyTab.this.m_cmbDate.setSelectedItem((Object)IDPropertyTab.this.m_hpf.getIdColumn());
                } else {
                    IDPropertyTab.this.m_cmbDate.setSelectedItem((Object)bundle.getString("HPF.None.txt"));
                }
            } else if (sType.compareToIgnoreCase("HPFTransform:StartDateChanged") == 0) {
                IDPropertyTab.this.m_txtStartDate.setText(IDPropertyTab.this.m_hpf.getStartDate());
            } else if (sType.compareToIgnoreCase("HPFTransform:EndDateChanged") == 0) {
                IDPropertyTab.this.m_txtEndDate.setText(IDPropertyTab.this.m_hpf.getEndDate());
            }
        }
    }

    private class cFocusListener
    implements FocusListener {
        private cFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (arg0.getComponent() == IDPropertyTab.this.m_txtStartDate) {
                IDPropertyTab.this.m_hpf.setStartDate(IDPropertyTab.this.m_txtStartDate.getText());
            } else if (arg0.getComponent() == IDPropertyTab.this.m_txtEndDate) {
                IDPropertyTab.this.m_hpf.setEndDate(IDPropertyTab.this.m_txtEndDate.getText());
            }
        }
    }

    public class cListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int iRow, boolean bSelected, boolean bHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, iRow, bSelected, bHasFocus);
            if (value instanceof IColumn) {
                IColumn oColumn = (IColumn)value;
                this.setText(oColumn.getName());
            }
            return this;
        }
    }

    private class cResetDefaultsAction
    extends WsAbstractAction {
        public cResetDefaultsAction() {
            super(bundle, "PropertyTab.Reset");
        }

        public void actionPerformed(ActionEvent event) {
            IDPropertyTab.this.resetToDefaultValues();
        }
    }

    private class cDateColumnListener
    implements ActionListener {
        private cDateColumnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IDPropertyTab.this.setDateEnabledComponents();
        }
    }
}

