/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hpf;

import com.sas.codegen.CodegenException;
import com.sas.codegen.TableLoaderOptions;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.PFDUtil;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.transforms.hpf.HPFPropertyHandler;
import com.sas.wadmin.visuals.WAPFDEditorOMAView;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class HPFUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(HPFUtil.class);
    public static final String OUT = "OUT";
    public static final String OUTEST = "OUTEST";
    public static final String OUTFOR = "OUTFOR";
    public static final String OUTSEASON = "OUTSEASON";
    public static final String OUTSTAT = "OUTSTAT";
    public static final String OUTSUM = "OUTSUM";
    public static final String OUTTREND = "OUTTREND";
    public static final String[] saROLES = new String[]{"OUT", "OUTEST", "OUTFOR", "OUTSEASON", "OUTSTAT", "OUTSUM", "OUTTREND"};
    public static final int LEAD_DEFAULT = 12;
    public static final int BACK_DEFAULT = 0;
    public static final String ACCUMULATE_DEFAULT = "NONE";
    public static final String SETMISSING_DEFAULT = "MISSING";
    public static final String ZEROMISS_DEFAULT = "NONE";
    public static final double ALPHA_DEFAULT = 0.05;
    public static final String USE_DEFAULT = "PREDICT";
    public static final String MODEL_DEFAULT = "BEST";
    public static final String SELECT_DEFAULT = "RMSE";
    public static final int HOLDOUT_DEFAULT = 0;
    public static final double HOLDOUTPCT_DEFAULT = 100.0;
    public static final double INTERMITTENT_DEFAULT = 1.25;
    public static final String TRANSFORM_DEFAULT = "NONE";
    public static final boolean REPLACEMISSING_DEFAULT = false;
    public static final boolean MEDIAN_DEFAULT = false;
    public static final boolean SORTNAMES_DEFAULT = false;
    public static final String SEASONALITY_DEFAULT = "";
    public static final boolean NOTSORTED_DEFAULT = false;
    public static final boolean PRINTDETAILS_DEFAULT = false;
    public static final boolean USEOUTPUTWINDOW_DEFAULT = false;
    public static final String START_DEFAULT = "";
    public static final String END_DEFAULT = "";
    public static final String IDCOLUMN_DEFAULT = bundle.getString("HPF.None.txt");

    public static Document getHPFDocument(TransformationStep tStep) throws MdException, RemoteException {
        AssociationList docs = tStep.getDocuments(false).getState() == 0 ? tStep.getDocuments(true) : tStep.getDocuments(false);
        Document cDoc = null;
        if (tStep != null) {
            for (int i = 0; i < docs.size(); ++i) {
                if (!((Document)docs.get(i)).getTextRole().equals("HPFOUTPUT")) continue;
                return (Document)docs.get(i);
            }
        }
        return cDoc;
    }

    public static void createHPFDocument(TransformationStep tStep) throws MdException, RemoteException {
        if (HPFUtil.getHPFDocument(tStep) == null) {
            Document cDocument = (Document)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)tStep.getObjectStore(), WsMetadataNameUtil.getUniqueNameForType((String)"Document", (String)bundle.getString("HPF.DefaultReportName.txt")), "Document", tStep.getRepositoryID());
            cDocument.setTextRole("HPFOUTPUT");
            cDocument.setTextType("HTML");
            cDocument.setURI(cDocument.getName().replaceAll(" ", "") + ".html");
            cDocument.setURIType("File");
            tStep.getDocuments().add((Object)cDocument);
            PFDUtil.dropTargetObject(tStep, (CMetadata)cDocument, true);
        }
    }

    public static void deleteHPFDocument(TransformationStep tStep) throws MdException, RemoteException {
        Document cDoc;
        if (tStep != null && (cDoc = HPFUtil.getHPFDocument(tStep)) != null) {
            ArrayList<Document> cDocList = new ArrayList<Document>();
            cDocList.add(cDoc);
            PFDPanel mainPanel = HPFUtil.getPFDPanel(tStep);
            if (mainPanel != null) {
                mainPanel.pfdDeleteObjects(cDocList, false);
            }
        }
    }

    public static String getNameSuffix(String metadataType, String preferredName) {
        StringBuffer newName;
        Random rand = new Random();
        int MAX_ATTEMPTS = 10;
        int MAX_SUFFIX = 99999;
        int attempts = 0;
        String strSuffix = "";
        do {
            newName = new StringBuffer();
            ++attempts;
            int suffix = rand.nextInt(MAX_SUFFIX) + 1;
            newName.append(preferredName);
            newName.append(" ");
            newName.append(suffix);
            strSuffix = Integer.toString(suffix);
        } while (!WsMetadataNameUtil.isNameUnique((String)metadataType, (String)newName.toString()) && attempts < MAX_ATTEMPTS);
        return strSuffix;
    }

    public static void updateHPFTargetTable(ClassifierMap cMap, String role) throws MdException, RemoteException {
        PhysicalTable wTable;
        PhysicalTable cPhysicalTable = null;
        boolean dropTable = false;
        if (HPFUtil.isOutputActive(cMap, role)) {
            cPhysicalTable = HPFUtil.getHPFPhysicalTable(cMap, role);
        }
        if (cPhysicalTable == null) {
            String tableDesc = HPFUtil.getTableDescription(role);
            String tableSuffix = HPFUtil.getNameSuffix("PhysicalTable", tableDesc);
            String tableName = role + "_" + tableSuffix;
            cPhysicalTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), tableDesc + " " + tableSuffix, "PhysicalTable", cMap.getRepositoryID());
            Role cPTRole = (Role)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), role, "Role", cMap.getRepositoryID());
            cPTRole.setObjectRole(role);
            cPhysicalTable.getRoles().add((Object)cPTRole);
            cPhysicalTable.setSASTableName(tableName);
            cPhysicalTable.setTableName(tableName);
            cPhysicalTable.setMemberType("DATA");
            DataTable lastTable = HPFUtil.getLastTable(cMap);
            if (lastTable != null) {
                cPhysicalTable.setTablePackage(lastTable.getTablePackage());
                DBMSNamesPropertyHandler.createDBMSNamesPropertySet((Root)cPhysicalTable, (String)DBMSNamesPropertyHandler.getCasePropertyValue((Root)lastTable), (String)DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)lastTable));
            }
            dropTable = true;
        }
        if ((wTable = HPFUtil.getHPFWorkTable(cMap, role)) == null) {
            String tableDesc = HPFUtil.getTableDescription(role);
            String tableSuffix = HPFUtil.getNameSuffix("WorkTable", tableDesc);
            String tableName = role + "_" + tableSuffix;
            wTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), tableDesc + " " + tableSuffix, "WorkTable", cMap.getRepositoryID());
            Role cPTRole = (Role)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), role, "Role", cMap.getRepositoryID());
            cPTRole.setObjectRole(role);
            wTable.getRoles().add((Object)cPTRole);
            wTable.setSASTableName(tableName);
            wTable.setTableName(tableName);
            wTable.setMemberType("DATA");
            cMap.getClassifierTargets().add((Object)wTable);
        }
        HPFUtil.updateTargetTableColumns((Select)cMap, (DataTable)cPhysicalTable, role, null, null);
        if (dropTable) {
            PFDUtil.dropTargetObject((TransformationStep)cMap.getSteps().get(0), (CMetadata)cPhysicalTable, true, wTable);
        }
        ClassifierMap cLoader = (ClassifierMap)cPhysicalTable.getTargetClassifierMaps().get(0);
        TransformationStep tLoader = (TransformationStep)cLoader.getSteps(false).get(0);
        if (dropTable) {
            TableLoaderOptions tLoaderOptions = new TableLoaderOptions(tLoader);
            tLoaderOptions.setTruncate(false);
        }
        HPFUtil.updateTargetTableColumns((Select)cMap, (DataTable)wTable, role, (DataTable)cPhysicalTable, cLoader);
        ((MdObjectStore)cMap.getObjectStore()).flushUpdatesToParentStore();
    }

    public static void deleteHPFTargetTable(ClassifierMap cMap, String role) throws MdException, RemoteException {
        if (cMap != null) {
            PFDPanel parentPanel;
            PhysicalTable pTable = HPFUtil.getHPFPhysicalTable(cMap, role);
            TransformationStep oTS = (TransformationStep)cMap.getSteps(false).get(0);
            if (oTS != null && (parentPanel = HPFUtil.getPFDPanel(oTS)) != null) {
                PhysicalTable wTable;
                if (pTable != null) {
                    ArrayList<PhysicalTable> tableList = new ArrayList<PhysicalTable>();
                    tableList.add(pTable);
                    parentPanel.pfdDeleteObjects(tableList, false);
                    PFDUtil.getTransformationActivityForTransformationStep(oTS).getTransformationTargets(false).remove((Object)pTable);
                }
                if ((wTable = HPFUtil.getHPFWorkTable(cMap, role)) != null) {
                    if (wTable.getCMetadataType().equals("WorkTable")) {
                        ArrayList deleteObjects = new ArrayList();
                        if (!wTable.getSourceClassifierMaps().isEmpty()) {
                            ClassifierMap loaderMap = (ClassifierMap)wTable.getSourceClassifierMaps().get(0);
                            TransformationStep loaderStep = (TransformationStep)loaderMap.getSteps(false).get(0);
                            WAPFDNodeModel loaderNodeModel = parentPanel.getNodeModel(loaderStep.getFQID());
                            parentPanel.pfdDeleteObject((PFDPrimitive)loaderNodeModel.getViewNode(), false);
                        }
                        deleteObjects.addAll(wTable.getColumns());
                        ((MdObjectStore)cMap.getObjectStore()).removeObjectsFromStore(deleteObjects);
                        ((MdObjectStore)cMap.getObjectStore()).flushUpdatesToParentStore();
                    } else {
                        cMap.getClassifierTargets().remove((Object)wTable);
                    }
                    WAPFDNodeModel.removeFMs((CMetadata)cMap, (DataTable)wTable);
                }
            }
        }
    }

    public static FeatureMap getFeatureMap(ClassifierMap cMap, String role) throws MdException, RemoteException {
        for (int i = 0; i < cMap.getFeatureMaps(false).size(); ++i) {
            FeatureMap fm = (FeatureMap)cMap.getFeatureMaps(false).get(i);
            if (!fm.getName().equals(role)) continue;
            return fm;
        }
        return null;
    }

    public static void updateDerivedFeatureMaps(ClassifierMap cMap, String role, List sourceColList, List targetColList) throws MdException, RemoteException {
        if (cMap != null) {
            FeatureMap fmap = HPFUtil.getFeatureMap(cMap, role);
            if (fmap == null) {
                fmap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), role, "FeatureMap", cMap.getRepositoryID());
                fmap.setAssociatedClassifierMap(cMap);
                fmap.setTransformRole("DERIVED");
            }
            fmap.getFeatureSources().removeAllElements();
            fmap.getFeatureSources().addAll((Collection)sourceColList);
            fmap.getFeatureTargets().removeAllElements();
            fmap.getFeatureTargets().addAll((Collection)targetColList);
        }
    }

    public static void updateOneToOneFeatureMaps(ClassifierMap cMap, List sourceColumnList, List targetColumnList) throws MdException, RemoteException {
        if (cMap != null) {
            for (int k = 0; k < targetColumnList.size(); ++k) {
                Column col = (Column)targetColumnList.get(k);
                if (!col.getTargetFeatureMaps().isEmpty()) continue;
                FeatureMap fmap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), "newmap", "FeatureMap", cMap.getRepositoryID());
                fmap.setAssociatedClassifierMap(cMap);
                fmap.setTransformRole("ONETOONE");
                fmap.getFeatureTargets().add((Object)col);
                fmap.getFeatureSources().add((Object)HPFUtil.getSASNamedColumn(sourceColumnList, col.getSASColumnName()));
            }
        }
    }

    public static PFDPanel getPFDPanel(TransformationStep step) throws MdException, RemoteException {
        Job oJob = PFDUtil.getJobForTransformationStep(step);
        WAPFDEditorOMAView omaView = (WAPFDEditorOMAView)WsViewFactory.findExistingView((CMetadata)oJob, (String)WAPFDEditorOMAView.class.getName());
        if (omaView != null) {
            return omaView.getPFDPanel();
        }
        return null;
    }

    public static PhysicalTable getHPFPhysicalTable(ClassifierMap cMap, String role) throws MdException, RemoteException {
        PhysicalTable wTable;
        if (cMap != null && HPFUtil.isOutputActive(cMap, role) && (wTable = HPFUtil.getHPFWorkTable(cMap, role)) != null) {
            if (wTable.getCMetadataType().equals("WorkTable")) {
                ClassifierMap cLoaderMap = (ClassifierMap)wTable.getSourceClassifierMaps(false).get(0);
                if (!cLoaderMap.getClassifierTargets().isEmpty()) {
                    return (PhysicalTable)cLoaderMap.getClassifierTargets(false).get(0);
                }
            } else {
                return wTable;
            }
        }
        return null;
    }

    public static PhysicalTable getHPFWorkTable(ClassifierMap cMap, String role) throws MdException, RemoteException {
        if (cMap != null) {
            for (int i = 0; i < cMap.getClassifierTargets(false).size(); ++i) {
                PhysicalTable wTable = (PhysicalTable)cMap.getClassifierTargets(false).get(i);
                if (wTable == null) continue;
                for (int j = 0; j < wTable.getRoles().size(); ++j) {
                    Role wRole = (Role)wTable.getRoles().get(j);
                    if (!wRole.getObjectRole().equals(role)) continue;
                    return wTable;
                }
            }
        }
        return null;
    }

    public static String getTableRole(DataTable oTable) throws MdException, RemoteException {
        if (oTable != null) {
            if (oTable.getRoles().isEmpty()) {
                return null;
            }
            return ((Role)oTable.getRoles(false).get(0)).getObjectRole();
        }
        return null;
    }

    public static boolean isOutputActive(ClassifierMap cMap, String role) throws MdException, RemoteException {
        PhysicalTable wTable;
        return cMap != null && (wTable = HPFUtil.getHPFWorkTable(cMap, role)) != null && (!wTable.getSourceClassifierMaps().isEmpty() || wTable.getCMetadataType().equals("PhysicalTable"));
    }

    public static boolean isOutputActive(PhysicalTable wTable) throws MdException, RemoteException {
        return wTable != null && (!wTable.getSourceClassifierMaps(false).isEmpty() || wTable.getCMetadataType().equals("PhysicalTable"));
    }

    public static void updateTargetTableColumns(Select cMap, DataTable oTable, String role, DataTable pTable, ClassifierMap cLoader) throws MdException, RemoteException {
        if (!cMap.getClassifierSources(false).isEmpty() && oTable != null && !((DataTable)cMap.getClassifierSources(false).get(0)).getColumns().isEmpty()) {
            Column col;
            int i;
            AssociationList colList = oTable.getColumns();
            ArrayList<Column> colsToAdd = new ArrayList<Column>();
            HPFPropertyHandler idHandler = new HPFPropertyHandler((Root)cMap, HPFPropertyHandler.ID_PROPERTY_SET_NAME);
            HPFPropertyHandler forecastHandler = new HPFPropertyHandler((Root)cMap, HPFPropertyHandler.FORECAST_PROPERTY_SET_NAME);
            Column idCol = idHandler.getPropertyColumn(HPFPropertyHandler.ID_VARIABLE_PROPERTY_NAME);
            if (role.equals(OUT)) {
                List forecastColumns;
                colsToAdd.addAll((Collection<Column>)cMap.getOrderByForSelect().getColumns());
                if (idCol != null) {
                    colsToAdd.add(idCol);
                }
                if ((forecastColumns = forecastHandler.getPropertyColumns(HPFPropertyHandler.FORECAST_VARIABLE_PROPERTY_NAME)) != null && !forecastColumns.isEmpty()) {
                    colsToAdd.addAll(forecastColumns);
                } else {
                    colsToAdd.addAll(HPFUtil.getPossibleForecastColumns((ClassifierMap)cMap));
                }
            } else if (role.equals(OUTEST)) {
                colsToAdd.addAll((Collection<Column>)cMap.getOrderByForSelect().getColumns());
            } else if (role.equals(OUTFOR)) {
                colsToAdd.addAll((Collection<Column>)cMap.getOrderByForSelect().getColumns());
                if (idCol != null) {
                    colsToAdd.add(idCol);
                }
            } else if (role.equals(OUTSEASON)) {
                colsToAdd.addAll((Collection<Column>)cMap.getOrderByForSelect().getColumns());
            } else if (role.equals(OUTSTAT)) {
                colsToAdd.addAll((Collection<Column>)cMap.getOrderByForSelect().getColumns());
            } else if (role.equals(OUTSUM)) {
                colsToAdd.addAll((Collection<Column>)cMap.getOrderByForSelect().getColumns());
            } else if (role.equals(OUTTREND)) {
                colsToAdd.addAll((Collection<Column>)cMap.getOrderByForSelect().getColumns());
                if (idCol != null) {
                    colsToAdd.add(idCol);
                }
            }
            ArrayList<Column> columnExclusionList = new ArrayList<Column>();
            for (int i2 = 0; i2 < colsToAdd.size(); ++i2) {
                String idFormat;
                Column sourceCol = (Column)colsToAdd.get(i2);
                Column tempCol = HPFUtil.getSASNamedColumn((List)colList, sourceCol.getSASColumnName());
                if (tempCol == null) {
                    String idFormat2;
                    Column targetCol = (Column)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), sourceCol.getName(), "Column", cMap.getRepositoryID());
                    MdStoreUtil.copyObjectAttributes((CMetadata)sourceCol, (CMetadata)targetCol);
                    if (sourceCol == idCol && (idFormat2 = idHandler.getSpecificOptionValue(HPFPropertyHandler.INTERVALFORMAT)) != null && idFormat2.length() > 0) {
                        targetCol.setSASFormat(idFormat2);
                    }
                    colList.add((Object)targetCol);
                    continue;
                }
                columnExclusionList.add(tempCol);
                if (sourceCol != idCol || (idFormat = idHandler.getSpecificOptionValue(HPFPropertyHandler.INTERVALFORMAT)) == null || idFormat.length() <= 0) continue;
                tempCol.setSASFormat(idFormat);
            }
            HPFUtil.createColumns((ClassifierMap)cMap, oTable, role, colsToAdd);
            ArrayList<Column> deleteColumnList = new ArrayList<Column>();
            for (i = colList.size() - 1; i >= 0; --i) {
                col = (Column)colList.get(i);
                if (HPFUtil.getSASNamedColumn(colsToAdd, col.getSASColumnName()) != null) continue;
                deleteColumnList.add(col);
            }
            WAPFDNodeModel.removeFMs((CMetadata)cMap, oTable, columnExclusionList);
            ((MdObjectStore)cMap.getObjectStore()).removeObjectsFromStore(deleteColumnList);
            if (pTable != null) {
                List forecastColumns;
                AssociationList orderBy;
                for (i = 0; i < oTable.getColumns().size(); ++i) {
                    col = (Column)oTable.getColumns().get(i);
                    if (!col.getSourceFeatureMaps().isEmpty()) continue;
                    FeatureMap fmap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), "newmap", "FeatureMap", cMap.getRepositoryID());
                    fmap.getFeatureSources().add((Object)col);
                    fmap.getFeatureTargets().add((Object)HPFUtil.getSASNamedColumn((List)pTable.getColumns(), col.getSASColumnName()));
                    fmap.setTransformRole("ONETOONE");
                    fmap.setAssociatedClassifierMap(cLoader);
                }
                ArrayList<Column> sourceColList = new ArrayList<Column>();
                Column idColumn = idHandler.getPropertyColumn(HPFPropertyHandler.ID_VARIABLE_PROPERTY_NAME);
                if (idColumn != null) {
                    sourceColList.add(idColumn);
                }
                if ((orderBy = cMap.getOrderByForSelect().getColumns()) != null) {
                    sourceColList.addAll((Collection<Column>)orderBy);
                }
                if ((forecastColumns = forecastHandler.getPropertyColumns(HPFPropertyHandler.FORECAST_VARIABLE_PROPERTY_NAME)) != null && !forecastColumns.isEmpty()) {
                    sourceColList.addAll(forecastColumns);
                }
                if (!role.equals(OUT)) {
                    HPFUtil.updateDerivedFeatureMaps((ClassifierMap)cMap, role, sourceColList, (List)colList);
                } else {
                    HPFUtil.updateOneToOneFeatureMaps((ClassifierMap)cMap, sourceColList, (List)colList);
                }
            }
        }
    }

    public static Column getSASNamedColumn(List colList, String columnName) {
        if (colList != null && columnName.length() > 0) {
            for (int i = 0; i < colList.size(); ++i) {
                Column tempCol = (Column)colList.get(i);
                try {
                    if (tempCol.getSASColumnName().equals(columnName)) {
                        return tempCol;
                    }
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        return null;
    }

    public static void createTargetColumn(ClassifierMap cMap, DataTable oTable, String columnName, String columnType, int columnIndex, String role, List columnsToRemain) throws MdException, RemoteException {
        HPFUtil.createTargetColumn(cMap, oTable, columnName, columnType, columnIndex, role, columnsToRemain, -1);
    }

    public static void createTargetColumn(ClassifierMap cMap, DataTable oTable, String columnName, String columnType, int columnIndex, String role, List columnsToRemain, int lead) throws MdException, RemoteException {
        if (oTable != null) {
            Column existingColumn = HPFUtil.getSASNamedColumn((List)oTable.getColumns(), columnName);
            if (existingColumn == null) {
                Column cColumn2 = (Column)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), columnName, "Column", cMap.getRepositoryID());
                cColumn2.setColumnName(columnName);
                cColumn2.setSASColumnName(columnName);
                cColumn2.setIsNullable(1);
                if (lead == -1) {
                    cColumn2.setDesc(bundle.getString("HPF.TargetTable." + role + "." + columnName + ".label.txt"));
                } else {
                    cColumn2.setDesc(bundle.messageString("HPF.TargetTable." + role + "._LEAD_.label.txt", (Object)Integer.toString(lead)));
                }
                cColumn2.setSASColumnType(columnType);
                if (WsColumnMetadataUtil.isColumnTypeNumeric((Column)cColumn2)) {
                    cColumn2.setColumnLength(8);
                    cColumn2.setSASColumnLength(8);
                } else {
                    cColumn2.setColumnLength(32);
                    cColumn2.setSASColumnLength(32);
                }
                oTable.getColumns().insertElementAt((Object)cColumn2, columnIndex);
                columnsToRemain.add(cColumn2);
            } else {
                columnsToRemain.add(existingColumn);
            }
        }
    }

    public static void createColumns(ClassifierMap cMap, DataTable oTable, String role, List columnsToRemain) throws MdException, RemoteException {
        HPFPropertyHandler hpfHandler = new HPFPropertyHandler((Root)cMap, HPFPropertyHandler.HPF_PROPERTY_SET_NAME);
        HPFPropertyHandler idHandler = new HPFPropertyHandler((Root)cMap, HPFPropertyHandler.ID_PROPERTY_SET_NAME);
        AssociationList colList = oTable.getColumns();
        if (role.equals(OUT)) {
            if (idHandler.getPropertyColumn(HPFPropertyHandler.ID_VARIABLE_PROPERTY_NAME) == null) {
                HPFUtil.createTargetColumn(cMap, oTable, "TIME", WsColumnMetadataUtil.getDataNumericType(), 0, role, columnsToRemain);
            }
        } else if (role.equals(OUTEST)) {
            HPFUtil.createTargetColumn(cMap, oTable, "_NAME_", WsColumnMetadataUtil.getDataCharacterType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_TRANSFORM_", WsColumnMetadataUtil.getDataCharacterType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_MODEL_", WsColumnMetadataUtil.getDataCharacterType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_PARM_", WsColumnMetadataUtil.getDataCharacterType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_EST_", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_STDERR_", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_TVALUE_", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_PVALUE_", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
        } else if (role.equals(OUTFOR)) {
            HPFUtil.createTargetColumn(cMap, oTable, "_NAME_", WsColumnMetadataUtil.getDataCharacterType(), colList.size(), role, columnsToRemain);
            if (idHandler.getPropertyColumn(HPFPropertyHandler.ID_VARIABLE_PROPERTY_NAME) == null) {
                HPFUtil.createTargetColumn(cMap, oTable, "_TIMEID", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            }
            HPFUtil.createTargetColumn(cMap, oTable, "ACTUAL", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, USE_DEFAULT, WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "LOWER", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "UPPER", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "ERROR", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "STD", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
        } else if (role.equals(OUTSEASON)) {
            HPFUtil.createTargetColumn(cMap, oTable, "_NAME_", WsColumnMetadataUtil.getDataCharacterType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_SEASON_", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NOBS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, WsColumnMetadataUtil.getDataNumericType(), WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NMISS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MIN", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MAX", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "RANGE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "SUM", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MEAN", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "STDDEV", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "CSS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "USS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MEDIAN", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
        } else if (role.equals(OUTSTAT)) {
            HPFUtil.createTargetColumn(cMap, oTable, "_NAME_", WsColumnMetadataUtil.getDataCharacterType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_REGION_", WsColumnMetadataUtil.getDataCharacterType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "DFE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, WsColumnMetadataUtil.getDataNumericType(), WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NOBS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NMISSA", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NMISSP", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NPARMS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "TSS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "SST", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "SSE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MSE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "UMSE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, SELECT_DEFAULT, WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "URMSE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MAPE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MAE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "RSQUARE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "ADJRSQ", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "AADJRSQ", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "RWRSQ", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "AIC", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "SBC", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "APC", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MAXERR", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MINERR", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MINPE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MAXPE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "ME", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MPE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
        } else if (role.equals(OUTSUM)) {
            HPFUtil.createTargetColumn(cMap, oTable, "_NAME_", WsColumnMetadataUtil.getDataCharacterType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_STATUS_", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NOBS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, WsColumnMetadataUtil.getDataNumericType(), WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NMISS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MIN", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MAX", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MEAN", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "STDDEV", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, USE_DEFAULT, WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "STD", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "LOWER", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "UPPER", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            String strLead = hpfHandler.getSpecificOptionValue(HPFPropertyHandler.LEAD);
            int lead = strLead.length() == 0 ? 12 : Integer.parseInt(strLead);
            for (int i = 1; i <= lead; ++i) {
                HPFUtil.createTargetColumn(cMap, oTable, "_LEAD" + Integer.toString(i) + "_", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain, i);
            }
        } else if (role.equals(OUTTREND)) {
            HPFUtil.createTargetColumn(cMap, oTable, "_NAME_", WsColumnMetadataUtil.getDataCharacterType(), colList.size() - 1, role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "_SEASON_", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NOBS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, WsColumnMetadataUtil.getDataNumericType(), WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "NMISS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MIN", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MAX", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "RANGE", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "SUM", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MEAN", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "STDDEV", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "CSS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "USS", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
            HPFUtil.createTargetColumn(cMap, oTable, "MEDIAN", WsColumnMetadataUtil.getDataNumericType(), colList.size(), role, columnsToRemain);
        }
    }

    public static DataTable getLastTable(ClassifierMap cMap) throws MdException, RemoteException {
        DataTable rTable = null;
        if (cMap != null) {
            StepPrecedence sPrec;
            TransformationStep pStep;
            DataTable tempTable;
            for (int i = 0; i < cMap.getClassifierSources(false).size(); ++i) {
                DataTable oTable = (DataTable)cMap.getClassifierSources(false).get(i);
                if (oTable.getTablePackage() == null) continue;
                if (oTable instanceof PhysicalTable) {
                    return oTable;
                }
                throw new CodegenException(bundle.getString("HPFUtil.NoExternalTableSource.msg.txt"));
            }
            TransformationStep tStep = (TransformationStep)cMap.getSteps(false).get(0);
            if (!tStep.getSuccessorDependencies(false).isEmpty() && (tempTable = HPFUtil.getLastTable((ClassifierMap)(pStep = (TransformationStep)(sPrec = (StepPrecedence)tStep.getSuccessorDependencies(false).get(0)).getPredecessors(false).get(0)).getTransformations(false).get(0))) != null) {
                rTable = tempTable;
            }
        }
        return rTable;
    }

    public static void cleanupColumns(ClassifierMap cMap) throws MdException, RemoteException {
        if (cMap != null) {
            ArrayList<Column> colDeleteList = new ArrayList<Column>();
            ArrayList<FeatureMap> fmDeleteList = new ArrayList<FeatureMap>();
            for (int i = 0; i < cMap.getClassifierTargets(false).size(); ++i) {
                DataTable oTable = (DataTable)cMap.getClassifierTargets(false).get(i);
                for (int j = 0; j < oTable.getColumns().size(); ++j) {
                    Column oColumn = (Column)oTable.getColumns().get(j);
                    if (!oColumn.getSourceFeatureMaps(false).isEmpty()) continue;
                    colDeleteList.add(oColumn);
                    for (int k = 0; k < oColumn.getTargetFeatureMaps(false).size(); ++k) {
                        FeatureMap fmap = (FeatureMap)oColumn.getTargetFeatureMaps(false).get(k);
                        fmDeleteList.add(fmap);
                    }
                }
            }
            if (!colDeleteList.isEmpty()) {
                ((MdObjectStore)cMap.getObjectStore()).removeObjectsFromStore(colDeleteList);
            }
            if (!fmDeleteList.isEmpty()) {
                ((MdObjectStore)cMap.getObjectStore()).removeObjectsFromStore(fmDeleteList);
            }
        }
    }

    public static String getTableDescription(String role) {
        if (role.equals(OUT)) {
            return bundle.getString("DefaultTableName.Out.txt");
        }
        if (role.equals(OUTEST)) {
            return bundle.getString("DefaultTableName.OutEst.txt");
        }
        if (role.equals(OUTFOR)) {
            return bundle.getString("DefaultTableName.OutFor.txt");
        }
        if (role.equals(OUTSEASON)) {
            return bundle.getString("DefaultTableName.OutSeason.txt");
        }
        if (role.equals(OUTSTAT)) {
            return bundle.getString("DefaultTableName.OutStat.txt");
        }
        if (role.equals(OUTSUM)) {
            return bundle.getString("DefaultTableName.OutSum.txt");
        }
        if (role.equals(OUTTREND)) {
            return bundle.getString("DefaultTableName.OutTrend.txt");
        }
        return "";
    }

    public static List getSourceNumericColumns(ClassifierMap cMap) throws MdException, RemoteException {
        ArrayList<Column> columnList = null;
        if (cMap != null && !cMap.getClassifierSources(false).isEmpty()) {
            DataTable oTable = (DataTable)cMap.getClassifierSources(false).get(0);
            AssociationList columns = oTable.getColumns();
            columnList = new ArrayList<Column>();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                if (!column.getSASColumnType().equals(WsColumnMetadataUtil.getDataNumericType())) continue;
                columnList.add(column);
            }
        }
        return columnList;
    }

    public static List getPossibleForecastColumns(ClassifierMap cMap) throws MdException, RemoteException {
        List columnList = null;
        if (cMap != null && (columnList = HPFUtil.getSourceNumericColumns(cMap)) != null) {
            AssociationList byVariables;
            HPFPropertyHandler idHandler = new HPFPropertyHandler((Root)cMap, HPFPropertyHandler.ID_PROPERTY_SET_NAME);
            Column idColumn = idHandler.getPropertyColumn(HPFPropertyHandler.ID_VARIABLE_PROPERTY_NAME);
            if (idColumn != null) {
                columnList.remove(idColumn);
            }
            if ((byVariables = ((Select)cMap).getOrderByForSelect().getColumns()) != null && !byVariables.isEmpty()) {
                columnList.removeAll((Collection<?>)byVariables);
            }
        }
        return columnList;
    }
}

