/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hpf;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.hpf.HPFTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.wadmin.transforms.hpf.HPFDualListSelector;
import com.sas.wadmin.transforms.hpf.NameValueComboBoxModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WADecimalTextField;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;

public class ForecastPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ForecastPropertyTab.class);
    private HPFTransformModel m_hpf;
    private WATextArea m_txtAreaForecast;
    private DualListSelector m_dlsForecastVars;
    private DefaultListModel m_lstAvailForecastVars;
    private DefaultListModel m_lstSelectedForecastVars;
    private List m_arrSourceNumericColumns;
    private List m_arrSelectedNumericColumns;
    private JLabel m_lblAlpha;
    private WADecimalTextField m_txtAlpha;
    private JLabel m_lblUse;
    private WAComboBox m_cmbUse;
    private JCheckBox m_chkReplace;
    private JPanel m_panModel;
    private TitledBorder m_titledBorder;
    private JLabel m_lblModel;
    private WAComboBox m_cmbModel;
    private JLabel m_lblModelSelect;
    private WAComboBox m_cmbModelSelect;
    private JLabel m_lblHoldout;
    private WAIntTextField m_txtHoldout;
    private JLabel m_lblHoldoutPct;
    private WADecimalTextField m_txtHoldoutPct;
    private JLabel m_lblIntermittent;
    private WADecimalTextField m_txtIntermittent;
    private JLabel m_lblTransform;
    private WAComboBox m_cmbTransform;
    private JCheckBox m_chkMedian;
    private JButton m_butReset;
    private NameValueComboBoxModel m_useList;
    private NameValueComboBoxModel m_selectList;
    private NameValueComboBoxModel m_modelList;
    private NameValueComboBoxModel m_transformList;
    private cResetDefaultsAction m_resetDefaultsAction = new cResetDefaultsAction();
    private IModelListener m_lsnrModel;
    private FocusListener m_lsnrFocus;
    private DualListener m_lsnrDual;
    private WsAbstractAction m_actModel;
    private WsAbstractAction m_actModelSelect;
    private WsAbstractAction m_actTransform;
    private WsAbstractAction m_actUse;
    private WsAbstractToggleAction m_actMedian;
    private WsAbstractToggleAction m_actReplaceMissing;
    private boolean m_bEditHappening;

    public ForecastPropertyTab(HPFTransformModel hpf) {
        this.m_hpf = hpf;
        this.setName(bundle.getString("ForecastPropertyTab.Name.txt"));
        this.setHelpTopic("forecast_tab");
        this.m_lsnrModel = new ModelListener();
        hpf.getModel().addModelListener(this.m_lsnrModel);
        this.initialize();
        this.setPreferredSize(new Dimension(200, 200));
        this.m_bEditHappening = false;
    }

    public void initialize() {
        this.m_useList = new NameValueComboBoxModel("ForecastPropertyTab.Use", true);
        this.m_useList.addItem("LOWER").addItem("PREDICT").addItem("UPPER");
        this.m_selectList = new NameValueComboBoxModel("ForecastPropertyTab.Select", true);
        this.m_selectList.addItem("AADJRSQ").addItem("ADJRSQ").addItem("AIC").addItem("APC").addItem("GMAPE").addItem("GMAPPE").addItem("GMASPE").addItem("GMRAE").addItem("MAE").addItem("MAPE").addItem("MAPPE").addItem("MAXERR").addItem("MAXPE").addItem("MAXPPE").addItem("MAXRE").addItem("MAXSPE").addItem("MDAPE").addItem("MDAPPE").addItem("MDASPE").addItem("MDRAE").addItem("ME").addItem("MINERR").addItem("MINPE").addItem("MINPPE").addItem("MINRE").addItem("MINSPE").addItem("MPE").addItem("MRAE").addItem("MRE").addItem("MSE").addItem("MSPE").addItem("MSPPE").addItem("RMSE").addItem("RSQUARE").addItem("RWRSQ").addItem("SBC").addItem("SMAPE").addItem("SSE").addItem("UMSE").addItem("URMSE");
        this.m_modelList = new NameValueComboBoxModel("ForecastPropertyTab.Model", true);
        this.m_modelList.addItem("ADDWINTERS").addItem("BEST").addItem("BESTALL").addItem("BESTN").addItem("BESTS").addItem("DAMPTREND").addItem("DOUBLE").addItem("IDM").addItem("LINEAR").addItem("NONE").addItem("SIMPLE").addItem("SEASONAL").addItem("WINTERS");
        this.m_transformList = new NameValueComboBoxModel("ForecastPropertyTab.Transform", true);
        this.m_transformList.addItem("AUTO").addItem("BOXCOX(n)").addItem("LOG").addItem("LOGISTIC").addItem("NONE").addItem("SQRT");
        this.m_lsnrFocus = new cFocusListener();
        this.m_txtAreaForecast = new WATextArea();
        this.m_txtAreaForecast.setBehavior(1);
        this.m_txtAreaForecast.setText(bundle.getString("ForecastPropertyTab.ForecastVars.SelectAll.txt"));
        this.m_txtAreaForecast.setAutosize(true);
        this.m_dlsForecastVars = new HPFDualListSelector(this.m_hpf.getModel());
        this.m_dlsForecastVars.setSourceCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_dlsForecastVars.setSourceLabel(bundle.getString("ForecastPropertyTab.ForecastVarsSource.txt"));
        this.m_dlsForecastVars.getSourceComponent().setToolTipText(bundle.getString("ForecastPropertyTab.ForecastVarsSource.tip"));
        ((JLabel)this.m_dlsForecastVars.getSourceLabelComponent()).setDisplayedMnemonic(bundle.getString("ForecastPropertyTab.ForecastVarsSource.mnem").charAt(0));
        this.m_dlsForecastVars.setTargetCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_dlsForecastVars.setTargetLabel(bundle.getString("ForecastPropertyTab.ForecastVarsTarget.txt"));
        this.m_dlsForecastVars.getTargetComponent().setToolTipText(bundle.getString("ForecastPropertyTab.ForecastVarsTarget.tip"));
        ((JLabel)this.m_dlsForecastVars.getTargetLabelComponent()).setDisplayedMnemonic(bundle.getString("ForecastPropertyTab.ForecastVarsTarget.mnem").charAt(0));
        this.m_dlsForecastVars.setDragAndDropEnabled(false);
        this.m_dlsForecastVars.setAlternatingSingleButtonStyle(false);
        this.m_lstSelectedForecastVars = new DefaultListModel();
        this.m_lstAvailForecastVars = new DefaultListModel();
        this.m_dlsForecastVars.setModel((ListModel)this.m_lstAvailForecastVars);
        this.m_dlsForecastVars.setTargetModel((ListModel)this.m_lstSelectedForecastVars);
        this.m_lsnrDual = new DualListener();
        this.m_lstAvailForecastVars.addListDataListener(this.m_lsnrDual);
        this.m_lstSelectedForecastVars.addListDataListener(this.m_lsnrDual);
        this.createActions();
        this.m_txtAlpha = new WADecimalTextField();
        this.m_lblAlpha = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtAlpha, (WAdminResource)bundle, (String)"ForecastPropertyTab.Alpha");
        this.listenForDataChangesTo((JTextComponent)this.m_txtAlpha);
        this.m_txtAlpha.addFocusListener(this.m_lsnrFocus);
        this.m_cmbUse = new WAComboBox();
        this.m_cmbUse.setModel((ComboBoxModel)this.m_useList);
        this.m_lblUse = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbUse, (WAdminResource)bundle, (String)"ForecastPropertyTab.Use");
        this.listenForDataChangesTo((JComboBox)this.m_cmbUse);
        this.m_cmbUse.addActionListener((ActionListener)this.m_actUse);
        this.m_chkReplace = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actReplaceMissing);
        this.listenForDataChangesTo(this.m_chkReplace);
        this.m_cmbModel = new WAComboBox();
        this.m_cmbModel.setModel((ComboBoxModel)this.m_modelList);
        this.m_lblModel = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbModel, (WAdminResource)bundle, (String)"ForecastPropertyTab.Model");
        this.m_cmbModel.addActionListener((ActionListener)new cModelActionListener());
        this.listenForDataChangesTo((JComboBox)this.m_cmbModel);
        this.m_cmbModel.addActionListener((ActionListener)this.m_actModel);
        this.m_cmbModelSelect = new WAComboBox();
        this.m_cmbModelSelect.setModel((ComboBoxModel)this.m_selectList);
        this.m_lblModelSelect = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbModelSelect, (WAdminResource)bundle, (String)"ForecastPropertyTab.ModelSelect");
        this.listenForDataChangesTo((JComboBox)this.m_cmbModelSelect);
        this.m_cmbModelSelect.addActionListener((ActionListener)this.m_actModelSelect);
        this.m_txtHoldout = new WAIntTextField();
        this.m_lblHoldout = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtHoldout, (WAdminResource)bundle, (String)"ForecastPropertyTab.Holdout");
        this.m_txtHoldout.getDocument().addDocumentListener(new cHoldoutListener());
        this.listenForDataChangesTo((JTextComponent)this.m_txtHoldout);
        this.m_txtHoldout.addFocusListener(this.m_lsnrFocus);
        this.m_txtHoldoutPct = new WADecimalTextField();
        this.m_lblHoldoutPct = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtHoldoutPct, (WAdminResource)bundle, (String)"ForecastPropertyTab.HoldoutPct");
        this.listenForDataChangesTo((JTextComponent)this.m_txtHoldoutPct);
        this.m_txtHoldoutPct.addFocusListener(this.m_lsnrFocus);
        this.m_txtIntermittent = new WADecimalTextField();
        this.m_lblIntermittent = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtIntermittent, (WAdminResource)bundle, (String)"ForecastPropertyTab.Intermittent");
        this.listenForDataChangesTo((JTextComponent)this.m_txtIntermittent);
        this.m_txtIntermittent.addFocusListener(this.m_lsnrFocus);
        this.m_cmbTransform = new WAComboBox();
        this.m_cmbTransform.setModel((ComboBoxModel)this.m_transformList);
        this.m_lblTransform = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbTransform, (WAdminResource)bundle, (String)"ForecastPropertyTab.Transform");
        this.m_cmbTransform.setEditable(true);
        this.listenForDataChangesTo((JComboBox)this.m_cmbTransform);
        this.m_cmbTransform.addActionListener((ActionListener)this.m_actTransform);
        this.m_chkMedian = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actMedian);
        this.listenForDataChangesTo(this.m_chkMedian);
        this.m_panModel = new JPanel();
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)bundle.getString("ForecastPropertyTab.ModelPanel.title.txt"));
        this.m_panModel.setBorder(this.m_titledBorder);
        this.m_butReset = WsUIUtilities.createTextButton((WsAbstractAction)this.m_resetDefaultsAction);
        this.setLayout(new GridBagLayout());
        this.m_panModel.setLayout(new GridBagLayout());
        this.add((Component)this.m_txtAreaForecast, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_dlsForecastVars, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.m_lblAlpha, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtAlpha, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_lblUse, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_cmbUse, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_chkReplace, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_panModel, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.m_panModel.add((Component)this.m_lblModel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_panModel.add((Component)this.m_cmbModel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.m_panModel.add((Component)this.m_lblModelSelect, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_panModel.add((Component)this.m_cmbModelSelect, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.m_panModel.add((Component)this.m_lblHoldout, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.m_panModel.add((Component)this.m_txtHoldout, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_panModel.add((Component)this.m_lblHoldoutPct, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_panModel.add((Component)this.m_txtHoldoutPct, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.m_panModel.add((Component)this.m_lblIntermittent, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.m_panModel.add((Component)this.m_txtIntermittent, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_panModel.add((Component)this.m_lblTransform, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_panModel.add((Component)this.m_cmbTransform, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.m_panModel.add((Component)this.m_chkMedian, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 14, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_butReset, new GridBagConstraints(0, 6, 4, 1, 1.0, 0.0, 14, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void setupModels() throws MdException, RemoteException {
        int i;
        List possibleColumns = this.m_hpf.getPossibleForecastColumns();
        ArrayList forecastColumns = new ArrayList(this.m_hpf.getForecastColumns());
        if (possibleColumns != null) {
            this.m_arrSourceNumericColumns = possibleColumns;
            if (forecastColumns == null || forecastColumns.isEmpty()) {
                this.m_arrSelectedNumericColumns = new ArrayList();
            } else {
                forecastColumns.retainAll(possibleColumns);
                this.m_arrSelectedNumericColumns = new ArrayList(forecastColumns);
                this.m_arrSourceNumericColumns.removeAll(this.m_arrSelectedNumericColumns);
            }
        }
        this.m_lstAvailForecastVars.removeAllElements();
        this.m_lstSelectedForecastVars.removeAllElements();
        for (i = 0; i < this.m_arrSourceNumericColumns.size(); ++i) {
            this.m_lstAvailForecastVars.addElement(this.m_arrSourceNumericColumns.get(i));
        }
        for (i = 0; i < this.m_arrSelectedNumericColumns.size(); ++i) {
            this.m_lstSelectedForecastVars.addElement(this.m_arrSelectedNumericColumns.get(i));
        }
    }

    protected void createActions() {
        this.m_actMedian = new cMedianCheckBoxAction();
        this.m_actReplaceMissing = new cReplaceMissingCheckBoxAction();
        this.m_actTransform = new cTransformComboBoxAction();
        this.m_actModel = new cModelComboBoxAction();
        this.m_actModelSelect = new cModelSelectComboBoxAction();
        this.m_actUse = new cUseComboBoxAction();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.setupModels();
        double alpha = this.m_hpf.getAlpha();
        this.m_txtAlpha.setText(NumberFormat.getInstance().format(alpha));
        this.m_useList.setSelectedValue(this.m_hpf.getUse());
        this.m_chkReplace.setSelected(this.m_hpf.isReplaceMissing());
        this.m_modelList.setSelectedValue(this.m_hpf.getModelOption());
        this.m_selectList.setSelectedValue(this.m_hpf.getModelSelection());
        this.m_txtHoldout.setText(Integer.toString(this.m_hpf.getHoldout()));
        double holdoutpct = this.m_hpf.getHoldoutPercent();
        this.m_txtHoldoutPct.setValue(holdoutpct);
        double intermittent = this.m_hpf.getIntermittent();
        this.m_txtIntermittent.setValue(intermittent);
        this.m_transformList.setSelectedValue(this.m_hpf.getTransform());
        this.m_chkMedian.setSelected(this.m_hpf.isEstimateMedian());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        try {
            this.m_hpf.setAlpha(this.m_txtAlpha.getValue());
            this.m_hpf.setHoldout(this.m_txtHoldout.getValue2());
            this.m_hpf.setHoldoutPercent(this.m_txtHoldoutPct.getValue());
            this.m_hpf.setIntermittent(this.m_txtIntermittent.getValue());
        }
        catch (WADecimalTextField.IllegalDecimalException illegalDecimalException) {
        }
        catch (WAIntTextField.IllegalIntegerException illegalIntegerException) {
            // empty catch block
        }
    }

    public boolean validateData() {
        double intermittent = 0.0;
        try {
            intermittent = this.m_txtIntermittent.getValue();
        }
        catch (WADecimalTextField.IllegalDecimalException exc) {
            MessageUtil.displayMessage((String)bundle.formatString("Common.Decimal.Error.txt", (Object)this.m_txtIntermittent.getText()), (int)0);
            this.m_txtIntermittent.requestFocus();
            return false;
        }
        try {
            this.m_txtHoldout.getValue2();
        }
        catch (WAIntTextField.IllegalIntegerException exc) {
            MessageUtil.displayMessage((String)bundle.formatString("Common.Integer.Error.txt", (Object)this.m_txtHoldout.getText()), (int)0);
            this.m_txtHoldout.requestFocus();
            return false;
        }
        try {
            this.m_txtHoldoutPct.getValue();
        }
        catch (WADecimalTextField.IllegalDecimalException exc) {
            MessageUtil.displayMessage((String)bundle.formatString("Common.Decimal.Error.txt", (Object)this.m_txtHoldoutPct.getText()), (int)0);
            this.m_txtHoldoutPct.requestFocus();
            return false;
        }
        if (this.m_txtAlpha.getText().length() > 0) {
            try {
                double alpha = this.m_txtAlpha.getValue();
                if (alpha < 0.0 || alpha > 1.0) {
                    MessageUtil.displayMessage((String)bundle.getString("ForecastPropertyTab.Alpha.Error.txt"), (int)0);
                    this.m_txtAlpha.requestFocus();
                    return false;
                }
            }
            catch (WADecimalTextField.IllegalDecimalException exc) {
                MessageUtil.displayMessage((String)bundle.formatString("Common.Decimal.Error.txt", (Object)this.m_txtAlpha.getText()), (int)0);
                this.m_txtAlpha.requestFocus();
                return false;
            }
        }
        if (intermittent <= 1.0) {
            MessageUtil.displayMessage((String)bundle.getString("ForecastPropertyTab.Intermittent.Error.txt"), (int)0);
            this.m_txtIntermittent.requestFocus();
            return false;
        }
        if (this.m_transformList.getSelectedValue().indexOf("BOXCOX") > -1) {
            int transform;
            String boxValue = this.m_transformList.getSelectedValue();
            if (boxValue.length() > 6 && boxValue.charAt(6) == '(' && boxValue.indexOf(")") > 6) {
                boxValue = boxValue.substring(7, boxValue.indexOf(")"));
                try {
                    transform = Integer.parseInt(boxValue);
                }
                catch (NumberFormatException exc) {
                    transform = -999;
                }
            } else {
                transform = -999;
            }
            if (transform < -5 || transform > 5) {
                MessageUtil.displayMessage((String)bundle.getString("ForecastPropertyTab.Transform.BoxCox.Error.txt"), (int)0);
                this.m_cmbTransform.requestFocus();
                return false;
            }
        } else if (this.m_cmbTransform.isEnabled() && !this.m_transformList.getValueList().contains(this.m_transformList.getSelectedValue())) {
            MessageUtil.displayMessage((String)bundle.getString("ForecastPropertyTab.Transform.Error.txt"), (int)0);
            this.m_cmbTransform.requestFocus();
            return false;
        }
        return true;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_dlsForecastVars.setEnabled(editable);
        this.m_txtAlpha.setEnabled(editable);
        this.m_cmbUse.setEnabled(editable);
        this.m_chkReplace.setEnabled(editable);
        this.m_cmbModel.setEnabled(editable);
        this.m_cmbModelSelect.setEnabled(editable);
        this.m_txtHoldout.setEnabled(editable);
        this.m_txtHoldoutPct.setEnabled(editable);
        this.m_txtIntermittent.setEnabled(editable);
        this.m_cmbTransform.setEnabled(editable);
        this.m_chkMedian.setEnabled(editable);
        this.m_butReset.setEnabled(editable);
        this.m_resetDefaultsAction.setEnabled(editable);
    }

    private void setHoldoutPctEnabled() {
        if (this.m_txtHoldout.getText().length() == 0 || this.m_txtHoldout.getValue() == 0) {
            this.m_txtHoldoutPct.setEnabled(false);
        } else {
            this.m_txtHoldoutPct.setEnabled(this.isEditable());
        }
    }

    private void setModelComponentsEnabled() {
        String modelSelection = this.m_modelList.getSelectedValue();
        this.m_txtIntermittent.setEnabled(modelSelection.equals("BESTALL") && this.isEditable());
        this.m_cmbTransform.setEnabled(!modelSelection.equals("IDM") && this.isEditable());
    }

    private void resetToDefaultValues() {
        this.m_hpf.getModel().startCompoundUndoable();
        try {
            this.m_hpf.setAlpha(0.05);
            this.m_hpf.setUse("PREDICT");
            this.m_hpf.setReplaceMissing(false);
            this.m_hpf.setModelOption("BEST");
            this.m_hpf.setModelSelection("RMSE");
            this.m_hpf.setHoldout(0);
            this.m_hpf.setHoldoutPercent(100.0);
            this.m_hpf.setIntermittent(1.25);
            this.m_hpf.setTransform("NONE");
            this.m_hpf.setEstimateMedian(false);
            for (int i = this.m_lstSelectedForecastVars.size(); i > 0; --i) {
                IColumn oColumn = (IColumn)this.m_lstSelectedForecastVars.getElementAt(i - 1);
                this.m_hpf.getForecastColumns().remove(oColumn);
            }
        }
        finally {
            this.m_hpf.getModel().endCompoundUndoable();
        }
        this.m_dlsForecastVars.transferToSourceModel(this.m_arrSelectedNumericColumns.toArray());
    }

    public void saveSettingsAndCleanUp() {
        this.m_hpf.getModel().removeModelListener(this.m_lsnrModel);
        this.m_txtAlpha.removeFocusListener(this.m_lsnrFocus);
        this.m_txtHoldout.removeFocusListener(this.m_lsnrFocus);
        this.m_txtHoldoutPct.removeFocusListener(this.m_lsnrFocus);
        this.m_txtIntermittent.removeFocusListener(this.m_lsnrFocus);
        this.m_chkMedian.removeActionListener((ActionListener)this.m_actMedian);
        this.m_chkReplace.removeActionListener((ActionListener)this.m_actReplaceMissing);
        this.m_cmbTransform.removeActionListener((ActionListener)this.m_actTransform);
        this.m_cmbModel.removeActionListener((ActionListener)this.m_actModel);
        this.m_cmbModelSelect.removeActionListener((ActionListener)this.m_actModelSelect);
        this.m_cmbUse.removeActionListener((ActionListener)this.m_actUse);
        this.m_lstAvailForecastVars.removeListDataListener(this.m_lsnrDual);
        this.m_lstSelectedForecastVars.removeListDataListener(this.m_lsnrDual);
        super.saveSettingsAndCleanUp();
    }

    protected class cReplaceMissingCheckBoxAction
    extends WsAbstractToggleAction {
        public cReplaceMissingCheckBoxAction() {
            super(bundle, "ForecastPropertyTab.ReplaceMissing", 0);
        }

        public void actionPerformed(ActionEvent event) {
            ForecastPropertyTab.this.m_hpf.setReplaceMissing(ForecastPropertyTab.this.m_chkReplace.isSelected());
        }
    }

    protected class cMedianCheckBoxAction
    extends WsAbstractToggleAction {
        public cMedianCheckBoxAction() {
            super(bundle, "ForecastPropertyTab.Median", 0);
        }

        public void actionPerformed(ActionEvent event) {
            ForecastPropertyTab.this.m_hpf.setEstimateMedian(ForecastPropertyTab.this.m_chkMedian.isSelected());
        }
    }

    protected class cTransformComboBoxAction
    extends WsAbstractAction {
        protected cTransformComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!ForecastPropertyTab.this.isListeningForChanges()) {
                return;
            }
            try {
                ForecastPropertyTab.this.m_hpf.setTransform(ForecastPropertyTab.this.m_transformList.getSelectedValue());
            }
            catch (IllegalArgumentException iae) {
                MessageUtil.displayMessage((String)iae.getLocalizedMessage(), (int)0);
                ForecastPropertyTab.this.m_transformList.setSelectedItem(ForecastPropertyTab.this.m_hpf.getTransform());
                ForecastPropertyTab.this.m_cmbTransform.requestFocus();
            }
        }
    }

    protected class cModelSelectComboBoxAction
    extends WsAbstractAction {
        protected cModelSelectComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!ForecastPropertyTab.this.isListeningForChanges()) {
                return;
            }
            ForecastPropertyTab.this.m_hpf.setModelSelection(ForecastPropertyTab.this.m_selectList.getSelectedValue());
        }
    }

    protected class cModelComboBoxAction
    extends WsAbstractAction {
        protected cModelComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!ForecastPropertyTab.this.isListeningForChanges()) {
                return;
            }
            ForecastPropertyTab.this.m_hpf.setModelOption(ForecastPropertyTab.this.m_modelList.getSelectedValue());
        }
    }

    protected class cUseComboBoxAction
    extends WsAbstractAction {
        protected cUseComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!ForecastPropertyTab.this.isListeningForChanges()) {
                return;
            }
            ForecastPropertyTab.this.m_hpf.setUse(ForecastPropertyTab.this.m_useList.getSelectedValue());
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType.compareToIgnoreCase("HPFTransform:ReplaceMissingChanged") == 0) {
                ForecastPropertyTab.this.m_chkReplace.setSelected(ForecastPropertyTab.this.m_hpf.isReplaceMissing());
            } else if (sType.compareToIgnoreCase("HPFTransform:EstimateMedianChanged") == 0) {
                ForecastPropertyTab.this.m_chkMedian.setSelected(ForecastPropertyTab.this.m_hpf.isEstimateMedian());
            } else if (sType.compareToIgnoreCase("HPFTransform:UseChanged") == 0) {
                ForecastPropertyTab.this.m_useList.setSelectedValue(ForecastPropertyTab.this.m_hpf.getUse());
            } else if (sType.compareToIgnoreCase("HPFTransform:ModelOptionChanged") == 0) {
                ForecastPropertyTab.this.m_modelList.setSelectedValue(ForecastPropertyTab.this.m_hpf.getModelOption());
            } else if (sType.compareToIgnoreCase("HPFTransform:ModelSelectionChanged") == 0) {
                ForecastPropertyTab.this.m_selectList.setSelectedValue(ForecastPropertyTab.this.m_hpf.getModelSelection());
            } else if (sType.compareToIgnoreCase("HPFTransform:TransformChanged") == 0) {
                ForecastPropertyTab.this.m_transformList.setSelectedValue(ForecastPropertyTab.this.m_hpf.getTransform());
            } else if (sType.compareToIgnoreCase("HPFTransform:AlphaChanged") == 0) {
                ForecastPropertyTab.this.m_txtAlpha.setText(NumberFormat.getInstance().format(ForecastPropertyTab.this.m_hpf.getAlpha()));
            } else if (sType.compareToIgnoreCase("HPFTransform:HoldoutChanged") == 0) {
                ForecastPropertyTab.this.m_txtHoldout.setText(Integer.toString(ForecastPropertyTab.this.m_hpf.getHoldout()));
            } else if (sType.compareToIgnoreCase("HPFTransform:HoldoutPercentChanged") == 0) {
                ForecastPropertyTab.this.m_txtHoldoutPct.setValue(ForecastPropertyTab.this.m_hpf.getHoldoutPercent());
            } else if (sType.compareToIgnoreCase("HPFTransform:IntermittentChanged") == 0) {
                ForecastPropertyTab.this.m_txtIntermittent.setValue(ForecastPropertyTab.this.m_hpf.getIntermittent());
            } else if (sType.compareToIgnoreCase("HPFTransform:ForecastColumnAdded") == 0) {
                if (ForecastPropertyTab.this.m_bEditHappening) {
                    return;
                }
                IColumn col = (IColumn)ev.getData();
                ForecastPropertyTab.this.m_dlsForecastVars.transferToTargetModel((Object[])new IColumn[]{col});
            } else if (sType.compareToIgnoreCase("HPFTransform:ForecastColumnRemoved") == 0) {
                if (ForecastPropertyTab.this.m_bEditHappening) {
                    return;
                }
                IColumn col = (IColumn)ev.getData();
                ForecastPropertyTab.this.m_dlsForecastVars.transferToSourceModel((Object[])new IColumn[]{col});
            }
        }
    }

    private class cFocusListener
    implements FocusListener {
        private cFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            try {
                if (arg0.getComponent() == ForecastPropertyTab.this.m_txtAlpha) {
                    ForecastPropertyTab.this.m_hpf.setAlpha(ForecastPropertyTab.this.m_txtAlpha.getValue());
                } else if (arg0.getComponent() == ForecastPropertyTab.this.m_txtHoldout) {
                    ForecastPropertyTab.this.m_hpf.setHoldout(ForecastPropertyTab.this.m_txtHoldout.getValue2());
                } else if (arg0.getComponent() == ForecastPropertyTab.this.m_txtHoldoutPct) {
                    ForecastPropertyTab.this.m_hpf.setHoldoutPercent(ForecastPropertyTab.this.m_txtHoldoutPct.getValue());
                } else if (arg0.getComponent() == ForecastPropertyTab.this.m_txtIntermittent) {
                    ForecastPropertyTab.this.m_hpf.setIntermittent(ForecastPropertyTab.this.m_txtIntermittent.getValue());
                }
            }
            catch (WADecimalTextField.IllegalDecimalException illegalDecimalException) {
            }
            catch (WAIntTextField.IllegalIntegerException illegalIntegerException) {
                // empty catch block
            }
        }
    }

    public class cListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int iRow, boolean bSelected, boolean bHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, iRow, bSelected, bHasFocus);
            if (value instanceof IColumn) {
                IColumn oColumn = (IColumn)value;
                this.setText(oColumn.getName());
            }
            return this;
        }
    }

    private class cResetDefaultsAction
    extends WsAbstractAction {
        public cResetDefaultsAction() {
            super(bundle, "PropertyTab.Reset");
        }

        public void actionPerformed(ActionEvent event) {
            ForecastPropertyTab.this.resetToDefaultValues();
        }
    }

    private class DualListener
    implements ListDataListener {
        private DualListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ForecastPropertyTab.this.setDataChanged(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void intervalAdded(ListDataEvent e) {
            ForecastPropertyTab.this.setDataChanged(true);
            ForecastPropertyTab.this.m_hpf.getModel().startCompoundUndoable();
            try {
                ForecastPropertyTab.this.m_bEditHappening = true;
                if (ForecastPropertyTab.this.m_lstSelectedForecastVars == e.getSource()) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        IColumn oColumn = (IColumn)ForecastPropertyTab.this.m_lstSelectedForecastVars.getElementAt(i);
                        if (ForecastPropertyTab.this.m_hpf.getForecastColumns().contains(oColumn)) continue;
                        ForecastPropertyTab.this.m_hpf.getForecastColumns().add(oColumn);
                    }
                } else if (ForecastPropertyTab.this.m_lstAvailForecastVars == e.getSource()) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        IColumn oColumn = (IColumn)ForecastPropertyTab.this.m_lstAvailForecastVars.getElementAt(i);
                        ForecastPropertyTab.this.m_hpf.getForecastColumns().remove(oColumn);
                    }
                }
            }
            finally {
                ForecastPropertyTab.this.m_bEditHappening = false;
                ForecastPropertyTab.this.m_hpf.getModel().endCompoundUndoable();
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private class cHoldoutListener
    implements DocumentListener {
        private cHoldoutListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ForecastPropertyTab.this.setHoldoutPctEnabled();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ForecastPropertyTab.this.setHoldoutPctEnabled();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class cModelActionListener
    implements ActionListener {
        private cModelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ForecastPropertyTab.this.setModelComponentsEnabled();
        }
    }
}

