/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hadoop.util;

import com.sas.etl.models.other.IHadoopServer;
import com.sas.wadmin.transforms.hadoop.util.LaunchDFSAction;
import com.sas.wadmin.transforms.hadoop.util.LaunchDFSSecondaryAction;
import com.sas.wadmin.transforms.hadoop.util.LaunchJobTrackerAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class ActionFactory {
    private static ActionFactory s_instance;

    private ActionFactory() {
    }

    public static ActionFactory getInstance() {
        if (s_instance == null) {
            s_instance = new ActionFactory();
        }
        return s_instance;
    }

    public Action[] createHadoopServerActions(IHadoopServer server) {
        boolean bEditable = server != null;
        Action[] aActions = new Action[]{new LaunchJobTrackerAction(server), new LaunchDFSAction(server), new LaunchDFSSecondaryAction(server)};
        if (!bEditable) {
            this.disableActions(aActions);
        }
        return aActions;
    }

    public static void addActionsToMenu(JMenu menu, Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) {
                menu.addSeparator();
                continue;
            }
            if (aActions[iAction] instanceof WsAbstractToggleAction) {
                menu.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)((WsAbstractToggleAction)aActions[iAction])));
                continue;
            }
            menu.add(aActions[iAction]);
        }
    }

    public static void addActionsToPopupMenu(JPopupMenu menuPopup, Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) {
                menuPopup.addSeparator();
                continue;
            }
            if (aActions[iAction] instanceof WsAbstractToggleAction) {
                menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)((WsAbstractToggleAction)aActions[iAction])));
                continue;
            }
            menuPopup.add(aActions[iAction]);
        }
    }

    private void disableActions(Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) continue;
            aActions[iAction].setEnabled(false);
        }
    }
}

