/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.fork;

import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.wadmin.transforms.fork.ForkPropertyHandler;
import com.sas.wadmin.transforms.fork.ForkUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ParameterColumnsTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ParameterColumnsTableModel.class);
    private List m_lstParameters = new ArrayList();
    private ClassifierMap m_classifierMap;
    private List m_lstInnerSteps;
    private static final int VISIBLE_COLUMN_COUNT = 4;
    private static final int HIDDEN_COLUMN_COUNT = 2;
    public static final int PARAMETERNAME_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int DESCR_COLUMN = 2;
    public static final int DEFAULTVALUE_COLUMN = 3;
    public static final int PROPERTY_COLUMN = 4;
    public static final int ATTRIBUTE_COLUMN = 5;
    private static final int NAME_COLUMN_WIDTH = 100;
    private static final int DESCR_COLUMN_WIDTH = 150;
    private static final int DEFAULTVALUE_COLUMN_WIDTH = 100;

    public ParameterColumnsTableModel(ClassifierMap classifierMap) {
        this.m_classifierMap = classifierMap;
        this.m_lstInnerSteps = new ArrayList();
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("ParameterColumnsTableModel.ParameterName.Column.txt"), 100);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ParameterColumnsTableModel.Name.Column.txt"), 100);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("ParameterColumnsTableModel.Descr.Column.txt"), 150, 200);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("ParameterColumnsTableModel.DefaultValue.Column.txt"), 100);
        this.m_aColumns[4] = new WsMetadataTableColumn();
        this.m_aColumns[5] = new WsMetadataTableColumn();
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3].setEditable(false);
    }

    public void setInnerSteps(List steps) {
        this.m_lstInnerSteps.clear();
        this.m_lstInnerSteps.addAll(steps);
    }

    public void clearParameters() {
        this.m_lstParameters.clear();
    }

    public int getColumnCount() {
        return 4;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        ForkPropertyHandler propertyHandler = new ForkPropertyHandler((Root)this.m_classifierMap, "PARAMETERPROPERTYSET", true);
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        this.m_lstParameters.clear();
        if (this.m_lstInnerSteps != null && !this.m_lstInnerSteps.isEmpty()) {
            this.m_lstParameters = ForkUtil.getStepsParameters(this.m_lstInnerSteps);
            for (int k = 0; k < this.m_lstParameters.size(); ++k) {
                ArrayList<String> attrRow = new ArrayList<String>();
                PromptDefinitionInterface param = (PromptDefinitionInterface)this.m_lstParameters.get(k);
                attrRow.add(param.getPromptLabel(Locale.getDefault()));
                attrRow.add(param.getPromptName());
                attrRow.add(param.getPromptDescription(Locale.getDefault()));
                Object defaultValue = "";
                if (param.isDefaultValueSet()) {
                    defaultValue = param.getDefaultValue();
                }
                attrRow.add((String)defaultValue);
                attrRow.add((String)propertyHandler.getSpecificProperty("OPTION." + param.getPromptName()));
                attrRow.add((String)param);
                this.m_lData.add(attrRow);
            }
            nRows = this.m_lData.size();
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }
}

