/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.fork;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.wadmin.transforms.fork.ForkColumns;
import com.sas.wadmin.transforms.fork.ForkEnd;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ForkUtil {
    public static void createTargetColumn(ClassifierMap cMap, DataTable oTable, String columnName, String columnType, int columnIndex, String desc) throws MdException, RemoteException {
        if (oTable != null) {
            Column cColumn2 = (Column)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)cMap.getObjectStore(), columnName, "Column", cMap.getRepositoryID());
            cColumn2.setColumnName(columnName);
            cColumn2.setSASColumnName(columnName);
            cColumn2.setIsNullable(1);
            cColumn2.setDesc(desc);
            cColumn2.setPublicType("Column");
            cColumn2.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            cColumn2.setSASColumnType(columnType);
            if (WsColumnMetadataUtil.isColumnTypeNumeric((Column)cColumn2)) {
                cColumn2.setColumnLength(8);
                cColumn2.setSASColumnLength(8);
            } else {
                cColumn2.setColumnLength(32);
                cColumn2.setSASColumnLength(32);
            }
            oTable.getColumns().insertElementAt((Object)cColumn2, columnIndex);
        }
    }

    public static boolean isForkGeneratedColumn(Column column) throws MdException, RemoteException {
        if (column != null) {
            ForkColumns forkColumns = new ForkColumns();
            return forkColumns.isForkColumn(column.getSASColumnName());
        }
        return false;
    }

    public static boolean updateTargetTableColumns(ClassifierMap cMap) throws MdException, RemoteException {
        boolean changeMade = false;
        DataTable oTable = null;
        if (!cMap.getClassifierTargets().isEmpty()) {
            oTable = (DataTable)cMap.getClassifierTargets().get(0);
        }
        if (oTable != null) {
            ForkColumns forkColumns = new ForkColumns();
            DataTable sTable = null;
            if (!cMap.getClassifierSources().isEmpty()) {
                sTable = (DataTable)cMap.getClassifierSources().get(0);
            }
            Object sColumns = null;
            sColumns = sTable != null ? sTable.getColumns() : new ArrayList();
            AssociationList extColumns = oTable.getColumns();
            ArrayList<Column> columnsToDelete = new ArrayList<Column>();
            for (int i = 0; i < extColumns.size(); ++i) {
                Column extCol = (Column)extColumns.get(i);
                if (forkColumns.isForkColumn(extCol.getSASColumnName()) || ForkUtil.getSASNamedColumn((List)sColumns, extCol.getSASColumnName()) != null) continue;
                columnsToDelete.add(extCol);
                changeMade = true;
            }
            ((MdObjectStore)cMap.getObjectStore()).removeObjectsFromStore(columnsToDelete);
            if (forkColumns.createMissingColumns(cMap, oTable)) {
                changeMade = true;
            }
        }
        return changeMade;
    }

    public static Column getSASNamedColumn(List colList, String columnName) {
        try {
            if (colList != null && columnName.length() > 0) {
                for (int i = 0; i < colList.size(); ++i) {
                    Column tempCol = (Column)colList.get(i);
                    if (!tempCol.getSASColumnName().equals(columnName)) continue;
                    return tempCol;
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public static List getStepsParameters(List steps) throws MdException, RemoteException {
        ArrayList parameters = new ArrayList();
        if (steps != null && !steps.isEmpty()) {
            for (int i = 0; i < steps.size(); ++i) {
                ParametersModel paramModel = new ParametersModel((Root)steps.get(i));
                parameters.addAll(paramModel.getParameterDefinitions());
            }
        }
        return parameters;
    }

    public static boolean getNextSteps(TransformationStep step, List nextSteps) throws MdException, RemoteException {
        boolean forkEndFound = false;
        if (step.getPredecessorDependencies().size() > 0) {
            for (int i = 0; i < step.getPredecessorDependencies().size(); ++i) {
                StepPrecedence sp = (StepPrecedence)step.getPredecessorDependencies().get(i);
                for (int j = 0; j < sp.getSuccessors().size(); ++j) {
                    TransformationStep nextStep = (TransformationStep)sp.getSuccessors().get(j);
                    if (nextStep.getTransformRole().equals(ForkEnd.TRANSFORM_ROLE_VALUE)) {
                        forkEndFound = true;
                        continue;
                    }
                    nextSteps.add(nextStep);
                    forkEndFound = ForkUtil.getNextSteps(nextStep, nextSteps);
                }
            }
        }
        return forkEndFound;
    }
}

