/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.fork;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.fork.impl.ForkTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.ParallelOptionsPanel;
import com.sas.wadmin.visuals.SASParallelMaximumConcurrentProcessesPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;

public class ForkOptionsPropertyTab2
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ForkOptionsPropertyTab2.class);
    private ForkTransformModel m_transformModel;
    protected ParallelOptionsPanel m_pnlForkOptions;
    private PropertyChangeListener m_lstnPanel;
    private IModelListener m_lstnModel;

    public ForkOptionsPropertyTab2(ForkTransformModel model) {
        this.m_transformModel = model;
        this.setName(bundle.getString("ForkOptionsPropertyTab.Title.txt"));
        this.setHelpTopic("options_fork_options_tab");
        this.createListeners();
        this.initialize();
    }

    protected void initialize() {
        this.m_pnlForkOptions = new ParallelOptionsPanel(this.m_transformModel.getExecutionServer(), this.getHelpTopic());
        this.m_pnlForkOptions.addPropertyChangeListener(this.m_lstnPanel);
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_pnlForkOptions), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createListeners() {
        this.m_lstnPanel = new cPanelListener();
        this.m_lstnModel = new ModelListener();
        this.m_transformModel.getModel().addModelListener(this.m_lstnModel);
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_pnlForkOptions.moveDataToView();
        this.m_pnlForkOptions.setServer(this.m_transformModel.getExecutionServer());
        this.m_pnlForkOptions.setExecuteParallel(this.m_transformModel.isExecuteInParallel());
        this.m_pnlForkOptions.setLogOutputLocation(this.m_transformModel.getLocationOfLogAndOutputDirectory());
        this.m_pnlForkOptions.setApplication(this.m_transformModel.getApplication());
        this.m_pnlForkOptions.setWorkload(this.m_transformModel.getWorkload());
        this.m_pnlForkOptions.setWaitForWhenComplete(this.m_transformModel.isWaitForProcessesToCompleteToContinue());
        this.m_pnlForkOptions.setMaximumConcurrentSetting(this.m_transformModel.getMaximumConcurrentProcessesSetting());
        this.m_pnlForkOptions.setAdditionalSignonOptions(this.m_transformModel.getSignonOptions());
        this.m_pnlForkOptions.setSignonRetries(this.m_transformModel.getNumberOfSignonRetries());
        String PropTab2String = this.m_transformModel.getGridSuppJobOptions();
        this.m_pnlForkOptions.setGridSuppJobOptions(this.m_transformModel.getGridSuppJobOptions());
        this.m_pnlForkOptions.setUnknownStatusAsError(this.m_transformModel.isErrorOnUnknownStatus());
        this.setEditable(this.isEditable());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_transformModel.setLocationOfLogAndOutputDirectory(this.m_pnlForkOptions.getLogOutputLocation());
        this.m_transformModel.setMaximumConcurrentProcessesSetting(this.m_pnlForkOptions.getMaximumConcurrentSetting());
        this.m_transformModel.setSignonOptions(this.m_pnlForkOptions.getAdditionalSignonOptions());
        this.m_transformModel.setNumberOfSignonRetries(this.m_pnlForkOptions.getSignonRetries());
        this.m_transformModel.setGridSuppJobOptions(this.m_pnlForkOptions.getGridSuppJobOptions());
        this.setListeningForChanges(true);
    }

    public boolean validateData() {
        return this.m_pnlForkOptions.validateData();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_pnlForkOptions.setEditable(editable);
        this.m_pnlForkOptions.setExecuteParallelAndDisableChange();
    }

    public void saveSettingsAndCleanUp() {
        this.m_transformModel.getModel().removeModelListener(this.m_lstnModel);
        this.m_pnlForkOptions.removePropertyChangeListener(this.m_lstnPanel);
        super.saveSettingsAndCleanUp();
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (ev.getModelObject() == ForkOptionsPropertyTab2.this.m_transformModel) {
                String type = ev.getType();
                if ("ITransform:ExecutionServerChanged".equals(type)) {
                    ForkOptionsPropertyTab2.this.m_pnlForkOptions.setServer(ForkOptionsPropertyTab2.this.m_transformModel.getExecutionServer());
                } else if ("ForkTransformModel:ExecuteinParallelChanged".equals(type)) {
                    ForkOptionsPropertyTab2.this.m_pnlForkOptions.setExecuteParallel(ForkOptionsPropertyTab2.this.m_transformModel.isExecuteInParallel());
                } else if ("ForkTransformModel:ApplicationChanged".equals(type)) {
                    ForkOptionsPropertyTab2.this.m_pnlForkOptions.setApplication(ForkOptionsPropertyTab2.this.m_transformModel.getApplication());
                } else if ("ForkTransformModel:WorkloadChanged".equals(type)) {
                    ForkOptionsPropertyTab2.this.m_pnlForkOptions.setWorkload(ForkOptionsPropertyTab2.this.m_transformModel.getWorkload());
                } else if ("ForkTransformModel:WaitForProcessesChanged".equals(type)) {
                    ForkOptionsPropertyTab2.this.m_pnlForkOptions.setWaitForWhenComplete(ForkOptionsPropertyTab2.this.m_transformModel.isWaitForProcessesToCompleteToContinue());
                } else if ("ForkTransformModel:ConcurrentProcessesChanged".equals(ev.getType())) {
                    ForkOptionsPropertyTab2.this.m_pnlForkOptions.setMaximumConcurrentSetting(ForkOptionsPropertyTab2.this.m_transformModel.getMaximumConcurrentProcessesSetting());
                } else if ("ForkTransformModel:ErrorOnUnknownStatusChanged".equals(type)) {
                    ForkOptionsPropertyTab2.this.m_pnlForkOptions.setUnknownStatusAsError(ForkOptionsPropertyTab2.this.m_transformModel.isErrorOnUnknownStatus());
                } else if ("ForkTransformModel:LogAndOutputLocationChanged".equals(type)) {
                    ForkOptionsPropertyTab2.this.m_pnlForkOptions.setLogOutputLocation(ForkOptionsPropertyTab2.this.m_transformModel.getLocationOfLogAndOutputDirectory());
                }
            }
        }
    }

    private class cPanelListener
    implements PropertyChangeListener {
        private cPanelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!ForkOptionsPropertyTab2.this.isListeningForChanges()) {
                return;
            }
            if (ParallelOptionsPanel.EXECUTE_PARALLEL_CHANGED.equals(ev.getPropertyName())) {
                ForkOptionsPropertyTab2.this.m_transformModel.setExecuteInParallel(((Boolean)ev.getNewValue()).booleanValue());
            } else if (ParallelOptionsPanel.APPLICATION_CHANGED.equals(ev.getPropertyName())) {
                String application = (String)ev.getNewValue();
                if (application == null || ParallelOptionsPanel.NONE.equals(application) || ParallelOptionsPanel.SELECT.equals(application)) {
                    application = "";
                }
                ForkOptionsPropertyTab2.this.m_transformModel.setApplication(application);
            } else if (ParallelOptionsPanel.WORKLOAD_CHANGED.equals(ev.getPropertyName())) {
                String workload = (String)ev.getNewValue();
                if (workload == null || ParallelOptionsPanel.NONE.equals(workload)) {
                    workload = "";
                }
                ForkOptionsPropertyTab2.this.m_transformModel.setWorkload(workload);
            } else if (ParallelOptionsPanel.WAIT_FOR_CHANGED.equals(ev.getPropertyName())) {
                ForkOptionsPropertyTab2.this.m_transformModel.setWaitForProcessesToCompleteToContinue(((Boolean)ev.getNewValue()).booleanValue());
            } else if (SASParallelMaximumConcurrentProcessesPanel.MAX_CONCURRENT_CHANGED.equals(ev.getPropertyName())) {
                ForkOptionsPropertyTab2.this.m_transformModel.setMaximumConcurrentProcessesSetting((String)ev.getNewValue());
            } else if (ParallelOptionsPanel.UNKNOWN_STATUS_IS_ERROR_CHANGED.equals(ev.getPropertyName())) {
                ForkOptionsPropertyTab2.this.m_transformModel.setErrorOnUnknownStatus(((Boolean)ev.getNewValue()).booleanValue());
            }
        }
    }
}

