/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.fork;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.transforms.fork.impl.ForkTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.wadmin.visuals.common.TargetColumnsTableModel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.undo.UndoManager;

public class ForkColumnsPropertyTab2
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ForkColumnsPropertyTab2.class);
    private ForkTransformModel m_transformModel;
    private JLabel m_lblGeneratedColumns;
    private WsTable m_tblTarget;
    private TargetColumnsTableModel m_mdlTarget;
    private JScrollPane m_scrTarget;
    private JPanel m_panAdditionalColumns;
    private TitledBorder m_titledBorder;
    private DualListSelector m_dlsSelectColumns;
    private CollectionToListModelAdapter m_adpAvailableColumns;
    private CollectionToListModelAdapter m_adpSelectedColumns;
    private static final String TARGET_SETTINGS_KEY = "ForkColumnsPropertyTab.TargetTable";
    private static final int MIN_TABLE_WIDTH = 100;
    private static final int PREF_TABLE_WIDTH = 200;
    private static final int ROW_HEIGHT = 18;
    private IModelListener m_lstModel;

    public ForkColumnsPropertyTab2(ForkTransformModel model) {
        this.m_transformModel = model;
        this.setName(bundle.getString("ForkColumnsPropertyTab.Title.txt"));
        this.setHelpTopic("fork_target_cols_tab");
        this.createListener();
        this.initialize();
    }

    protected void createListener() {
        this.m_lstModel = new ModelListener();
        this.m_transformModel.getModel().addModelListener(this.m_lstModel);
    }

    protected void initialize() {
        this.m_mdlTarget = new ForkTargetColumnsTableModel((IMappingsContainer)this.m_transformModel);
        this.m_mdlTarget.getColumn(2).setWidth(185);
        this.m_mdlTarget.getColumn(3).setWidth(350);
        this.m_tblTarget = new WsTable((WsAbstractTableModel)this.m_mdlTarget);
        this.m_lblGeneratedColumns = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_tblTarget, (WAdminResource)bundle, (String)"ForkColumnsPropertyTab.GeneratedColumns");
        this.m_tblTarget.setName("TargetTable");
        this.m_tblTarget.setRowsReorderable(false);
        this.m_tblTarget.restoreSettings(TARGET_SETTINGS_KEY);
        this.m_scrTarget = new JScrollPane((Component)this.m_tblTarget);
        this.m_scrTarget.setMinimumSize(new Dimension(100, (this.m_transformModel.getNumberofForkColumns() + 1) * 18));
        this.m_scrTarget.setPreferredSize(new Dimension(200, (this.m_transformModel.getNumberofForkColumns() + 1) * 18));
        this.removeColumn(this.m_tblTarget, 4);
        this.removeColumn(this.m_tblTarget, 0);
        this.removeColumn(this.m_tblTarget, 6);
        this.removeColumn(this.m_tblTarget, 5);
        this.m_tblTarget.setMultipleSelectionDragEnabled(true);
        this.m_tblTarget.setUndoManager((UndoManager)this.waum);
        this.m_dlsSelectColumns = new DualListSelector();
        this.m_adpAvailableColumns = new CollectionToListModelAdapter();
        this.m_adpSelectedColumns = new CollectionToListModelAdapter();
        this.m_adpSelectedColumns.addListDataListener((ListDataListener)new TargetDualListener());
        this.m_dlsSelectColumns.setSourceLabel(bundle.getString("ForkColumnsPropertyTab.AvailableColumns.txt"));
        this.m_dlsSelectColumns.getSourceComponent().setToolTipText(bundle.getString("ForkColumnsPropertyTab.AvailableColumns.ToolTip.txt"));
        ((JLabel)this.m_dlsSelectColumns.getSourceLabelComponent()).setDisplayedMnemonic(bundle.getString("ForkColumnsPropertyTab.AvailableColumns.mnem").charAt(0));
        this.m_dlsSelectColumns.setTargetLabel(bundle.getString("ForkColumnsPropertyTab.SelectedColumns.txt"));
        this.m_dlsSelectColumns.getTargetComponent().setToolTipText(bundle.getString("ForkColumnsPropertyTab.SelectedColumns.ToolTip.txt"));
        ((JLabel)this.m_dlsSelectColumns.getTargetLabelComponent()).setDisplayedMnemonic(bundle.getString("ForkColumnsPropertyTab.SelectedColumns.mnem").charAt(0));
        this.m_panAdditionalColumns = new JPanel();
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)bundle.getString("ForkColumnsPropertyTab.AdditionalColumns.title.txt"));
        this.m_panAdditionalColumns.setBorder(this.m_titledBorder);
        this.m_panAdditionalColumns.setLayout(new GridBagLayout());
        this.m_panAdditionalColumns.add((Component)this.m_dlsSelectColumns, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_dlsSelectColumns.setModel((ListModel)this.m_adpAvailableColumns);
        this.m_dlsSelectColumns.setTargetModel((ListModel)this.m_adpSelectedColumns);
        ColumnsTableNameCellRenderer rdrColumnName = new ColumnsTableNameCellRenderer();
        rdrColumnName.setTypeColumnIndex(7);
        int iColumnName = this.m_tblTarget.convertColumnIndexToView(2);
        if (iColumnName != -1) {
            TableColumn colColumnName = this.m_tblTarget.getColumnModel().getColumn(iColumnName);
            colColumnName.setCellRenderer((TableCellRenderer)((Object)rdrColumnName));
        }
        this.m_dlsSelectColumns.setTargetCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_dlsSelectColumns.setSourceCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblGeneratedColumns, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_scrTarget, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_panAdditionalColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
    }

    protected void removeColumn(WsTable tbl, int iModelColumn) {
        int iViewColumn = tbl.convertColumnIndexToView(iModelColumn);
        if (iViewColumn != -1) {
            tbl.removeColumn(tbl.getColumnModel().getColumn(iViewColumn));
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlTarget.moveDataToModel();
        for (int i = this.m_mdlTarget.getRowCount() - 1; i >= 0; --i) {
            if (this.m_transformModel.isForkColumn(this.m_mdlTarget.getTargetColumn(i))) continue;
            this.m_mdlTarget.deleteRow(i);
        }
        ArrayList<IColumn> selectedColumns = new ArrayList<IColumn>();
        ArrayList<IColumn> availColumns = new ArrayList<IColumn>();
        ITable[] tables = this.m_transformModel.getSourceTables();
        if (tables.length > 0) {
            availColumns.addAll(Arrays.asList(tables[0].getColumns()));
        }
        IMapping[] mappings = this.m_transformModel.getMappings();
        for (int i = 0; i < mappings.length; ++i) {
            if (!"ONETOONE".equals(mappings[i].getType())) continue;
            selectedColumns.add(mappings[i].getSources()[0]);
        }
        availColumns.removeAll(selectedColumns);
        this.m_adpAvailableColumns.setModel(availColumns);
        this.m_adpSelectedColumns.setModel(selectedColumns);
        this.setEditable(this.isEditable());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblTarget.saveSettings(TARGET_SETTINGS_KEY);
        this.m_transformModel.getModel().removeModelListener(this.m_lstModel);
        super.saveSettingsAndCleanUp();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_dlsSelectColumns.setEnabled(editable);
        for (int i = 0; i < this.m_mdlTarget.getColumnCount(); ++i) {
            block4: {
                block3: {
                    if (i == 10) break block3;
                    if (i == 9) break block3;
                    if (i != 3) break block4;
                }
                this.m_mdlTarget.getColumn(i).setEditable(editable);
                continue;
            }
            this.m_mdlTarget.getColumn(i).setEditable(false);
        }
    }

    protected List getMappedSourceColumns() {
        ArrayList<IColumn> mapped = new ArrayList<IColumn>();
        IMapping[] mappings = this.m_transformModel.getMappings();
        for (int i = 0; i < mappings.length; ++i) {
            IColumn[] sources;
            if (!"ONETOONE".equals(mappings[i].getType()) || (sources = mappings[i].getSources()).length <= 0) continue;
            mapped.add(sources[0]);
        }
        return mapped;
    }

    protected List getMappingsForSourceColumns(List columns) {
        ArrayList<IMapping> mapped = new ArrayList<IMapping>();
        IMapping[] mappings = this.m_transformModel.getMappings();
        for (int i = 0; i < mappings.length; ++i) {
            IColumn[] sources;
            if (!"ONETOONE".equals(mappings[i].getType()) || (sources = mappings[i].getSources()).length <= 0 || !columns.contains(sources[0])) continue;
            mapped.add(mappings[i]);
        }
        return mapped;
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (ForkColumnsPropertyTab2.this.isListeningForChanges() && ev.getModelObject() == ForkColumnsPropertyTab2.this.m_transformModel) {
                String type = ev.getType();
                if ("MappingsContainer:MappingRemoved".equals(type)) {
                    IMapping mapping = (IMapping)ev.getData();
                    Object[] cols = mapping.getSources();
                    ForkColumnsPropertyTab2.this.m_dlsSelectColumns.transferToSourceModel(cols);
                } else if ("MappingsContainer:MappingAdded".equals(type)) {
                    IMapping mapping = (IMapping)ev.getData();
                    Object[] cols = mapping.getSources();
                    ForkColumnsPropertyTab2.this.m_dlsSelectColumns.transferToTargetModel(cols);
                }
            }
        }
    }

    private class cListCellRenderer
    extends DefaultListCellRenderer {
        private cListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            WsCompoundIcon iconCompound = new WsCompoundIcon();
            iconCompound.setIconGap(1);
            IColumn column = (IColumn)value;
            iconCompound.addIcon(ColumnUIUtilities.getTypeIcon(column));
            this.setText(column.getName());
            if (iconCompound.getIconCount() == 0) {
                this.setIcon(null);
            } else {
                this.setIcon((Icon)iconCompound);
            }
            return this;
        }
    }

    private class ForkTargetColumnsTableModel
    extends TargetColumnsTableModel {
        public ForkTargetColumnsTableModel(IMappingsContainer container) {
            super(container);
            this.setMappingsFilter(new OrdinaryMappingsFilter());
        }

        @Override
        protected void createListeners() {
        }
    }

    private static class OrdinaryMappingsFilter
    implements IFilter {
        private OrdinaryMappingsFilter() {
        }

        public boolean pass(Object obj) {
            return ((IMapping)obj).isOrdinary();
        }
    }

    private class TargetDualListener
    implements ListDataListener {
        private TargetDualListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void contentsChanged(ListDataEvent e) {
            if (!ForkColumnsPropertyTab2.this.isListeningForChanges()) {
                return;
            }
            ForkColumnsPropertyTab2.this.setListeningForChanges(false);
            ArrayList lst = new ArrayList(ForkColumnsPropertyTab2.this.m_adpSelectedColumns.getModel());
            IModel model = ForkColumnsPropertyTab2.this.m_transformModel.getModel();
            model.startCompoundUndoable();
            try {
                ITable target = ForkColumnsPropertyTab2.this.m_transformModel.getTargetTables()[0];
                List mappedSourceColumns = ForkColumnsPropertyTab2.this.getMappedSourceColumns();
                ArrayList removed = new ArrayList(mappedSourceColumns);
                removed.removeAll(lst);
                ArrayList added = new ArrayList(lst);
                added.removeAll(mappedSourceColumns);
                ForkColumnsPropertyTab2.this.m_transformModel.propagateColumnsToTargetTable(added.toArray(new IColumn[added.size()]), target);
                List mappings = ForkColumnsPropertyTab2.this.getMappingsForSourceColumns(removed);
                for (int i = 0; i < mappings.size(); ++i) {
                    IMapping mapping = (IMapping)mappings.get(i);
                    target.removeColumn(mapping.getTargets()[0]);
                }
            }
            finally {
                ForkColumnsPropertyTab2.this.setListeningForChanges(true);
                model.endCompoundUndoable();
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }
}

