/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.fork;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.wadmin.transforms.fork.ForkColumns;
import com.sas.wadmin.transforms.fork.ForkPropertyHandler;
import com.sas.wadmin.transforms.fork.ForkUtil;
import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.undo.UndoManager;

public class ForkColumnsPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ForkColumnsPropertyTab.class);
    private TransformationStep m_metadata;
    private ClassifierMap m_classifierMap;
    private JLabel m_lblGeneratedColumns;
    private WsTable m_tblTarget;
    private TransformationTargetColumnsTableModel m_mdlTarget;
    private JScrollPane m_scrTarget;
    private cTableModelListener m_lsnrTargetTableModel;
    private JPanel m_panAdditionalColumns;
    private TitledBorder m_titledBorder;
    private DualListSelector m_dlsSelectColumns;
    private CollectionToListModelAdapter m_adpAvailableColumns;
    private CollectionToListModelAdapter m_adpSelectedColumns;
    private static final String TARGET_SETTINGS_KEY = "ForkColumnsPropertyTab.TargetTable";
    private static final int MIN_TABLE_WIDTH = 100;
    private static final int PREF_TABLE_WIDTH = 200;
    private static final int ROW_HEIGHT = 18;

    public ForkColumnsPropertyTab(TransformationStep metadata) {
        this.m_metadata = metadata;
        this.setHelpTopic("fork_target_cols_tab");
        this.initialize();
    }

    protected void initialize() {
        this.m_lsnrTargetTableModel = new cTableModelListener();
        this.m_mdlTarget = new TransformationTargetColumnsTableModel();
        this.m_mdlTarget.addTableModelListener(this.m_lsnrTargetTableModel);
        this.m_mdlTarget.setTransformationStep(this.m_metadata);
        this.m_mdlTarget.getColumn(0).setWidth(185);
        this.m_mdlTarget.getColumn(2).setWidth(350);
        this.m_tblTarget = new WsTable((WsAbstractTableModel)this.m_mdlTarget);
        this.m_lblGeneratedColumns = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_tblTarget, (WAdminResource)bundle, (String)"ForkColumnsPropertyTab.GeneratedColumns");
        this.m_tblTarget.setName("TargetTable");
        this.m_tblTarget.setRowsReorderable(false);
        this.m_tblTarget.restoreSettings(TARGET_SETTINGS_KEY);
        ForkColumns forkColumns = new ForkColumns();
        this.m_scrTarget = new JScrollPane((Component)this.m_tblTarget);
        this.m_scrTarget.setMinimumSize(new Dimension(100, (forkColumns.getNumberOfCreatedColumns() + 1) * 18));
        this.m_scrTarget.setPreferredSize(new Dimension(200, (forkColumns.getNumberOfCreatedColumns() + 1) * 18));
        this.removeColumn(this.m_tblTarget, 1);
        this.removeColumn(this.m_tblTarget, 12);
        this.removeColumn(this.m_tblTarget, 5);
        this.removeColumn(this.m_tblTarget, 6);
        this.removeColumn(this.m_tblTarget, 4);
        this.removeColumn(this.m_tblTarget, 3);
        this.m_tblTarget.setMultipleSelectionDragEnabled(true);
        this.m_tblTarget.setUndoManager((UndoManager)this.waum);
        this.m_dlsSelectColumns = new DualListSelector();
        this.m_adpAvailableColumns = new CollectionToListModelAdapter();
        this.m_adpSelectedColumns = new CollectionToListModelAdapter();
        this.m_adpSelectedColumns.addListDataListener((ListDataListener)new DualListener());
        this.m_dlsSelectColumns.setSourceLabel(bundle.getString("ForkColumnsPropertyTab.AvailableColumns.txt"));
        this.m_dlsSelectColumns.getSourceComponent().setToolTipText(bundle.getString("ForkColumnsPropertyTab.AvailableColumns.ToolTip.txt"));
        ((JLabel)this.m_dlsSelectColumns.getSourceLabelComponent()).setDisplayedMnemonic(bundle.getString("ForkColumnsPropertyTab.AvailableColumns.mnem").charAt(0));
        this.m_dlsSelectColumns.setTargetLabel(bundle.getString("ForkColumnsPropertyTab.SelectedColumns.txt"));
        this.m_dlsSelectColumns.getTargetComponent().setToolTipText(bundle.getString("ForkColumnsPropertyTab.SelectedColumns.ToolTip.txt"));
        ((JLabel)this.m_dlsSelectColumns.getTargetLabelComponent()).setDisplayedMnemonic(bundle.getString("ForkColumnsPropertyTab.SelectedColumns.mnem").charAt(0));
        this.m_panAdditionalColumns = new JPanel();
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)bundle.getString("ForkColumnsPropertyTab.AdditionalColumns.title.txt"));
        this.m_panAdditionalColumns.setBorder(this.m_titledBorder);
        this.m_panAdditionalColumns.setLayout(new GridBagLayout());
        this.m_panAdditionalColumns.add((Component)this.m_dlsSelectColumns, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_dlsSelectColumns.setModel((ListModel)this.m_adpAvailableColumns);
        this.m_dlsSelectColumns.setTargetModel((ListModel)this.m_adpSelectedColumns);
        ColumnsTableNameCellRenderer rdrColumnName = new ColumnsTableNameCellRenderer();
        rdrColumnName.setTypeColumnIndex(7);
        int iColumnName = this.m_tblTarget.convertColumnIndexToView(0);
        if (iColumnName != -1) {
            TableColumn colColumnName = this.m_tblTarget.getColumnModel().getColumn(iColumnName);
            colColumnName.setCellRenderer((TableCellRenderer)((Object)rdrColumnName));
        }
        this.m_dlsSelectColumns.setTargetCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_dlsSelectColumns.setSourceCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblGeneratedColumns, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_scrTarget, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_panAdditionalColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        try {
            this.populateStore();
            ForkUtil.updateTargetTableColumns(this.m_classifierMap);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void removeColumn(WsTable tbl, int iModelColumn) {
        int iViewColumn = tbl.convertColumnIndexToView(iModelColumn);
        if (iViewColumn != -1) {
            tbl.removeColumn(tbl.getColumnModel().getColumn(iViewColumn));
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        AssociationList transList = this.m_metadata.getTransformations(false);
        if (!transList.isEmpty()) {
            this.m_classifierMap = (ClassifierMap)transList.get(0);
            this.setStorePopulated(true);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlTarget.moveDataToModel();
        ForkColumns forkColumns = new ForkColumns();
        for (int i = this.m_mdlTarget.getRowCount() - 1; i >= 0; --i) {
            if (forkColumns.isForkColumn(this.m_mdlTarget.getValueAt(i, 0).toString())) continue;
            this.m_mdlTarget.deleteRow(i);
        }
        ForkPropertyHandler lHandler = new ForkPropertyHandler((Root)this.m_classifierMap, "INITIALIZED", true);
        Property prop = lHandler.getSpecificProperty("INITIALIZED");
        boolean init = false;
        if (prop == null) {
            init = true;
        }
        if (!this.m_classifierMap.getClassifierSources().isEmpty()) {
            ArrayList targetColumns = new ArrayList();
            for (int i = 0; i < this.m_classifierMap.getFeatureMaps().size(); ++i) {
                FeatureMap fm = (FeatureMap)this.m_classifierMap.getFeatureMaps().get(i);
                targetColumns.addAll(fm.getFeatureTargets());
            }
            DataTable sourceTable = (DataTable)this.m_classifierMap.getClassifierSources().get(0);
            AssociationList sourceColumns = sourceTable.getColumns();
            ArrayList<Column> selectedColumns = new ArrayList<Column>();
            ArrayList<Column> availColumns = new ArrayList<Column>();
            for (int i = 0; i < sourceColumns.size(); ++i) {
                Column col = (Column)sourceColumns.get(i);
                if (forkColumns.isForkColumn(col.getSASColumnName())) continue;
                if (ForkUtil.getSASNamedColumn(targetColumns, col.getSASColumnName()) == null) {
                    availColumns.add(col);
                    continue;
                }
                selectedColumns.add(col);
            }
            if (!init) {
                this.m_adpAvailableColumns.setModel(availColumns);
                this.m_adpSelectedColumns.setModel(selectedColumns);
            } else {
                this.m_adpAvailableColumns.setModel(selectedColumns);
                this.m_adpSelectedColumns.setModel(availColumns);
            }
        }
        this.setEditable(this.isEditable());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        ForkPropertyHandler lHandler = new ForkPropertyHandler((Root)this.m_classifierMap, "INITIALIZED", true);
        if (lHandler.getSpecificProperty("INITIALIZED") != null && !this.hasDataChanged()) {
            return;
        }
        this.m_mdlTarget.moveDataToStore();
        lHandler.setSpecificProperty("INITIALIZED", "1");
        DataTable targetTable = null;
        if (!this.m_classifierMap.getClassifierTargets().isEmpty()) {
            targetTable = (DataTable)this.m_classifierMap.getClassifierTargets().get(0);
        }
        if (targetTable != null && this.m_adpSelectedColumns.getModel() != null) {
            AssociationList existingColumns = targetTable.getColumns();
            ArrayList selectedColumns = new ArrayList(this.m_adpSelectedColumns.getModel());
            for (int i = 0; i < selectedColumns.size(); ++i) {
                Column col = (Column)selectedColumns.get(i);
                if (ForkUtil.getSASNamedColumn((List)existingColumns, col.getSASColumnName()) != null) continue;
                Column targetCol = (Column)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_classifierMap.getObjectStore(), col.getName(), "Column", this.m_classifierMap.getRepositoryID());
                targetTable.getColumns().add((Object)targetCol);
                MdStoreUtil.copyObjectAttributes((CMetadata)col, (CMetadata)targetCol);
                FeatureMap newMap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_classifierMap.getObjectStore(), "newmap", "FeatureMap", this.m_classifierMap.getRepositoryID());
                newMap.setIsActive(1);
                newMap.setTransformRole("ONETOONE");
                newMap.getFeatureSources().add((Object)col);
                newMap.getFeatureTargets().add((Object)targetCol);
                newMap.setAssociatedClassifierMap(this.m_classifierMap);
            }
            ForkColumns forkColumns = new ForkColumns();
            ArrayList<Column> objectsToDelete = new ArrayList<Column>();
            for (int i = 0; i < existingColumns.size(); ++i) {
                Column col = (Column)existingColumns.get(i);
                if (ForkUtil.getSASNamedColumn(selectedColumns, col.getSASColumnName()) != null || forkColumns.isForkColumn(col.getSASColumnName())) continue;
                objectsToDelete.add(col);
                objectsToDelete.addAll((Collection<Column>)col.getTargetFeatureMaps());
            }
            ((MdObjectStore)this.m_classifierMap.getObjectStore()).removeObjectsFromStore(objectsToDelete);
        }
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblTarget.saveSettings(TARGET_SETTINGS_KEY);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_dlsSelectColumns.setEnabled(editable);
        for (int i = 0; i < this.m_mdlTarget.getColumnCount(); ++i) {
            block4: {
                block3: {
                    if (i == 10) break block3;
                    if (i == 9) break block3;
                    if (i != 2) break block4;
                }
                this.m_mdlTarget.getColumn(i).setEditable(editable);
                continue;
            }
            this.m_mdlTarget.getColumn(i).setEditable(false);
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (ForkColumnsPropertyTab.this.isListeningForChanges()) {
                ForkColumnsPropertyTab.this.setDataChanged(true);
            }
        }
    }

    private class cListCellRenderer
    extends DefaultListCellRenderer {
        private cListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            try {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                WsCompoundIcon iconCompound = new WsCompoundIcon();
                iconCompound.setIconGap(1);
                String sType = WsColumnMetadataUtil.convertColumnTypeToView((String)((Column)value).getSASColumnType());
                iconCompound.addIcon(WsColumnMetadataUtil.getColumnViewTypeIcon((String)sType));
                if (iconCompound.getIconCount() == 0) {
                    this.setIcon(null);
                } else {
                    this.setIcon((Icon)iconCompound);
                }
                return this;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }
    }

    private class DualListener
    implements ListDataListener {
        private DualListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ForkColumnsPropertyTab.this.setDataChanged(true);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }
}

