/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.edmflow;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.edmflow.IEDMFlowColumn;
import com.sas.etl.models.data.edmflow.IEDMFlowTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMapping;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMappingsContainer;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class EDMFlowTargetColumnsTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(EDMFlowTargetColumnsTableModel.class);
    private static final int VISIBLE_COLUMNS = 6;
    private static final int INVISIBLE_COLUMNS = 2;
    public static final int MAPPINGTYPE_COLUMN = 0;
    public static final int EXCLUSIONS_COLUMN = 1;
    public static final int COLUMNNAME_COLUMN = 2;
    public static final int COLUMNNAME_DISPLAYNAME = 3;
    public static final int COLUMNDESCR_COLUMN = 4;
    public static final int TYPE_COLUMN = 5;
    private static final int COLUMN_COLUMN = 6;
    private static final int MAPPING_COLUMN = 7;
    private static final int MAPPINGTYPE_WIDTH = 18;
    private static final int EXCLUSIONS_WIDTH = 18;
    private static final int COLUMNNAME_WIDTH = 75;
    private static final int COLUMNDESCR_WIDTH = 75;
    private static final int TYPE_WIDTH = 75;
    private static final Icon UNMAPPED_ICON = bundle.getIcon("EDMFlowTargetColumnsTableModel.MappingType.Unmapped.image");
    private static final Icon ONE_TO_ONE_ICON = bundle.getIcon("EDMFlowTargetColumnsTableModel.MappingType.OneToOne.image");
    private static final Icon DERIVED_ICON = bundle.getIcon("EDMFlowTargetColumnsTableModel.MappingType.Derived.image");
    private static final Icon WARNING_ICON = bundle.getIcon("EDMFlowTargetColumnsTableModel.MappingType.Warning.image");
    private static final Icon NOT_EXCLUDED_ICON = bundle.getIcon("EDMFlowTargetColumnsTableModel.ExclusionType.None.image");
    private static final Icon EXCLUDED_FROM_MAPPING_ICON = bundle.getIcon("EDMFlowTargetColumnsTableModel.ExclusionType.Mapping.image");
    private IEDMFlowMappingsContainer m_container;
    private List<IEDMFlowTable> m_lTables;
    private IEDMFlowTable m_tblSelected;
    private IFilter m_filter;
    private IModelListener m_lsnrModel;

    public EDMFlowTargetColumnsTableModel(IEDMFlowMappingsContainer container) {
        this.m_container = container;
        this.m_lTables = new ArrayList<IEDMFlowTable>();
        this.createListeners();
        this.createColumnDefinitions();
        this.setRowInstanceCount(1);
    }

    protected void createListeners() {
        this.m_lsnrModel = new EDMFlowModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void createColumnDefinitions() {
        String[] saTypes = ColumnUIUtilities.getViewTypes();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsIconTableColumn(0, " ", 18);
        this.m_aColumns[1] = new WsIconTableColumn(1, " ", 18);
        this.m_aColumns[2] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 2, bundle.getString("EDMFlowTargetColumnsTableModel.Column.txt"), 75, 32);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("EDMFlowTargetColumnsTableModel.Column.txt"), 75, 32);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("EDMFlowTargetColumnsTableModel.ColumnDescr.txt"), 75, 200);
        this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("EDMFlowTargetColumnsTableModel.Type.txt"), 75);
        this.m_aColumns[2].setCellRenderer((TableCellRenderer)((Object)new ColumnNameCellRenderer()));
        this.m_aColumns[6] = new WsObjectTableColumn();
        this.m_aColumns[7] = new WsObjectTableColumn();
        this.m_aColumns[0].setEditable(false);
    }

    public int getColumnCount() {
        return 6;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public int getDefaultEditColumnIndex() {
        return 2;
    }

    public void setValueAt(Object obj, int iRow, int iColumn) {
        IEDMFlowColumn col = (IEDMFlowColumn)this.getValueAt(iRow, 6);
        if (iColumn == 2) {
            col.setName((String)obj);
        } else if (iColumn == 4) {
            col.setDescription((String)obj);
        } else if (iColumn == 5) {
            col.setDataType(col.getDataType());
        }
    }

    public String getToolTipAt(int iRow, int iColumn) {
        if (iColumn == 0) {
            if (iRow == -1) {
                return bundle.getString("EDMFlowTargetColumnsTableModel.MappingType.ColumnHeader.tip");
            }
            if (this.getValueAt(iRow, iColumn) == WARNING_ICON) {
                return this.getMapping(iRow).getWarning();
            }
        } else if (iColumn == 1) {
            if (iRow == -1) {
                return bundle.getString("EDMFlowTargetColumnsTableModel.ExclusionType.ColumnHeader.tip");
            }
            Icon icon = (Icon)this.getValueAt(iRow, iColumn);
            if (icon == EXCLUDED_FROM_MAPPING_ICON) {
                return bundle.getString("EDMFlowTargetColumnsTableModel.ExclusionType.Mapping.tip");
            }
        }
        return null;
    }

    public void moveDataToModel() {
        this.clear();
        this.m_lTables.clear();
        IEDMFlowTable[] aTables = this.m_container.getSourceEDMFlowTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            this.m_lTables.add(aTables[iTable]);
            if (this.m_tblSelected != null && this.m_tblSelected != aTables[iTable]) continue;
            for (IEDMFlowColumn aColumn : aTables[iTable].getColumns()) {
                this.m_lData.add(this.createRowValues(aColumn));
            }
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() {
    }

    public void populateStore() {
    }

    private List<Object> createRowValues(IEDMFlowColumn col) {
        IEDMFlowMapping mapping = this.findMappingForColumn(col);
        ArrayList<Object> lValues = new ArrayList<Object>(8);
        lValues.add(this.getMappingTypeIcon(mapping));
        lValues.add(this.getExclusionsIcon(col));
        lValues.add(col.getName());
        lValues.add(col.getDisplayName());
        lValues.add(col.getDescription());
        lValues.add(col.getDataType().getName());
        lValues.add(col);
        lValues.add(mapping);
        return lValues;
    }

    private IEDMFlowMapping findMappingForColumn(IEDMFlowColumn col) {
        IEDMFlowMapping[] aMappings = this.m_container.getEDMFlowMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            IEDMFlowMapping mapping = aMappings[iMapping];
            if (!this.m_filter.pass((Object)mapping) || !mapping.containsInTargets(col)) continue;
            return mapping;
        }
        return null;
    }

    public IEDMFlowColumn getTargetColumn(int iRow) {
        return (IEDMFlowColumn)this.getValueAt(iRow, 6);
    }

    public int getRowIndex(IEDMFlowColumn col) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(6) != col) continue;
            return iRow;
        }
        return -1;
    }

    public int getRowIndex(IEDMFlowMapping mapping) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(7) != mapping) continue;
            return iRow;
        }
        return -1;
    }

    public IEDMFlowMapping getMapping(int iRow) {
        return (IEDMFlowMapping)this.getValueAt(iRow, 7);
    }

    private Icon getMappingTypeIcon(IEDMFlowMapping mapping) {
        if (mapping == null) {
            return UNMAPPED_ICON;
        }
        if (mapping.getWarning() != null) {
            return WARNING_ICON;
        }
        String sType = mapping.getType();
        return "ONETOONE".equals(sType) ? ONE_TO_ONE_ICON : ("DERIVED".equals(sType) ? DERIVED_ICON : UNMAPPED_ICON);
    }

    private Icon getExclusionsIcon(IEDMFlowColumn column) {
        Icon icon = NOT_EXCLUDED_ICON;
        if (this.m_container.getListOfColumnsExcludedFromMapping().contains(column)) {
            icon = EXCLUDED_FROM_MAPPING_ICON;
        }
        return icon;
    }

    public void setSelectedTable(IEDMFlowTable tbl) {
        if (this.m_tblSelected == tbl) {
            return;
        }
        this.m_tblSelected = tbl;
        this.moveDataToModel();
    }

    public IEDMFlowTable getSelectedTable() {
        return this.m_tblSelected;
    }

    public void setMappingsFilter(IFilter filter) {
        this.m_filter = filter;
    }

    public IFilter getMappingsFilter() {
        return this.m_filter;
    }

    private void addTable(IEDMFlowTable tbl) {
        if (this.m_tblSelected != null && this.m_tblSelected != tbl) {
            return;
        }
        if (!this.m_lTables.contains(tbl)) {
            this.m_lTables.add(tbl);
            for (IEDMFlowColumn aColumn : tbl.getColumns()) {
                this.insertRow(this.getRowCount() - 1, this.createRowValues(aColumn));
            }
        }
    }

    private void removeTable(IEDMFlowTable tbl) {
        if (this.m_tblSelected != null && this.m_tblSelected != tbl) {
            return;
        }
        if (this.m_lTables.contains(tbl)) {
            this.m_lTables.remove(tbl);
            for (IEDMFlowColumn aColumn : tbl.getColumns()) {
                this.deleteRow(this.getRowIndex(aColumn));
            }
        }
    }

    private void addMapping(IEDMFlowMapping mapping) {
        IEDMFlowColumn[] aColumns = mapping.getTargetsOfEDMFlowColumn();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            int iRow = this.getRowIndex(aColumns[iColumn]);
            if (iRow == -1) continue;
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void removeMapping(IEDMFlowMapping mapping) {
        IEDMFlowColumn[] aColumns = mapping.getTargetsOfEDMFlowColumn();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            int iRow = this.getRowIndex(aColumns[iColumn]);
            if (iRow == -1) continue;
            this.refreshMappingValues(iRow, null);
        }
    }

    private void addMappingSource(IEDMFlowMapping mapping, IColumn column) {
        int iRow = this.getRowIndex(mapping);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void removeMappingSource(IEDMFlowMapping mapping, IColumn column) {
        int iRow = this.getRowIndex(mapping);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void addMappingTarget(IEDMFlowMapping mapping, IEDMFlowColumn column) {
        int iRow = this.getRowIndex(column);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void removeMappingTarget(IEDMFlowMapping mapping, IEDMFlowColumn column) {
        int iRow = this.getRowIndex(column);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, null);
        }
    }

    private void refreshMappingValues(int iRow, IEDMFlowMapping mapping) {
        super.setValueAt((Object)mapping, iRow, 7);
        super.setValueAt((Object)this.getMappingTypeIcon(mapping), iRow, 0);
    }

    private void refreshExclusionsIcon(IEDMFlowColumn column) {
        int iRow = this.getRowIndex(column);
        if (iRow == -1) {
            return;
        }
        super.setValueAt((Object)this.getExclusionsIcon(column), iRow, 1);
    }

    private class ColumnNameCellRenderer
    extends WsDefaultTableCellRenderer {
        private ColumnNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            IEDMFlowColumn col;
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (tbl instanceof TableView) {
                iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            }
            if ((col = EDMFlowTargetColumnsTableModel.this.getTargetColumn(iRow)) != null) {
                this.setIcon(ColumnUIUtilities.getTypeIcon(col.getSASType()));
            }
            return this;
        }
    }

    private class EDMFlowModelListener
    implements IModelListener {
        private EDMFlowModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                EDMFlowTargetColumnsTableModel.this.moveDataToModel();
            } else if (obj == EDMFlowTargetColumnsTableModel.this.m_container) {
                if (sType == "DataTransform.DataTargetAdded") {
                    Object data = ev.getData();
                    if (data instanceof IEDMFlowTable) {
                        EDMFlowTargetColumnsTableModel.this.addTable((IEDMFlowTable)data);
                    }
                } else if (sType == "DataTransform.DataTargetRemoved") {
                    Object data = ev.getData();
                    if (data instanceof IEDMFlowTable) {
                        EDMFlowTargetColumnsTableModel.this.removeTable((IEDMFlowTable)data);
                    }
                } else if (sType == "MappingsContainer:EDMFlowMappingAdded") {
                    IEDMFlowMapping mapping = (IEDMFlowMapping)ev.getData();
                    if (EDMFlowTargetColumnsTableModel.this.m_filter.pass((Object)mapping)) {
                        EDMFlowTargetColumnsTableModel.this.addMapping(mapping);
                    }
                } else if (sType == "MappingsContainer:EDMFlowMappingRemoved") {
                    IEDMFlowMapping mapping = (IEDMFlowMapping)ev.getData();
                    if (mapping != null && EDMFlowTargetColumnsTableModel.this.m_filter.pass((Object)mapping)) {
                        EDMFlowTargetColumnsTableModel.this.removeMapping(mapping);
                    }
                } else if (sType == "MappingsContainer:ColumnExcludedFromMapping") {
                    EDMFlowTargetColumnsTableModel.this.refreshExclusionsIcon((IEDMFlowColumn)ev.getData());
                } else if (sType == "MappingsContainer:ColumnIncludedInMapping") {
                    EDMFlowTargetColumnsTableModel.this.refreshExclusionsIcon((IEDMFlowColumn)ev.getData());
                }
            } else if (EDMFlowTargetColumnsTableModel.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)EDMFlowTargetColumnsTableModel.this.m_container).getParentQuery().getTransformModel() == obj) {
                Object data;
                if (sType == "DataTransform.DataTargetAdded") {
                    Object data2 = ev.getData();
                    if (data2 instanceof IEDMFlowTable) {
                        EDMFlowTargetColumnsTableModel.this.addTable((IEDMFlowTable)data2);
                    }
                } else if (sType == "DataTransform.DataTargetRemoved" && (data = ev.getData()) instanceof IEDMFlowTable) {
                    EDMFlowTargetColumnsTableModel.this.removeTable((IEDMFlowTable)data);
                }
            } else if (obj instanceof IEDMFlowMapping) {
                IEDMFlowMapping mapping = (IEDMFlowMapping)obj;
                if (!EDMFlowTargetColumnsTableModel.this.m_filter.pass((Object)mapping) || !EDMFlowTargetColumnsTableModel.this.m_container.containsMapping((IMapping)mapping)) {
                    return;
                }
                if (sType == "Mapping:TargetColumnAdded") {
                    EDMFlowTargetColumnsTableModel.this.addMappingTarget(mapping, (IEDMFlowColumn)ev.getData());
                } else if (sType == "Mapping:TargetColumnRemoved") {
                    EDMFlowTargetColumnsTableModel.this.removeMappingTarget(mapping, (IEDMFlowColumn)ev.getData());
                } else if (sType == "Mapping:SourceColumnAdded") {
                    EDMFlowTargetColumnsTableModel.this.addMappingSource(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:SourceColumnRemoved") {
                    EDMFlowTargetColumnsTableModel.this.removeMappingSource(mapping, (IColumn)ev.getData());
                } else {
                    int iRow = EDMFlowTargetColumnsTableModel.this.getRowIndex(mapping);
                    if (iRow == -1) {
                        return;
                    }
                    if (sType == "Mapping:TypeChanged") {
                        EDMFlowTargetColumnsTableModel.super.setValueAt(EDMFlowTargetColumnsTableModel.this.getMappingTypeIcon(mapping), iRow, 0);
                    } else if (sType == "Mapping:MappingChanged") {
                        EDMFlowTargetColumnsTableModel.this.refreshMappingValues(iRow, EDMFlowTargetColumnsTableModel.this.getMapping(iRow));
                    }
                }
            }
        }
    }
}

