/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.edmflow;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.edmflow.IEDMFlowColumn;
import com.sas.etl.models.data.edmflow.IEDMFlowTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMapping;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMappingsContainer;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.wadmin.transforms.edmflow.EDMFlowTargetColumnsTableModel;
import com.sas.wadmin.visuals.common.SourceColumnsTableModel;
import com.sas.workspace.WsDefaultObjectListModel;
import com.sas.workspace.WsMapping;

public class EDMFlowMappingsModel
extends WsDefaultObjectListModel {
    private IEDMFlowMappingsContainer m_container;
    private SourceColumnsTableModel m_mdlSourceColumns;
    private EDMFlowTargetColumnsTableModel m_mdlTargetColumns;
    private IFilter m_filter;
    private IModelListener m_lsnrModel;

    public EDMFlowMappingsModel(IEDMFlowMappingsContainer container, SourceColumnsTableModel mdlSourceColumns, EDMFlowTargetColumnsTableModel mdlTargetColumns) {
        this.m_container = container;
        this.m_mdlSourceColumns = mdlSourceColumns;
        this.m_mdlTargetColumns = mdlTargetColumns;
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
    }

    public void setMappingsFilter(IFilter filter) {
        this.m_filter = filter;
    }

    public IFilter getMappingsFilter() {
        return this.m_filter;
    }

    public void moveDataToModel() {
        this.removeAll();
        IEDMFlowMapping[] aMappings = this.m_container.getEDMFlowMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping])) continue;
            this.addMapping(aMappings[iMapping]);
        }
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) {
        WsMapping pair = (WsMapping)obj;
        if (pair.isTemporary()) {
            super.add((Object)pair);
        } else {
            IColumn source = this.m_mdlSourceColumns.getSourceColumn(pair.getSource());
            IEDMFlowColumn target = this.m_mdlTargetColumns.getTargetColumn(pair.getTarget());
            IEDMFlowMapping mapping = this.m_mdlTargetColumns.getMapping(pair.getTarget());
            if (mapping == null) {
                this.m_container.addMapping(new IColumn[]{source}, new IEDMFlowColumn[]{target});
            } else {
                this.m_container.getModel().startCompoundUndoable();
                try {
                    mapping.addSource(source);
                }
                finally {
                    this.m_container.getModel().endCompoundUndoable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object obj) {
        WsMapping pair = (WsMapping)obj;
        if (pair.isTemporary()) {
            super.remove((Object)pair);
        } else {
            this.m_container.getModel().startCompoundUndoable();
            try {
                PairingDataObject pdo = (PairingDataObject)pair.getDataObject();
                IColumn source = pdo.m_colSource;
                IEDMFlowMapping mapping = pdo.m_mapping;
                mapping.removeSource(source);
            }
            finally {
                this.m_container.getModel().endCompoundUndoable();
            }
        }
    }

    public void remove(int iObj) {
        this.remove(this.get(iObj));
    }

    private void addMapping(IEDMFlowMapping mapping) {
        if (!this.m_filter.pass((Object)mapping)) {
            return;
        }
        IColumn[] aSources = mapping.getSources();
        IEDMFlowColumn[] aTargets = mapping.getTargetsOfEDMFlowColumn();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            int iSourceRow = this.m_mdlSourceColumns.getRowIndex(aSources[iSource]);
            if (iSourceRow == -1) continue;
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                int iTargetRow = this.m_mdlTargetColumns.getRowIndex(aTargets[iTarget]);
                if (iTargetRow == -1) continue;
                super.add((Object)this.createPairing(iSourceRow, aSources[iSource], iTargetRow, aTargets[iTarget], mapping));
            }
        }
    }

    private void removeMapping(IEDMFlowMapping mapping) {
        if (!this.m_filter.pass((Object)mapping)) {
            return;
        }
        IColumn[] aSources = mapping.getSources();
        IEDMFlowColumn[] aTargets = mapping.getTargetsOfEDMFlowColumn();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                this.removePairing(aSources[iSource], aTargets[iTarget], mapping);
            }
        }
    }

    private void addPairingsForSourceColumnInMapping(IEDMFlowMapping mapping, IColumn column) {
        int iSourceRow = this.m_mdlSourceColumns.getRowIndex(column);
        if (iSourceRow == -1) {
            return;
        }
        IEDMFlowColumn[] aTargets = mapping.getTargetsOfEDMFlowColumn();
        for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
            int iTargetRow = this.m_mdlTargetColumns.getRowIndex(aTargets[iTarget]);
            if (iTargetRow == -1) continue;
            super.add((Object)this.createPairing(iSourceRow, column, iTargetRow, aTargets[iTarget], mapping));
        }
    }

    private void addPairingsForTargetColumnInMapping(IEDMFlowMapping mapping, IEDMFlowColumn column) {
        int iTargetRow = this.m_mdlTargetColumns.getRowIndex(column);
        if (iTargetRow == -1) {
            return;
        }
        IColumn[] aSources = mapping.getSources();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            int iSourceRow = this.m_mdlSourceColumns.getRowIndex(aSources[iSource]);
            if (iSourceRow == -1) continue;
            super.add((Object)this.createPairing(iSourceRow, aSources[iSource], iTargetRow, column, mapping));
        }
    }

    private void removePairingsForSourceColumnInMapping(IEDMFlowMapping mapping, IColumn column) {
        IEDMFlowColumn[] aTargets = mapping.getTargetsOfEDMFlowColumn();
        for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
            this.removePairing(column, aTargets[iTarget], mapping);
        }
    }

    private void removePairingsForTargetColumnInMapping(IEDMFlowMapping mapping, IEDMFlowColumn column) {
        IColumn[] aSources = mapping.getSources();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            this.removePairing(aSources[iSource], column, mapping);
        }
    }

    private void addPairingsForSourceColumn(IColumn col) {
        IEDMFlowMapping[] aMappings = this.m_container.getEDMFlowMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInSources(col)) continue;
            this.addPairingsForSourceColumnInMapping(aMappings[iMapping], col);
        }
    }

    private void addPairingsForTargetColumn(IEDMFlowColumn col) {
        IEDMFlowMapping[] aMappings = this.m_container.getEDMFlowMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInTargets(col)) continue;
            this.addPairingsForTargetColumnInMapping(aMappings[iMapping], col);
        }
    }

    private void removePairingsForSourceColumn(IColumn col) {
        IEDMFlowMapping[] aMappings = this.m_container.getEDMFlowMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInSources(col)) continue;
            this.removePairingsForSourceColumnInMapping(aMappings[iMapping], col);
        }
    }

    private void removePairingsForTargetColumn(IEDMFlowColumn col) {
        IEDMFlowMapping[] aMappings = this.m_container.getEDMFlowMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInTargets(col)) continue;
            this.removePairingsForTargetColumnInMapping(aMappings[iMapping], col);
        }
    }

    private boolean isSourceTable(ITable tbl) {
        ITable[] aTables = this.m_container.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            if (aTables[iTable] != tbl) continue;
            return true;
        }
        return false;
    }

    private boolean isTargetTable(IEDMFlowTable tbl) {
        IEDMFlowTable[] aTables = this.m_container.getSourceEDMFlowTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            if (aTables[iTable] != tbl) continue;
            return true;
        }
        return false;
    }

    private WsMapping createPairing(int iSourceRow, IColumn colSource, int iTargetRow, IEDMFlowColumn colTarget, IEDMFlowMapping mapping) {
        WsMapping pairing = new WsMapping(iSourceRow, iTargetRow);
        pairing.setDataObject((Object)new PairingDataObject(colSource, colTarget, mapping));
        return pairing;
    }

    private WsMapping removePairing(IColumn colSource, IEDMFlowColumn colTarget, IEDMFlowMapping mapping) {
        for (int iPairing = 0; iPairing < this.size(); ++iPairing) {
            WsMapping pairing = (WsMapping)this.get(iPairing);
            PairingDataObject pdo = (PairingDataObject)pairing.getDataObject();
            if (pdo.m_colSource != colSource || pdo.m_colTarget != colTarget || pdo.m_mapping != mapping) continue;
            super.remove(iPairing);
            return pairing;
        }
        return null;
    }

    private static class PairingDataObject {
        IColumn m_colSource;
        IEDMFlowColumn m_colTarget;
        IEDMFlowMapping m_mapping;

        PairingDataObject(IColumn colSource, IEDMFlowColumn colTarget, IEDMFlowMapping mapping) {
            this.m_colSource = colSource;
            this.m_colTarget = colTarget;
            this.m_mapping = mapping;
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                EDMFlowMappingsModel.this.moveDataToModel();
            } else if (obj == EDMFlowMappingsModel.this.m_container) {
                if (sType == "MappingsContainer:EDMFlowMappingAdded") {
                    EDMFlowMappingsModel.this.addMapping((IEDMFlowMapping)ev.getData());
                } else if (sType == "MappingsContainer:EDMFlowMappingRemoved") {
                    EDMFlowMappingsModel.this.removeMapping((IEDMFlowMapping)ev.getData());
                } else if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataTargetAdded") {
                    EDMFlowMappingsModel.this.moveDataToModel();
                }
            } else if (EDMFlowMappingsModel.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)EDMFlowMappingsModel.this.m_container).getParentQuery().getTransformModel() == obj) {
                if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataTargetAdded") {
                    EDMFlowMappingsModel.this.moveDataToModel();
                }
            } else if (obj instanceof ITable) {
                if (EDMFlowMappingsModel.this.isSourceTable((ITable)obj)) {
                    if (sType == "Table:ColumnAdded") {
                        EDMFlowMappingsModel.this.addPairingsForSourceColumn((IColumn)ev.getData());
                    } else if (sType == "Table:ColumnMoved") {
                        EDMFlowMappingsModel.this.removePairingsForSourceColumn((IColumn)ev.getData());
                        EDMFlowMappingsModel.this.addPairingsForSourceColumn((IColumn)ev.getData());
                    } else if (sType == "Table:ColumnRemoved") {
                        EDMFlowMappingsModel.this.removePairingsForSourceColumn((IColumn)ev.getData());
                    }
                }
            } else if (obj instanceof IEDMFlowTable) {
                if (EDMFlowMappingsModel.this.isTargetTable((IEDMFlowTable)obj)) {
                    if (sType == "Table:ColumnAdded") {
                        EDMFlowMappingsModel.this.addPairingsForTargetColumn((IEDMFlowColumn)ev.getData());
                    } else if (sType == "Table:ColumnMoved") {
                        EDMFlowMappingsModel.this.removePairingsForTargetColumn((IEDMFlowColumn)ev.getData());
                        EDMFlowMappingsModel.this.addPairingsForTargetColumn((IEDMFlowColumn)ev.getData());
                    } else if (sType == "Table:ColumnRemoved") {
                        EDMFlowMappingsModel.this.removePairingsForTargetColumn((IEDMFlowColumn)ev.getData());
                    }
                }
            } else if (obj instanceof IEDMFlowMapping) {
                IEDMFlowMapping mapping = (IEDMFlowMapping)obj;
                if (!EDMFlowMappingsModel.this.m_filter.pass((Object)mapping) || !EDMFlowMappingsModel.this.m_container.containsMapping((IMapping)mapping)) {
                    return;
                }
                if (sType == "Mapping:SourceColumnAdded") {
                    EDMFlowMappingsModel.this.addPairingsForSourceColumnInMapping(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:TargetColumnAdded") {
                    EDMFlowMappingsModel.this.addPairingsForTargetColumnInMapping(mapping, (IEDMFlowColumn)ev.getData());
                } else if (sType == "Mapping:SourceColumnRemoved") {
                    EDMFlowMappingsModel.this.removePairingsForSourceColumnInMapping(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:TargetColumnRemoved") {
                    EDMFlowMappingsModel.this.removePairingsForTargetColumnInMapping(mapping, (IEDMFlowColumn)ev.getData());
                }
            }
        }
    }
}

