/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.edmflow;

import com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMappingsContainer;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.edmflow.EDMFlowMappingsTab;
import com.sas.wadmin.transforms.edmflow.EDMFlowTargetPanel;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class EDMFlowInputOutputTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(EDMFlowInputOutputTab.class);
    private static final String SPLIT_DETAILS_PANE_DIV_LOC = "EDMFlowSplitPanelLocation";
    private EDMFlowTransformModel _transform;
    private EDMFlowMappingsTab _edmMappings;
    private EDMFlowTargetPanel _targetPanel;
    private JSplitPane m_splitPane;
    private boolean m_layoutComplete;

    public EDMFlowInputOutputTab(EDMFlowTransformModel model, MappingsTab.Configuration configuration) {
        this.setName(bundle.getString("EDMFlowInputOutputTab.Name.txt"));
        this._transform = model;
        this._edmMappings = new EDMFlowMappingsTab((IEDMFlowMappingsContainer)this._transform, configuration);
        this._targetPanel = new EDMFlowTargetPanel(this._transform);
        this.setHelpProduct("wdb");
        this.setHelpTopic("edm_flow_inputs_outputs");
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        JPanel top = new JPanel();
        top.setLayout(new GridBagLayout());
        JLabel lbltop = WsUIUtilities.createLabelForComponent((JComponent)((Object)this._edmMappings), (String)bundle.getString("EDMFlowInputOutputTab.Inputs.txt"));
        top.add((Component)lbltop, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        top.add((Component)((Object)this._edmMappings), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        JPanel bottom = new JPanel();
        bottom.setLayout(new GridBagLayout());
        JLabel lblbottom = WsUIUtilities.createLabelForComponent((JComponent)((Object)this._edmMappings), (String)bundle.getString("EDMFlowInputOutputTab.Outputs.txt"));
        bottom.add((Component)lblbottom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        bottom.add((Component)((Object)this._targetPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.m_splitPane = new JSplitPane(0, true);
        this.m_splitPane.setTopComponent(top);
        this.m_splitPane.setBottomComponent(bottom);
        this.add(this.m_splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void doLayout() {
        if (!this.m_layoutComplete) {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            this.m_splitPane.setDividerLocation(appDefaults.getPropertyInt(SPLIT_DETAILS_PANE_DIV_LOC, 300));
            this.m_splitPane.setResizeWeight(0.5);
            this.m_layoutComplete = true;
        }
        super.doLayout();
    }

    public void moveDataToStore() throws RemoteException, MdException {
        super.moveDataToStore();
        this._edmMappings.moveDataToStore();
        this._targetPanel.moveDataToStore();
    }

    public void moveDataToView() {
        this._edmMappings.moveDataToView();
        this._targetPanel.moveDataToView();
    }

    public void setEditable(boolean isEditable) {
        super.setEditable(isEditable);
        this._edmMappings.setEditable(isEditable);
        this._targetPanel.setEditable(isEditable);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(SPLIT_DETAILS_PANE_DIV_LOC, this.m_splitPane.getDividerLocation());
        this._edmMappings.saveSettingsAndCleanUp();
        this._targetPanel.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        return super.validateData() && this._edmMappings.validateData() && this._targetPanel.validateData();
    }
}

