/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationUtil;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.datavalidation.ChooseColumnsPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class ErrorsTab
extends WAPropertyTab {
    public static final int ERROR_TABLE = 0;
    public static final int EXCEPTION_TABLE = 1;
    private static WAdminResource bundle = WAdminResource.getBundle(ErrorsTab.class);
    private DataValidationTransformModel m_transform;
    private IPhysicalTable m_errorTable;
    private IPhysicalTable m_exceptionTable;
    private JCheckBox m_cbErrorTable;
    private JCheckBox m_cbErrorTableReplace;
    private JButton m_btnErrorColumns;
    private JCheckBox m_cbExceptionTable;
    private JCheckBox m_cbExceptionTableReplace;
    private JButton m_btnExceptionColumns;
    private cChooseErrorColumnsAction m_actErrorColumns;
    private cChooseExceptionColumnsAction m_actExceptionColumns;
    private IModelListener m_lsnrModel;

    public ErrorsTab(DataValidationTransformModel transform) {
        this.m_transform = transform;
        this.setName(bundle.getString("ErrorsTab.Title.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("err_exc_tab");
        this.initialize();
        this.m_lsnrModel = new ModelListener();
        this.m_transform.getModel().addModelListener(this.m_lsnrModel);
    }

    protected void initialize() {
        this.m_actErrorColumns = new cChooseErrorColumnsAction("ErrorsTab.actErrorColumns");
        this.m_actExceptionColumns = new cChooseExceptionColumnsAction("ErrorsTab.actExceptionColumns");
        this.m_cbErrorTable = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbErrorTable", (int)1);
        this.m_cbErrorTableReplace = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbErrorTableReplace", (int)1);
        this.m_cbExceptionTable = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbExceptionTable", (int)1);
        this.m_cbExceptionTableReplace = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbExceptionTableReplace", (int)1);
        this.m_btnErrorColumns = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actErrorColumns);
        this.m_btnExceptionColumns = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actExceptionColumns);
        this.m_cbErrorTable.addActionListener(new cErrorCheckBoxActionListener());
        this.m_cbErrorTableReplace.addActionListener(new cCBErrorTableReplaceActionListener());
        this.m_cbExceptionTable.addActionListener(new cExceptionCheckBoxActionListener());
        this.m_cbExceptionTableReplace.addActionListener(new cCBExceptionTableReplaceActionListener());
        this.setLayout(new GridBagLayout());
        this.add(this.createErrorTablePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createExceptionTablePanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.m_transform.getModel().removeModelListener(this.m_lsnrModel);
    }

    public void populateStore() throws MdException, RemoteException {
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.hasDataChanged()) {
            return;
        }
        this.setListeningForChanges(false);
        this.m_errorTable = this.m_transform.getErrorTable();
        if (this.m_errorTable != null) {
            this.m_cbErrorTable.setSelected(true);
            this.m_cbErrorTableReplace.setSelected(this.m_transform.isErrorTableReplace());
        } else {
            this.m_cbErrorTableReplace.setEnabled(false);
            this.m_btnErrorColumns.setEnabled(false);
        }
        this.m_exceptionTable = this.m_transform.getExceptionTable();
        if (this.m_exceptionTable != null) {
            this.m_cbExceptionTable.setSelected(true);
            this.m_cbExceptionTableReplace.setSelected(this.m_transform.isExceptionTableReplace());
        } else {
            this.m_cbExceptionTableReplace.setEnabled(false);
            this.m_btnExceptionColumns.setEnabled(false);
        }
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.updateTables();
    }

    private void updateTables() {
        if (this.m_cbErrorTable.isSelected()) {
            if (this.m_errorTable != this.m_transform.getErrorTable()) {
                this.m_transform.setErrorTable(this.m_errorTable);
            }
        } else if (this.m_transform.getErrorTable() != null) {
            this.m_transform.setErrorTable(null);
        }
        if (this.m_cbExceptionTable.isSelected()) {
            if (this.m_exceptionTable != this.m_transform.getExceptionTable()) {
                this.m_transform.setExceptionTable(this.m_exceptionTable);
            }
        } else if (this.m_transform.getExceptionTable() != null) {
            this.m_transform.setExceptionTable(null);
        }
    }

    public boolean validateData() {
        String sMessage = null;
        boolean addTables = false;
        if (this.m_transform.getErrorTable() != null && !this.m_cbErrorTable.isSelected()) {
            sMessage = bundle.getString("ErrorsTab.RemoveErrorTable.msg.txt");
        }
        if (this.m_transform.getExceptionTable() != null && !this.m_cbExceptionTable.isSelected()) {
            sMessage = sMessage == null ? bundle.getString("ErrorsTab.RemoveExceptionTable.msg.txt") : bundle.getString("ErrorsTab.RemoveBothTables.msg.txt");
        }
        if (this.m_transform.getErrorTable() == null && this.m_cbErrorTable.isSelected() && this.m_transform.isErrorTableNameOptionUsed()) {
            sMessage = bundle.formatString("ErrorsTab.AddErrorTable.msg.txt", (Object)this.m_transform.getErrorTableName());
            addTables = true;
        }
        if (sMessage != null) {
            int iMessageChoice = 0;
            if (addTables) {
                iMessageChoice = MessageUtil.displayMessage((String)sMessage, (String)bundle.getString("ErrorsTab.AddTables.title.txt"), (int)1, (int)0);
                if (iMessageChoice == 0) {
                    this.m_transform.removeErrorTableName(true);
                    return true;
                }
                if (iMessageChoice == 1) {
                    return false;
                }
            } else {
                iMessageChoice = MessageUtil.displayMessage((String)sMessage, (String)bundle.getString("ErrorsTab.RemoveTables.title.txt"), (int)1, (int)0);
                if (iMessageChoice == 1) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_cbErrorTable.setEnabled(bEditable);
        this.m_cbExceptionTable.setEnabled(bEditable);
    }

    private boolean launchChooseColumnsDialog(IPhysicalTable table, int iTableType) {
        ChooseColumnsPanel pnlChooseColumns = new ChooseColumnsPanel(this.m_transform, table, iTableType);
        String sTitle = iTableType == 0 ? bundle.getString("ErrorsTab.ChooseErrorColumns.txt") : bundle.getString("ErrorsTab.ChooseExceptionColumns.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnlChooseColumns);
        dlg.setEditable(this.m_bEditable);
        dlg.setResizable(true);
        dlg.setPreferredSize(new Dimension(750, 600));
        dlg.show();
        if (dlg.getReturnValue() == 1) {
            this.setDataChanged(true);
            return true;
        }
        return false;
    }

    protected void setCreateErrorTable(boolean bSelected) {
        this.m_cbErrorTable.setSelected(bSelected);
        this.m_btnErrorColumns.setEnabled(bSelected);
        this.m_cbErrorTableReplace.setEnabled(bSelected);
        if (bSelected && this.m_errorTable == null) {
            this.m_errorTable = DataValidationUtil.createErrorWorkTable((DataValidationTransformModel)this.m_transform);
        }
    }

    protected void setCreateExceptionTable(boolean bSelected) {
        this.m_cbExceptionTable.setSelected(bSelected);
        this.m_btnExceptionColumns.setEnabled(bSelected);
        this.m_cbExceptionTableReplace.setEnabled(bSelected);
        if (bSelected && this.m_exceptionTable == null) {
            this.m_exceptionTable = DataValidationUtil.createExceptionWorkTable((DataValidationTransformModel)this.m_transform);
        }
    }

    protected JPanel createErrorTablePanel() {
        this.m_actErrorColumns = new cChooseErrorColumnsAction("ErrorsTab.actErrorColumns");
        this.m_cbErrorTable = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbErrorTable", (int)1);
        this.m_cbErrorTableReplace = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbErrorTableReplace", (int)1);
        this.m_btnErrorColumns = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actErrorColumns);
        this.m_cbErrorTable.addActionListener(new cErrorCheckBoxActionListener());
        this.m_cbErrorTableReplace.addActionListener(new cCBErrorTableReplaceActionListener());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ErrorsTab.pErrorTable.txt")));
        panel.add((Component)this.m_cbErrorTable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_cbErrorTableReplace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_btnErrorColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 4, 0, 0), 0, 0));
        return panel;
    }

    protected JPanel createExceptionTablePanel() {
        this.m_actExceptionColumns = new cChooseExceptionColumnsAction("ErrorsTab.actExceptionColumns");
        this.m_cbExceptionTable = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbExceptionTable", (int)1);
        this.m_cbExceptionTableReplace = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ErrorsTab.cbExceptionTableReplace", (int)1);
        this.m_btnExceptionColumns = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actExceptionColumns);
        this.m_cbExceptionTable.addActionListener(new cExceptionCheckBoxActionListener());
        this.m_cbExceptionTableReplace.addActionListener(new cCBExceptionTableReplaceActionListener());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ErrorsTab.pExceptionTable.txt")));
        panel.add((Component)this.m_cbExceptionTable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_cbExceptionTableReplace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_btnExceptionColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 4, 0, 0), 0, 0));
        return panel;
    }

    private class CreateExceptionTableUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public CreateExceptionTableUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            ErrorsTab.this.setCreateExceptionTable(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            ErrorsTab.this.setCreateExceptionTable(this.m_newValue);
        }
    }

    private class CreateErrorTableUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public CreateErrorTableUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            ErrorsTab.this.setCreateErrorTable(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            ErrorsTab.this.setCreateErrorTable(this.m_newValue);
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType.compareToIgnoreCase("DVR:ErrorTableReplaceChanged") == 0) {
                ErrorsTab.this.m_cbErrorTableReplace.setSelected(ErrorsTab.this.m_transform.isErrorTableReplace());
            } else if (sType.compareToIgnoreCase("DVR:ExceptionTableReplaceChanged") == 0) {
                ErrorsTab.this.m_cbExceptionTableReplace.setSelected(ErrorsTab.this.m_transform.isExceptionTableReplace());
            }
        }
    }

    private class cExceptionCheckBoxActionListener
    implements ActionListener {
        private cExceptionCheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.setDataChanged(true);
            ErrorsTab.this.m_transform.getModel().startCompoundUndoable();
            try {
                boolean bSelected = ((JCheckBox)e.getSource()).isSelected();
                ErrorsTab.this.m_btnExceptionColumns.setEnabled(bSelected);
                ErrorsTab.this.m_cbExceptionTableReplace.setEnabled(bSelected);
                if (bSelected && ErrorsTab.this.m_exceptionTable == null) {
                    ErrorsTab.this.m_exceptionTable = DataValidationUtil.createExceptionWorkTable((DataValidationTransformModel)ErrorsTab.this.m_transform);
                }
                ErrorsTab.this.m_transform.getModel().undoableEditHappened((UndoableEdit)new CreateExceptionTableUndoable(!bSelected, bSelected));
            }
            finally {
                ErrorsTab.this.m_transform.getModel().endCompoundUndoable();
            }
        }
    }

    private class cCBExceptionTableReplaceActionListener
    implements ActionListener {
        private cCBExceptionTableReplaceActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.setDataChanged(true);
            boolean bSelected = ((JCheckBox)e.getSource()).isSelected();
            ErrorsTab.this.m_transform.setExceptionTableReplace(bSelected);
        }
    }

    private class cCBErrorTableReplaceActionListener
    implements ActionListener {
        private cCBErrorTableReplaceActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.setDataChanged(true);
            boolean bSelected = ((JCheckBox)e.getSource()).isSelected();
            ErrorsTab.this.m_transform.setErrorTableReplace(bSelected);
        }
    }

    private class cErrorCheckBoxActionListener
    implements ActionListener {
        private cErrorCheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.setDataChanged(true);
            ErrorsTab.this.m_transform.getModel().startCompoundUndoable();
            try {
                boolean bSelected = ((JCheckBox)e.getSource()).isSelected();
                ErrorsTab.this.m_btnErrorColumns.setEnabled(bSelected);
                ErrorsTab.this.m_cbErrorTableReplace.setEnabled(bSelected);
                if (bSelected && ErrorsTab.this.m_errorTable == null) {
                    ErrorsTab.this.m_errorTable = DataValidationUtil.createErrorWorkTable((DataValidationTransformModel)ErrorsTab.this.m_transform);
                }
                ErrorsTab.this.m_transform.getModel().undoableEditHappened((UndoableEdit)new CreateErrorTableUndoable(!bSelected, bSelected));
            }
            finally {
                ErrorsTab.this.m_transform.getModel().endCompoundUndoable();
            }
        }
    }

    private class cChooseExceptionColumnsAction
    extends WsAbstractToggleAction {
        public cChooseExceptionColumnsAction(String sResourceKey) {
            super(bundle, sResourceKey, 0);
        }

        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.launchChooseColumnsDialog(ErrorsTab.this.m_exceptionTable, 1);
        }
    }

    private class cChooseErrorColumnsAction
    extends WsAbstractToggleAction {
        public cChooseErrorColumnsAction(String sResourceKey) {
            super(bundle, sResourceKey, 0);
        }

        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.launchChooseColumnsDialog(ErrorsTab.this.m_errorTable, 0);
        }
    }
}

