/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationCustomConditionRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomAssignEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomConditionFalseTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomConditionTrueTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationDuplicatesEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationDuplicatesTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationInvalidEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationInvalidTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationMissingEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationMissingTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableModel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class DataValidationTableViewer
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationTableViewer.class);
    private static final int UP = 0;
    private static final int DOWN = 1;
    public Configuration m_configuration;
    protected DataValidationTableModel m_DVTableModel;
    protected DataValidationTransformModel m_DVTransformModel;
    protected DataValidationRecord m_DataValidationRecord;
    public WsTable m_DV_WsTable;
    private JScrollPane m_scrollPane;
    private JToolBar m_barTools;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actEdit;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actMoveUp;
    protected WsAbstractAction m_actMoveDown;
    protected WsAbstractAction m_actUndo;
    protected WsAbstractAction m_actRedo;
    protected WsAbstractAction m_actSelectAll;
    protected cTableModelListener m_tableModelListener = new cTableModelListener();
    protected cTablePopupMenuRequestListener m_tablePopupListener = new cTablePopupMenuRequestListener();
    protected cTablePopupMenuRequestListener m_viewportPopupListener = new cTablePopupMenuRequestListener();
    protected cTableSelectionListener m_tableSelectionListener = new cTableSelectionListener();
    protected cTableRowModelListener m_tableRowModelListener = new cTableRowModelListener();
    protected String m_validationType;
    private ChangeListener m_lsnrUndo;

    public DataValidationTableViewer(DataValidationTransformModel DVTransformModel, String sValidationType) {
        this(DVTransformModel, sValidationType, null);
    }

    public DataValidationTableViewer(DataValidationTransformModel DVTransformModel, String sValidationType, DataValidationTableModel DVTableModel) {
        this(DVTransformModel, sValidationType, DVTableModel, null);
    }

    public DataValidationTableViewer(DataValidationTransformModel DVTransformModel, String sValidationType, DataValidationTableModel DVTableModel, DataValidationRecord oDVR) {
        this.m_DVTableModel = DVTableModel;
        this.m_configuration = new Configuration();
        this.m_DVTransformModel = DVTransformModel;
        this.m_validationType = sValidationType;
        this.m_DataValidationRecord = oDVR;
        this.initialize();
    }

    public void initialize() {
        this.setTitleAndHelpId();
        this.createActions();
        this.createToolBar();
        this.createModel();
        this.createTable();
        this.layoutComponents();
    }

    public void setTitleAndHelpId() {
        String helpID = "";
        if (this.m_validationType.equalsIgnoreCase("Missing")) {
            helpID = "missing_values_tab";
            this.setName(bundle.getString("DataValidation.MissingTab.title.txt"));
        } else if (this.m_validationType.equalsIgnoreCase("Duplicate")) {
            helpID = "dup_values_tab";
            this.setName(bundle.getString("DataValidation.DuplicateTab.title.txt"));
        } else if (this.m_validationType.equalsIgnoreCase("Invalid")) {
            helpID = "invalid_values_tab";
            this.setName(bundle.getString("DataValidation.InvalidTab.title.txt"));
        } else if (this.m_validationType.equalsIgnoreCase("Custom")) {
            helpID = "custom_validation_tab";
            this.setName(bundle.getString("DataValidation.CustomTab.title.txt"));
        }
        this.setHelpTopic(helpID);
    }

    private void createActions() {
        this.m_actNew = new NewDVRAction();
        this.m_actEdit = new cEditAction();
        this.m_actDelete = new cDeleteAction();
        this.m_actMoveUp = new MoveUpAction();
        this.m_actMoveDown = new MoveDownAction();
        this.m_actUndo = new UndoAction();
        this.m_actRedo = new RedoAction();
        this.m_actSelectAll = new SelectAllRowsAction();
    }

    private void createToolBar() {
        this.m_barTools = WsUIUtilities.createToolBar();
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actNew));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actEdit));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actDelete));
        this.m_barTools.addSeparator();
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveUp));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveDown));
        this.m_barTools.addSeparator();
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actUndo));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRedo));
    }

    public void createModel() {
        if (this.m_DVTableModel == null) {
            if (this.m_validationType.equalsIgnoreCase("Missing")) {
                this.m_DVTableModel = new DataValidationMissingTableModel(this.m_DVTransformModel);
            } else if (this.m_validationType.equalsIgnoreCase("Duplicate")) {
                this.m_DVTableModel = new DataValidationDuplicatesTableModel(this.m_DVTransformModel);
            } else if (this.m_validationType.equalsIgnoreCase("Invalid")) {
                this.m_DVTableModel = new DataValidationInvalidTableModel(this.m_DVTransformModel);
            } else if (this.m_validationType.equalsIgnoreCase("Custom")) {
                this.m_DVTableModel = new DataValidationCustomTableModel(this.m_DVTransformModel);
            }
            this.m_DVTableModel.moveDataToModel();
        }
    }

    private void createTable() {
        this.m_DV_WsTable = new WsTable((WsAbstractTableModel)this.m_DVTableModel);
        this.m_scrollPane = new JScrollPane((Component)this.m_DV_WsTable);
        this.m_DV_WsTable.setDefaultAction((Action)this.m_actEdit);
        this.m_DV_WsTable.setKeepSortedEnabled(true);
        this.m_DV_WsTable.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new TablePopupMenuListener());
        this.m_DV_WsTable.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)new RowHeaderPopupMenuListener());
        this.m_DV_WsTable.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new ViewportPopupMenuListener());
        this.m_DV_WsTable.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        ((WsDefaultTableRowModel)this.m_DV_WsTable.getRowModel()).addRowModelListener((WsTableRowModelListener)new RowModelListener());
        this.m_DV_WsTable.setDeleteKeyAction((Action)this.m_actDelete);
        int[] aHiddenColumns = this.m_configuration.getPermanentlyHiddenColumns();
        for (int iColumn = 0; iColumn < aHiddenColumns.length; ++iColumn) {
            this.m_DV_WsTable.removeColumn(aHiddenColumns[iColumn]);
        }
        this.m_DV_WsTable.restoreSettings(this.m_configuration.getSettingsPrefix() + ".Table");
        this.m_DV_WsTable.setAutoResizeMode(4);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.m_barTools, "North");
        this.add(this.m_scrollPane, "Center");
    }

    public boolean validateData() {
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_DV_WsTable.saveSettings(this.m_configuration.getSettingsPrefix() + ".Table");
        this.m_DVTableModel.dispose();
        IModel mdl = this.m_DVTransformModel.getModel();
        ((WsUndoManager)mdl.getUndoManager()).removeChangeListener(this.m_lsnrUndo);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_DV_WsTable.setEditable(bEditable);
        this.m_DV_WsTable.setRowsReorderable(bEditable && this.m_configuration.isRowReorderingEnabled());
        this.updateActions();
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.doDataExchange(false);
        this.setStorePopulated(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.doDataExchange(true);
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        return true;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.initializeUndo();
        this.updateActions();
    }

    public void initializeUndo() {
        if (this.m_lsnrUndo != null) {
            return;
        }
        WsUndoManager mgrUndo = (WsUndoManager)this.m_DVTransformModel.getModel().getUndoManager();
        this.m_DV_WsTable.setUndoManager((UndoManager)mgrUndo);
        this.m_lsnrUndo = new UndoManagerListener();
        mgrUndo.addChangeListener(this.m_lsnrUndo);
        this.m_actUndo.setEnabled(mgrUndo.canUndo());
        this.m_actRedo.setEnabled(mgrUndo.canRedo());
    }

    private void updateActions() {
        boolean bEditable = this.isEditable();
        boolean bNotSorted = !this.m_DV_WsTable.isSorted();
        int[] aRows = this.m_DV_WsTable.getSelectedRowsFromSelectedCells();
        boolean bOneSelected = aRows.length == 1;
        boolean bAtLeastOneSelected = aRows.length > 0;
        boolean bFirstSelected = bAtLeastOneSelected && aRows[0] == 0;
        boolean bLastSelected = bAtLeastOneSelected && aRows[aRows.length - 1] == this.m_DV_WsTable.getRowCount() - 1;
        this.m_actNew.setEnabled(bEditable && bNotSorted);
        this.m_actEdit.setEnabled(bOneSelected);
        this.m_actMoveUp.setEnabled(bEditable && bAtLeastOneSelected && bNotSorted && !bFirstSelected);
        this.m_actMoveDown.setEnabled(bEditable && bAtLeastOneSelected && bNotSorted && !bLastSelected);
        this.m_actSelectAll.setEnabled(this.m_DV_WsTable.getRowCount() > 0);
        this.m_actDelete.setEnabled(bEditable && bAtLeastOneSelected);
        this.m_DV_WsTable.setRowsReorderable(bEditable && bNotSorted && this.m_configuration.isRowReorderingEnabled());
    }

    public DataValidationTableModel getModel() {
        return this.m_DVTableModel;
    }

    public DataValidationEditPanel getEditPanel(List rowValues) {
        if (this.m_DVTransformModel.getTargetTable() == null) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationTableViewer.NoTargetTable.txt"));
            return null;
        }
        if (this.m_DVTransformModel.getTargetTable().getColumnCount() <= 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationTableViewer.NoTargetTableColumns.txt"));
            return null;
        }
        DataValidationEditPanel editPanel = null;
        if (this.m_validationType.equalsIgnoreCase("Missing")) {
            editPanel = new DataValidationMissingEditPanel(this.m_DVTransformModel, rowValues, this.isEditable());
        } else if (this.m_validationType.equalsIgnoreCase("Duplicate")) {
            editPanel = new DataValidationDuplicatesEditPanel(this.m_DVTransformModel, rowValues, this.isEditable());
        } else if (this.m_validationType.equalsIgnoreCase("Invalid")) {
            editPanel = new DataValidationInvalidEditPanel(this.m_DVTransformModel, rowValues, this.isEditable());
        } else if (this.m_validationType.equalsIgnoreCase("Custom")) {
            String sEventFQID = this.m_DVTransformModel.createNewDataValidationRecord();
            DataValidationRecord oDVR = (DataValidationRecord)rowValues.get(rowValues.size() - 1);
            if (oDVR == null) {
                oDVR = new DataValidationRecord(sEventFQID, this.m_DVTransformModel, "Custom");
            }
            editPanel = new DataValidationCustomEditPanel(this.m_DVTransformModel, rowValues, oDVR, this.isEditable());
        } else if (this.m_validationType.equalsIgnoreCase("TRUE") || this.m_validationType.equalsIgnoreCase("FALSE")) {
            editPanel = new DataValidationCustomAssignEditPanel(this.m_DVTransformModel, rowValues, this.m_DataValidationRecord, this.isEditable());
        }
        if (!this.isEditable()) {
            editPanel.setEditable(false);
        }
        return editPanel;
    }

    public void createNewValidationRecord() {
        List rowValues = this.m_DVTableModel.newRow();
        DataValidationEditPanel editPanel = this.getEditPanel(rowValues);
        if (editPanel == null) {
            return;
        }
        DataValidationRecord oTempDVR = null;
        if (editPanel instanceof DataValidationCustomEditPanel) {
            oTempDVR = ((DataValidationCustomEditPanel)editPanel).getDataValidationRecord();
        } else if (editPanel instanceof DataValidationCustomAssignEditPanel) {
            oTempDVR = ((DataValidationCustomAssignEditPanel)editPanel).getDataValidationRecord();
        } else {
            String sEventFQID = this.m_DVTransformModel.createNewDataValidationRecord();
            oTempDVR = new DataValidationRecord(sEventFQID, this.m_DVTransformModel, "TEMP");
        }
        int iRC = ModelUIUtilities.showDialog((IObject)oTempDVR, bundle.getString("DataValidation." + this.m_validationType + "Tab.title.txt"), editPanel);
        if (iRC == 1) {
            rowValues = editPanel.getRow();
            editPanel.cleanUp();
            editPanel = null;
            if (this.m_validationType.equals("TRUE") || this.m_validationType.equals("FALSE")) {
                DataValidationCustomConditionRecord oConditionRecord = (DataValidationCustomConditionRecord)rowValues.get(rowValues.size() - 1);
                oConditionRecord.setConditionType(this.m_validationType);
                DataValidationRecord parentRecord = oConditionRecord.getParentRecord();
                parentRecord.addDataValidationCustomConditionRecord(oConditionRecord);
            } else {
                DataValidationRecord oDVR = (DataValidationRecord)rowValues.get(rowValues.size() - 1);
                oDVR.setValidationType(this.m_validationType);
                this.m_DVTransformModel.addDataValidationRecord(oDVR);
            }
        }
        oTempDVR = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedDVRs() {
        if (!this.m_DV_WsTable.stopCellEditing()) {
            return;
        }
        if (this.m_validationType.equals("TRUE") || this.m_validationType.equals("FALSE")) {
            int iRow;
            int iModelRow;
            int iRow2;
            DataValidationTableModel customConditionTableModel;
            int[] aRows = this.m_DV_WsTable.getSelectedRowsFromSelectedCells();
            DataValidationCustomConditionRecord[] aCustomConditionRecords = new DataValidationCustomConditionRecord[aRows.length];
            if (this.m_validationType.equals("TRUE")) {
                customConditionTableModel = (DataValidationCustomConditionTrueTableModel)this.m_DVTableModel;
                for (iRow2 = aRows.length - 1; iRow2 >= 0; --iRow2) {
                    iModelRow = this.m_DV_WsTable.convertRowIndexToModel(aRows[iRow2]);
                    aCustomConditionRecords[iRow2] = ((DataValidationCustomConditionTrueTableModel)customConditionTableModel).getConditionForRow(iModelRow);
                }
            } else if (this.m_validationType.equals("FALSE")) {
                customConditionTableModel = (DataValidationCustomConditionFalseTableModel)this.m_DVTableModel;
                for (iRow2 = aRows.length - 1; iRow2 >= 0; --iRow2) {
                    iModelRow = this.m_DV_WsTable.convertRowIndexToModel(aRows[iRow2]);
                    aCustomConditionRecords[iRow2] = ((DataValidationCustomConditionFalseTableModel)customConditionTableModel).getConditionForRow(iModelRow);
                }
            }
            this.m_DVTransformModel.getModel().startCompoundUndoable();
            try {
                this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectConditionsUndoable(aCustomConditionRecords, true, false));
                for (iRow = 0; iRow < aCustomConditionRecords.length; ++iRow) {
                    DataValidationCustomConditionRecord oConditionRecord = aCustomConditionRecords[iRow];
                    oConditionRecord.getParentRecord().removeDataValidationCustomConditionRecord(oConditionRecord);
                }
                this.m_DVTransformModel.getModel().undoableEditHappened(this.m_DV_WsTable.createClearSelectionUndoable(true, true));
            }
            finally {
                this.m_DVTransformModel.getModel().endCompoundUndoable();
            }
            iRow = Math.min(aRows[aRows.length - 1] - (aRows.length - 1), this.m_DV_WsTable.getRowCount() - 1);
            if (iRow >= 0) {
                this.m_DV_WsTable.selectRow(iRow);
            }
        } else {
            int iRow;
            int[] aRows = this.m_DV_WsTable.getSelectedRowsFromSelectedCells();
            DataValidationRecord[] aDataValidationRecords = new DataValidationRecord[aRows.length];
            for (iRow = aRows.length - 1; iRow >= 0; --iRow) {
                int iModelRow = this.m_DV_WsTable.convertRowIndexToModel(aRows[iRow]);
                aDataValidationRecords[iRow] = this.m_DVTableModel.getDVRForRow(iModelRow);
            }
            this.m_DVTransformModel.getModel().startCompoundUndoable();
            try {
                this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectRowsUndoable(aDataValidationRecords, true, false));
                for (int iColumn = 0; iColumn < aDataValidationRecords.length; ++iColumn) {
                    this.m_DVTransformModel.removeDataValidationRecord(aDataValidationRecords[iColumn]);
                }
                this.m_DVTransformModel.getModel().undoableEditHappened(this.m_DV_WsTable.createClearSelectionUndoable(true, true));
            }
            finally {
                this.m_DVTransformModel.getModel().endCompoundUndoable();
            }
            iRow = Math.min(aRows[aRows.length - 1] - (aRows.length - 1), this.m_DV_WsTable.getRowCount() - 1);
            if (iRow >= 0) {
                this.m_DV_WsTable.selectRow(iRow);
            }
        }
    }

    public void doEditAction() {
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_DV_WsTable.getRowModel();
        this.m_DVTableModel.setRowMappings(mdlRows.getRowMappings());
        int[] selRows = this.m_DV_WsTable.getSelectedRowsFromSelectedCells();
        if (selRows.length != 1) {
            return;
        }
        int selectedRow = selRows[0];
        List rowValues = this.m_DVTableModel.getRowValues(selectedRow);
        DataValidationRecord oDVRBeforeEdit = null;
        DataValidationCustomConditionRecord oCustomConditionRecordBeforeEdit = null;
        if (rowValues.get(rowValues.size() - 1) instanceof DataValidationRecord) {
            oDVRBeforeEdit = (DataValidationRecord)rowValues.get(rowValues.size() - 1);
        } else if (rowValues.get(rowValues.size() - 1) instanceof DataValidationCustomConditionRecord) {
            oCustomConditionRecordBeforeEdit = (DataValidationCustomConditionRecord)rowValues.get(rowValues.size() - 1);
        }
        DataValidationEditPanel editPanel = this.getEditPanel(rowValues);
        int iRC = 0;
        iRC = oDVRBeforeEdit != null ? ModelUIUtilities.showDialog((IObject)oDVRBeforeEdit, bundle.getString("DataValidation." + this.m_validationType + "Tab.title.txt"), editPanel) : ModelUIUtilities.showDialog((IObject)oCustomConditionRecordBeforeEdit, bundle.getString("DataValidation." + this.m_validationType + "Tab.title.txt"), editPanel);
        if (iRC == 1) {
            String sDVRFQID = null;
            String sCustomConditionRecordFQID = null;
            if (oDVRBeforeEdit != null) {
                sDVRFQID = oDVRBeforeEdit.getID();
            }
            DataValidationRecord parentRecord = null;
            if (oCustomConditionRecordBeforeEdit != null) {
                sCustomConditionRecordFQID = oCustomConditionRecordBeforeEdit.getID();
                parentRecord = oCustomConditionRecordBeforeEdit.getParentRecord();
            }
            rowValues = editPanel.getRow(sDVRFQID, sCustomConditionRecordFQID, parentRecord);
            DataValidationRecord oDVRAfterEdit = null;
            DataValidationCustomConditionRecord oCustomConditionRecordAfterEdit = null;
            if (rowValues.get(rowValues.size() - 1) instanceof DataValidationRecord) {
                oDVRAfterEdit = (DataValidationRecord)rowValues.get(rowValues.size() - 1);
                oDVRAfterEdit.setValidationType(oDVRBeforeEdit.getValidationType());
                this.m_DVTransformModel.replaceDataValidationRecord(oDVRBeforeEdit, oDVRAfterEdit);
            } else if (rowValues.get(rowValues.size() - 1) instanceof DataValidationCustomConditionRecord) {
                oCustomConditionRecordAfterEdit = (DataValidationCustomConditionRecord)rowValues.get(rowValues.size() - 1);
                oCustomConditionRecordAfterEdit.setConditionType(oCustomConditionRecordBeforeEdit.getConditionType());
                oCustomConditionRecordAfterEdit.getParentRecord().replaceDataValidationCustomConditionRecord(oCustomConditionRecordBeforeEdit, oCustomConditionRecordAfterEdit);
            }
        }
        this.m_DV_WsTable.selectRow(selectedRow);
    }

    private void selectAllRows() {
        this.m_DV_WsTable.selectAll();
    }

    private void selectRows(DataValidationRecord[] aDVRs) {
        this.m_DV_WsTable.clearSelection();
        for (int iRecord = 0; iRecord < aDVRs.length; ++iRecord) {
            int iRow = this.m_DVTableModel.getRowIndex(aDVRs[iRecord]);
            if (iRow == -1) continue;
            this.m_DV_WsTable.addRowToSelection(this.m_DV_WsTable.convertRowIndexToView(iRow));
        }
    }

    private void selectRows(DataValidationCustomConditionRecord[] aDVRs) {
        block3: {
            block2: {
                this.m_DV_WsTable.clearSelection();
                if (!(this.m_DVTableModel instanceof DataValidationCustomConditionTrueTableModel)) break block2;
                DataValidationCustomConditionTrueTableModel model = (DataValidationCustomConditionTrueTableModel)this.m_DVTableModel;
                for (int iRecord = 0; iRecord < aDVRs.length; ++iRecord) {
                    int iRow = model.getRowIndex(aDVRs[iRecord]);
                    if (iRow == -1) continue;
                    this.m_DV_WsTable.addRowToSelection(this.m_DV_WsTable.convertRowIndexToView(iRow));
                }
                break block3;
            }
            if (!(this.m_DVTableModel instanceof DataValidationCustomConditionFalseTableModel)) break block3;
            DataValidationCustomConditionFalseTableModel model = (DataValidationCustomConditionFalseTableModel)this.m_DVTableModel;
            for (int iRecord = 0; iRecord < aDVRs.length; ++iRecord) {
                int iRow = model.getRowIndex(aDVRs[iRecord]);
                if (iRow == -1) continue;
                this.m_DV_WsTable.addRowToSelection(this.m_DV_WsTable.convertRowIndexToView(iRow));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedRows(int eDir) {
        block22: {
            if (eDir != 0 && eDir != 1) {
                throw new IllegalArgumentException("Direction must be UP or DOWN but is: " + eDir);
            }
            if (!this.m_DV_WsTable.stopCellEditing()) {
                return;
            }
            this.m_DVTransformModel.getModel().startCompoundUndoable();
            try {
                int iRow;
                int[] aRows = this.m_DV_WsTable.getSelectedRowsFromSelectedCells();
                if (this.m_DVTableModel instanceof DataValidationCustomConditionTrueTableModel) {
                    int iRow2;
                    DataValidationCustomConditionRecord[] aCustomConditionRecords = new DataValidationCustomConditionRecord[aRows.length];
                    DataValidationCustomConditionTrueTableModel customConditionTableModel = (DataValidationCustomConditionTrueTableModel)this.m_DVTableModel;
                    for (iRow2 = 0; iRow2 < aRows.length; ++iRow2) {
                        aCustomConditionRecords[iRow2] = customConditionTableModel.getConditionForRow(aRows[iRow2]);
                    }
                    this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectConditionsUndoable(aCustomConditionRecords, true, false));
                    if (eDir == 1) {
                        for (iRow2 = aRows.length - 1; iRow2 >= 0; --iRow2) {
                            DataValidationRecord dataValidationRecord = aCustomConditionRecords[iRow2].getParentRecord();
                            dataValidationRecord.moveDataValidationCustomConditionRecord(aCustomConditionRecords[iRow2], aRows[iRow2] + 1);
                        }
                    } else {
                        for (iRow2 = 0; iRow2 < aRows.length; ++iRow2) {
                            DataValidationRecord dataValidationRecord = aCustomConditionRecords[iRow2].getParentRecord();
                            dataValidationRecord.moveDataValidationCustomConditionRecord(aCustomConditionRecords[iRow2], aRows[iRow2] - 1);
                        }
                    }
                    this.selectRows(aCustomConditionRecords);
                    this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectConditionsUndoable(aCustomConditionRecords, false, true));
                    break block22;
                }
                if (this.m_DVTableModel instanceof DataValidationCustomConditionFalseTableModel) {
                    int iRow3;
                    DataValidationCustomConditionRecord[] aCustomConditionRecords = new DataValidationCustomConditionRecord[aRows.length];
                    DataValidationCustomConditionFalseTableModel customConditionTableModel = (DataValidationCustomConditionFalseTableModel)this.m_DVTableModel;
                    for (iRow3 = 0; iRow3 < aRows.length; ++iRow3) {
                        aCustomConditionRecords[iRow3] = customConditionTableModel.getConditionForRow(aRows[iRow3]);
                    }
                    this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectConditionsUndoable(aCustomConditionRecords, true, false));
                    if (eDir == 1) {
                        for (iRow3 = aRows.length - 1; iRow3 >= 0; --iRow3) {
                            DataValidationRecord dataValidationRecord = aCustomConditionRecords[iRow3].getParentRecord();
                            dataValidationRecord.moveDataValidationCustomConditionRecord(aCustomConditionRecords[iRow3], aRows[iRow3] + 1);
                        }
                    } else {
                        for (iRow3 = 0; iRow3 < aRows.length; ++iRow3) {
                            DataValidationRecord dataValidationRecord = aCustomConditionRecords[iRow3].getParentRecord();
                            dataValidationRecord.moveDataValidationCustomConditionRecord(aCustomConditionRecords[iRow3], aRows[iRow3] - 1);
                        }
                    }
                    this.selectRows(aCustomConditionRecords);
                    this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectConditionsUndoable(aCustomConditionRecords, false, true));
                    break block22;
                }
                DataValidationRecord[] aDVRs = new DataValidationRecord[aRows.length];
                for (iRow = 0; iRow < aRows.length; ++iRow) {
                    aDVRs[iRow] = this.m_DVTableModel.getDVRForRow(aRows[iRow]);
                }
                this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectRowsUndoable(aDVRs, true, false));
                if (eDir == 1) {
                    for (iRow = aRows.length - 1; iRow >= 0; --iRow) {
                        this.m_DVTableModel.moveDVR(aDVRs[iRow], aRows[iRow] + 1);
                    }
                } else {
                    for (iRow = 0; iRow < aRows.length; ++iRow) {
                        this.m_DVTableModel.moveDVR(aDVRs[iRow], aRows[iRow] - 1);
                    }
                }
                this.selectRows(aDVRs);
                this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectRowsUndoable(aDVRs, false, true));
            }
            finally {
                this.m_DVTransformModel.getModel().endCompoundUndoable();
            }
        }
    }

    private class SelectConditionsUndoable
    extends AbstractUndoableEdit {
        private DataValidationCustomConditionRecord[] m_aConditionRecords;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectConditionsUndoable(DataValidationCustomConditionRecord oDVR, boolean bOnUndo, boolean bOnRedo) {
            this(new DataValidationCustomConditionRecord[]{oDVR}, bOnUndo, bOnRedo);
        }

        public SelectConditionsUndoable(DataValidationCustomConditionRecord[] aDVRs, boolean bOnUndo, boolean bOnRedo) {
            this.m_aConditionRecords = aDVRs;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                DataValidationTableViewer.this.selectRows(this.m_aConditionRecords);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                DataValidationTableViewer.this.selectRows(this.m_aConditionRecords);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aConditionRecords, null);
            this.m_aConditionRecords = null;
        }
    }

    private class SelectRowsUndoable
    extends AbstractUndoableEdit {
        private DataValidationRecord[] m_aDVRs;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectRowsUndoable(DataValidationRecord oDVR, boolean bOnUndo, boolean bOnRedo) {
            this(new DataValidationRecord[]{oDVR}, bOnUndo, bOnRedo);
        }

        public SelectRowsUndoable(DataValidationRecord[] aDVRs, boolean bOnUndo, boolean bOnRedo) {
            this.m_aDVRs = aDVRs;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                DataValidationTableViewer.this.selectRows(this.m_aDVRs);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                DataValidationTableViewer.this.selectRows(this.m_aDVRs);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aDVRs, null);
            this.m_aDVRs = null;
        }
    }

    protected class cTableRowModelListener
    implements WsTableRowModelListener {
        protected cTableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            DataValidationTableViewer.this.setDataChanged(true);
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            DataValidationTableViewer.this.setDataChanged(true);
        }
    }

    protected class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu menuPopup = new JPopupMenu();
            menuPopup.add((Action)DataValidationTableViewer.this.m_actNew);
            menuPopup.add((Action)DataValidationTableViewer.this.m_actEdit);
            menuPopup.add((Action)DataValidationTableViewer.this.m_actDelete);
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (DataValidationTableViewer.this.isListeningForChanges()) {
                DataValidationTableViewer.this.setDataChanged(true);
            }
        }
    }

    private class RowModelListener
    implements WsTableRowModelListener {
        private RowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)DataValidationTableViewer.this.m_DV_WsTable.getRowModel();
            mdlRows.clearRowMoves();
            this.moveRow(ev.getFromIndex(), ev.getToIndex());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveRow(int iFrom, int iTo) {
            if (!DataValidationTableViewer.this.m_DV_WsTable.stopCellEditing()) {
                return;
            }
            DataValidationTableViewer.this.m_DVTransformModel.getModel().startCompoundUndoable();
            try {
                DataValidationTableViewer.this.m_DV_WsTable.clearSelection();
                DataValidationRecord oDVR = DataValidationTableViewer.this.m_DVTableModel.getDVRForRow(iFrom);
                DataValidationTableViewer.this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectRowsUndoable(oDVR, true, false));
                DataValidationTableViewer.this.m_DVTableModel.moveDVR(oDVR, iTo);
                DataValidationTableViewer.this.m_DV_WsTable.selectRow(iTo);
                DataValidationTableViewer.this.m_DVTransformModel.getModel().undoableEditHappened((UndoableEdit)new SelectRowsUndoable(oDVR, false, true));
            }
            finally {
                DataValidationTableViewer.this.m_DVTransformModel.getModel().endCompoundUndoable();
            }
        }

        public void rowsRemapped(ChangeEvent ev) {
            DataValidationTableViewer.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class ViewportPopupMenuListener
    implements WsPopupMenuRequestListener {
        private ViewportPopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actNew));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actSelectAll));
            mnuPopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class RowHeaderPopupMenuListener
    implements WsPopupMenuRequestListener {
        private RowHeaderPopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actNew));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actMoveUp));
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actMoveDown));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actSelectAll));
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actDelete));
            DataValidationTableViewer.this.m_DV_WsTable.addRowHeaderMenuItems(mnuPopup);
            WsUIUtilities.addSpaceIconToPopupMenu((JPopupMenu)mnuPopup);
            mnuPopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class TablePopupMenuListener
    implements WsPopupMenuRequestListener {
        private TablePopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actNew));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actMoveUp));
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actMoveDown));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actSelectAll));
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)DataValidationTableViewer.this.m_actDelete));
            mnuPopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            DataValidationTableViewer.this.updateActions();
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            UndoManager mgrUndo = DataValidationTableViewer.this.m_DVTransformModel.getModel().getUndoManager();
            DataValidationTableViewer.this.m_actUndo.setEnabled(mgrUndo.canUndo());
            DataValidationTableViewer.this.m_actRedo.setEnabled(mgrUndo.canRedo());
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            DataValidationTableViewer.this.m_DV_WsTable.cancelCellEditing();
        }
    }

    private class SelectAllRowsAction
    extends WsAbstractAction {
        public SelectAllRowsAction() {
            super(bundle, "ColumnsTab.Action.SelectAll", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            DataValidationTableViewer.this.selectAllRows();
        }
    }

    private class RedoAction
    extends WsAbstractAction {
        public RedoAction() {
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Redo"));
            this.setToolTipText(bundle.getString("ColumnsTab.Action.Redo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            DataValidationTableViewer.this.m_DVTransformModel.getModel().getUndoManager().redo();
        }
    }

    private class UndoAction
    extends WsAbstractAction {
        public UndoAction() {
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Undo"));
            this.setToolTipText(bundle.getString("ColumnsTab.Action.Undo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            DataValidationTableViewer.this.m_DVTransformModel.getModel().getUndoManager().undo();
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "ColumnsTab.Action.MoveDown", 2);
        }

        public void actionPerformed(ActionEvent ev) {
            DataValidationTableViewer.this.moveSelectedRows(1);
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "ColumnsTab.Action.MoveUp", 2);
        }

        public void actionPerformed(ActionEvent ev) {
            DataValidationTableViewer.this.moveSelectedRows(0);
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "DataValidationTableViewer.DeleteButton", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            DataValidationTableViewer.this.deleteSelectedDVRs();
        }
    }

    protected class cEditAction
    extends WsAbstractAction {
        public cEditAction() {
            super(bundle, "DataValidationTableViewer.EditButton", 2);
        }

        public void actionPerformed(ActionEvent e) {
            DataValidationTableViewer.this.doEditAction();
        }
    }

    private class NewDVRAction
    extends WsAbstractAction {
        public NewDVRAction() {
            super(bundle, "ColumnsTab.Action.NewColumn", 2);
        }

        public void actionPerformed(ActionEvent ev) {
            DataValidationTableViewer.this.createNewValidationRecord();
        }
    }

    public static class Configuration {
        private int[] m_aPermanentlyHiddenColumns = new int[0];
        private String m_sSettingsPrefix = "DataValidationTab";
        private boolean m_bForDialog = true;
        private boolean m_bExtraImportOptions = false;
        private boolean m_bRowReorderingEnabled = true;

        public void setPermanentlyHiddenColumns(int[] aColumnIndexes) {
            this.m_aPermanentlyHiddenColumns = aColumnIndexes;
        }

        public int[] getPermanentlyHiddenColumns() {
            return this.m_aPermanentlyHiddenColumns;
        }

        public void setSettingsPrefix(String sPrefix) {
            this.m_sSettingsPrefix = sPrefix;
        }

        public String getSettingsPrefix() {
            return this.m_sSettingsPrefix;
        }

        public void setForDialog(boolean bForDialog) {
            this.m_bForDialog = bForDialog;
        }

        public boolean isForDialog() {
            return this.m_bForDialog;
        }

        public void setExtraImportOptions(boolean bExtraImportOptions) {
            this.m_bExtraImportOptions = bExtraImportOptions;
        }

        public boolean isExtraImportOptions() {
            return this.m_bExtraImportOptions;
        }

        public void setRowReorderingEnabled(boolean bRowReorderingEnabled) {
            this.m_bRowReorderingEnabled = bRowReorderingEnabled;
        }

        public boolean isRowReorderingEnabled() {
            return this.m_bRowReorderingEnabled;
        }
    }
}

