/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationCustomConditionRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomConditionFalseTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomConditionTrueTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableViewer;
import com.sas.wadmin.visuals.common.WsExpressionTextField_ITable;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class DataValidationCustomEditPanel
extends DataValidationEditPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationCustomEditPanel.class);
    protected JLabel m_lblName;
    protected WATextField m_txtName;
    protected JLabel m_lblCondition;
    protected WsExpressionTextField_ITable m_expCondition;
    protected JPanel m_pnlTrue;
    protected DataValidationTableViewer m_dvTableViewer_True;
    protected DataValidationCustomConditionTrueTableModel m_tblTrueModel;
    protected JCheckBox m_chkTrueException;
    protected JLabel m_lblTrueAction;
    protected WAComboBox m_cmbTrueAction;
    protected DataValidationRecord m_DataValidationRecord;
    protected JPanel m_pnlFalse;
    protected DataValidationTableViewer m_dvTableViewer_False;
    protected DataValidationCustomConditionFalseTableModel m_tblFalseModel;
    protected JCheckBox m_chkFalseException;
    protected JLabel m_lblFalseAction;
    protected WAComboBox m_cmbFalseAction;
    protected boolean m_bEditable;
    protected List m_rowValues;
    protected DataValidationTransformModel m_DVTransformModel;
    protected List m_actionList;
    protected ModelList m_ModelList_TrueType;
    protected ModelList m_ModelList_FalseType;
    static final String HELP_ID = "custom_validation_win";

    public DataValidationCustomEditPanel(DataValidationTransformModel dvTransformModel, List rowValues, DataValidationRecord dataValidationRecord, boolean bEditable) {
        super(bEditable);
        this.m_DVTransformModel = dvTransformModel;
        this.m_rowValues = rowValues;
        this.m_DataValidationRecord = dataValidationRecord;
        this.m_bEditable = bEditable;
        this.setHelpTopic(HELP_ID);
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.m_txtName = new WATextField();
        this.m_txtName.setToolTipText(bundle.getString("DataValidationEditPanel.Name.tooltip.txt"));
        this.m_txtName.setMaxCharacters(60);
        this.m_lblName = new JLabel(bundle.getString("DataValidationEditPanel.Name.label.txt"));
        this.m_lblName.setLabelFor((Component)this.m_txtName);
        this.m_lblName.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Name.mnem").charAt(0));
        this.m_expCondition = new WsExpressionTextField_ITable((ITable)this.m_DVTransformModel.getTargetTable(), "");
        this.m_expCondition.setToolTipText(bundle.getString("DataValidationEditPanel.Condition.tooltip.txt"));
        this.m_lblCondition = new JLabel(bundle.getString("DataValidationEditPanel.Condition.label.txt"));
        this.m_lblCondition.setLabelFor((Component)((Object)this.m_expCondition));
        this.m_lblCondition.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Condition.mnem").charAt(0));
        this.m_pnlTrue = new JPanel();
        TitledBorder borderTrue = BorderFactory.createTitledBorder(bundle.getString("DataValidationEditPanel.TrueBox.label.txt"));
        this.m_pnlTrue.setBorder(borderTrue);
        this.m_ModelList_TrueType = (ModelList)this.m_rowValues.get(3);
        this.m_tblTrueModel = new DataValidationCustomConditionTrueTableModel(this.m_DVTransformModel, "TRUE", (List)this.m_ModelList_TrueType, this.m_DataValidationRecord);
        this.m_dvTableViewer_True = new DataValidationTableViewer(this.m_DVTransformModel, "TRUE", this.m_tblTrueModel, this.m_DataValidationRecord);
        this.m_dvTableViewer_True.setEditable(this.m_bEditable);
        Dimension dim = this.m_dvTableViewer_True.getPreferredSize();
        dim.setSize(dim.getHeight(), 150.0);
        this.m_dvTableViewer_True.setPreferredSize(dim);
        this.m_ModelList_FalseType = (ModelList)this.m_rowValues.get(2);
        this.m_tblFalseModel = new DataValidationCustomConditionFalseTableModel(this.m_DVTransformModel, "FALSE", (List)this.m_ModelList_FalseType, this.m_DataValidationRecord);
        this.m_dvTableViewer_False = new DataValidationTableViewer(this.m_DVTransformModel, "FALSE", this.m_tblFalseModel, this.m_DataValidationRecord);
        this.m_dvTableViewer_False.setEditable(this.m_bEditable);
        this.m_dvTableViewer_False.setPreferredSize(dim);
        this.m_chkTrueException = new JCheckBox(bundle.getString("DataValidationEditPanel.Exception.label.txt"));
        this.m_chkTrueException.setToolTipText(bundle.getString("DataValidationEditPanel.Exception.tooltip.txt"));
        this.m_chkTrueException.setMnemonic(bundle.getString("DataValidationEditPanel.Exception.mnem").charAt(0));
        this.m_cmbTrueAction = new WAComboBox();
        this.m_cmbTrueAction.setToolTipText(bundle.getString("DataValidationEditPanel.Custom.Action.tooltip.txt"));
        this.m_lblTrueAction = new JLabel(bundle.getString("DataValidationEditPanel.Custom.Action.label.txt"));
        this.m_lblTrueAction.setLabelFor((Component)this.m_cmbTrueAction);
        this.m_lblTrueAction.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Custom.Action.mnem").charAt(0));
        this.m_pnlFalse = new JPanel();
        TitledBorder borderFalse = BorderFactory.createTitledBorder(bundle.getString("DataValidationEditPanel.FalseBox.label.txt"));
        this.m_pnlFalse.setBorder(borderFalse);
        this.m_chkFalseException = new JCheckBox(bundle.getString("DataValidationEditPanel.Exception2.label.txt"));
        this.m_chkFalseException.setToolTipText(bundle.getString("DataValidationEditPanel.Exception.tooltip.txt"));
        this.m_chkFalseException.setMnemonic(bundle.getString("DataValidationEditPanel.Exception2.mnem").charAt(0));
        this.m_cmbFalseAction = new WAComboBox();
        this.m_cmbFalseAction.setToolTipText(bundle.getString("DataValidationEditPanel.Custom.Action.tooltip.txt"));
        this.m_lblFalseAction = new JLabel(bundle.getString("DataValidationEditPanel.Custom.Action2.label.txt"));
        this.m_lblFalseAction.setLabelFor((Component)this.m_cmbFalseAction);
        this.m_lblFalseAction.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Custom.Action2.mnem").charAt(0));
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblCondition, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)((Object)this.m_expCondition), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlTrue.setLayout(new GridBagLayout());
        this.m_pnlTrue.add((Component)((Object)this.m_dvTableViewer_True), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlTrue.add((Component)this.m_chkTrueException, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlTrue.add((Component)this.m_lblTrueAction, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlTrue.add((Component)this.m_cmbTrueAction, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_pnlTrue, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlFalse.setLayout(new GridBagLayout());
        this.m_pnlFalse.add((Component)((Object)this.m_dvTableViewer_False), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlFalse.add((Component)this.m_chkFalseException, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlFalse.add((Component)this.m_lblFalseAction, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlFalse.add((Component)this.m_cmbFalseAction, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_pnlFalse, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        return true;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_dvTableViewer_True.initializeUndo();
        this.m_dvTableViewer_False.initializeUndo();
        String name = (String)this.m_rowValues.get(0);
        if (name == null || name.trim().length() <= 0) {
            name = bundle.getString("DataValidationEditPanel.DefaultName.txt");
        }
        this.m_txtName.setText(name);
        String condition = (String)this.m_rowValues.get(1);
        this.m_expCondition.setText(condition);
        if (this.m_rowValues.get(5) != null) {
            String sExcpFlag = (String)this.m_rowValues.get(5);
            boolean bExcpFlag = false;
            if (sExcpFlag.equalsIgnoreCase("Yes")) {
                bExcpFlag = true;
            }
            this.m_chkTrueException.setSelected(bExcpFlag);
        }
        List m_metaActionList = DataValidationRecord.loadMetaActionList((String)"Custom");
        this.m_actionList = DataValidationRecord.makeActionList((List)m_metaActionList, (String)"Custom");
        this.m_cmbTrueAction.addItems(this.m_actionList);
        String trueAction = (String)this.m_rowValues.get(7);
        if (trueAction == null) {
            this.m_cmbTrueAction.setSelectedIndex(0);
        } else {
            this.m_cmbTrueAction.setSelectedItem((Object)trueAction);
        }
        if (this.m_rowValues.get(4) != null) {
            String sExcpFlag = (String)this.m_rowValues.get(4);
            boolean bExcpFlag = false;
            if (sExcpFlag.equalsIgnoreCase("Yes")) {
                bExcpFlag = true;
            }
            this.m_chkFalseException.setSelected(bExcpFlag);
        }
        this.m_cmbFalseAction.addItems(this.m_actionList);
        String falseAction = (String)this.m_rowValues.get(6);
        if (falseAction == null) {
            this.m_cmbFalseAction.setSelectedIndex(0);
        } else {
            this.m_cmbFalseAction.setSelectedItem((Object)falseAction);
        }
        this.setListeningForChanges(true);
    }

    @Override
    public boolean validateData() {
        if (this.m_txtName.getText().equals("")) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingName.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingName.Title.txt"), (int)0);
            this.m_txtName.requestFocus();
            return false;
        }
        if (this.m_expCondition.getText().equals("")) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingCondition.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingCondition.Title.txt"), (int)0);
            this.m_expCondition.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public List getRow() {
        return this.getRow(null, null, null);
    }

    @Override
    public List getRow(String oDVRFQID, String oCustomConditionRecordFQID, DataValidationRecord oParentDVR) {
        this.m_DVTransformModel.getModel().setUndoSupported(false);
        DataValidationRecord oDVR = null;
        if (oDVRFQID == null) {
            oDVR = this.getDataValidationRecord();
        } else {
            oDVR = new DataValidationRecord(oDVRFQID, this.m_DVTransformModel, "Custom");
            this.setDataValidationRecord(oDVR);
        }
        oDVR.setEvent_Name(this.m_txtName.getText());
        oDVR.setExpression(this.m_expCondition.getText());
        oDVR.createProperty_TrueExceptionChkBox_ID();
        oDVR.setPropertyTrue_PS1_Name("Action");
        oDVR.createProperty_TrueExceptionChkBox_ID();
        oDVR.set_Property_TrueExceptionChkBox_Role("Exception");
        oDVR.set_Property_TrueExceptionChkBox_Name("Exception");
        if (this.m_chkTrueException.isSelected()) {
            oDVR.set_Property_TrueExceptionChkBox_DefVal("Yes");
        } else {
            oDVR.set_Property_TrueExceptionChkBox_DefVal("No");
        }
        oDVR.createProperty_FalseExceptionChkBox_ID();
        oDVR.setPropertyTrue_PS1_Name("Action");
        oDVR.createProperty_FalseExceptionChkBox_ID();
        oDVR.set_Property_FalseExceptionChkBox_Role("Exception");
        oDVR.set_Property_FalseExceptionChkBox_Name("Exception");
        if (this.m_chkFalseException.isSelected()) {
            oDVR.set_Property_FalseExceptionChkBox_DefVal("Yes");
        } else {
            oDVR.set_Property_FalseExceptionChkBox_DefVal("No");
        }
        oDVR.createPropertyTrue_PS1_ID();
        oDVR.setPropertyTrue_PS1_Name("Action");
        oDVR.setPropertyTrue_PS1_DefVal(this.m_cmbTrueAction.getSelectedItem().toString());
        oDVR.createPropertyFalse_ID();
        oDVR.setPropertyFalse_PS1_Name("Action");
        oDVR.setPropertyFalse_PS1_DefVal(this.m_cmbFalseAction.getSelectedItem().toString());
        if (oDVR.getPropertyTrue_PS1_DefVal().equals(bundle.getString("DataValidationTableModel.Custom.ActionList.MOVE.txt")) || oDVR.getPropertyFalse_PS1_DefVal().equals(bundle.getString("DataValidationTableModel.Custom.ActionList.MOVE.txt"))) {
            oDVR.setAction(bundle.getString("DataValidationTableModel.Custom.ActionList.MOVE.txt"));
        } else {
            oDVR.setAction("");
        }
        ModelList lCustomRecordsTrue = this.getCustomRecordsFromRows(this.m_tblTrueModel.getTableRows(), true);
        oDVR.setCustomTrueTypeRecords(lCustomRecordsTrue);
        ModelList lCustomRecordsFalse = this.getCustomRecordsFromRows(this.m_tblFalseModel.getTableRows(), false);
        oDVR.setCustomFalseTypeRecords(lCustomRecordsFalse);
        ArrayList<Object> lRowValues = new ArrayList<Object>(9);
        for (int i = 0; i < 9; ++i) {
            lRowValues.add(null);
        }
        oDVR.setChanged(true);
        this.m_DVTransformModel.getModel().setUndoSupported(true);
        return DataValidationCustomTableModel.getRowValuesFromValidationRecord(oDVR, lRowValues);
    }

    private ModelList getCustomRecordsFromRows(List tableRows, boolean bTrueType) {
        ModelList lCustomRecords = this.createModelList(bTrueType);
        for (int i = 0; i < tableRows.size(); ++i) {
            List lRow = (List)tableRows.get(i);
            DataValidationCustomConditionRecord customRecord = (DataValidationCustomConditionRecord)lRow.get(lRow.size() - 1);
            customRecord.setParentRecord(this.getDataValidationRecord());
            lCustomRecords.add(lRow.get(lRow.size() - 1));
        }
        return lCustomRecords;
    }

    private ModelList createModelList(boolean bTrueType) {
        if (bTrueType) {
            return new ModelList((AbstractPersistableObject)this.m_DVTransformModel, new String[]{"DVR:CustomConditionTrueAdded", "DVR:CustomConditionTrueRemoved", "DVR:CustomConditionTrueMoved"}, 0, DataValidationCustomConditionRecord.class);
        }
        return new ModelList((AbstractPersistableObject)this.m_DVTransformModel, new String[]{"DVR:CustomConditionFalseAdded", "DVR:CustomConditionFalseRemoved", "DVR:CustomConditionFalseMoved"}, 0, DataValidationCustomConditionRecord.class);
    }

    public DataValidationRecord getDataValidationRecord() {
        return this.m_DataValidationRecord;
    }

    public void setDataValidationRecord(DataValidationRecord dataValidationRecord) {
        this.m_DataValidationRecord = dataValidationRecord;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_ModelList_TrueType != null) {
            this.m_ModelList_TrueType.clear();
        }
        if (this.m_ModelList_FalseType != null) {
            this.m_ModelList_FalseType.clear();
        }
        this.m_dvTableViewer_True = null;
        if (this.m_tblTrueModel != null) {
            this.m_tblTrueModel.dispose();
        }
        this.m_tblTrueModel = null;
        this.m_DataValidationRecord = null;
        this.m_pnlFalse = null;
        this.m_dvTableViewer_False = null;
        if (this.m_tblFalseModel != null) {
            this.m_tblFalseModel.dispose();
        }
        this.m_tblFalseModel = null;
    }
}

