/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.dataloader;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.dataloader.DataLoaderDirectiveTransformModel;
import com.sas.graphics.components.pfd.PFDStatusUtil;
import com.sas.metadata.remote.MdException;
import com.sas.table.StaticRowLabelInterface;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class DirectiveTargetPortTableModel
extends WsAbstractTableModel
implements StaticRowLabelInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(DirectiveTargetPortTableModel.class);
    private static final int VISIBLE_COLUMNS = 3;
    private static final int HIDDEN_COLUMNS = 3;
    public static final int NAME_COLUMN = 0;
    public static final int TABLE_COLUMN = 1;
    public static final int STATE_COLUMN = 2;
    public static final int PORT_COLUMN = 3;
    public static final int STATE_ICON_COLUMN = 4;
    public static final int TABLE_ICON_COLUMN = 5;
    private static final int NAME_WIDTH = 100;
    private static final int TABLE_WIDTH = 150;
    private static final int STATE_WIDTH = 100;
    private IModelListener m_lsnrModel;
    private DataLoaderDirectiveTransformModel m_model;

    public DirectiveTargetPortTableModel(DataLoaderDirectiveTransformModel model) {
        this.m_model = model;
        this.m_lsnrModel = new ModelListener();
        this.m_model.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_model.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void createColumnDefinitions() {
        WsStringTableColumn colName = new WsStringTableColumn(0, bundle.getString("DirectiveTargetPortTableModel.PortName.txt"), 100);
        WsStringTableColumn colTable = new WsStringTableColumn(1, bundle.getString("DirectiveTargetPortTableModel.PortTable.txt"), 150);
        WsStringTableColumn colState = new WsStringTableColumn(2, bundle.getString("DirectiveTargetPortTableModel.PortStatus.txt"), 100);
        WsObjectTableColumn colPort = new WsObjectTableColumn();
        WsIconTableColumn colStateIcon = new WsIconTableColumn();
        WsIconTableColumn colTableIcon = new WsIconTableColumn();
        colState.setIconColumn(4);
        colTable.setIconColumn(5);
        colName.setEditable(false);
        colTable.setEditable(false);
        colState.setEditable(false);
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = colName;
        this.m_aColumns[1] = colTable;
        this.m_aColumns[2] = colState;
        this.m_aColumns[3] = colPort;
        this.m_aColumns[4] = colStateIcon;
        this.m_aColumns[5] = colTableIcon;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getHiddenColumnCount() {
        return 3;
    }

    public String getToolTipAt(int iRow, int iColumn) {
        Object value = this.getValueAt(iRow, iColumn);
        if (value instanceof String && value != null && value.toString().length() > 0) {
            return "<html>" + value.toString().replaceAll("\\n", "<br>") + "</html>";
        }
        return null;
    }

    public void moveDataToModel() {
        this.clear();
        for (ITransformPort statement : this.m_model.getTargetPorts()) {
            if (statement.getGeneratedTable() == null) continue;
            this.m_lData.add(this.createRowValues((ITransformPort<? extends IDataObject>)statement));
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore is not supported");
    }

    public void populateStore() throws MdException, RemoteException {
        throw new UnsupportedOperationException("populateStore is not supported");
    }

    private List createRowValues(ITransformPort<? extends IDataObject> port) {
        ArrayList<Object> lValues = new ArrayList<Object>(6);
        lValues.add(port.getName());
        lValues.add(this.getTargetTableName(port));
        lValues.add(this.getStatusText(port));
        lValues.add(port);
        lValues.add(this.getStatusIcon(port));
        lValues.add(this.getTargetIcon(port));
        return lValues;
    }

    private String getStatusText(ITransformPort<? extends IDataObject> port) {
        IPhysicalTable source = this.m_model.getSourceTable();
        StringBuffer sbContent = new StringBuffer();
        if (!port.isComplete(source != null ? source.getColumns() : null)) {
            List lMessages = port.getReasonsIncomplete(source != null ? source.getColumns() : null);
            for (int iMessage = 0; iMessage < lMessages.size(); ++iMessage) {
                sbContent.append(lMessages.get(iMessage)).append("\n");
            }
        } else if (port.hasWarnings()) {
            List lMessages = port.getWarnings();
            for (int iMessage = 0; iMessage < lMessages.size(); ++iMessage) {
                sbContent.append(lMessages.get(iMessage)).append("\n");
            }
        } else {
            sbContent.append(bundle.getString("DirectiveTargetPortTableModel.Complete.txt"));
        }
        return sbContent.toString();
    }

    private Icon getStatusIcon(ITransformPort<? extends IDataObject> port) {
        IPhysicalTable source = this.m_model.getSourceTable();
        int status = 5;
        if (!port.isComplete(source != null ? source.getColumns() : null)) {
            status = 4;
        } else if (port.hasWarnings()) {
            status = 2;
        }
        return PFDStatusUtil.getSmallIcon((int)status);
    }

    private String getTargetTableName(ITransformPort<? extends IDataObject> port) {
        if (port.getObject() != null) {
            return ((IDataObject)port.getObject()).getName();
        }
        return bundle.getString("Common.None.txt");
    }

    private Icon getTargetIcon(ITransformPort<? extends IDataObject> port) {
        if (port.getObject() instanceof IWorkTable) {
            return AppIconFactory.getInstance().getIconForPrivateType("Type:WorkTable", 16);
        }
        if (port.getObject() instanceof IPhysicalTable) {
            return AppIconFactory.getInstance().getIconForSimpleObject((SimpleObject)port.getObject());
        }
        return null;
    }

    public Object getRowLabel(int iRow) {
        return null;
    }

    public Object[] getRowLabels(int iStartRow, int nRows) {
        return null;
    }

    public boolean isRowLabelsSupported() {
        return true;
    }

    public boolean isRowsLabelSupported() {
        return true;
    }

    public int getRowIndex(ITransformPort<? extends IDataObject> port) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            ITransformPort tr = (ITransformPort)lValues.get(3);
            if (tr != port) continue;
            return iRow;
        }
        return -1;
    }

    public ITransformPort<? extends IDataObject> getPortForRow(int iRow) {
        if (iRow >= 0 && iRow <= this.getRowCount() - 1) {
            return (ITransformPort)this.getValueAt(iRow, 3);
        }
        return null;
    }

    public int addPort(ITransformPort<? extends IDataObject> port) {
        int iRow = this.m_model.getTargetPorts().indexOf(port);
        this.insertRow(iRow - 1, this.createRowValues(port));
        return iRow;
    }

    public int addPortToModel(ITransformPort<? extends IDataObject> port) {
        this.m_model.addPort(false, port);
        return this.getRowIndex(port);
    }

    private int removePort(ITransformPort<? extends IDataObject> port) {
        int iRow = this.getRowIndex(port);
        this.deleteRow(iRow);
        return iRow;
    }

    public void removeSelectedTransform(int i) {
        this.removePort(this.getPortForRow(i));
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            ITransformPort port;
            int rowIndex;
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                DirectiveTargetPortTableModel.this.moveDataToModel();
            } else if (DirectiveTargetPortTableModel.this.m_model == obj) {
                if ("DataTransform.OutputAdded".equals(sType)) {
                    DirectiveTargetPortTableModel.this.addPort((ITransformPort<? extends IDataObject>)((ITransformPort)ev.getData()));
                } else if ("DataTransform.OutputRemoved".equals(sType)) {
                    DirectiveTargetPortTableModel.this.removePort((ITransformPort<? extends IDataObject>)((ITransformPort)ev.getData()));
                } else if ("DataTransform.OutputUpdated".equals(sType)) {
                    DirectiveTargetPortTableModel.this.removePort((ITransformPort<? extends IDataObject>)((ITransformPort)ev.getData()));
                    DirectiveTargetPortTableModel.this.addPort((ITransformPort<? extends IDataObject>)((ITransformPort)ev.getData()));
                }
            } else if (obj instanceof ITransformPort && (rowIndex = DirectiveTargetPortTableModel.this.getRowIndex((ITransformPort<? extends IDataObject>)(port = (ITransformPort)obj))) > -1) {
                if ("Object:NameChanged".equals(sType)) {
                    DirectiveTargetPortTableModel.this.setValueAt(port.getName(), rowIndex, 0);
                } else if ("ITransformPort:TableChanged".equals(sType)) {
                    DirectiveTargetPortTableModel.this.setValueAt(DirectiveTargetPortTableModel.this.getTargetTableName((ITransformPort<? extends IDataObject>)port), rowIndex, 1);
                    DirectiveTargetPortTableModel.this.setValueAt(DirectiveTargetPortTableModel.this.getTargetIcon((ITransformPort<? extends IDataObject>)port), rowIndex, 5);
                }
                DirectiveTargetPortTableModel.this.setValueAt(DirectiveTargetPortTableModel.this.getStatusIcon((ITransformPort<? extends IDataObject>)port), rowIndex, 4);
                DirectiveTargetPortTableModel.this.setValueAt(DirectiveTargetPortTableModel.this.getStatusText((ITransformPort<? extends IDataObject>)port), rowIndex, 2);
            }
        }
    }
}

