/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.dataloader;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.dataloader.DataLoaderDirectiveTransformModel;
import com.sas.etl.models.job.transforms.dataloader.IDirective;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.etl.DirectiveInterface;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorFilterFactory;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DataLoaderDirectiveAttributesTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(DataLoaderDirectiveAttributesTab.class);
    private DataLoaderDirectiveTransformModel m_mdlTransform;
    private IModelListener m_lsnrModel;
    private WsAbstractAction m_actSelectPackage;
    private JLabel m_lblName;
    private JLabel m_lblDescription;
    private WATextField m_txtName;
    private JScrollPane m_scrDescription;
    private WATextArea m_txtDescription;
    private JButton m_btnPackage;
    private cDirectiveFilter filter = new cDirectiveFilter();
    private WsAbstractAction m_properties;
    private WsAbstractAction m_open;

    public DataLoaderDirectiveAttributesTab(DataLoaderDirectiveTransformModel model) {
        this.setName(bundle.getString("DataLoaderDirectiveTab.Name.txt"));
        this.m_mdlTransform = model;
        this.m_lsnrModel = new DataLoaderModelListener();
        this.m_mdlTransform.getModel().addModelListener(this.m_lsnrModel);
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("dataloader_directives_tab");
    }

    public void initialize() {
        this.m_txtName = new WATextField();
        this.m_txtName.setToolTipText(bundle.getString("DataLoaderDirectiveTab.TextField.Name.ToolTip.txt"));
        this.m_txtName.setEditable(false);
        this.m_lblName = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtName, (String)bundle.getString("DataLoaderDirectiveTab.Label.Name.txt"));
        this.m_actSelectPackage = new SelectPackageAction();
        this.m_btnPackage = new JButton((Action)this.m_actSelectPackage);
        this.m_btnPackage.setPreferredSize(new Dimension(this.m_txtName.getPreferredSize().height, this.m_txtName.getPreferredSize().height));
        this.m_txtDescription = new WATextArea();
        this.m_txtDescription.setEditable(false);
        this.m_txtDescription.setMaxCharacters(200);
        this.m_txtDescription.setLineWrap(true);
        this.m_txtDescription.setWrapStyleWord(true);
        this.m_txtDescription.setRows(5);
        this.m_txtDescription.setColumns(30);
        this.m_scrDescription = new JScrollPane((Component)this.m_txtDescription, 20, 31);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrDescription);
        this.m_lblDescription = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtDescription, (String)bundle.getString("DataLoaderDirectiveTab.Label.Description.txt"));
        this.m_txtDescription.setToolTipText(bundle.getString("DataLoaderDirectiveTab.TextField.Description.ToolTip.txt"));
        this.m_properties = new cPropertiesAction();
        this.m_open = new cOpenAction();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_btnPackage, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(new JButton((Action)this.m_properties), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JButton((Action)this.m_open), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_scrDescription, new GridBagConstraints(1, 1, 5, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, 2, 5, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        try {
            if (this.m_mdlTransform.getDirective() != null) {
                this.m_txtName.setText(this.m_mdlTransform.getDirective().getName());
                this.m_txtDescription.setText(this.m_mdlTransform.getDirective().getDescription());
            }
            this.updateActions();
        }
        finally {
            this.setListeningForChanges(true);
        }
    }

    protected void updateActions() {
        boolean actionEnabled = this.isEditable() && !this.m_mdlTransform.isUsingUserWrittenCode();
        this.m_actSelectPackage.setEnabled(actionEnabled);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_mdlTransform.getModel().removeModelListener(this.m_lsnrModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleModelChanged(ModelEvent ev) {
        String type = ev.getType();
        boolean bWasListeningForChanges = this.isListeningForChanges();
        this.setListeningForChanges(false);
        try {
            if ("Directive_Changed".equals(type)) {
                if (this.m_mdlTransform.getDirective() != null) {
                    this.m_txtName.setText(this.m_mdlTransform.getDirective().getName());
                    this.m_txtDescription.setText(this.m_mdlTransform.getDirective().getDescription());
                }
                this.updateActions();
            }
        }
        finally {
            this.setListeningForChanges(bWasListeningForChanges);
        }
    }

    private class SelectPackageAction
    extends WsAbstractAction {
        public SelectPackageAction() {
            super(bundle, "DataLoaderDirectiveTab.SelectPackageAction", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            String sTitle = bundle.getString("DataLoaderDirectiveTab.PackageSelector.title.txt");
            ObjectSelectorPanel pnl = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), -1);
            pnl.setSelectionOptional(true);
            pnl.setSelectableObjectsFilter((ISimpleObjectFilter)DataLoaderDirectiveAttributesTab.this.filter);
            pnl.setVisibleObjectsFilter((ISimpleObjectFilter)DataLoaderDirectiveAttributesTab.this.filter);
            pnl.setInventoryTypesFilter(DataLoaderDirectiveAttributesTab.this.filter.getPublicTypeFilter());
            pnl.setHelpTopic("dl_select_directive");
            pnl.setAdditionalHierarchyModel(null);
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject simpleObject = pnl.getSelectedObject();
                DataLoaderDirectiveAttributesTab.this.m_mdlTransform.getModel().startCompoundUndoable();
                OMRAdapter load = null;
                try {
                    if (simpleObject != null) {
                        load = new OMRAdapter(DataLoaderDirectiveAttributesTab.this.m_mdlTransform.getModel(), Workspace.getMdFactory(), "load directive");
                        SimpleObject[] so = new SimpleObject[]{simpleObject};
                        IDirective flow = (IDirective)load.acquireObject(ObjectConverter.getInstance().convertToJOMAObject(load.getOMRStore(), so[0]));
                        DataLoaderDirectiveAttributesTab.this.m_mdlTransform.setDirective(flow);
                    } else {
                        DataLoaderDirectiveAttributesTab.this.m_mdlTransform.setDirective(null);
                    }
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                finally {
                    if (load != null) {
                        load.dispose();
                    }
                    DataLoaderDirectiveAttributesTab.this.m_mdlTransform.getModel().endCompoundUndoable();
                }
            }
        }
    }

    private static class cDirectiveFilter
    implements ISimpleObjectFilter {
        IPublicTypeFilter m_typeFilter = ObjectSelectorFilterFactory.createTypeFilter((String[])new String[]{"Directive.DL"});

        public IPublicTypeFilter getPublicTypeFilter() {
            return this.m_typeFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean accept(SimpleObject simpleObject) {
            if (!this.m_typeFilter.accept(simpleObject.getPublicType())) {
                return false;
            }
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore();
                try {
                    Root r = ObjectConverter.getInstance().convertToJOMAObject(store, simpleObject);
                    if (!(r instanceof Transformation)) return false;
                    boolean bl = ((Transformation)r).getTransformRole().equals("Directive");
                    return bl;
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return false;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            return false;
        }
    }

    private class DataLoaderModelListener
    implements IModelListener {
        private DataLoaderModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (!DataLoaderDirectiveAttributesTab.this.isListeningForChanges()) {
                return;
            }
            String type = ev.getType();
            if (type == "ModelController:UnknownChanges") {
                try {
                    DataLoaderDirectiveAttributesTab.this.moveDataToView();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                return;
            }
            IObject object = ev.getModelObject();
            if (object != DataLoaderDirectiveAttributesTab.this.m_mdlTransform) {
                return;
            }
            DataLoaderDirectiveAttributesTab.this.handleModelChanged(ev);
        }
    }

    private class cOpenAction
    extends WsAbstractAction {
        public cOpenAction() {
            super(bundle, "DataLoaderDirectiveTab.cOpenAction", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            IDirective flow = DataLoaderDirectiveAttributesTab.this.m_mdlTransform.getDirective();
            if (flow != null) {
                ChildServerInterface child = null;
                try {
                    ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                    child = server.newChild(true);
                    String key = flow.getID() + "/" + "Transformation";
                    DirectiveInterface directive = (DirectiveInterface)child.fetch(key, false);
                    URI webpage = directive.getApplicationOpenURI();
                    ModelUIUtilities.showWebpage(webpage.toString());
                }
                catch (ServiceException ex) {
                    Workspace.handleServiceException((ServiceException)ex);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
                finally {
                    try {
                        if (child != null) {
                            child.destroy();
                        }
                    }
                    catch (ServiceException ex) {
                        Workspace.handleServiceException((ServiceException)ex);
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                    }
                }
            }
        }
    }

    private class cPropertiesAction
    extends WsAbstractAction {
        public cPropertiesAction() {
            super(bundle, "DataLoaderDirectiveTab.cPropertiesAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            IDirective flow = DataLoaderDirectiveAttributesTab.this.m_mdlTransform.getDirective();
            if (flow != null) {
                AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)flow);
            }
        }
    }
}

