/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.control;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.loop.IParameterMapping;
import com.sas.etl.models.job.transforms.loop.impl.LoopTransformModel;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ParameterMappingTab2
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(ParameterMappingTab2.class);
    private static String ROW_NUMBER = bundle.getString("ParameterMappingTab2.RowNumber.txt");
    private static String NONE = bundle.getString("ParameterMappingTab2.None.txt");
    private LoopTransformModel m_transformModel;
    private WsTable m_tblMapping;
    private ParameterTableModel m_mdlMapping;
    private JScrollPane m_scrTarget;

    public ParameterMappingTab2(LoopTransformModel loopModel) {
        this.setHelpTopic("loop_params_map_tab");
        this.setName(bundle.getString("ParameterMappingPropertyTab.Title.txt"));
        this.m_transformModel = loopModel;
        this.initialize();
    }

    protected void initialize() {
        this.m_mdlMapping = this.createTableModel();
        this.m_tblMapping = this.createTable(this.m_mdlMapping);
        this.m_scrTarget = new JScrollPane((Component)this.m_tblMapping);
        this.setLayout(new GridBagLayout());
        this.add(this.m_scrTarget, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected WsTable createTable(WsAbstractTableModel tableModel) {
        WsTable table = new WsTable(tableModel);
        table.setRowHeaderVisible(false);
        table.setRowsReorderable(false);
        table.setAutoResizeMode(4);
        table.setColumnAutoResizeMode(4);
        table.restoreSettings("Loop.ParameterMapping.Table.Settings");
        return table;
    }

    protected ParameterTableModel createTableModel() {
        return new ParameterTableModel();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_mdlMapping.moveDataToModel();
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblMapping.saveSettings("Loop.ParameterMapping.Table.Settings");
        this.m_mdlMapping.dispose();
        super.saveSettingsAndCleanUp();
    }

    private class ParameterTableModel
    extends WsAbstractTableModel {
        private static final int VISIBLE_COLUMN_COUNT = 4;
        private static final int HIDDEN_COLUMN_COUNT = 2;
        public static final int PARAMETERNAME_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        public static final int DEFAULTVALUE_COLUMN = 2;
        public static final int MAPPED_COLUMN = 3;
        public static final int PARAMETER_DEFINITION_COLUMN = 4;
        public static final int PARAMETER_MAPPING_COLUMN = 5;
        private static final int NAME_COLUMN_WIDTH = 100;
        private static final int MAPPED_COLUMN_WIDTH = 250;
        private static final int DEFAULTVALUE_COLUMN_WIDTH = 100;
        private IModelListener m_lstnModel;

        public ParameterTableModel() {
            this.createColumnDefinitions();
            this.createListeners();
        }

        protected void createListeners() {
            this.m_lstnModel = new ModelListener();
            ParameterMappingTab2.this.m_transformModel.getModel().addModelListener(this.m_lstnModel);
        }

        protected void createColumnDefinitions() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("ParameterTableModel.Column.ParameterName.txt"), 100);
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ParameterTableModel.Column.MacroName.txt"), 100);
            this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("ParameterTableModel.Column.DefaultValue.txt"), 100);
            this.m_aColumns[3] = new WsEnumeratedTableColumn(3, bundle.getString("ParameterTableModel.Column.MappedColumn.txt"), 250);
            this.m_aColumns[3].setCellEditor((TableCellEditor)((Object)new ColumnNameCellEditor()));
            this.m_aColumns[3].setCellRenderer((TableCellRenderer)((Object)new ColumnNameCellRenderer()));
            this.m_aColumns[4] = new WsMetadataTableColumn();
            this.m_aColumns[5] = new WsMetadataTableColumn();
            this.m_aColumns[0].setEditable(false);
            this.m_aColumns[1].setEditable(false);
            this.m_aColumns[2].setEditable(false);
            this.m_aColumns[3].setEditable(true);
        }

        public void dispose() {
            ParameterMappingTab2.this.m_transformModel.getModel().removeModelListener(this.m_lstnModel);
        }

        public int getColumnCount() {
            return 4;
        }

        public int getHiddenColumnCount() {
            return 2;
        }

        public void moveDataToModel() throws MdException, RemoteException {
            IPromptDefinitionValue[] lstParameters;
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            if ((lstParameters = ParameterMappingTab2.this.m_transformModel.getInnerParameters()) != null) {
                for (int k = 0; k < lstParameters.length; ++k) {
                    Object columnValue;
                    ArrayList<String> attrRow = new ArrayList<String>(this.getHiddenColumnCount() + this.getColumnCount());
                    IPromptDefinitionValue param = lstParameters[k];
                    attrRow.add(param.getPromptLabel());
                    attrRow.add(param.getName());
                    Object defaultValue = "";
                    if (param.isDefaultValueSet()) {
                        defaultValue = param.getDefaultValue();
                    }
                    attrRow.add((String)defaultValue);
                    IParameterMapping mapping = ParameterMappingTab2.this.m_transformModel.getMappingForParameter(param);
                    IColumn iColumn = columnValue = mapping != null ? mapping.getSourceColumn() : null;
                    if (columnValue == null) {
                        columnValue = mapping != null && mapping.isRowNumber() ? ROW_NUMBER : NONE;
                    }
                    attrRow.add((String)columnValue);
                    attrRow.add((String)param);
                    attrRow.add((String)mapping);
                    this.m_lData.add(attrRow);
                }
            }
            if ((nRows = this.m_lData.size()) > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValueAt(Object obj, int iRow, int iColumn) {
            IParameterMapping parameterMapping = (IParameterMapping)this.getValueAt(iRow, 5);
            if (iColumn == 3) {
                IModel model = ParameterMappingTab2.this.m_transformModel.getModel();
                model.startCompoundUndoable();
                try {
                    if (parameterMapping == null) {
                        parameterMapping = ParameterMappingTab2.this.m_transformModel.createNewParameterMapping((IPromptDefinitionValue)this.getValueAt(iRow, 4));
                        this.setValueAt(parameterMapping, iRow, 5);
                    }
                    if (obj.equals(NONE)) {
                        parameterMapping.setIsRowNumber(false);
                        parameterMapping.setSourceColumn(null);
                    } else if (obj.equals(ROW_NUMBER)) {
                        parameterMapping.setIsRowNumber(true);
                        parameterMapping.setSourceColumn(null);
                    } else {
                        parameterMapping.setIsRowNumber(false);
                        parameterMapping.setSourceColumn((IColumn)obj);
                    }
                }
                finally {
                    model.endCompoundUndoable();
                }
            }
        }

        protected int getRowIndex(IParameterMapping mapping) {
            for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
                List lValues = (List)this.m_lData.get(iRow);
                if (lValues.get(5) != mapping) continue;
                return iRow;
            }
            return -1;
        }

        protected int getRowIndex(IPromptDefinitionValue definition) {
            for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
                List lValues = (List)this.m_lData.get(iRow);
                if (lValues.get(4) != definition) continue;
                return iRow;
            }
            return -1;
        }

        public IParameterMapping getMapping(int iRow) {
            return (IParameterMapping)this.getValueAt(iRow, 5);
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }

        public void populateStore() throws MdException, RemoteException {
        }

        private String getTextForValue(Object value) {
            if (value == null) {
                return NONE;
            }
            if (value instanceof IColumn) {
                IColumn col = (IColumn)value;
                return col.getName();
            }
            return value.toString();
        }

        private Icon getIconForValue(Object value) {
            if (ROW_NUMBER.equals(value)) {
                return ColumnUIUtilities.getTypeIcon(1);
            }
            if (value instanceof IColumn) {
                return ColumnUIUtilities.getTypeIcon((IColumn)value);
            }
            return null;
        }

        private List getComboItems() {
            ArrayList<String> items = new ArrayList<String>();
            items.add(NONE);
            items.add(ROW_NUMBER);
            ITable[] sources = ParameterMappingTab2.this.m_transformModel.getSourceTables();
            if (sources.length > 0) {
                ITable table = sources[0];
                IColumn[] cols = table.getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    items.add((String)cols[i]);
                }
            }
            return items;
        }

        private class ModelListener
        implements IModelListener {
            private ModelListener() {
            }

            public void modelChanged(ModelEvent ev) {
                if ("IParameterMapping:SourceColumnChanged".equals(ev.getType())) {
                    IColumn sourceColumn;
                    IParameterMapping mapping = (IParameterMapping)ev.getModelObject();
                    int row = ParameterTableModel.this.getRowIndex(mapping);
                    if (row == -1) {
                        return;
                    }
                    String value = NONE;
                    value = mapping.isRowNumber() ? ROW_NUMBER : ((sourceColumn = mapping.getSourceColumn()) == null ? NONE : sourceColumn);
                    ParameterTableModel.super.setValueAt(value, row, 3);
                } else if ("LoopTransformModel:ParameterMappingAdded".equals(ev.getType())) {
                    IParameterMapping mapping = (IParameterMapping)ev.getData();
                    IPromptDefinitionValue definition = ParameterMappingTab2.this.m_transformModel.getDefinitionForMapping(mapping);
                    if (definition != null) {
                        int row = ParameterTableModel.this.getRowIndex(definition);
                        if (row == -1) {
                            return;
                        }
                        ParameterTableModel.super.setValueAt(mapping, row, 5);
                    }
                } else if ("LoopTransformModel:ParameterMappingRemoved".equals(ev.getType())) {
                    IParameterMapping mapping = (IParameterMapping)ev.getData();
                    int row = ParameterTableModel.this.getRowIndex(mapping);
                    if (row == -1) {
                        return;
                    }
                    ParameterTableModel.super.setValueAt(null, row, 5);
                }
            }
        }

        private class ColumnNameCellRenderer
        extends WsDefaultTableCellRenderer {
            private ColumnNameCellRenderer() {
            }

            public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
                super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
                this.setIcon(ParameterTableModel.this.getIconForValue(value));
                this.setText(ParameterTableModel.this.getTextForValue(value));
                return this;
            }
        }

        private class ColumnListCellRenderer
        extends BasicComboBoxRenderer {
            private ColumnListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int arg2, boolean isSelected, boolean arg4) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setFont(list.getFont());
                this.setIcon(ParameterTableModel.this.getIconForValue(value));
                this.setText(ParameterTableModel.this.getTextForValue(value));
                return this;
            }
        }

        private class ColumnNameCellEditor
        extends WsDefaultCellEditor {
            private WAComboBox m_comboBox = new WAComboBox();

            public ColumnNameCellEditor() {
                this.m_comboBox.setRenderer((ListCellRenderer)new ColumnListCellRenderer());
                this.initialize();
            }

            protected void initialize() {
                this.m_comboBox.addItems(ParameterTableModel.this.getComboItems());
                super.initialize((JComboBox)this.m_comboBox, (WsDefaultCellEditor.cEditorDelegate)new WsDefaultCellEditor.cComboBoxDelegate((WsDefaultCellEditor)this, (JComboBox)this.m_comboBox));
            }
        }
    }
}

