/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.control;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.loop.impl.LoopTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.ParallelOptionsPanel;
import com.sas.wadmin.visuals.SASParallelMaximumConcurrentProcessesPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;

public class LoopOptionsPropertyTab2
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(LoopOptionsPropertyTab2.class);
    private LoopTransformModel m_transformModel;
    protected ParallelOptionsPanel m_pnlLoopOptions;
    private PropertyChangeListener m_lstnPanel;
    private IModelListener m_lstnModel;

    public LoopOptionsPropertyTab2(LoopTransformModel model) {
        this.m_transformModel = model;
        this.setName(bundle.getString("LoopOptionsPropertyTab.Title.txt"));
        this.setHelpTopic("loop_options_tab");
        this.createListeners();
        this.initialize();
    }

    protected void initialize() {
        this.m_pnlLoopOptions = new ParallelOptionsPanel(this.m_transformModel.getExecutionServer(), this.getHelpTopic());
        this.m_pnlLoopOptions.addPropertyChangeListener(this.m_lstnPanel);
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_pnlLoopOptions), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createListeners() {
        this.m_lstnPanel = new cPanelListener();
        this.m_lstnModel = new ModelListener();
        this.m_transformModel.getModel().addModelListener(this.m_lstnModel);
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_pnlLoopOptions.moveDataToView();
        this.m_pnlLoopOptions.setServer(this.m_transformModel.getExecutionServer());
        this.m_pnlLoopOptions.setExecuteParallel(this.m_transformModel.isExecuteInParallel());
        this.m_pnlLoopOptions.setLogOutputLocation(this.m_transformModel.getLocationOfLogAndOutputDirectory());
        this.m_pnlLoopOptions.setApplication(this.m_transformModel.getApplication());
        this.m_pnlLoopOptions.setWorkload(this.m_transformModel.getWorkload());
        this.m_pnlLoopOptions.setWaitForWhenComplete(this.m_transformModel.isWaitForProcessesToCompleteToContinue());
        this.m_pnlLoopOptions.setMaximumConcurrentSetting(this.m_transformModel.getMaximumConcurrentProcessesSetting());
        this.m_pnlLoopOptions.setAdditionalSignonOptions(this.m_transformModel.getSignonOptions());
        this.m_pnlLoopOptions.setSignonRetries(this.m_transformModel.getNumberOfSignonRetries());
        String PropTab2String = this.m_transformModel.getGridSuppJobOptions();
        this.m_pnlLoopOptions.setGridSuppJobOptions(this.m_transformModel.getGridSuppJobOptions());
        this.m_pnlLoopOptions.setUnknownStatusAsError(this.m_transformModel.isErrorOnUnknownStatus());
        this.setEditable(this.isEditable());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_transformModel.setLocationOfLogAndOutputDirectory(this.m_pnlLoopOptions.getLogOutputLocation());
        this.m_transformModel.setMaximumConcurrentProcessesSetting(this.m_pnlLoopOptions.getMaximumConcurrentSetting());
        this.m_transformModel.setSignonOptions(this.m_pnlLoopOptions.getAdditionalSignonOptions());
        this.m_transformModel.setNumberOfSignonRetries(this.m_pnlLoopOptions.getSignonRetries());
        this.m_transformModel.setGridSuppJobOptions(this.m_pnlLoopOptions.getGridSuppJobOptions());
        this.setListeningForChanges(true);
    }

    public boolean validateData() {
        return this.m_pnlLoopOptions.validateData();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_pnlLoopOptions.setEditable(editable);
    }

    public void saveSettingsAndCleanUp() {
        this.m_transformModel.getModel().removeModelListener(this.m_lstnModel);
        this.m_pnlLoopOptions.removePropertyChangeListener(this.m_lstnPanel);
        super.saveSettingsAndCleanUp();
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (ev.getModelObject() == LoopOptionsPropertyTab2.this.m_transformModel) {
                String type = ev.getType();
                if ("ITransform:ExecutionServerChanged".equals(type)) {
                    LoopOptionsPropertyTab2.this.m_pnlLoopOptions.setServer(LoopOptionsPropertyTab2.this.m_transformModel.getExecutionServer());
                } else if ("LoopTransformModel:ExecuteinParallelChanged".equals(type)) {
                    LoopOptionsPropertyTab2.this.m_pnlLoopOptions.setExecuteParallel(LoopOptionsPropertyTab2.this.m_transformModel.isExecuteInParallel());
                } else if ("LoopTransformModel:ApplicationChanged".equals(type)) {
                    LoopOptionsPropertyTab2.this.m_pnlLoopOptions.setApplication(LoopOptionsPropertyTab2.this.m_transformModel.getApplication());
                } else if ("LoopTransformModel:WorkloadChanged".equals(type)) {
                    LoopOptionsPropertyTab2.this.m_pnlLoopOptions.setWorkload(LoopOptionsPropertyTab2.this.m_transformModel.getWorkload());
                } else if ("LoopTransformModel:WaitForProcessesChanged".equals(type)) {
                    LoopOptionsPropertyTab2.this.m_pnlLoopOptions.setWaitForWhenComplete(LoopOptionsPropertyTab2.this.m_transformModel.isWaitForProcessesToCompleteToContinue());
                } else if ("LoopTransformModel:ConcurrentProcessesChanged".equals(ev.getType())) {
                    LoopOptionsPropertyTab2.this.m_pnlLoopOptions.setMaximumConcurrentSetting(LoopOptionsPropertyTab2.this.m_transformModel.getMaximumConcurrentProcessesSetting());
                } else if ("LoopTransformModel:ErrorOnUnknownStatusChanged".equals(type)) {
                    LoopOptionsPropertyTab2.this.m_pnlLoopOptions.setUnknownStatusAsError(LoopOptionsPropertyTab2.this.m_transformModel.isErrorOnUnknownStatus());
                } else if ("LoopTransformModel:LogAndOutputLocationChanged".equals(type)) {
                    LoopOptionsPropertyTab2.this.m_pnlLoopOptions.setLogOutputLocation(LoopOptionsPropertyTab2.this.m_transformModel.getLocationOfLogAndOutputDirectory());
                }
            }
        }
    }

    private class cPanelListener
    implements PropertyChangeListener {
        private cPanelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!LoopOptionsPropertyTab2.this.isListeningForChanges()) {
                return;
            }
            if (ParallelOptionsPanel.EXECUTE_PARALLEL_CHANGED.equals(ev.getPropertyName())) {
                LoopOptionsPropertyTab2.this.m_transformModel.setExecuteInParallel(((Boolean)ev.getNewValue()).booleanValue());
            } else if (ParallelOptionsPanel.APPLICATION_CHANGED.equals(ev.getPropertyName())) {
                String application = (String)ev.getNewValue();
                if (application == null || ParallelOptionsPanel.NONE.equals(application) || ParallelOptionsPanel.SELECT.equals(application)) {
                    application = "";
                }
                LoopOptionsPropertyTab2.this.m_transformModel.setApplication(application);
            } else if (ParallelOptionsPanel.WORKLOAD_CHANGED.equals(ev.getPropertyName())) {
                String workload = (String)ev.getNewValue();
                if (workload == null || ParallelOptionsPanel.NONE.equals(workload)) {
                    workload = "";
                }
                LoopOptionsPropertyTab2.this.m_transformModel.setWorkload(workload);
            } else if (ParallelOptionsPanel.WAIT_FOR_CHANGED.equals(ev.getPropertyName())) {
                LoopOptionsPropertyTab2.this.m_transformModel.setWaitForProcessesToCompleteToContinue(((Boolean)ev.getNewValue()).booleanValue());
            } else if (SASParallelMaximumConcurrentProcessesPanel.MAX_CONCURRENT_CHANGED.equals(ev.getPropertyName())) {
                LoopOptionsPropertyTab2.this.m_transformModel.setMaximumConcurrentProcessesSetting((String)ev.getNewValue());
            } else if (ParallelOptionsPanel.UNKNOWN_STATUS_IS_ERROR_CHANGED.equals(ev.getPropertyName())) {
                LoopOptionsPropertyTab2.this.m_transformModel.setErrorOnUnknownStatus(((Boolean)ev.getNewValue()).booleanValue());
            }
        }
    }
}

