/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.control;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.visuals.ParallelOptionsPanel;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.GridBagLayout;
import java.rmi.RemoteException;

public class LoopOptionsPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(LoopOptionsPropertyTab.class);
    private TransformationStep m_metadata;
    private ClassifierMap m_classifierMap;
    protected ParallelOptionsPanel m_pnlLoopOptions;
    protected static final String ITERATION_PROPERTY_SET = "ITERATION_OPTIONS";
    protected static final String EXECUTE_PROPERTY_NAME = "EXECUTEPARALLEL";
    protected static final String SIGNOFF_PROPERTY_NAME = "SIGNOFF";
    protected static final String WAITFOR_PROPERTY_NAME = "WAITFOR";
    protected static final String LOG_OUTPUT_PROPERTY_NAME = "LOGOUTPUTLOCATION";
    protected static final String APPLICATION_PROPERTY_NAME = "APPLICATION";
    protected static final String WORKLOAD_PROPERTY_NAME = "WORKLOAD";
    protected static final String MAX_CONCURRENT_PROPERTY_NAME = "MAXIMUMCONCURRENTPROCESSES";
    protected static final String ADDITIONAL_SIGNON_OPTIONS_PROPERTY_NAME = "ADDITIONALSIGNONOPTIONS";
    protected static final String SIGNON_RETRIES_PROPERTY_NAME = "SIGNONRETRIES";
    protected static final String GRID_SUPP_JOB_OPTIONS_PROPERTY_NAME = "GRIDSUPPJOBOPTIONS";
    protected static final String UNKNOWN_STATUS_ERROR_PROPERTY_NAME = "UNKNOWNSTATUSERROR";
    private static final String NONE = bundle.getString("Common.None.txt");
    private PropertyHandler m_propertyHandler;

    public LoopOptionsPropertyTab(TransformationStep metadata) {
        this.m_metadata = metadata;
        this.setHelpTopic("loop_options_tab");
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        AssociationList transList = this.m_metadata.getTransformations(false);
        if (!transList.isEmpty()) {
            this.m_classifierMap = (ClassifierMap)transList.get(0);
            this.m_propertyHandler = new PropertyHandler((Root)this.m_classifierMap, ITERATION_PROPERTY_SET, true);
            this.m_pnlLoopOptions.populateStore();
            this.setStorePopulated(true);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_pnlLoopOptions.setExecuteParallel(this.m_propertyHandler.stringToBoolean(this.m_propertyHandler.getSpecificOptionValue(EXECUTE_PROPERTY_NAME), false));
        this.m_pnlLoopOptions.setLogOutputLocation(this.m_propertyHandler.getSpecificOptionValue(LOG_OUTPUT_PROPERTY_NAME));
        this.m_pnlLoopOptions.setApplication(this.m_propertyHandler.getSpecificOptionValue(APPLICATION_PROPERTY_NAME));
        this.m_pnlLoopOptions.setWorkload(this.m_propertyHandler.getSpecificOptionValue(WORKLOAD_PROPERTY_NAME));
        this.m_pnlLoopOptions.setWaitForWhenComplete(this.m_propertyHandler.stringToBoolean(this.m_propertyHandler.getSpecificOptionValue(WAITFOR_PROPERTY_NAME), true));
        this.m_pnlLoopOptions.setMaximumConcurrentSetting(this.m_propertyHandler.getSpecificOptionValue(MAX_CONCURRENT_PROPERTY_NAME));
        this.m_pnlLoopOptions.setAdditionalSignonOptions(this.m_propertyHandler.getSpecificOptionValue(ADDITIONAL_SIGNON_OPTIONS_PROPERTY_NAME));
        String strSignonRetries = this.m_propertyHandler.getSpecificOptionValue(SIGNON_RETRIES_PROPERTY_NAME);
        int iSignonRetries = 0;
        iSignonRetries = "".equals(strSignonRetries) ? 3 : Integer.parseInt(strSignonRetries);
        this.m_pnlLoopOptions.setSignonRetries(iSignonRetries);
        this.m_pnlLoopOptions.setGridSuppJobOptions(this.m_propertyHandler.getSpecificOptionValue(GRID_SUPP_JOB_OPTIONS_PROPERTY_NAME));
        this.m_pnlLoopOptions.setUnknownStatusAsError(this.m_propertyHandler.stringToBoolean(this.m_propertyHandler.getSpecificOptionValue(UNKNOWN_STATUS_ERROR_PROPERTY_NAME), false));
        this.m_pnlLoopOptions.moveDataToView();
        this.setEditable(this.isEditable());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_pnlLoopOptions.moveDataToStore();
        this.m_propertyHandler.setSpecificProperty(EXECUTE_PROPERTY_NAME, this.m_propertyHandler.booleanToString(this.m_pnlLoopOptions.getExecuteParallel(), this.m_propertyHandler.booleanToString(false)), EXECUTE_PROPERTY_NAME, 12);
        this.m_propertyHandler.setSpecificProperty(LOG_OUTPUT_PROPERTY_NAME, this.m_pnlLoopOptions.getLogOutputLocation(), LOG_OUTPUT_PROPERTY_NAME, 12);
        String application = this.m_pnlLoopOptions.getApplication();
        if (application.equalsIgnoreCase(NONE)) {
            application = "";
        }
        this.m_propertyHandler.setSpecificProperty(APPLICATION_PROPERTY_NAME, application, APPLICATION_PROPERTY_NAME, 12);
        String workload = this.m_pnlLoopOptions.getWorkload();
        if (workload.equalsIgnoreCase(NONE)) {
            workload = "";
        }
        this.m_propertyHandler.setSpecificProperty(WORKLOAD_PROPERTY_NAME, workload, WORKLOAD_PROPERTY_NAME, 12);
        this.m_propertyHandler.setSpecificProperty(WAITFOR_PROPERTY_NAME, this.m_propertyHandler.booleanToString(this.m_pnlLoopOptions.getWaitForWhenComplete(), this.m_propertyHandler.booleanToString(true)), WAITFOR_PROPERTY_NAME, 12);
        this.m_propertyHandler.setSpecificProperty(MAX_CONCURRENT_PROPERTY_NAME, this.m_pnlLoopOptions.getMaximumConcurrentSetting(), MAX_CONCURRENT_PROPERTY_NAME, 12);
        this.m_propertyHandler.setSpecificProperty(ADDITIONAL_SIGNON_OPTIONS_PROPERTY_NAME, this.m_pnlLoopOptions.getAdditionalSignonOptions(), ADDITIONAL_SIGNON_OPTIONS_PROPERTY_NAME, 12);
        this.m_propertyHandler.setSpecificProperty(SIGNON_RETRIES_PROPERTY_NAME, Integer.toString(this.m_pnlLoopOptions.getSignonRetries()));
        this.m_propertyHandler.setSpecificProperty(GRID_SUPP_JOB_OPTIONS_PROPERTY_NAME, this.m_pnlLoopOptions.getGridSuppJobOptions(), GRID_SUPP_JOB_OPTIONS_PROPERTY_NAME, 12);
        this.m_propertyHandler.setSpecificProperty(UNKNOWN_STATUS_ERROR_PROPERTY_NAME, this.m_propertyHandler.booleanToString(this.m_pnlLoopOptions.getUnknownStatusAsError(), this.m_propertyHandler.booleanToString(false)), UNKNOWN_STATUS_ERROR_PROPERTY_NAME, 12);
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return this.m_pnlLoopOptions.validateData();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_pnlLoopOptions.setEditable(editable);
    }
}

