/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.control;

import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.TransformationActivityCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.wadmin.transforms.control.LoopColumns;
import com.sas.wadmin.transforms.control.LoopPropertyHandler;
import com.sas.wadmin.transforms.control.LoopUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.ServerSupport;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LoopCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(LoopCodegen.class);
    private static final int STARTING_COLUMN_FOR_PARAMETER_TABLE = 1;
    private static final String ERROR_ON_ANY_PROCESS_CONDITION = "Condition17";
    private static final String ABORT_REMAINING_PROCESS = "Abort Remaining Processes";
    private static final String ABORT_AFTER_LOOP = "Abort After Looping";
    private static final String ABORT_ALL_PROCESS = "Abort All Processes";
    private static final String RETURN_CODE_MACRO_CHECK = "etls_loopRCCheck";
    private static final String RETURN_CODE_MACRO_ERROR = "etls_loopRCError";
    public static final int UNKNOWN_STATUS_ERROR_RC = 99;

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        String maxProcs;
        boolean hasStandardEvents;
        ServerContext server;
        ArrayList innerSteps;
        TransformationStep tStep = (TransformationStep)classifierMap.getSteps().get(0);
        if (!LoopUtil.getNextSteps(tStep, innerSteps = new ArrayList())) {
            throw new CodegenException(bundle.getString("LoopCodegen.NoLoopEndFound.txt"));
        }
        int outerLoopCount = cgReq.getLoopCount();
        String itername = cgReq.getUniqueLoopHandleName();
        cgReq.setCurrentLoop(itername);
        cgReq.checkTargetsForExternalTable(classifierMap);
        DataTableCG sourceCG = null;
        if (!classifierMap.getClassifierSources().isEmpty()) {
            sourceCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)((DataTable)classifierMap.getClassifierSources().get(0)));
        }
        DataTableCG targetCG = cgReq.getTargetTableCG(classifierMap);
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        PropertyHandler propHandler = new PropertyHandler((Root)classifierMap, "ITERATION_OPTIONS", true);
        boolean parallelIteration = propHandler.stringToBoolean(propHandler.getSpecificOptionValue("EXECUTEPARALLEL"), false);
        String signoff = "1";
        if (!propHandler.stringToBoolean(propHandler.getSpecificOptionValue("SIGNOFF"), true)) {
            signoff = "0";
        }
        String logOutputPath = propHandler.getSpecificOptionValue("LOGOUTPUTLOCATION");
        String workload = propHandler.getSpecificOptionValue("WORKLOAD");
        String additionalSignonOptions = propHandler.getSpecificOptionValue("ADDITIONALSIGNONOPTIONS");
        String signonRetries = propHandler.getSpecificOptionValue("SIGNONRETRIES");
        String gridSuppJobOptions = propHandler.getSpecificOptionValue("GRIDSUPPJOBOPTIONS");
        String unknownStatusSetting = ".";
        if (propHandler.stringToBoolean(propHandler.getSpecificOptionValue("UNKNOWNSTATUSERROR"), false)) {
            unknownStatusSetting = Integer.toString(99);
        }
        if ((server = TransformationActivityCG.getServerForStep(tStep, cgReq.getCurrentServer())) == null) {
            server = cgReq.getAppServerContext();
        }
        if (parallelIteration) {
            cgReq.genParallelMacros(server, false);
        } else if (!cgReq.getParallelMacroStatus(server)) {
            cgReq.setGenerateCommentHeaderOnParallelMacros(false);
            cgReq.genParallelGetHandleMacro().genParallelFreeHandleMacro().genParallelCreateHandleMacro();
        }
        cgReq.setInRemoteSubmit(parallelIteration);
        cgReq.genGetParameterNamesMacro().genGetParametersMacro();
        DataTable targetTable = (DataTable)targetCG.getMetadataClass();
        ArrayList standardActions = new ArrayList();
        ArrayList abortRemainingActions = new ArrayList();
        ArrayList abortAfterLoopActions = new ArrayList();
        LoopCodegen.setupEventLists(tStep, standardActions, abortRemainingActions, abortAfterLoopActions);
        boolean bl = hasStandardEvents = !standardActions.isEmpty();
        if (hasStandardEvents) {
            LoopCodegen.genStandardActions(cgReq, standardActions, tStep);
        }
        boolean hasAbortRemainingProcessActions = !abortRemainingActions.isEmpty();
        boolean hasAbortAfterLoopActions = !abortAfterLoopActions.isEmpty();
        String loopMacroName = "etls_loop" + cgReq.getUniqueWorkTableName();
        String oneIterationMacroName = "etls_processToLoop" + cgReq.getUniqueWorkTableName();
        String jobMacroName = "etls_job" + cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("%macro ").addSourceCode(loopMacroName).addSourceCode("; \n");
        cgReq.indent();
        cgReq.addSourceCode("%local etls_filePrefix; \n");
        if (outerLoopCount > 0) {
            cgReq.addSourceCode("%let etls_filePrefix = &etls_filePrefix.&handleName.-; \n\n");
        } else {
            cgReq.addSourceCode("%let etls_filePrefix = ; \n\n");
        }
        cgReq.addRemoteMacroVariable("etls_filePrefix");
        cgReq.addSourceCode("%macro ").addSourceCode(oneIterationMacroName).addSourceCode("(parameterTable=, row=").addSourceCode(", handleName=rmt").addSourceCode(");\n");
        cgReq.indent();
        LoopColumns loopColumns = new LoopColumns();
        if (!parallelIteration) {
            cgReq.addSourceCode("%local etls_parmvars; \n").addSourceCode("%etls_getParameterNames(parameterTable=&parameterTable, \n").indent().addSourceCode("parameterVariableMacro=etls_parmvars, \n").addSourceCode("startingColumnNumber=").addSourceCode(Integer.toString(1)).addSourceCode("); \n").unIndent().addSourceCode("%local &etls_parmvars; \n");
        }
        cgReq.addSourceCode("%etls_getParameters(parameterTable=&parameterTable, row=&row, \n").indent().addSourceCode("startingColumnNumber=").addSourceCode(Integer.toString(1));
        if (parallelIteration) {
            cgReq.addSourceCode(", handleName=&handleName");
        }
        cgReq.addSourceCode("); \n").unIndent();
        cgReq.addSourceCode("%let etls_previousFilePrefix = &etls_filePrefix;\n").addSourceCode("%local etls_filePrefix; \n").addSourceCode("%let etls_filePrefix = &etls_previousFilePrefix.&handleName; \n");
        if (parallelIteration) {
            cgReq.addSourceCode("%syslput &etls_controlName = &row / remote = &handleName; \n").addSourceCode("%syslput handleName = &handleName / remote = &handleName; \n\n");
            cgReq.genRemoteMacroVariablesSetup("&handleName", true);
            cgReq.addSourceCode("rsubmit &handleName wait = no sysrputsync = yes persist = ");
            if (signoff.equals("1")) {
                cgReq.addSourceCode("no");
            } else {
                cgReq.addSourceCode("yes");
            }
            if (logOutputPath.length() > 0) {
                cgReq.addSourceCode("\n").indent().addSourceCode("log = \"&etls_logOutputPath./").addSourceCode("&etls_filePrefix..log\" \n").addSourceCode("output = \"&etls_logOutputPath./").addSourceCode("&etls_filePrefix..lst\" \n").unIndent();
            }
            cgReq.addSourceCode("; \n\n").indent();
        }
        cgReq.addSourceCode("%macro ").addSourceCode(jobMacroName).addSourceCode("; \n\n").indent();
        List parameterList = LoopUtil.getStepsParameters(innerSteps);
        LoopPropertyHandler loopHandler = new LoopPropertyHandler((Root)classifierMap, "PARAMETERPROPERTYSET", true);
        AssociationList parameterProperties = loopHandler.getPropertyList();
        HashMap outerMacroList = new HashMap(cgReq.getRemoteMacroVariablesMap());
        for (int i = 0; i < parameterList.size(); ++i) {
            String macroName = ((PromptDefinitionInterface)parameterList.get(i)).getPromptName();
            String macroKey = macroName + '.' + classifierMap.getId();
            cgReq.addRemoteMacroVariable(macroKey, macroName);
        }
        ArrayList<StringBuffer> parameterSelectList = new ArrayList<StringBuffer>();
        if (parameterProperties != null) {
            Property prop;
            int i;
            for (i = parameterProperties.size() - 1; i >= 0; --i) {
                prop = (Property)parameterProperties.get(i);
                Column col = loopHandler.getPropertyColumn(prop.getPropertyRole());
                if (col == null || sourceCG != null && ((DataTable)sourceCG.getMetadataClass()).getColumns().contains((Object)col)) continue;
                parameterProperties.remove(i);
            }
            for (i = parameterProperties.size() - 1; i >= 0; --i) {
                prop = (Property)parameterProperties.get(i);
                String propRole = prop.getPropertyRole();
                boolean found = false;
                for (int j = 0; j < parameterList.size(); ++j) {
                    if (!("OPTION." + ((PromptDefinitionInterface)parameterList.get(j)).getPromptName()).equals(propRole)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                parameterProperties.remove(i);
            }
            for (i = 0; i < parameterProperties.size(); ++i) {
                prop = (Property)parameterProperties.get(i);
                String propName = SASCodeGeneration.getRealOptionName((String)prop.getPropertyName());
                Column col = loopHandler.getPropertyColumn(prop.getPropertyRole());
                StringBuffer temp = new StringBuffer();
                if (col != null) {
                    ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
                    String sourceColName = colCG.getColumnName(cgReq, false);
                    parameterSelectList.add(temp.append(sourceColName).append(" as ").append(propName));
                    continue;
                }
                if (!prop.getDefaultValue().equalsIgnoreCase("_n_")) continue;
                parameterSelectList.add(temp.append("monotonic() as ").append(propName));
            }
            block5: for (i = 0; i < parameterProperties.size(); ++i) {
                for (int k = 0; k < parameterList.size(); ++k) {
                    if (!("OPTION." + ((PromptDefinitionInterface)parameterList.get(k)).getPromptName()).equalsIgnoreCase(((Property)parameterProperties.get(i)).getPropertyName())) continue;
                    parameterList.remove(k);
                    continue block5;
                }
            }
        }
        if (parameterList != null && !parameterList.isEmpty()) {
            for (int i = 0; i < parameterList.size(); ++i) {
                PromptDefinitionInterface attr = (PromptDefinitionInterface)parameterList.get(i);
                String strDefaultValue = LoopCodegen.getDefaultForAttribute(attr, outerMacroList, classifierMap.getId());
                StringBuffer temp = new StringBuffer();
                parameterSelectList.add(temp.append(strDefaultValue).append(" as ").append(attr.getPromptName()));
            }
        }
        String strHandleName = loopColumns.getIdColumnName(0);
        String strStatus = loopColumns.getIdColumnName(4);
        String strStartTime = loopColumns.getIdColumnName(2);
        String strMachineId = loopColumns.getIdColumnName(1);
        String strEndTime = loopColumns.getIdColumnName(3);
        String strRC = loopColumns.getIdColumnName(5);
        ArrayList serverSupSignonCache = ServerSupport.getSignonCache();
        List oldList = cgReq.getLibraryContextList("");
        String o_VVN = "";
        String o_Case = "";
        String o_SpecChar = "";
        if (parallelIteration) {
            ArrayList blankList = new ArrayList();
            cgReq.setLibraryContextList(blankList, "");
            ServerSupport.clearSignonCache();
            o_VVN = cgReq.getGlobalData("ValidVarName");
            o_Case = cgReq.getGlobalData("Case");
            o_SpecChar = cgReq.getGlobalData("SpecChar");
            cgReq.resetValidVarName();
            cgReq.addSourceCode("%sysrput etls_startTime_&handleName = %sysfunc(datetime()); \n\n");
        }
        cgReq.setGenerateParameterDefaultSetting(false);
        cgReq.setUnIndentJobCode(false);
        for (int i = 0; i < innerSteps.size(); ++i) {
            CodeGenUtil.getCodeGenClass((CMetadata)innerSteps.get(i)).codeGen(cgReq);
        }
        cgReq.setUnIndentJobCode(true);
        cgReq.setGenerateParameterDefaultSetting(true);
        if (parallelIteration) {
            ServerSupport.setSignonCache((ArrayList)serverSupSignonCache);
            cgReq.setLibraryContextList(oldList, "");
            cgReq.setGlobalData("ValidVarName", o_VVN);
            cgReq.setGlobalData("SpecChar", o_SpecChar);
            cgReq.setGlobalData("Case", o_Case);
        }
        if (parallelIteration) {
            cgReq.addSourceCode("%sysrput job_rc&handleName = &job_rc; \n");
            cgReq.addSourceCode("%sysrput etls_endTime_&handleName = %sysfunc(datetime()); \n\n");
        }
        cgReq.unIndent().addSourceCode("%mend ").addSourceCode(jobMacroName).addSourceCode("; \n\n").addSourceCode("%").addSourceCode(jobMacroName).addSourceCode("; \n\n");
        if (parallelIteration) {
            cgReq.unIndent().addSourceCode("endrsubmit;\n\n");
        } else {
            cgReq.addSourceCode("%let handleName = %etls_getHandle(statusTable=&etls_statusTable,\n").indent().addSourceCode("handleVariable=etls_handleName, row=&&&etls_controlName);\n\n").unIndent();
            cgReq.addSourceCode("%let job_rc&handleName. = &job_rc; \n\n");
            cgReq.addSourceCode("%etls_freeHandle(statusTable=&etls_statusTable, statusVariable=").addSourceCode(strStatus).addSourceCode(", \n").indent().addSourceCode("handleVariable=").addSourceCode(strHandleName).addSourceCode(", handleName=\"&handleName\", \n").addSourceCode("startTimeVariable=").addSourceCode(strStartTime).addSourceCode(", endTimeVariable=").addSourceCode(strEndTime).addSourceCode(", signoff=0, \n").addSourceCode("returnCodeVariable=").addSourceCode(strRC).addSourceCode(", returnCodeMacroVariable=job_rc&handleName., setMainJobRc=1); \n\n").unIndent();
        }
        cgReq.unIndent().addSourceCode("%mend ").addSourceCode(oneIterationMacroName).addSourceCode(";\n\n");
        cgReq.addSourceCode("%local etls_controlTable etls_statusTable etls_controlName \n").indent().addSourceCode("etls_processesRunning etls_maxProcesses etls_parameterTable \n").addSourceCode("etls_additionalSignonOptions etls_signonRetries;\n").unIndent();
        cgReq.addSourceCode("%let etls_controlName = ").addSourceCode(itername).addSourceCode("; \n");
        cgReq.addSourceCode("%let etls_statusTable = ").addSourceCode(targetCG.getDataLocation(cgReq)).addSourceCode("; \n");
        String parameterTableName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("%let etls_parameterTable = ").addSourceCode("work").addSourceCode(".").addSourceCode(parameterTableName).addSourceCode("; \n");
        if (parallelIteration) {
            cgReq.addSourceCode("%let etls_workload = ").addSourceCode(workload).addSourceCode(";\n");
            cgReq.addSourceCode("%let etls_additionalSignonOptions = ").addSourceCode(additionalSignonOptions).addSourceCode(";\n");
            cgReq.addSourceCode("%let etls_signonRetries = ").addSourceCode(signonRetries).addSourceCode(";\n");
            cgReq.addSourceCode("%let etls_gridSuppJobOptions = %nrstr(").addSourceCode(gridSuppJobOptions).addSourceCode(");\n");
        }
        cgReq.addSourceCode("%let &etls_controlName = 0;\n");
        if (sourceCG != null) {
            cgReq.addSourceCode("%let etls_controlTable = ").addSourceCode(sourceCG.getDataLocation(cgReq)).addSourceCode(";\n");
        }
        AssociationList targetColumns = targetTable.getColumns();
        AssociationList sourceColumns = null;
        ArrayList<Column> lstKeepColumns = new ArrayList<Column>();
        sourceColumns = sourceCG != null ? ((DataTable)sourceCG.getMetadataClass()).getColumns() : new ArrayList();
        for (int i = 0; i < targetColumns.size(); ++i) {
            Column col = (Column)targetColumns.get(i);
            if (LoopUtil.getSASNamedColumn((List)sourceColumns, col.getSASColumnName()) == null && !loopColumns.isLoopColumn(col.getSASColumnName())) continue;
            lstKeepColumns.add(col);
        }
        String statusKeepList = cgReq.makeColumnList(lstKeepColumns, "        ");
        cgReq.addSourceCode("\n");
        cgReq.genPercentPutStatement(bundle.getString("LoopCodegen.CreateStatusTable.sasmacro.notrans"));
        cgReq.addSourceCode("data &etls_statusTable \n");
        if (!lstKeepColumns.isEmpty()) {
            cgReq.indent().addSourceCode("(keep = ").addSourceCode(statusKeepList).addSourceCode("\n)").unIndent();
        }
        cgReq.addSourceCode(";\n").indent();
        loopColumns.genColumnCreateStatements(cgReq, (List)targetColumns);
        if (sourceCG != null) {
            cgReq.addSourceCode("set &etls_controlTable;\n");
        }
        cgReq.unIndent().addSourceCode("run;\n\n");
        cgReq.genRCSetCall("&syserr", true);
        LoopCodegen.genParameterTable(cgReq, sourceCG, parameterSelectList, parameterList, outerMacroList, classifierMap.getId());
        if (sourceCG != null) {
            cgReq.addCommentLine(bundle.getString("LoopCodegen.GetNumberOfIterations.comment.txt"));
            cgReq.addSourceCode("proc sql noprint; \n").indent().addSourceCode("select count(*) into :&etls_controlName._max from &etls_statusTable;\n").addSourceCode("%let &etls_controlName._max = &&&etls_controlName._max;\n").unIndent().addSourceCode("quit;\n\n");
            cgReq.genRCSetCall("&sqlrc", true);
        } else {
            cgReq.addSourceCode("%let &etls_controlName._max = 1; \n\n");
        }
        if (hasStandardEvents) {
            cgReq.addCommentLine(bundle.getString("LoopCodegen.SetupStatusHandlingMacros.comment.txt"));
            cgReq.addSourceCode("%do i=1 %to &&&etls_controlName._max; \n").indent().addSourceCode("%local etls_statusReported&i; \n").addSourceCode("%let etls_statusReported&i = 0; \n").unIndent().addSourceCode("%end; \n\n");
        }
        if ("".equals(maxProcs = propHandler.getSpecificOptionValue("MAXIMUMCONCURRENTPROCESSES"))) {
            maxProcs = "NNODES";
        }
        if (parallelIteration) {
            if (maxProcs.equals("NNODES")) {
                cgReq.addSourceCode("%let etls_gridInstalled =;\n").addSourceCode("%etls_tsLevel(macroName=etls_gridInstalled, featureName=uwugrdsv); \n\n").addSourceCode("%if (%str(&etls_gridInstalled) ne %str()) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%let etls_maxProcesses = %sysfunc(grdsvc_nnodes(\"").addSourceCode(cgReq.getAppServerContext().getName()).addSourceCode("\")); \n").addSourceCode("%if (&etls_maxProcesses = 0) %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(bundle.getString("LoopCodegen.NoConfiguredGridNodes.sasmacro.notrans"), "NOTE:").addSourceCode("%let etls_maxProcesses = &SYSNCPU;\n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%end; \n").addSourceCode("%else \n").addSourceCode("%do; \n").indent().genPercentPutStatement(bundle.getString("LoopCodegen.GridServiceFunctionsNotInstalled.sasmacro.notrans")).addSourceCode("%let etls_maxProcesses = &SYSNCPU;\n").unIndent().addSourceCode("%end; \n").addSourceCode("\n");
            } else if (maxProcs.equals("ALL")) {
                cgReq.addSourceCode("%let etls_maxProcesses = &etls_controlName._max; \n\n");
            } else {
                if (maxProcs.length() == 0) {
                    maxProcs = "1";
                }
                cgReq.addSourceCode("%let etls_maxProcesses = ").addSourceCode(maxProcs).addSourceCode("; \n\n");
            }
        } else {
            cgReq.addSourceCode("%let etls_maxProcesses = 1; \n\n");
        }
        if (hasAbortRemainingProcessActions) {
            cgReq.addSourceCode("%let etls_stopLoop = 0; \n\n");
        }
        cgReq.addSourceCode("%if (&etls_maxProcesses > 0) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%do %until (&&&etls_controlName ge &&&etls_controlName._max");
        if (hasAbortRemainingProcessActions) {
            cgReq.addSourceCode("\n").indent().addSourceCode("or &etls_stopLoop ne 0").unIndent();
        }
        cgReq.addSourceCode("); \n\n").indent().addSourceCode("%let etls_lastLoopPtr = &&&etls_controlName;\n\n");
        if (parallelIteration) {
            cgReq.addSourceCode("%etls_getProcessesRunning(statusTable=&etls_statusTable, statusVariable=").addSourceCode(strStatus).addSourceCode(", \n").indent().addSourceCode("processCountMacro=etls_processesRunning, statusSetting=\"").addSourceCode(bundle.getString("LoopCodegen.Status.Running.txt")).addSourceCode("\");\n\n").unIndent();
        } else {
            cgReq.addSourceCode("%let etls_processesRunning = 0; \n\n");
        }
        cgReq.addSourceCode("%do %while(&etls_processesRunning lt &&&etls_controlName._max \n").indent().addSourceCode("and &etls_processesRunning lt &etls_maxProcesses \n").addSourceCode("and &&&etls_controlName lt &&&etls_controlName._max);\n\n").unIndent().indent();
        cgReq.addSourceCode("%let &etls_controlName = %eval(&&&etls_controlName+1);\n\n");
        if (parallelIteration) {
            cgReq.addSourceCode("%global etls_signonStatus; \n");
            if (logOutputPath.trim().length() > 0) {
                cgReq.addSourceCode("%let etls_logOutputPath = " + logOutputPath + "; \n");
            }
        } else {
            cgReq.addSourceCode("%let job_rcLast=&job_rc; \n");
        }
        cgReq.addSourceCode("\n%etls_createHandle(statusTable=&etls_statusTable, statusVariable=").addSourceCode(strStatus).addSourceCode(", \n").indent().addSourceCode("handleVariable=").addSourceCode(strHandleName).addSourceCode(", handlePrefix=&etls_controlName, \n");
        if (parallelIteration && workload.length() > 0) {
            cgReq.addSourceCode("workloadMacroVariable=etls_workload, \n");
        }
        cgReq.addSourceCode("row=&&&etls_controlName, machineVariable=").addSourceCode(strMachineId).addSourceCode(", \n").addSourceCode("startTimeVariable=").addSourceCode(strStartTime);
        if (parallelIteration) {
            cgReq.addSourceCode(", cmacvar=etls_signonStatus");
            cgReq.addSourceCode(", signon=1, useGrid=1, \nadditionalSignonOptions=&etls_additionalSignonOptions, signonRetries=&etls_signonRetries);\n\n");
        } else {
            cgReq.addSourceCode(", signon=0, useGrid=0);\n\n");
        }
        cgReq.unIndent();
        if (parallelIteration) {
            cgReq.addSourceCode("%etls_getProcessesRunning(statusTable=&etls_statusTable, statusVariable=").addSourceCode(strStatus).addSourceCode(", \n").indent().addSourceCode("processCountMacro=etls_processesRunning, statusSetting=\"").addSourceCode(bundle.getString("LoopCodegen.Status.Running.txt")).addSourceCode("\");\n\n").unIndent();
        } else {
            cgReq.addSourceCode("%let etls_processesRunning = 1; \n");
        }
        String rowMacroParameter = "&&&etls_controlName";
        if (parallelIteration) {
            cgReq.addSourceCode("%if &etls_processesRunning > 0 and &etls_signonStatus ne 1 %then \n").indent();
        }
        cgReq.addSourceCode("%").addSourceCode(oneIterationMacroName).addSourceCode("(parameterTable=&etls_parameterTable, row=").addSourceCode(rowMacroParameter).addSourceCode(",").addSourceCode("\n").indent().addSourceCode("handleName=%etls_getHandle(statusTable=&etls_statusTable,\n").addSourceCode("handleVariable=").addSourceCode(strHandleName).addSourceCode(", row=").addSourceCode(rowMacroParameter).addSourceCode(")").unIndent().addSourceCode("); \n");
        if (parallelIteration) {
            cgReq.unIndent().addSourceCode("%else \n").addSourceCode("%do; /* if signon error, set iterator to max to force loop to stop. */ \n").indent().addSourceCode("%let &etls_controlName = &&&etls_controlName._max; \n").genPercentPutStatement(bundle.getString("LoopCodegen.ParallelProcessStartupFailed.sasmacro.notrans"), "ERROR%QUOTE(:)").unIndent().addSourceCode("%end; \n");
        } else {
            cgReq.addSourceCode("\n/* Reset main Job_RC and Trans_RC to max return code of all iterations */ \n").addSourceCode("%let job_rcThisIter=&job_rc; \n").addSourceCode("%let job_rc=&job_rcLast; \n").addSourceCode("%let trans_rc=&job_rcLast; \n").addSourceCode("%rcSet(&job_rcThisIter); \n");
        }
        if (!parallelIteration && hasStandardEvents) {
            cgReq.addSourceCode("\n");
            LoopCodegen.genRCErrorCall(cgReq, strRC, "&&&etls_controlName");
        }
        cgReq.unIndent().addSourceCode("%end; \n\n");
        if (parallelIteration && !maxProcs.equals("ALL")) {
            cgReq.addSourceCode("%etls_waitFor(statusTable=&etls_statusTable, statusVariable=").addSourceCode(strStatus).addSourceCode(", \n").indent().addSourceCode("runningStatusSetting=\"").addSourceCode(bundle.getString("LoopCodegen.Status.Running.txt")).addSourceCode("\", handleVariable=").addSourceCode(strHandleName).addSourceCode(", \n").addSourceCode("completeStatusSetting=\"").addSourceCode(bundle.getString("LoopCodegen.Status.Finished.txt")).addSourceCode("\", endTimeVariable=").addSourceCode(strEndTime).addSourceCode(", \n").addSourceCode("startTimeVariable=").addSourceCode(strStartTime).addSourceCode(", waitType=_ANY_, signoff=").addSourceCode(signoff).addSourceCode(", \n").addSourceCode("returnCodeVariable=").addSourceCode(strRC).addSourceCode(", \n").addSourceCode("statusUnknownReturnCode=").addSourceCode(unknownStatusSetting).addSourceCode("); \n\n").unIndent();
            if (hasStandardEvents) {
                LoopCodegen.genRCErrorCall(cgReq, strRC);
            }
        }
        if (hasAbortRemainingProcessActions) {
            cgReq.addSourceCode("%if (&job_rc ge 5) %then \n").indent().addSourceCode("%let etls_stopLoop = 1; \n\n").unIndent();
        }
        cgReq.unIndent().addSourceCode("%end; \n\n");
        if (parallelIteration && propHandler.stringToBoolean(propHandler.getSpecificOptionValue("WAITFOR"), true)) {
            cgReq.addSourceCode("%etls_waitFor(statusTable=&etls_statusTable, statusVariable=").addSourceCode(strStatus).addSourceCode(", \n").indent().addSourceCode("runningStatusSetting=\"").addSourceCode(bundle.getString("LoopCodegen.Status.Running.txt")).addSourceCode("\", handleVariable=").addSourceCode(strHandleName).addSourceCode(", \n").addSourceCode("completeStatusSetting=\"").addSourceCode(bundle.getString("LoopCodegen.Status.Finished.txt")).addSourceCode("\", endTimeVariable=").addSourceCode(strEndTime).addSourceCode(", \n").addSourceCode("startTimeVariable=").addSourceCode(strStartTime).addSourceCode(", waitType=_ALL_, signoff=").addSourceCode(signoff).addSourceCode(", \n").addSourceCode("returnCodeVariable=").addSourceCode(strRC).addSourceCode(", \n").addSourceCode("statusUnknownReturnCode=").addSourceCode(unknownStatusSetting).addSourceCode("); \n\n").unIndent();
            if (hasStandardEvents) {
                LoopCodegen.genRCErrorCall(cgReq, strRC);
            }
        }
        cgReq.unIndent().addSourceCode("%end;\n\n").genTableDelete(parameterTableName);
        cgReq.unIndent().addSourceCode("%mend ").addSourceCode(loopMacroName).addSourceCode("; \n\n").addSourceCode("%").addSourceCode(loopMacroName).addSourceCode("; \n\n");
        if (hasAbortAfterLoopActions) {
            String loopEndRcMacroName = "etls_loopEndRcChk";
            cgReq.addSourceCode("%macro ").addSourceCode(loopEndRcMacroName).addSourceCode("; \n").indent().addSourceCode("%if (&job_rc ge 5) %then \n").addSourceCode("%do; \n").indent();
            for (int i = 0; i < abortAfterLoopActions.size(); ++i) {
                Property prop = (Property)abortAfterLoopActions.get(i);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(prop, (AbstractTransformation)tStep));
            }
            cgReq.unIndent().addSourceCode("%end; \n\n").unIndent().addSourceCode("%mend ").addSourceCode(loopEndRcMacroName).addSourceCode("; \n\n").addSourceCode("%").addSourceCode(loopEndRcMacroName).addSourceCode("; \n\n");
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        HashMap cgReqMap = cgReq.getRemoteMacroVariablesMap();
        Set keys = cgReqMap.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String nextMacro = iter.next().toString();
            String[] macro = nextMacro.split("\\.");
            String metaId = "";
            if (macro.length <= 1 || !(metaId = macro[1] + '.' + macro[2]).equalsIgnoreCase(classifierMap.getId())) continue;
            toRemove.add(nextMacro);
        }
        toRemove.add("ETLS_FILEPREFIX");
        for (int i = 0; i < toRemove.size(); ++i) {
            cgReqMap.remove(toRemove.get(i).toString());
        }
        cgReq.endCurrentLoop();
    }

    private static void genParameterTable(CodegenRequest cgReq, DataTableCG sourceCG, List parameterSelectList, List attrList, HashMap outerMacros, String classifierId) throws MdException, RemoteException {
        cgReq.genPercentPutStatement(bundle.getString("LoopCodegen.CreateParameterTable.sasmacro.notrans"));
        if (sourceCG != null && !parameterSelectList.isEmpty()) {
            cgReq.addSourceCode("proc sql; \n").indent().addSourceCode("create table &etls_parameterTable as \n").indent();
            for (int i = 0; i < parameterSelectList.size(); ++i) {
                if (i == 0) {
                    cgReq.addSourceCode("select ");
                } else {
                    cgReq.addSourceCode("       ");
                }
                cgReq.addSourceCode(parameterSelectList.get(i).toString());
                if (i != parameterSelectList.size() - 1) {
                    cgReq.addSourceCode(", \n");
                    continue;
                }
                cgReq.addSourceCode(" \n");
            }
            cgReq.addSourceCode("from &etls_controlTable; \n");
            cgReq.unIndent().unIndent().addSourceCode("quit; \n\n");
            cgReq.genRCSetCall("&sqlrc", true);
        } else {
            cgReq.addSourceCode("data &etls_parameterTable; \n").indent();
            for (int i = 0; i < attrList.size(); ++i) {
                PromptDefinitionInterface attr = (PromptDefinitionInterface)attrList.get(i);
                String defaultValue = LoopCodegen.getDefaultForAttribute(attr, outerMacros, classifierId);
                cgReq.addSourceCode(attr.getPromptName()).addSourceCode(" = ").addSourceCode(defaultValue).addSourceCode("; \n");
            }
            cgReq.unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr", true);
        }
    }

    private static void genRCErrorCall(CodegenRequest cgReq, String strRC) throws MdException, RemoteException {
        LoopCodegen.genRCErrorCall(cgReq, strRC, "%eval(&etls_lastLoopPtr+1)");
    }

    private static void genRCErrorCall(CodegenRequest cgReq, String strRC, String start) throws MdException, RemoteException {
        cgReq.addSourceCode("%").addSourceCode(RETURN_CODE_MACRO_CHECK).addSourceCode("(statusTable=&etls_statusTable, returnCodeVariable=").addSourceCode(strRC).addSourceCode(", \n").indent().addSourceCode("start=").addSourceCode(start).addSourceCode(",end=&&&etls_controlName); \n").unIndent();
    }

    private static void genStandardActions(CodegenRequest cgReq, List standardActions, TransformationStep step) throws MdException, RemoteException {
        cgReq.addCommentLine(bundle.getString("LoopCodegen.LoopReturnCodeCheck.msg.txt")).addSourceCode("%macro ").addSourceCode(RETURN_CODE_MACRO_CHECK).addSourceCode("(statusTable=, returnCodeVariable=,start=,end=); \n").indent();
        cgReq.addSourceCode("%macro ").addSourceCode(RETURN_CODE_MACRO_ERROR).addSourceCode("(_iteration); \n").indent();
        for (int iAction = 0; iAction < standardActions.size(); ++iAction) {
            Property oAction = (Property)standardActions.get(iAction);
            cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)step));
        }
        cgReq.unIndent().addSourceCode("%mend ").addSourceCode(RETURN_CODE_MACRO_ERROR).addSourceCode("; \n\n");
        cgReq.addSourceCode("%local etls_rows etls_dsid rc etls_varnum;\n\n");
        cgReq.addSourceCode("%let etls_rows = 0; \n").addSourceCode("proc sql noprint; \n").indent().addSourceCode("select count(*) into :etls_rows from &statusTable; \n").unIndent().addSourceCode("quit; \n\n");
        cgReq.addSourceCode("%if &start le &etls_rows %then \n").addSourceCode("%do; \n").indent().addSourceCode("%let etls_dsid = %sysfunc(open(&statusTable)); \n").addSourceCode("%if (&etls_dsid = 0) %then \n").indent().addSourceCode("%put %sysfunc(sysmsg()); \n").unIndent().addSourceCode("%else \n").addSourceCode("%do; \n").indent().addSourceCode("%do i=&start %to &end; \n").indent().addSourceCode("%let rc = %sysfunc(fetchobs(&etls_dsid, &i)); \n").addSourceCode("%if (&rc ne 0) %then \n").indent().addSourceCode("%put %sysfunc(sysmsg()); \n").unIndent().addSourceCode("%else \n").addSourceCode("%do; \n").indent().addSourceCode("%let etls_varnum = %sysfunc(varnum(&etls_dsid,&returnCodeVariable)); \n").addSourceCode("%if (&etls_varnum > 0) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%if ((%sysfunc(getvarn(&etls_dsid,&etls_varnum)) ge 5) and \n").addSourceCode("     (&&etls_statusReported&i eq 0)) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%etls_loopRCError(&i); \n").addSourceCode("%let etls_statusReported&i = 1; \n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%end; \n").addSourceCode("%else \n").indent().addSourceCode("%put %sysfunc(sysmsg()); \n").unIndent().unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%end; \n").addSourceCode("%let rc = %sysfunc(close(&etls_dsid)); \n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%end; \n");
        cgReq.unIndent().addSourceCode("%mend ").addSourceCode(RETURN_CODE_MACRO_CHECK).addSourceCode("; \n\n");
    }

    public static void setupEventLists(TransformationStep step, List standardActions, List abortRemainingActions, List abortAfterLoopActions) throws MdException, RemoteException {
        AssociationList alTriggeredEvents = step.getTriggeredEvents();
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event oEvent = (Event)alTriggeredEvents.get(iEvent);
            if (oEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("LoopCodegen.NoPropertySets.msg.txt"));
            }
            if (!oEvent.getEventRole().equals(ERROR_ON_ANY_PROCESS_CONDITION)) continue;
            PropertySet oTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(oEvent, true);
            AssociationList alTrueProperties = oTruePropertySet.getSetProperties();
            for (int iAction = 0; iAction < alTrueProperties.size(); ++iAction) {
                Property oAction = (Property)alTrueProperties.get(iAction);
                if (oAction.getPropertyName().equals(ABORT_REMAINING_PROCESS)) {
                    abortRemainingActions.add(oAction);
                    continue;
                }
                if (oAction.getPropertyName().equals(ABORT_AFTER_LOOP)) {
                    abortAfterLoopActions.add(oAction);
                    continue;
                }
                standardActions.add(oAction);
            }
        }
        ArrayList<Property> abortlist = new ArrayList<Property>();
        for (int i = standardActions.size() - 1; i >= 0; --i) {
            Property action = (Property)standardActions.get(i);
            if (!action.getPropertyName().equals(ABORT_ALL_PROCESS)) continue;
            abortlist.add(0, action);
            standardActions.remove(action);
        }
        standardActions.addAll(abortlist);
    }

    private static String findMacro(HashMap outerMacros, String currentClassifierId, String attrName) {
        String key = null;
        Set keys = outerMacros.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String nextMacro = iter.next().toString();
            String[] macro = nextMacro.split("\\.");
            String metaId = "";
            if (macro.length > 1) {
                metaId = macro[1] + '.' + macro[2];
            }
            if (!macro[0].equalsIgnoreCase(attrName) || currentClassifierId.equalsIgnoreCase(metaId)) continue;
            key = nextMacro;
            break;
        }
        return key;
    }

    private static String getDefaultForAttribute(PromptDefinitionInterface attr, HashMap outerMacros, String currentClassifierId) {
        String strDefaultValue = "";
        String attrName = attr.getPromptName();
        String macroKey = LoopCodegen.findMacro(outerMacros, currentClassifierId, attrName);
        if (macroKey != null) {
            strDefaultValue = "symget(\"" + outerMacros.get(macroKey) + "\")";
        } else {
            Object defaultValue = "";
            if (attr.isDefaultValueSet()) {
                defaultValue = attr.getDefaultValue();
            }
            strDefaultValue = "\"" + (defaultValue != null ? defaultValue.toString() : "") + "\"";
        }
        return strDefaultValue;
    }
}

