/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.comparetables;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.transforms.comparetables.ICompareTables;
import com.sas.etl.models.job.transforms.comparetables.ICompareTablesTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.wadmin.transforms.comparetables.CompareTablesSourceColumnsModel;
import com.sas.wadmin.transforms.scd.ColumnSelectorPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.dualselector.DefaultSelectorTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class CompareTablesTargetTableModel
extends DefaultSelectorTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(CompareTablesSourceColumnsModel.class);
    protected static final int SOURCE_COL_NAME = 0;
    protected static final int COMPARE_COL_NAME = 1;
    protected static final int SOURCE_COL = 2;
    protected static final int COMPARE_COL = 3;
    protected static final int MAPPING_COL = 4;
    protected static final int COLUMNS_IN_TABLE = 5;
    protected int HIDDEN_COLUMNS = 3;
    private ICompareTablesTransformModel m_compareModel;
    private ICompareTables m_compare;
    private ModelListener m_lsnrModel;
    private int numberOfColumns;

    public CompareTablesTargetTableModel(ICompareTablesTransformModel compareModel) {
        this.m_compareModel = compareModel;
        this.m_compare = this.m_compareModel.getCompareTablesObject();
        this.m_aColumns = new WsAbstractTableColumn[5];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("CompareTablesTargetTableModel.SourceColumnName.txt"), 100);
        this.m_aColumns[1] = new ButtonTableColumn(1, bundle.getString("CompareTablesTargetTableModel.TargetColumnName.txt"), 100);
        this.m_aColumns[2] = new WsObjectTableColumn();
        this.m_aColumns[3] = new WsObjectTableColumn();
        this.m_aColumns[4] = new WsObjectTableColumn();
        this.m_aColumns[0].setEditable(false);
        this.numberOfColumns = this.m_aColumns.length;
        this.m_lsnrModel = new ModelListener();
        this.m_compareModel.getModel().addModelListener((IModelListener)this.m_lsnrModel);
        boolean b_compareToDigest = this.m_compare.compareToDigestColumn();
        this.HIDDEN_COLUMNS = b_compareToDigest ? 4 : 3;
    }

    public void dispose() {
        this.m_compareModel.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    public ICompareTables getCompareTablesModel() {
        return this.m_compare;
    }

    public int getColumnCount() {
        return this.m_aColumns.length - this.HIDDEN_COLUMNS;
    }

    protected List createRowValues(Object obj, int iRow) {
        if (obj instanceof IColumn) {
            IColumn oColumn = (IColumn)obj;
            ArrayList<String> lRowValues = new ArrayList<String>();
            lRowValues.add(oColumn.getName());
            lRowValues.add(null);
            lRowValues.add((String)oColumn);
            lRowValues.add(null);
            return lRowValues;
        }
        if (obj instanceof IMapping) {
            IMapping oMap = (IMapping)obj;
            ArrayList<String> lRowValues = new ArrayList<String>();
            IColumn sCol = null;
            IColumn[] sCols = oMap.getSources();
            if (sCols != null && sCols.length > 0) {
                sCol = sCols[0];
                lRowValues.add(sCol.getName());
            } else {
                lRowValues.add(null);
            }
            IColumn tCol = null;
            IColumn[] tCols = oMap.getTargets();
            if (tCols != null && tCols.length > 0) {
                tCol = tCols[0];
                lRowValues.add(tCol.getName());
            } else {
                lRowValues.add(null);
            }
            lRowValues.add((String)sCol);
            lRowValues.add((String)tCol);
            lRowValues.add((String)oMap);
            return lRowValues;
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    protected List createRowValues(Object obj) {
        return this.createRowValues(obj, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(Object obj) {
        if (obj instanceof List) {
            Object col = ((List)obj).get(1);
            this.m_compare.getModel().startCompoundUndoable();
            try {
                IMapping newMap = this.m_compare.addNewCompareColumnsMapping((IColumn)col, false);
                if (this.getMappingRowIndex(newMap) < 0) {
                    this.insertRow(this.getRowCount() - 1, this.createRowValues(newMap));
                }
            }
            finally {
                this.m_compare.getModel().endCompoundUndoable();
            }
        }
    }

    public void moveDataToModel() {
        super.clear();
        IMapping[] mkMappings = this.m_compare.getCompareColumnsMappings();
        for (int i = 0; i < mkMappings.length; ++i) {
            IMapping mkMap = mkMappings[i];
            ArrayList<String> row = new ArrayList<String>();
            IColumn sCol = null;
            IColumn[] sCols = mkMap.getSources();
            if (sCols != null && sCols.length > 0) {
                sCol = sCols[0];
                row.add(sCol.getName());
            } else {
                row.add(null);
            }
            IColumn tCol = null;
            IColumn[] tCols = mkMap.getTargets();
            if (tCols != null && tCols.length > 0) {
                tCol = tCols[0];
                row.add(tCol.getName());
            } else {
                row.add(null);
            }
            row.add((String)sCol);
            row.add((String)tCol);
            row.add((String)mkMap);
            this.m_lData.add(row);
            ++this.m_nRowInstances;
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public Object getRow(int iRow) {
        if (iRow > this.getRowCount() - 1) {
            return null;
        }
        String sSourceColName = (String)this.getValueAt(iRow, 0);
        String sTargetColName = (String)this.getValueAt(iRow, 1);
        IColumn oSourceColumn = (IColumn)this.getValueAt(iRow, 2);
        IColumn oTargetColumn = (IColumn)this.getValueAt(iRow, 3);
        IMapping oMapping = (IMapping)this.getValueAt(iRow, 4);
        ArrayList<String> lRowValues = new ArrayList<String>();
        lRowValues.add(sSourceColName);
        lRowValues.add(sTargetColName);
        lRowValues.add((String)oSourceColumn);
        lRowValues.add((String)oTargetColumn);
        lRowValues.add((String)oMapping);
        return lRowValues;
    }

    protected IColumn[] promptForColumnToAdd() {
        if (this.m_compare.getComparisonTable() == null) {
            MessageUtil.displayMessage((String)bundle.getString("CompareTablesTargetTableModel.NoComparisonTable.txt"), (int)1);
            return null;
        }
        String title = bundle.formatString("CompareTablesTargetTableModel.SelectColumn.Title.txt", (Object)this.m_compare.getComparisonTable().getName());
        ColumnSelectorPanel colSelector = new ColumnSelectorPanel((ITable)this.m_compare.getComparisonTable(), bundle.getString("CompareTablesTargetTableModel.SelectColumn.Desc.txt"), false);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), title, true, (WAPanel)colSelector);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return colSelector.getSelectedColumns();
        }
        return null;
    }

    public void clear() {
        super.clear();
        ModelList lMappings = this.m_compare.getCompareColumnsMappingsList();
        int size = lMappings.size();
        for (int i = size - 1; i > -1; --i) {
            lMappings.remove(lMappings.get(i));
        }
    }

    public void deleteRow(int iRow) {
        if (iRow == -1) {
            return;
        }
        IMapping oMapping = (IMapping)this.getRowValues(iRow).get(4);
        List lDeletedRowValues = (List)this.m_lData.remove(iRow);
        this.fireTableRowDeleted(iRow, lDeletedRowValues);
        if (this.m_compare.getCompareColumnsMappingsList().contains((Object)oMapping)) {
            this.m_compare.removeCompareColumnsMapping(oMapping);
        }
    }

    private void removeMappingRow(IMapping oMap) {
        this.deleteRow(this.getMappingRowIndex(oMap));
    }

    public void removeRow(int iRow) {
        if (iRow == -1) {
            return;
        }
        IMapping oMapping = (IMapping)this.getRowValues(iRow).get(4);
        List lDeletedRowValues = (List)this.m_lData.remove(iRow);
        this.fireTableRowDeleted(iRow, lDeletedRowValues);
    }

    private void removeMappingRowOnly(IMapping oMap) {
        this.removeRow(this.getMappingRowIndex(oMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveCompareTablesModelItems(int[] selectedIndices, boolean bMovingUp) {
        if (selectedIndices != null && selectedIndices.length > 0) {
            try {
                this.m_compare.getModel().startCompoundUndoable();
                IMapping[] mkMappings = this.m_compare.getCompareColumnsMappings();
                if (bMovingUp) {
                    for (int i = 0; i < selectedIndices.length; ++i) {
                        IMapping currentMap = mkMappings[selectedIndices[i]];
                        this.m_compare.moveCompareColumnsMapping(currentMap, selectedIndices[i] - 1);
                    }
                } else {
                    for (int i = selectedIndices.length - 1; i >= 0; --i) {
                        IMapping currentMap = mkMappings[selectedIndices[i]];
                        this.m_compare.moveCompareColumnsMapping(currentMap, selectedIndices[i] + 1);
                    }
                }
            }
            finally {
                this.m_compare.getModel().endCompoundUndoable();
            }
        }
    }

    public int getMappingRowIndex(IMapping oMap) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(4) != oMap) continue;
            return iRow;
        }
        return -1;
    }

    public int getMappingIndexFromModel(IMapping oMap) {
        ModelList mappings = this.m_compare.getCompareColumnsMappingsList();
        return mappings.indexOf(oMap);
    }

    private class ButtonTableColumn
    extends WsAbstractTableColumn {
        public ButtonTableColumn(int iModelIndex, String sName, int cxWidth) {
            super(iModelIndex, sName, cxWidth);
            this.setColumnClass(String.class);
        }

        protected TableCellRenderer createCellRenderer() {
            return new ButtonCellRenderer();
        }

        protected TableCellEditor createCellEditor() {
            return new ButtonCellEditor();
        }

        public Object createDefaultValue() {
            return null;
        }

        class ButtonCellEditor
        extends DefaultTableCellEditor {
            Object m_Value;
            int m_iRow;
            int m_iCol;
            JLabel m_lblEditor = new JLabel();
            JButton m_btnBrowse = WsUIUtilities.createBrowseButton();
            JPanel m_pnlEditor = new JPanel(){

                @Override
                public void requestFocus() {
                    ButtonCellEditor.this.m_btnBrowse.requestFocus();
                    ButtonCellEditor.this.cancelCellEditing();
                }
            };

            ButtonCellEditor() {
                this.m_lblEditor.setOpaque(true);
                this.m_lblEditor.setBackground(SystemColor.window);
                this.m_lblEditor.setForeground(SystemColor.windowText);
                this.setClickCountToStart(1);
                this.m_btnBrowse.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IColumn[] compCol = CompareTablesTargetTableModel.this.promptForColumnToAdd();
                        if (compCol != null && compCol.length > 0) {
                            IColumn col = compCol[0];
                            ButtonCellEditor.this.m_Value = col;
                            ButtonCellEditor.this.m_lblEditor.setText(col.getName());
                            IMapping currentMap = (IMapping)CompareTablesTargetTableModel.this.getValueAt(ButtonCellEditor.this.m_iRow, 4);
                            IColumn currentTarget = (IColumn)CompareTablesTargetTableModel.this.getValueAt(ButtonCellEditor.this.m_iRow, 3);
                            currentMap.replaceTargetColumn(currentTarget, col);
                            ButtonCellEditor.this.cancelCellEditing();
                        }
                        ButtonCellEditor.this.cancelCellEditing();
                    }
                });
                this.m_pnlEditor.setLayout(new BorderLayout());
                this.m_pnlEditor.add((Component)this.m_lblEditor, "Center");
                this.m_pnlEditor.add((Component)this.m_btnBrowse, "East");
            }

            public boolean stopCellEditing() {
                this.cancelCellEditing();
                return true;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean flag, int row, int column) {
                this.m_Value = value;
                this.m_iRow = row;
                this.m_iCol = column;
                String sText = bundle.getString("CompareTablesTargetTableModel.None.txt");
                if (value != null) {
                    if (value instanceof String) {
                        sText = (String)value;
                    } else if (value instanceof IColumn) {
                        IColumn target = (IColumn)value;
                        sText = target.getName();
                    }
                }
                this.m_lblEditor.setText(sText);
                return this.m_pnlEditor;
            }

            public Object getCellEditorValue() {
                return this.m_Value;
            }
        }

        class ButtonCellRenderer
        extends WsDefaultTableCellRenderer {
            JPanel m_pnlRenderer = new JPanel();
            JLabel m_lblRenderer = new JLabel();
            JButton m_btnBrowse = WsUIUtilities.createBrowseButton();

            ButtonCellRenderer() {
                this.m_lblRenderer.setOpaque(true);
                this.m_lblRenderer.setBackground(SystemColor.window);
                this.m_lblRenderer.setForeground(SystemColor.windowText);
                this.m_pnlRenderer.setLayout(new BorderLayout());
                this.m_pnlRenderer.add((Component)this.m_lblRenderer, "Center");
                this.m_pnlRenderer.add((Component)this.m_btnBrowse, "East");
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String sLabel = bundle.getString("CompareTablesTargetTableModel.None.txt");
                Object myValue = table.getValueAt(row, column);
                if (myValue != null) {
                    if (myValue instanceof String) {
                        sLabel = (String)myValue;
                    } else if (myValue instanceof IColumn) {
                        IColumn target = (IColumn)myValue;
                        sLabel = target.getName();
                    }
                }
                this.m_lblRenderer.setText(sLabel);
                return this.m_pnlRenderer;
            }
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            Object obj2 = ev.getData();
            if (sType == "ModelController:UnknownChanges") {
                CompareTablesTargetTableModel.this.moveDataToModel();
            } else if (sType == "CompareTables:CompareColumnsMappingAdded") {
                IMapping oMap = (IMapping)ev.getData();
                if (oMap instanceof IMapping) {
                    int iRowIndex = CompareTablesTargetTableModel.this.getMappingRowIndex(oMap);
                    if (iRowIndex > -1) {
                        return;
                    }
                    int iRow = CompareTablesTargetTableModel.this.getMappingIndexFromModel(oMap);
                    CompareTablesTargetTableModel.this.insertRow(iRow - 1, CompareTablesTargetTableModel.this.createRowValues(oMap));
                }
            } else if (sType == "CompareTables:CompareColumnsMappinRemoved") {
                IMapping oMap = (IMapping)ev.getData();
                if (oMap instanceof IMapping) {
                    CompareTablesTargetTableModel.this.removeMappingRow(oMap);
                }
            } else if (sType == "Mapping:TargetColumnRemoved") {
                int iRowIndex;
                if (obj instanceof IMapping && (iRowIndex = CompareTablesTargetTableModel.this.getMappingRowIndex((IMapping)obj)) >= 0) {
                    IColumn oCol = (IColumn)ev.getData();
                    CompareTablesTargetTableModel.super.setValueAt(null, iRowIndex, 3);
                    CompareTablesTargetTableModel.super.setValueAt(bundle.getString("CompareTablesTargetTableModel.None.txt"), iRowIndex, 1);
                    CompareTablesTargetTableModel.this.fireTableCellUpdated(iRowIndex, 3);
                    CompareTablesTargetTableModel.this.fireTableCellUpdated(iRowIndex, 1);
                }
            } else if (sType == "Mapping:TargetColumnAdded") {
                int iRowIndex;
                if (obj instanceof IMapping && (iRowIndex = CompareTablesTargetTableModel.this.getMappingRowIndex((IMapping)obj)) >= 0) {
                    IColumn oCol = (IColumn)ev.getData();
                    CompareTablesTargetTableModel.super.setValueAt(oCol, iRowIndex, 3);
                    CompareTablesTargetTableModel.super.setValueAt(oCol.getName(), iRowIndex, 1);
                    CompareTablesTargetTableModel.this.fireTableCellUpdated(iRowIndex, 3);
                    CompareTablesTargetTableModel.this.fireTableCellUpdated(iRowIndex, 1);
                }
            } else if (sType == "CompareTables:CompareColumnsMappinMoved") {
                IMapping oMap = (IMapping)ev.getData();
                if (oMap instanceof IMapping) {
                    int iRowIndex = CompareTablesTargetTableModel.this.getMappingRowIndex(oMap);
                    int iRow = CompareTablesTargetTableModel.this.getMappingIndexFromModel(oMap);
                    System.out.println("iRowIndex is: " + iRowIndex + " and iRow is: " + iRow);
                    if (iRowIndex == iRow) {
                        return;
                    }
                    CompareTablesTargetTableModel.this.removeMappingRowOnly(oMap);
                    CompareTablesTargetTableModel.this.insertRow(iRow - 1, CompareTablesTargetTableModel.this.createRowValues(oMap));
                }
            } else if (sType == "CompareTables:CompareToDigestChanged" && obj instanceof ICompareTables) {
                boolean b_compareToDigest = ((ICompareTables)obj).compareToDigestColumn();
                CompareTablesTargetTableModel.this.HIDDEN_COLUMNS = b_compareToDigest ? 4 : 3;
                CompareTablesTargetTableModel.this.fireTableStructureChanged();
            }
        }
    }
}

