/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.comparetables;

import com.sas.beans.Util;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.job.IMapping;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.DualSelectorUpDownInterface;
import com.sas.wadmin.transforms.comparetables.CompareTablesTargetTableModel;
import com.sas.wadmin.transforms.comparetables.JTableDualSelectorAdapterCompareTables;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.visuals.dualselector.SelectorTableModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class CompareTablesTableTableSelector
extends BaseDualSelector
implements ListSelectionListener,
ViewDefaultModel {
    private static WAdminResource bundle = WAdminResource.getBundle(CompareTablesTableTableSelector.class);
    private transient TableModel sourceTableModel;
    private transient TableModel targetTableModel;
    protected JTable sourceJTable;
    protected JTable targetJTable;

    public CompareTablesTableTableSelector(JTable sTable, JTable tTable) {
        this.setDesignTime(Util.isDesignTime());
        this.setOpaque(true);
        this.targetMaximumCount = -1;
        this.sourceAdapter = new JTableDualSelectorAdapterCompareTables(sTable, (JComponent)((Object)this));
        this.targetAdapter = new JTableDualSelectorAdapterCompareTables(tTable, (JComponent)((Object)this));
        this.sourceJTable = (JTable)this.sourceAdapter.getComponent();
        this.targetJTable = (JTable)this.targetAdapter.getComponent();
        this.initializeBaseDualSelector();
        this.sourceJTable.addMouseListener(this.sourceMouseListener);
        this.targetJTable.addMouseListener(this.targetMouseListener);
        if (this.getModel() == null) {
            this.setModel(sTable.getModel());
        }
        if (this.getTargetModel() == null) {
            this.setTargetModel(tTable.getModel());
        }
        this.initialized = true;
        this.ensureButtonsEnabled();
        this.addListeners();
        this.updateUI();
    }

    public boolean isDefaultModelAttached() {
        return this.getModel() instanceof DefaultTableModel && this.getModel().getRowCount() == 0;
    }

    public TableModel getModel() {
        return this.sourceTableModel;
    }

    public TableModel getTargetModel() {
        return this.targetTableModel;
    }

    public void setTargetModel(TableModel tableModel) throws IllegalArgumentException {
        TableModel oldModel;
        if (tableModel instanceof SelectorTableModel) {
            oldModel = this.targetTableModel;
            if (tableModel != null) {
                this.targetTableModel = tableModel;
            }
            if (this.targetJTable != null) {
                this.targetJTable.setModel(this.targetTableModel);
            } else {
                this.targetTableModel = new DefaultTableModel();
                if (this.targetJTable != null) {
                    this.targetJTable.setModel(this.targetTableModel);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("targetListModel", oldModel, this.targetTableModel);
    }

    public void setModel(TableModel tableModel) throws IllegalArgumentException {
        TableModel oldModel;
        if (tableModel instanceof SelectorTableModel) {
            oldModel = this.sourceTableModel;
            if (tableModel != null) {
                this.sourceTableModel = tableModel;
            }
            if (this.sourceJTable != null) {
                this.sourceJTable.setModel(this.sourceTableModel);
            } else {
                this.sourceTableModel = new DefaultTableModel();
                if (this.sourceJTable != null) {
                    this.sourceJTable.setModel(this.sourceTableModel);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("sourceListModel", oldModel, this.sourceTableModel);
    }

    @Override
    public void valueChanged(ListSelectionEvent ie) {
        ListSelectionModel lsm = (ListSelectionModel)ie.getSource();
        this.direction = lsm != this.sourceJTable.getSelectionModel() || this.sourceTableModel.getRowCount() <= 0;
        if (!this.clearSelection && ie.getFirstIndex() >= 0) {
            if (this.direction) {
                if (this.alternatingMultipleButtonStyle) {
                    this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", true));
                }
                if (this.alternatingSingleButtonStyle) {
                    this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", true));
                }
            } else {
                if (this.alternatingMultipleButtonStyle) {
                    this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", false));
                }
                if (this.alternatingSingleButtonStyle) {
                    this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", false));
                }
            }
            this.ensureButtonsEnabled();
            this.clearSelection = true;
            try {
                if (this.direction) {
                    this.sourceJTable.getSelectionModel().clearSelection();
                    this.direction = true;
                } else {
                    this.targetJTable.getSelectionModel().clearSelection();
                    this.direction = false;
                }
            }
            finally {
                this.clearSelection = false;
            }
        }
    }

    protected void addListeners() {
        super.addListeners();
        this.sourceJTable.getSelectionModel().removeListSelectionListener(this);
        this.sourceJTable.getSelectionModel().addListSelectionListener(this);
        this.targetJTable.getSelectionModel().removeListSelectionListener(this);
        this.targetJTable.getSelectionModel().addListSelectionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List passedItems) {
        int index;
        int selectedCount;
        int maxCnt = -1;
        if (fromAdapter == this.sourceAdapter) {
            maxCnt = this.getTargetMaximumCount();
        }
        if (passedItems == null) {
            this.selectedItems = fromAdapter.getSelectedItems();
            selectedCount = fromAdapter.getSelectedCount();
            index = fromAdapter.getLastSelectedIndex();
        } else {
            this.selectedItems = passedItems;
            index = selectedCount = passedItems.size();
        }
        if (this.selectedItems != null && selectedCount > 0) {
            DualSelectorInterface dualSelectorInterface = fromAdapter;
            synchronized (dualSelectorInterface) {
                DualSelectorInterface dualSelectorInterface2 = toAdapter;
                synchronized (dualSelectorInterface2) {
                    int count = this.selectedItems.size() + toAdapter.getCount();
                    if (maxCnt == -1 || count <= maxCnt) {
                        if (fromAdapter == this.targetAdapter) {
                            fromAdapter.removeItems(this.selectedItems);
                            this.selectedItems.clear();
                        } else if (this.selectedItems.size() > 0 && fromAdapter == this.sourceAdapter) {
                            List lTargetItems = toAdapter.getAllItems();
                            ArrayList<String> duplicateColumns = new ArrayList<String>();
                            Iterator iter = this.selectedItems.iterator();
                            block6: while (iter.hasNext()) {
                                Object item = iter.next();
                                IColumn selectedColumn = (IColumn)((List)item).get(1);
                                for (int i = 0; i < lTargetItems.size(); ++i) {
                                    ArrayList item2 = (ArrayList)lTargetItems.get(i);
                                    IColumn targetColumn = (IColumn)item2.get(2);
                                    if (!selectedColumn.getName().equalsIgnoreCase(targetColumn.getName())) continue;
                                    duplicateColumns.add(selectedColumn.getName());
                                    iter.remove();
                                    continue block6;
                                }
                            }
                            if (this.targetTableModel instanceof CompareTablesTargetTableModel) {
                                ModelList lTargetItems2 = ((CompareTablesTargetTableModel)((Object)this.targetTableModel)).getCompareTablesModel().getMatchKeyMappingsList();
                                Iterator iter2 = this.selectedItems.iterator();
                                block8: while (iter2.hasNext()) {
                                    Object item = iter2.next();
                                    IColumn selectedColumn = (IColumn)((List)item).get(1);
                                    for (int i = 0; i < lTargetItems2.size(); ++i) {
                                        IMapping mkMap = (IMapping)lTargetItems2.get(i);
                                        IColumn[] tCols = mkMap.getSources();
                                        if (tCols == null || tCols.length <= 0) continue;
                                        IColumn tCol = tCols[0];
                                        if (!selectedColumn.getName().equalsIgnoreCase(tCol.getName())) continue;
                                        duplicateColumns.add(selectedColumn.getName());
                                        iter2.remove();
                                        continue block8;
                                    }
                                }
                            }
                            if (duplicateColumns.size() > 0) {
                                MessageUtil.displayListMessage((String)bundle.getString("CompareTablesTableTableSelector.DuplicateColumnWarning.txt"), duplicateColumns, (int)1);
                            }
                            toAdapter.addItems(this.selectedItems);
                        }
                        if (fromAdapter == this.sourceAdapter) {
                            fromAdapter.setSelectedIndex(index);
                        } else {
                            fromAdapter.setSelectedIndex(Math.min(index, fromAdapter.getAllItems().size() - 1));
                        }
                        this.ensureButtonsEnabled();
                        this.firePropertyChange("sourceItems", null, null);
                        this.firePropertyChange("targetItems", null, null);
                        this.selectedItems = null;
                    }
                }
            }
        }
    }

    protected synchronized void moveTargetItem(boolean moveItemUp) {
        int offset;
        int[] selectedIndices = ((DualSelectorUpDownInterface)this.targetAdapter).getSelectedIndices();
        int[] modelIndices = new int[selectedIndices.length];
        for (int i = 0; i < selectedIndices.length; ++i) {
            modelIndices[i] = selectedIndices[i];
        }
        if (selectedIndices != null && selectedIndices.length > 0) {
            offset = moveItemUp ? -1 : 1;
            ((DualSelectorUpDownInterface)this.targetAdapter).moveItems(selectedIndices, offset);
        }
        this.ensureButtonsEnabled();
        ((JTableDualSelectorAdapterCompareTables)this.targetAdapter).clearSelections();
        ((CompareTablesTargetTableModel)((Object)this.targetJTable.getModel())).moveCompareTablesModelItems(modelIndices, moveItemUp);
        offset = moveItemUp ? -1 : 1;
        for (int i = 0; i < modelIndices.length; ++i) {
            selectedIndices[i] = modelIndices[i] + offset;
        }
        if (this.targetAdapter instanceof JTableDualSelectorAdapterCompareTables) {
            ((JTableDualSelectorAdapterCompareTables)this.targetAdapter).setSelectedIndices(selectedIndices);
        }
    }
}

