/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.comparetables;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.comparetables.ICompareTables;
import com.sas.etl.models.job.transforms.comparetables.ICompareTablesTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.util.Util;
import com.sas.wadmin.transforms.comparetables.CompareTablesSourceColumnsModel;
import com.sas.wadmin.transforms.comparetables.CompareTablesTableTableSelector;
import com.sas.wadmin.transforms.comparetables.CompareTablesTargetTableModel;
import com.sas.wadmin.transforms.comparetables.MatchKeysPanel;
import com.sas.wadmin.transforms.scd.ColumnSelectorPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractBrowsableTextField;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.dualselector.DefaultSelectorTable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class CompareColumnsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(MatchKeysPanel.class);
    private TitledBorder m_titledBorder;
    private ICompareTablesTransformModel m_compareModel;
    ICompareTables m_compare;
    CompareTablesSourceColumnsModel m_leftTableModel;
    CompareTablesTargetTableModel m_rightTableModel;
    cCompareToDigestCheckBoxAction m_actCompareToDigest;
    WAComboBox m_cmbColumn;
    cBrowseColumnsTextField m_browseColumns;
    JLabel m_tblLbl2;
    private JCheckBox m_chkCompareToDigest;
    private ModelListener m_lsnrModel;

    public CompareColumnsPanel(ICompareTablesTransformModel compareTablesModel) {
        this.m_compareModel = compareTablesModel;
        this.m_lsnrModel = new ModelListener();
        this.m_compare = this.m_compareModel.getCompareTablesObject();
        this.m_compareModel.getModel().addModelListener((IModelListener)this.m_lsnrModel);
        this.initialize();
        this.layoutWidgets();
        this.setListeningForChanges(false);
    }

    protected void initialize() {
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)bundle.getString("CompareColumnsPanel.Title.txt"));
        this.setBorder(this.m_titledBorder);
        this.m_leftTableModel = new CompareTablesSourceColumnsModel(this.m_compareModel);
        this.m_rightTableModel = new CompareTablesTargetTableModel(this.m_compareModel);
        DefaultSelectorTable leftsidedefaultSelectorTable = new DefaultSelectorTable((WsAbstractTableModel)this.m_leftTableModel);
        DefaultSelectorTable rightsidedefaultSelectorTable = new DefaultSelectorTable((WsAbstractTableModel)this.m_rightTableModel);
        WATextArea txtAreaDesc = new WATextArea();
        txtAreaDesc.setBehavior(1);
        txtAreaDesc.setText(bundle.getString("CompareColumnsPanel.CompareColumnsDescription.txt"));
        txtAreaDesc.setAutosize(true);
        leftsidedefaultSelectorTable.setAutoResizeMode(4);
        rightsidedefaultSelectorTable.setAutoResizeMode(4);
        rightsidedefaultSelectorTable.setColumnHeaderPopupMenuEnabled(false);
        rightsidedefaultSelectorTable.setColumnsReorderable(false);
        leftsidedefaultSelectorTable.setSortingEnabled(true);
        leftsidedefaultSelectorTable.setColumnHidingEnabled(false);
        leftsidedefaultSelectorTable.setColumnHoldingEnabled(false);
        CompareTablesTableTableSelector dts = new CompareTablesTableTableSelector((JTable)leftsidedefaultSelectorTable, (JTable)rightsidedefaultSelectorTable);
        JLabel tblLbl = (JLabel)dts.getSourceLabelComponent();
        tblLbl.setText(Util.getLabelWithoutMnemonic((String)bundle.getString("CompareColumnsPanel.AvailableColumns.txt")));
        int sourceLabelMnemonicCharacter = Util.getDisplayedMnemonic((String)bundle.getString("CompareColumnsPanel.AvailableColumns.txt"));
        int sourceLabelMnemonicIndex = Util.getDisplayedMnemonicIndex((String)bundle.getString("CompareColumnsPanel.AvailableColumns.txt"));
        tblLbl.setDisplayedMnemonic(sourceLabelMnemonicCharacter);
        tblLbl.setDisplayedMnemonicIndex(sourceLabelMnemonicIndex);
        this.m_tblLbl2 = (JLabel)dts.getTargetLabelComponent();
        this.setTargetTableLabel(this.m_compare.compareToDigestColumn());
        dts.setTargetControlsVisible(true);
        dts.setTransferAllControlsVisible(false);
        dts.setModel((TableModel)((Object)this.m_leftTableModel));
        this.m_actCompareToDigest = new cCompareToDigestCheckBoxAction();
        this.m_chkCompareToDigest = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actCompareToDigest);
        this.listenForDataChangesTo(this.m_chkCompareToDigest);
        this.m_browseColumns = new cBrowseColumnsTextField();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        topPanel.add((Component)this.m_chkCompareToDigest, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        topPanel.add((Component)((Object)this.m_browseColumns), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)txtAreaDesc, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)dts), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(topPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 14, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    protected void layoutWidgets() {
    }

    public void setBorderTitle(String title) {
        this.m_titledBorder.setTitle(title);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_leftTableModel.moveDataToModel();
        this.m_rightTableModel.moveDataToModel();
        this.m_chkCompareToDigest.setSelected(this.m_compare.compareToDigestColumn());
        this.m_browseColumns.setEditable(true);
        this.m_browseColumns.setEnabled(this.m_compare.compareToDigestColumn());
        IColumn digestColumn = this.m_compare.getDigestColumn();
        if (digestColumn != null) {
            this.m_browseColumns.setText(digestColumn.getName());
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_rightTableModel.dispose();
        this.m_leftTableModel.dispose();
        this.m_compareModel.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    protected void setTargetTableLabel(boolean digestSelected) {
        if (digestSelected) {
            this.m_tblLbl2.setText(Util.getLabelWithoutMnemonic((String)bundle.getString("CompareColumnsPanel.SelectedColumnsWithoutMapping.txt")));
            int targetLabelMnemonicCharacter = Util.getDisplayedMnemonic((String)bundle.getString("CompareColumnsPanel.SelectedColumnsWithoutMapping.txt"));
            int targetLabelMnemonicIndex = Util.getDisplayedMnemonicIndex((String)bundle.getString("CompareColumnsPanel.SelectedColumnsWithoutMapping.txt"));
            this.m_tblLbl2.setDisplayedMnemonic(targetLabelMnemonicCharacter);
            this.m_tblLbl2.setDisplayedMnemonicIndex(targetLabelMnemonicIndex);
        } else {
            this.m_tblLbl2.setText(Util.getLabelWithoutMnemonic((String)bundle.getString("CompareColumnsPanel.SelectedColumns.txt")));
            int targetLabelMnemonicCharacter = Util.getDisplayedMnemonic((String)bundle.getString("CompareColumnsPanel.SelectedColumns.txt"));
            int targetLabelMnemonicIndex = Util.getDisplayedMnemonicIndex((String)bundle.getString("CompareColumnsPanel.SelectedColumns.txt"));
            this.m_tblLbl2.setDisplayedMnemonic(targetLabelMnemonicCharacter);
            this.m_tblLbl2.setDisplayedMnemonicIndex(targetLabelMnemonicIndex);
        }
    }

    protected IColumn[] promptForColumn() {
        if (this.m_compare.getComparisonTable() == null) {
            MessageUtil.displayMessage((String)bundle.getString("CompareColumnsPanel.NoComparisonTable.txt"), (int)1);
            return null;
        }
        String title = bundle.formatString("CompareColumnsPanel.SelectColumn.Title.txt", (Object)this.m_compare.getComparisonTable().getName());
        ColumnSelectorPanel colSelector = new ColumnSelectorPanel((ITable)this.m_compare.getComparisonTable(), bundle.getString("CompareColumnsPanel.SelectColumn.Desc.txt"), false);
        ArrayList<IColumn> hiddenColumns = new ArrayList<IColumn>();
        IPhysicalTable compTable = this.m_compare.getComparisonTable();
        IColumn[] allColumns = compTable.getColumns();
        for (int i = 0; i < allColumns.length; ++i) {
            IColumn col = allColumns[i];
            if (col.getType() != 1) continue;
            hiddenColumns.add(col);
        }
        colSelector.hideColumns(hiddenColumns);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), title, true, (WAPanel)colSelector);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return colSelector.getSelectedColumns();
        }
        return null;
    }

    protected IColumn findPossibleDigestColumn() {
        IPhysicalTable compareTable = this.m_compare.getComparisonTable();
        IColumn[] tCols = compareTable.getColumns();
        for (int i = 0; i < tCols.length; ++i) {
            IColumn tCol = tCols[i];
            if (!tCol.getName().equalsIgnoreCase("DIGEST_VALUE")) continue;
            return tCol;
        }
        return null;
    }

    private class cBrowseColumnsTextField
    extends WsAbstractBrowsableTextField {
        private cBrowseColumnsTextField() {
        }

        public void setEnabled(boolean bEnabled) {
            this.m_txt.setEnabled(true);
            this.m_btn.setEnabled(bEnabled);
        }

        public boolean isEnabled() {
            return this.m_btn.isEnabled();
        }

        public void setEditable(boolean bEditable) {
            this.m_txt.setEditable(false);
            this.m_btn.setEnabled(bEditable);
        }

        public boolean isEditable() {
            return this.m_btn.isEnabled();
        }

        protected Border createTextFieldBorder() {
            if (WsUIUtilities.isXPThemeActive()) {
                return new EmptyBorder(1, 5, 1, 0);
            }
            return new EmptyBorder(1, 1, 1, 0);
        }

        protected void showDialog() {
            IColumn[] compCol = CompareColumnsPanel.this.promptForColumn();
            if (compCol != null && compCol.length > 0) {
                IColumn col = compCol[0];
                CompareColumnsPanel.this.m_browseColumns.setText(col.getName());
                CompareColumnsPanel.this.m_compare.setDigestColumn(col);
            }
        }
    }

    protected class ChooseColumnAction
    extends WsAbstractAction {
        public ChooseColumnAction() {
            super(bundle, "CompareColumnsPanel.ChooseColumnAction.Browse", 0);
        }

        public void actionPerformed(ActionEvent e) {
            IColumn[] compCol = CompareColumnsPanel.this.promptForColumn();
            if (compCol != null && compCol.length > 0) {
                IColumn col = compCol[0];
                CompareColumnsPanel.this.m_compare.setDigestColumn(col);
            }
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "CompareTables:CompareToDigestColumnChanged") {
                if (obj instanceof ICompareTables) {
                    IColumn selectedColumn = ((ICompareTables)obj).getDigestColumn();
                    if (selectedColumn != null) {
                        CompareColumnsPanel.this.m_browseColumns.setText(selectedColumn.getName());
                    } else {
                        CompareColumnsPanel.this.m_browseColumns.setText("");
                    }
                }
            } else if (sType == "CompareTables:CompareToDigestChanged" && obj instanceof ICompareTables) {
                boolean b_compareToDigest = ((ICompareTables)obj).compareToDigestColumn();
                CompareColumnsPanel.this.m_chkCompareToDigest.setSelected(b_compareToDigest);
                CompareColumnsPanel.this.setTargetTableLabel(b_compareToDigest);
                CompareColumnsPanel.this.m_browseColumns.setEditable(true);
                CompareColumnsPanel.this.m_browseColumns.setEnabled(CompareColumnsPanel.this.m_compare.compareToDigestColumn());
            }
        }
    }

    protected class cCompareToDigestCheckBoxAction
    extends WsAbstractToggleAction {
        public cCompareToDigestCheckBoxAction() {
            super(bundle, "CompareColumnsPanel.CompareCheckBox", 0);
        }

        public void actionPerformed(ActionEvent event) {
            IColumn digestColumn;
            ICompareTables m_compare = CompareColumnsPanel.this.m_compareModel.getCompareTablesObject();
            m_compare.setCompareToDigestColumn(CompareColumnsPanel.this.m_chkCompareToDigest.isSelected());
            CompareColumnsPanel.this.m_browseColumns.setEditable(true);
            CompareColumnsPanel.this.m_browseColumns.setEnabled(CompareColumnsPanel.this.m_chkCompareToDigest.isSelected());
            if (CompareColumnsPanel.this.m_chkCompareToDigest.isSelected() && m_compare.getDigestColumn() == null && (digestColumn = CompareColumnsPanel.this.findPossibleDigestColumn()) != null) {
                CompareColumnsPanel.this.m_browseColumns.setText(digestColumn.getName());
                m_compare.setDigestColumn(digestColumn);
            }
            CompareColumnsPanel.this.setTargetTableLabel(CompareColumnsPanel.this.m_chkCompareToDigest.isSelected());
        }
    }
}

