/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.casloader;

import com.sas.etl.models.other.IServer;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.rio.MVAResultSet;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.transforms.casloader.CASInfoObject;
import com.sas.wadmin.transforms.casloader.ListItemPanel;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractBrowsableTextField;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class WABrowseResultsTextField
extends WsAbstractBrowsableTextField {
    private static WAdminResource bundle = WAdminResource.getBundle(WABrowseResultsTextField.class);
    private String m_objectType;
    private boolean m_returnObjects = true;
    private MdObjectStore m_mdStore;
    private IServer server;
    private String m_caslib;

    public WABrowseResultsTextField() {
    }

    public WABrowseResultsTextField(MdObjectStore mdStore) {
        this.m_mdStore = mdStore;
    }

    public WABrowseResultsTextField(String objectType) {
        this();
        this.setMetadataType(objectType);
    }

    public WABrowseResultsTextField(MdObjectStore mdStore, String objectType) {
        this(mdStore);
        this.setMetadataType(objectType);
    }

    public WABrowseResultsTextField(MdObjectStore mdStore, String objectType, boolean returnObjects) {
        this(mdStore, objectType);
        this.setReturnObjects(returnObjects);
    }

    public WABrowseResultsTextField(String objectType, boolean returnObjects) {
        this(null, objectType);
        this.setReturnObjects(returnObjects);
    }

    public void setServer(IServer server) {
        this.server = server;
    }

    public IServer getServer() {
        return this.server;
    }

    public void setMetadataType(String objectType) {
        this.m_objectType = objectType;
    }

    public void setCasLib(String value) {
        this.m_caslib = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showDialog() {
        if (this.m_objectType.equals("File")) {
            LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
            fileTypes.put(bundle.getString("WABrowseResultsTextField.AllFileTypes.txt"), "*");
            this.setCursor(Cursor.getPredefinedCursor(3));
            WsAppServer wsAppServer = WsAppServer.createDefaultAppServer();
            String selection = "";
            try {
                selection = wsAppServer.promptForFilename(bundle.getString("WABrowseResultsTextField.RemoteFileSelector.Title.txt"), this.getText(), fileTypes);
            }
            catch (WsAppServerFailException exc) {
                this.setCursor(Cursor.getDefaultCursor());
                MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                return;
            }
            catch (GenericError err) {
                this.setCursor(Cursor.getDefaultCursor());
                MessageUtil.displayMessage((String)err.getLocalizedMessage(), (int)0);
                return;
            }
            finally {
                wsAppServer.dispose();
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (selection != null) {
                this.setText(selection);
            }
        } else if ("PhysicalTable".equals(this.m_objectType)) {
            try {
                boolean disposeStore = false;
                SimpleObject selObject = null;
                PrimaryType mdObject = null;
                if (this.m_mdStore == null) {
                    try {
                        this.m_mdStore = Workspace.getMdFactory().createObjectStore();
                        disposeStore = true;
                        mdObject = MacroPluginUtilities.findTable(Workspace.getWorkspace().getDefaultRepository().getFQID(), this.getText().split("\\."), this.m_mdStore);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                } else if (this.getData() != null && this.getData() instanceof PrimaryType) {
                    mdObject = (PrimaryType)this.getData();
                }
                if (mdObject != null) {
                    selObject = ObjectConverter.getInstance().convertToSimpleObject(mdObject);
                }
                UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
                String type = "";
                if (!this.m_objectType.equals("PhysicalTable")) return;
                ObjectSelectorPanel pnl = new ObjectSelectorPanel(userContext, 3);
                type = bundle.getString("WABrowseResultsTextField.Types.Table.txt");
                pnl.setHelpProduct("wdb");
                pnl.setHelpTopic("select_table_win");
                String sSelectDialogTitle = bundle.formatString("WABrowseResultsTextField.SelectionType.title.txt", (Object)type);
                pnl.setSelectionOptional(true);
                if (selObject != null) {
                    pnl.setSelectedObject(selObject);
                }
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sSelectDialogTitle, true, (WAPanel)pnl);
                dlg.setResizable(true);
                dlg.show();
                if (dlg.getReturnValue() == 1) {
                    SimpleObject simpleObj = pnl.getSelectedObject();
                    if (simpleObj != null) {
                        try {
                            Root oRoot = ObjectConverter.getInstance().convertToJOMAObject(this.m_mdStore, simpleObj);
                            String textDisplay = oRoot.toString();
                            if (this.m_returnObjects) {
                                this.setData(oRoot);
                            } else if (oRoot instanceof PhysicalTable) {
                                textDisplay = WABrowseResultsTextField.getTableTextDisplay((PhysicalTable)oRoot);
                            }
                            this.setText(textDisplay);
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                    } else {
                        this.setData("");
                        this.setText("");
                    }
                }
                if (disposeStore) {
                    this.m_mdStore.dispose();
                    this.m_mdStore = null;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        } else if ("CAS.LIBRARY".equals(this.m_objectType) || "CAS.SOURCE".equals(this.m_objectType)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WsAppServer wsAppServer = WsAppServer.createDefaultAppServer();
            try {
                CASInfoObject obj;
                String[] values = null;
                if ("CAS.SOURCE".equals(this.m_objectType)) {
                    values = new String[]{this.m_caslib};
                }
                wsAppServer.submitSASCode(this.getCode(this.m_objectType, values));
                MVAResultSet mytablelist = null;
                mytablelist = "CAS.LIBRARY".equals(this.m_objectType) ? wsAppServer.submitSQLStatement("Select Name, Type from work.casinfo") : wsAppServer.submitSQLStatement("Select Name from work.casinfo");
                ListItemPanel pnl = new ListItemPanel();
                pnl.setSelectionMode(0);
                ArrayList<CASInfoObject> items = new ArrayList<CASInfoObject>();
                try {
                    mytablelist.next();
                }
                catch (SQLException e1) {
                    this.setCursor(Cursor.getDefaultCursor());
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                    this.setCursor(Cursor.getDefaultCursor());
                    wsAppServer.dispose();
                    return;
                }
                boolean hasMore = true;
                while (hasMore) {
                    try {
                        String name = mytablelist.getString(1);
                        String type = null;
                        if ("CAS.LIBRARY".equals(this.m_objectType)) {
                            type = mytablelist.getString(2);
                        }
                        if (name != null) {
                            obj = new CASInfoObject(name.trim(), type != null ? type.trim() : null);
                            items.add(obj);
                        }
                        hasMore = mytablelist.next();
                    }
                    catch (SQLException e) {
                        hasMore = false;
                        this.setCursor(Cursor.getDefaultCursor());
                        if (wsAppServer != null) {
                            try {
                                StringBuffer log = wsAppServer.getLogBuffer();
                                if (null != log) {
                                    WATextArea txtDetails = new WATextArea(log.toString());
                                    txtDetails.setBehavior(2);
                                    txtDetails.setRows(25);
                                    JScrollPane scroll = new JScrollPane((Component)txtDetails);
                                    scroll.setVerticalScrollBarPolicy(22);
                                    scroll.setHorizontalScrollBarPolicy(32);
                                    MessageUtil.displayDetailsMessage((String)bundle.getString("WABrowseResultsTextField.CaslibNoFiles.txt"), (String)bundle.getString("Common.Information.txt"), (int)1, (int)-1, (JComponent)scroll);
                                }
                            }
                            catch (WsAppServerFailException log) {
                                // empty catch block
                            }
                        }
                        this.setCursor(Cursor.getDefaultCursor());
                        wsAppServer.dispose();
                        return;
                    }
                }
                pnl.addItems(items);
                String selectItem = "";
                if ("CAS.LIBRARY".equals(this.m_objectType)) {
                    selectItem = bundle.getString("WABrowseResultsTextField.SelectionType.library.txt");
                    pnl.setHelpTopic("select_library");
                } else {
                    selectItem = bundle.getString("WABrowseResultsTextField.SelectionType.source.txt");
                    pnl.setHelpTopic("select_source");
                }
                String sSelectDialogTitle = bundle.formatString("WABrowseResultsTextField.SelectionType.title.spec.txt", (Object)selectItem);
                pnl.setTitle(sSelectDialogTitle);
                if (this.getData() instanceof CASInfoObject) {
                    pnl.setSelectedObject((CASInfoObject)this.getData());
                } else if (this.getText() != null) {
                    obj = new CASInfoObject(this.getText(), null);
                    pnl.setSelectedObject(obj);
                }
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("WABrowseResultsTextField.SelectionType.title.txt"), true, pnl);
                dlg.setResizable(true);
                dlg.show();
                if (dlg.getReturnValue() != 1 || pnl.getSelectedList().length <= 0) return;
                this.setData(pnl.getSelectedList()[0]);
                this.setText(pnl.getSelectedList()[0].toString());
                return;
            }
            catch (WsAppServerCodeException exc) {
                this.setCursor(Cursor.getDefaultCursor());
                if (wsAppServer == null) return;
                try {
                    StringBuffer log = wsAppServer.getLogBuffer();
                    if (null == log) return;
                    WATextArea txtDetails = new WATextArea(log.toString());
                    txtDetails.setBehavior(2);
                    txtDetails.setRows(25);
                    JScrollPane scroll = new JScrollPane((Component)txtDetails);
                    scroll.setVerticalScrollBarPolicy(22);
                    scroll.setHorizontalScrollBarPolicy(32);
                    MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)bundle.getString("Common.Error.txt"), (int)0, (int)-1, (JComponent)scroll);
                    return;
                }
                catch (WsAppServerFailException wsAppServerFailException) {
                    // empty catch block
                }
                return;
            }
            catch (WsAppServerFailException exc) {
                this.setCursor(Cursor.getDefaultCursor());
                MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                return;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
                wsAppServer.dispose();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getCode(String type, String ... values) throws WsAppServerFailException {
        if (null == this.server) {
            throw new WsAppServerFailException(bundle.getString("WABrowseResultsTextField.NoServer.txt"));
        }
        StringBuffer code = new StringBuffer();
        code.append("options cashost=\"").append(this.server.getHost()).append("\" casport=").append(this.server.getPort()).append(";\n\n ").append("cas loadsession;  /* start a session */\n\n").append("proc cas;\n").append(" session loadsession;\n");
        if ("CAS.LIBRARY".equals(type)) {
            code.append(" action caslibInfo result=r ;\n");
        } else {
            code.append(" action fileInfo result=r / caslib=\"").append(values[0]).append("\";\n");
        }
        code.append(" saveresult r dataout=work.casinfo;\n").append("run;\n").append("quit;\n");
        return code.toString();
    }

    public static String getTableTextDisplay(PhysicalTable oTable) throws MdException, RemoteException {
        String tableText = oTable.getSASTableName();
        if (oTable != null) {
            RelationalSchema rSchema = oTable.getTablePackage();
            if (rSchema != null && rSchema instanceof DatabaseSchema) {
                SASLibrary tLibrary;
                tableText = ((DatabaseSchema)rSchema).getSchemaName() + '.' + tableText;
                if (!rSchema.getUsedByPackages(false).isEmpty() && (tLibrary = (SASLibrary)rSchema.getUsedByPackages(false).get(0)) != null) {
                    tableText = tLibrary.getLibref() + '.' + tableText;
                }
            } else if (rSchema != null) {
                tableText = ((SASLibrary)rSchema).getLibref() + '.' + tableText;
            }
        }
        return tableText;
    }

    public void setReturnObjects(boolean returnObjects) {
        this.m_returnObjects = returnObjects;
    }

    public boolean getReturnObjects() {
        return this.m_returnObjects;
    }
}

