/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.casloader;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.casloader.CASDataPanel;
import com.sas.wadmin.transforms.casloader.CASServerInfoPanel;
import com.sas.wadmin.transforms.casloader.FileDataPanel;
import com.sas.wadmin.transforms.casloader.SASDataPanel;
import com.sas.wadmin.transforms.loader.NameValueComboBoxModel;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class CASSourcePropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(CASSourcePropertyTab.class);
    private CASLoaderTransformModel m_mdlTransform;
    private IModelListener m_lsnrModel;
    private JLabel m_lblSourceType;
    private WAComboBox m_cmbSourceType;
    private NameValueComboBoxModel m_sourceTypeListModel;
    private WsAbstractAction m_actSourceType;
    private JLabel m_lblReplace;
    private WAComboBox m_cmbReplace;
    private NameValueComboBoxModel m_replaceListModel;
    private WsAbstractAction m_actReplace;
    private CASServerInfoPanel serverPanel;
    private CASDataPanel casDataPanel;
    private SASDataPanel sasDataPanel;
    private FileDataPanel fileDataPanel;

    public CASSourcePropertyTab(CASLoaderTransformModel model) {
        this.setName(bundle.getString("CASLoaderSourceTab.Name.txt"));
        this.m_mdlTransform = model;
        this.m_lsnrModel = new ModelListener();
        this.m_mdlTransform.getModel().addModelListener(this.m_lsnrModel);
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("load_technique_cas");
    }

    public void initialize() {
        this.m_sourceTypeListModel = new NameValueComboBoxModel(bundle, "SourcePropertyTab.SourceType", true);
        this.m_sourceTypeListModel.addItem("CASDATA").addItem("DATA").addItem("FILE");
        this.m_cmbSourceType = new WAComboBox();
        this.m_cmbSourceType.setModel((ComboBoxModel)this.m_sourceTypeListModel);
        this.m_lblSourceType = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbSourceType, (String)bundle.getString("SourcePropertyTab.SourceType.txt"));
        this.m_lblSourceType.setToolTipText(bundle.getString("SourcePropertyTab.SourceType.ToolTip.txt"));
        this.listenForDataChangesTo((JComboBox)this.m_cmbSourceType);
        this.m_actSourceType = new cSourceTypeAction();
        this.m_cmbSourceType.addActionListener((ActionListener)this.m_actSourceType);
        this.m_replaceListModel = new NameValueComboBoxModel(bundle, "SourcePropertyTab.ReplaceType", true);
        this.m_replaceListModel.addItem("NONE").addItem("REPLACE").addItem("APPEND");
        this.m_cmbReplace = new WAComboBox();
        this.m_cmbReplace.setModel((ComboBoxModel)this.m_replaceListModel);
        this.m_lblReplace = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbReplace, (String)bundle.getString("SourcePropertyTab.ReplaceType.txt"));
        this.m_lblReplace.setToolTipText(bundle.getString("SourcePropertyTab.ReplaceType.ToolTip.txt"));
        this.listenForDataChangesTo((JComboBox)this.m_cmbReplace);
        this.m_actReplace = new cReplaceTypeAction();
        this.m_cmbReplace.addActionListener((ActionListener)this.m_actReplace);
        this.serverPanel = new CASServerInfoPanel(this.m_mdlTransform);
        this.casDataPanel = new CASDataPanel(this.m_mdlTransform);
        this.listenForDataChangesTo(this.casDataPanel);
        this.sasDataPanel = new SASDataPanel(this.m_mdlTransform);
        this.listenForDataChangesTo(this.sasDataPanel);
        this.fileDataPanel = new FileDataPanel(this.m_mdlTransform);
        this.listenForDataChangesTo(this.fileDataPanel);
        this.updateVisiblePanel();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.serverPanel), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.add(this.m_lblSourceType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbSourceType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 5), 0, 0));
        this.add(this.m_lblReplace, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbReplace, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 5), 0, 0));
        this.add((Component)((Object)this.casDataPanel), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.sasDataPanel), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.fileDataPanel), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateVisiblePanel() {
        boolean isListening = this.isListeningForChanges();
        this.setListeningForChanges(false);
        try {
            String type = this.m_mdlTransform.getLoadType();
            if ("DATA".equals(type)) {
                this.sasDataPanel.setVisible(true);
                this.casDataPanel.setVisible(false);
                this.fileDataPanel.setVisible(false);
                if (!this.m_replaceListModel.isValueInList("APPEND")) {
                    this.m_replaceListModel.addItem("APPEND");
                }
            } else if ("FILE".equals(type)) {
                this.sasDataPanel.setVisible(false);
                this.casDataPanel.setVisible(false);
                this.fileDataPanel.setVisible(true);
                this.m_replaceListModel.removeItem("APPEND");
            } else {
                this.sasDataPanel.setVisible(false);
                this.casDataPanel.setVisible(true);
                this.fileDataPanel.setVisible(false);
                this.m_replaceListModel.removeItem("APPEND");
            }
        }
        finally {
            this.setListeningForChanges(isListening);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        try {
            this.m_sourceTypeListModel.setSelectedValue(this.m_mdlTransform.getLoadType());
            this.m_replaceListModel.setSelectedValue(this.m_mdlTransform.getReplaceType());
            this.casDataPanel.moveDataToView();
            this.sasDataPanel.moveDataToView();
            this.fileDataPanel.moveDataToView();
            this.updateVisiblePanel();
            this.updateActions();
        }
        finally {
            this.setListeningForChanges(true);
        }
    }

    protected void updateActions() {
        boolean actionEnabled = this.isEditable() && !this.m_mdlTransform.isUsingUserWrittenCode();
        this.casDataPanel.updateActions();
        this.sasDataPanel.updateActions();
        this.fileDataPanel.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_mdlTransform.getModel().removeModelListener(this.m_lsnrModel);
        this.casDataPanel.saveSettingsAndCleanUp();
        this.sasDataPanel.saveSettingsAndCleanUp();
        this.fileDataPanel.saveSettingsAndCleanUp();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_cmbReplace.setEnabled(editable);
        this.m_cmbSourceType.setEnabled(editable);
        this.casDataPanel.setEditable(editable);
        this.sasDataPanel.setEditable(editable);
        this.fileDataPanel.setEditable(editable);
    }

    protected class cReplaceTypeAction
    extends WsAbstractAction {
        protected cReplaceTypeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!CASSourcePropertyTab.this.isListeningForChanges()) {
                return;
            }
            CASSourcePropertyTab.this.m_mdlTransform.setReplaceType(CASSourcePropertyTab.this.m_replaceListModel.getSelectedValue());
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if ("CASLoaderTransformModel:LoadStyleChanged".equals(sType)) {
                CASSourcePropertyTab.this.m_sourceTypeListModel.setSelectedValue(ev.getData().toString());
                CASSourcePropertyTab.this.updateVisiblePanel();
            } else if ("CASLoaderTransformModel:ReplaceTypeChanged".equals(sType)) {
                CASSourcePropertyTab.this.m_replaceListModel.setSelectedValue(ev.getData().toString());
            }
        }
    }

    protected class cSourceTypeAction
    extends WsAbstractAction {
        protected cSourceTypeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!CASSourcePropertyTab.this.isListeningForChanges()) {
                return;
            }
            CASSourcePropertyTab.this.m_mdlTransform.setLoadType(CASSourcePropertyTab.this.m_sourceTypeListModel.getSelectedValue());
        }
    }
}

