/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.businessrules;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowColumn;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMapping;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMappingsContainer;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class BusinessRuleTargetColumnsTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(BusinessRuleTargetColumnsTableModel.class);
    private static final int VISIBLE_COLUMNS = 5;
    private static final int INVISIBLE_COLUMNS = 2;
    public static final int MAPPINGTYPE_COLUMN = 0;
    public static final int EXCLUSIONS_COLUMN = 1;
    public static final int COLUMNNAME_COLUMN = 2;
    public static final int COLUMNDESCR_COLUMN = 3;
    public static final int TYPE_COLUMN = 4;
    private static final int COLUMN_COLUMN = 5;
    private static final int MAPPING_COLUMN = 6;
    private static final int MAPPINGTYPE_WIDTH = 18;
    private static final int EXCLUSIONS_WIDTH = 18;
    private static final int COLUMNNAME_WIDTH = 100;
    private static final int COLUMNDESCR_WIDTH = 110;
    private static final int TYPE_WIDTH = 75;
    private static final Icon UNMAPPED_ICON = bundle.getIcon("BusinessRuleTargetColumnsTableModel.MappingType.Unmapped.image");
    private static final Icon ONE_TO_ONE_ICON = bundle.getIcon("BusinessRuleTargetColumnsTableModel.MappingType.OneToOne.image");
    private static final Icon DERIVED_ICON = bundle.getIcon("BusinessRuleTargetColumnsTableModel.MappingType.Derived.image");
    private static final Icon WARNING_ICON = bundle.getIcon("BusinessRuleTargetColumnsTableModel.MappingType.Warning.image");
    private static final Icon NOT_EXCLUDED_ICON = bundle.getIcon("BusinessRuleTargetColumnsTableModel.ExclusionType.None.image");
    private static final Icon EXCLUDED_FROM_MAPPING_ICON = bundle.getIcon("BusinessRuleTargetColumnsTableModel.ExclusionType.Mapping.image");
    private IBusinessRuleMappingsContainer m_container;
    private List<IBusinessRuleFlowTable> m_lTables;
    private IBusinessRuleFlowTable m_tblSelected;
    private IFilter m_filter;
    private IModelListener m_lsnrModel;

    public BusinessRuleTargetColumnsTableModel(IBusinessRuleMappingsContainer container) {
        this.m_container = container;
        this.m_lTables = new ArrayList<IBusinessRuleFlowTable>();
        this.createListeners();
        this.createColumnDefinitions();
        this.setRowInstanceCount(1);
    }

    protected void createListeners() {
        this.m_lsnrModel = new BusinessRuleModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void createColumnDefinitions() {
        String[] saTypes = ColumnUIUtilities.getViewTypes();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsIconTableColumn(0, " ", 18);
        this.m_aColumns[1] = new WsIconTableColumn(1, " ", 18);
        this.m_aColumns[2] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 2, bundle.getString("BusinessRuleTargetColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("BusinessRuleTargetColumnsTableModel.ColumnDescr.txt"), 110, 200);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("BusinessRuleTargetColumnsTableModel.Type.txt"), 75);
        this.m_aColumns[2].setCellRenderer((TableCellRenderer)((Object)new ColumnNameCellRenderer()));
        this.m_aColumns[5] = new WsObjectTableColumn();
        this.m_aColumns[6] = new WsObjectTableColumn();
        this.m_aColumns[0].setEditable(false);
    }

    public int getColumnCount() {
        return 5;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public int getDefaultEditColumnIndex() {
        return 2;
    }

    public void setValueAt(Object obj, int iRow, int iColumn) {
        IBusinessRuleFlowColumn col = (IBusinessRuleFlowColumn)this.getValueAt(iRow, 5);
        if (iColumn == 2) {
            col.setName((String)obj);
        } else if (iColumn == 3) {
            col.setDescription((String)obj);
        } else if (iColumn == 4) {
            col.setDataType(col.getDisplayableDataType());
        }
    }

    public String getToolTipAt(int iRow, int iColumn) {
        if (iColumn == 0) {
            if (iRow == -1) {
                return bundle.getString("BusinessRuleTargetColumnsTableModel.MappingType.ColumnHeader.tip");
            }
            if (this.getValueAt(iRow, iColumn) == WARNING_ICON) {
                return this.getMapping(iRow).getWarning();
            }
        } else if (iColumn == 1) {
            if (iRow == -1) {
                return bundle.getString("BusinessRuleTargetColumnsTableModel.ExclusionType.ColumnHeader.tip");
            }
            Icon icon = (Icon)this.getValueAt(iRow, iColumn);
            if (icon == EXCLUDED_FROM_MAPPING_ICON) {
                return bundle.getString("BusinessRuleTargetColumnsTableModel.ExclusionType.Mapping.tip");
            }
        }
        return null;
    }

    public void moveDataToModel() {
        this.clear();
        this.m_lTables.clear();
        IBusinessRuleFlowTable[] aTables = this.m_container.getSourceBusinessRuleTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            this.m_lTables.add(aTables[iTable]);
            if (this.m_tblSelected != null && this.m_tblSelected != aTables[iTable]) continue;
            for (IBusinessRuleFlowColumn aColumn : aTables[iTable].getColumns()) {
                this.m_lData.add(this.createRowValues(aColumn));
            }
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() {
    }

    public void populateStore() {
    }

    private List<Object> createRowValues(IBusinessRuleFlowColumn col) {
        IBusinessRuleMapping mapping = this.findMappingForColumn(col);
        ArrayList<Object> lValues = new ArrayList<Object>(7);
        lValues.add(this.getMappingTypeIcon(mapping));
        lValues.add(this.getExclusionsIcon(col));
        lValues.add(col.getName());
        lValues.add(col.getDescription());
        lValues.add(col.getDisplayableDataType());
        lValues.add(col);
        lValues.add(mapping);
        return lValues;
    }

    private IBusinessRuleMapping findMappingForColumn(IBusinessRuleFlowColumn col) {
        IBusinessRuleMapping[] aMappings = this.m_container.getBusinessRuleMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            IBusinessRuleMapping mapping = aMappings[iMapping];
            if (!this.m_filter.pass((Object)mapping) || !mapping.containsInTargets(col)) continue;
            return mapping;
        }
        return null;
    }

    public IBusinessRuleFlowColumn getTargetColumn(int iRow) {
        return (IBusinessRuleFlowColumn)this.getValueAt(iRow, 5);
    }

    public int getRowIndex(IBusinessRuleFlowColumn col) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(5) != col) continue;
            return iRow;
        }
        return -1;
    }

    public int getRowIndex(IBusinessRuleMapping mapping) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(6) != mapping) continue;
            return iRow;
        }
        return -1;
    }

    public IBusinessRuleMapping getMapping(int iRow) {
        return (IBusinessRuleMapping)this.getValueAt(iRow, 6);
    }

    private Icon getMappingTypeIcon(IBusinessRuleMapping mapping) {
        if (mapping == null) {
            return UNMAPPED_ICON;
        }
        if (mapping.getWarning() != null) {
            return WARNING_ICON;
        }
        String sType = mapping.getType();
        return "ONETOONE".equals(sType) ? ONE_TO_ONE_ICON : ("DERIVED".equals(sType) ? DERIVED_ICON : UNMAPPED_ICON);
    }

    private Icon getExclusionsIcon(IBusinessRuleFlowColumn column) {
        Icon icon = NOT_EXCLUDED_ICON;
        if (this.m_container.getListOfColumnsExcludedFromMapping().contains(column)) {
            icon = EXCLUDED_FROM_MAPPING_ICON;
        }
        return icon;
    }

    public void setSelectedTable(IBusinessRuleFlowTable tbl) {
        if (this.m_tblSelected == tbl) {
            return;
        }
        this.m_tblSelected = tbl;
        this.moveDataToModel();
    }

    public IBusinessRuleFlowTable getSelectedTable() {
        return this.m_tblSelected;
    }

    public void setMappingsFilter(IFilter filter) {
        this.m_filter = filter;
    }

    public IFilter getMappingsFilter() {
        return this.m_filter;
    }

    private void addTable(IBusinessRuleFlowTable tbl) {
        if (this.m_tblSelected != null && this.m_tblSelected != tbl) {
            return;
        }
        if (!this.m_lTables.contains(tbl)) {
            this.m_lTables.add(tbl);
            for (IBusinessRuleFlowColumn aColumn : tbl.getColumns()) {
                this.insertRow(this.getRowCount() - 1, this.createRowValues(aColumn));
            }
        }
    }

    private void removeTable(IBusinessRuleFlowTable tbl) {
        if (this.m_tblSelected != null && this.m_tblSelected != tbl) {
            return;
        }
        if (this.m_lTables.contains(tbl)) {
            this.m_lTables.remove(tbl);
            for (IBusinessRuleFlowColumn aColumn : tbl.getColumns()) {
                this.deleteRow(this.getRowIndex(aColumn));
            }
        }
    }

    private void addMapping(IBusinessRuleMapping mapping) {
        IBusinessRuleFlowColumn[] aColumns = mapping.getTargetsOfBusinessRuleColumn();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            int iRow = this.getRowIndex(aColumns[iColumn]);
            if (iRow == -1) continue;
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void removeMapping(IBusinessRuleMapping mapping) {
        IBusinessRuleFlowColumn[] aColumns = mapping.getTargetsOfBusinessRuleColumn();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            int iRow = this.getRowIndex(aColumns[iColumn]);
            if (iRow == -1) continue;
            this.refreshMappingValues(iRow, null);
        }
    }

    private void addMappingSource(IBusinessRuleMapping mapping, IColumn column) {
        int iRow = this.getRowIndex(mapping);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void removeMappingSource(IBusinessRuleMapping mapping, IColumn column) {
        int iRow = this.getRowIndex(mapping);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void addMappingTarget(IBusinessRuleMapping mapping, IBusinessRuleFlowColumn column) {
        int iRow = this.getRowIndex(column);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, mapping);
        }
    }

    private void removeMappingTarget(IBusinessRuleMapping mapping, IBusinessRuleFlowColumn column) {
        int iRow = this.getRowIndex(column);
        if (iRow != -1) {
            this.refreshMappingValues(iRow, null);
        }
    }

    private void refreshMappingValues(int iRow, IBusinessRuleMapping mapping) {
        super.setValueAt((Object)mapping, iRow, 6);
        super.setValueAt((Object)this.getMappingTypeIcon(mapping), iRow, 0);
    }

    private void refreshExclusionsIcon(IBusinessRuleFlowColumn column) {
        int iRow = this.getRowIndex(column);
        if (iRow == -1) {
            return;
        }
        super.setValueAt((Object)this.getExclusionsIcon(column), iRow, 1);
    }

    private class ColumnNameCellRenderer
    extends WsDefaultTableCellRenderer {
        private ColumnNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            IBusinessRuleFlowColumn col;
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (tbl instanceof TableView) {
                iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            }
            if ((col = BusinessRuleTargetColumnsTableModel.this.getTargetColumn(iRow)) != null) {
                this.setIcon(ColumnUIUtilities.getTypeIcon(col.getSASType()));
            }
            return this;
        }
    }

    private class BusinessRuleModelListener
    implements IModelListener {
        private BusinessRuleModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                BusinessRuleTargetColumnsTableModel.this.moveDataToModel();
            } else if (obj == BusinessRuleTargetColumnsTableModel.this.m_container) {
                if (sType == "DataTransform.DataTargetAdded") {
                    Object data = ev.getData();
                    if (data instanceof IBusinessRuleFlowTable) {
                        BusinessRuleTargetColumnsTableModel.this.addTable((IBusinessRuleFlowTable)data);
                    }
                } else if (sType == "DataTransform.DataTargetRemoved") {
                    Object data = ev.getData();
                    if (data instanceof IBusinessRuleFlowTable) {
                        BusinessRuleTargetColumnsTableModel.this.removeTable((IBusinessRuleFlowTable)data);
                    }
                } else if (sType == "MappingsContainer:BusinessRuleMappingAdded") {
                    IBusinessRuleMapping mapping = (IBusinessRuleMapping)ev.getData();
                    if (BusinessRuleTargetColumnsTableModel.this.m_filter.pass((Object)mapping)) {
                        BusinessRuleTargetColumnsTableModel.this.addMapping(mapping);
                    }
                } else if (sType == "MappingsContainer:BusinessRuleMappingRemoved") {
                    IBusinessRuleMapping mapping = (IBusinessRuleMapping)ev.getData();
                    if (BusinessRuleTargetColumnsTableModel.this.m_filter.pass((Object)mapping)) {
                        BusinessRuleTargetColumnsTableModel.this.removeMapping(mapping);
                    }
                } else if (sType == "MappingsContainer:ColumnExcludedFromMapping") {
                    BusinessRuleTargetColumnsTableModel.this.refreshExclusionsIcon((IBusinessRuleFlowColumn)ev.getData());
                } else if (sType == "MappingsContainer:ColumnIncludedInMapping") {
                    BusinessRuleTargetColumnsTableModel.this.refreshExclusionsIcon((IBusinessRuleFlowColumn)ev.getData());
                }
            } else if (BusinessRuleTargetColumnsTableModel.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)BusinessRuleTargetColumnsTableModel.this.m_container).getParentQuery().getTransformModel() == obj) {
                Object data;
                if (sType == "DataTransform.DataTargetAdded") {
                    Object data2 = ev.getData();
                    if (data2 instanceof IBusinessRuleFlowTable) {
                        BusinessRuleTargetColumnsTableModel.this.addTable((IBusinessRuleFlowTable)data2);
                    }
                } else if (sType == "DataTransform.DataTargetRemoved" && (data = ev.getData()) instanceof IBusinessRuleFlowTable) {
                    BusinessRuleTargetColumnsTableModel.this.removeTable((IBusinessRuleFlowTable)data);
                }
            } else if (obj instanceof IBusinessRuleMapping) {
                IBusinessRuleMapping mapping = (IBusinessRuleMapping)obj;
                if (!BusinessRuleTargetColumnsTableModel.this.m_filter.pass((Object)mapping) || !BusinessRuleTargetColumnsTableModel.this.m_container.containsMapping((IMapping)mapping)) {
                    return;
                }
                if (sType == "Mapping:TargetColumnAdded") {
                    BusinessRuleTargetColumnsTableModel.this.addMappingTarget(mapping, (IBusinessRuleFlowColumn)ev.getData());
                } else if (sType == "Mapping:TargetColumnRemoved") {
                    BusinessRuleTargetColumnsTableModel.this.removeMappingTarget(mapping, (IBusinessRuleFlowColumn)ev.getData());
                } else if (sType == "Mapping:SourceColumnAdded") {
                    BusinessRuleTargetColumnsTableModel.this.addMappingSource(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:SourceColumnRemoved") {
                    BusinessRuleTargetColumnsTableModel.this.removeMappingSource(mapping, (IColumn)ev.getData());
                } else {
                    int iRow = BusinessRuleTargetColumnsTableModel.this.getRowIndex(mapping);
                    if (iRow == -1) {
                        return;
                    }
                    if (sType == "Mapping:TypeChanged") {
                        BusinessRuleTargetColumnsTableModel.super.setValueAt(BusinessRuleTargetColumnsTableModel.this.getMappingTypeIcon(mapping), iRow, 0);
                    } else if (sType == "Mapping:MappingChanged") {
                        BusinessRuleTargetColumnsTableModel.this.refreshMappingValues(iRow, BusinessRuleTargetColumnsTableModel.this.getMapping(iRow));
                    }
                }
            }
        }
    }
}

