/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.businessrules;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowColumn;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMapping;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMappingsContainer;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.wadmin.transforms.businessrules.BusinessRuleTargetColumnsTableModel;
import com.sas.wadmin.visuals.common.SourceColumnsTableModel;
import com.sas.workspace.WsDefaultObjectListModel;
import com.sas.workspace.WsMapping;

public class BusinessRuleMappingsModel
extends WsDefaultObjectListModel {
    private IBusinessRuleMappingsContainer m_container;
    private SourceColumnsTableModel m_mdlSourceColumns;
    private BusinessRuleTargetColumnsTableModel m_mdlTargetColumns;
    private IFilter m_filter;
    private IModelListener m_lsnrModel;

    public BusinessRuleMappingsModel(IBusinessRuleMappingsContainer container, SourceColumnsTableModel mdlSourceColumns, BusinessRuleTargetColumnsTableModel mdlTargetColumns) {
        this.m_container = container;
        this.m_mdlSourceColumns = mdlSourceColumns;
        this.m_mdlTargetColumns = mdlTargetColumns;
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
    }

    public void setMappingsFilter(IFilter filter) {
        this.m_filter = filter;
    }

    public IFilter getMappingsFilter() {
        return this.m_filter;
    }

    public void moveDataToModel() {
        this.removeAll();
        IBusinessRuleMapping[] aMappings = this.m_container.getBusinessRuleMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping])) continue;
            this.addMapping(aMappings[iMapping]);
        }
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) {
        WsMapping pair = (WsMapping)obj;
        if (pair.isTemporary()) {
            super.add((Object)pair);
        } else {
            IColumn source = this.m_mdlSourceColumns.getSourceColumn(pair.getSource());
            IBusinessRuleFlowColumn target = this.m_mdlTargetColumns.getTargetColumn(pair.getTarget());
            IBusinessRuleMapping mapping = this.m_mdlTargetColumns.getMapping(pair.getTarget());
            if (mapping == null) {
                this.m_container.addMapping(new IColumn[]{source}, new IBusinessRuleFlowColumn[]{target});
            } else {
                this.m_container.getModel().startCompoundUndoable();
                try {
                    mapping.addSource(source);
                }
                finally {
                    this.m_container.getModel().endCompoundUndoable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object obj) {
        WsMapping pair = (WsMapping)obj;
        if (pair.isTemporary()) {
            super.remove((Object)pair);
        } else {
            this.m_container.getModel().startCompoundUndoable();
            try {
                PairingDataObject pdo = (PairingDataObject)pair.getDataObject();
                IColumn source = pdo.m_colSource;
                IBusinessRuleMapping mapping = pdo.m_mapping;
                mapping.removeSource(source);
            }
            finally {
                this.m_container.getModel().endCompoundUndoable();
            }
        }
    }

    public void remove(int iObj) {
        this.remove(this.get(iObj));
    }

    private void addMapping(IBusinessRuleMapping mapping) {
        if (!this.m_filter.pass((Object)mapping)) {
            return;
        }
        IColumn[] aSources = mapping.getSources();
        IBusinessRuleFlowColumn[] aTargets = mapping.getTargetsOfBusinessRuleColumn();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            int iSourceRow = this.m_mdlSourceColumns.getRowIndex(aSources[iSource]);
            if (iSourceRow == -1) continue;
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                int iTargetRow = this.m_mdlTargetColumns.getRowIndex(aTargets[iTarget]);
                if (iTargetRow == -1) continue;
                super.add((Object)this.createPairing(iSourceRow, aSources[iSource], iTargetRow, aTargets[iTarget], mapping));
            }
        }
    }

    private void removeMapping(IBusinessRuleMapping mapping) {
        if (!this.m_filter.pass((Object)mapping)) {
            return;
        }
        IColumn[] aSources = mapping.getSources();
        IBusinessRuleFlowColumn[] aTargets = mapping.getTargetsOfBusinessRuleColumn();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                this.removePairing(aSources[iSource], aTargets[iTarget], mapping);
            }
        }
    }

    private void addPairingsForSourceColumnInMapping(IBusinessRuleMapping mapping, IColumn column) {
        int iSourceRow = this.m_mdlSourceColumns.getRowIndex(column);
        if (iSourceRow == -1) {
            return;
        }
        IBusinessRuleFlowColumn[] aTargets = mapping.getTargetsOfBusinessRuleColumn();
        for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
            int iTargetRow = this.m_mdlTargetColumns.getRowIndex(aTargets[iTarget]);
            if (iTargetRow == -1) continue;
            super.add((Object)this.createPairing(iSourceRow, column, iTargetRow, aTargets[iTarget], mapping));
        }
    }

    private void addPairingsForTargetColumnInMapping(IBusinessRuleMapping mapping, IBusinessRuleFlowColumn column) {
        int iTargetRow = this.m_mdlTargetColumns.getRowIndex(column);
        if (iTargetRow == -1) {
            return;
        }
        IColumn[] aSources = mapping.getSources();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            int iSourceRow = this.m_mdlSourceColumns.getRowIndex(aSources[iSource]);
            if (iSourceRow == -1) continue;
            super.add((Object)this.createPairing(iSourceRow, aSources[iSource], iTargetRow, column, mapping));
        }
    }

    private void removePairingsForSourceColumnInMapping(IBusinessRuleMapping mapping, IColumn column) {
        IBusinessRuleFlowColumn[] aTargets = mapping.getTargetsOfBusinessRuleColumn();
        for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
            this.removePairing(column, aTargets[iTarget], mapping);
        }
    }

    private void removePairingsForTargetColumnInMapping(IBusinessRuleMapping mapping, IBusinessRuleFlowColumn column) {
        IColumn[] aSources = mapping.getSources();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            this.removePairing(aSources[iSource], column, mapping);
        }
    }

    private void addPairingsForSourceColumn(IColumn col) {
        IBusinessRuleMapping[] aMappings = this.m_container.getBusinessRuleMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInSources(col)) continue;
            this.addPairingsForSourceColumnInMapping(aMappings[iMapping], col);
        }
    }

    private void addPairingsForTargetColumn(IBusinessRuleFlowColumn col) {
        IBusinessRuleMapping[] aMappings = this.m_container.getBusinessRuleMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInTargets(col)) continue;
            this.addPairingsForTargetColumnInMapping(aMappings[iMapping], col);
        }
    }

    private void removePairingsForSourceColumn(IColumn col) {
        IBusinessRuleMapping[] aMappings = this.m_container.getBusinessRuleMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInSources(col)) continue;
            this.removePairingsForSourceColumnInMapping(aMappings[iMapping], col);
        }
    }

    private void removePairingsForTargetColumn(IBusinessRuleFlowColumn col) {
        IBusinessRuleMapping[] aMappings = this.m_container.getBusinessRuleMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInTargets(col)) continue;
            this.removePairingsForTargetColumnInMapping(aMappings[iMapping], col);
        }
    }

    private boolean isSourceTable(ITable tbl) {
        ITable[] aTables = this.m_container.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            if (aTables[iTable] != tbl) continue;
            return true;
        }
        return false;
    }

    private boolean isTargetTable(IBusinessRuleFlowTable tbl) {
        IBusinessRuleFlowTable[] aTables = this.m_container.getSourceBusinessRuleTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            if (aTables[iTable] != tbl) continue;
            return true;
        }
        return false;
    }

    private WsMapping createPairing(int iSourceRow, IColumn colSource, int iTargetRow, IBusinessRuleFlowColumn colTarget, IBusinessRuleMapping mapping) {
        WsMapping pairing = new WsMapping(iSourceRow, iTargetRow);
        pairing.setDataObject((Object)new PairingDataObject(colSource, colTarget, mapping));
        return pairing;
    }

    private WsMapping removePairing(IColumn colSource, IBusinessRuleFlowColumn colTarget, IBusinessRuleMapping mapping) {
        for (int iPairing = 0; iPairing < this.size(); ++iPairing) {
            WsMapping pairing = (WsMapping)this.get(iPairing);
            PairingDataObject pdo = (PairingDataObject)pairing.getDataObject();
            if (pdo.m_colSource != colSource || pdo.m_colTarget != colTarget || pdo.m_mapping != mapping) continue;
            super.remove(iPairing);
            return pairing;
        }
        return null;
    }

    private static class PairingDataObject {
        IColumn m_colSource;
        IBusinessRuleFlowColumn m_colTarget;
        IBusinessRuleMapping m_mapping;

        PairingDataObject(IColumn colSource, IBusinessRuleFlowColumn colTarget, IBusinessRuleMapping mapping) {
            this.m_colSource = colSource;
            this.m_colTarget = colTarget;
            this.m_mapping = mapping;
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                BusinessRuleMappingsModel.this.moveDataToModel();
            } else if (obj == BusinessRuleMappingsModel.this.m_container) {
                if (sType == "MappingsContainer:BusinessRuleMappingAdded") {
                    BusinessRuleMappingsModel.this.addMapping((IBusinessRuleMapping)ev.getData());
                } else if (sType == "MappingsContainer:BusinessRuleMappingRemoved") {
                    BusinessRuleMappingsModel.this.removeMapping((IBusinessRuleMapping)ev.getData());
                } else if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataTargetAdded") {
                    BusinessRuleMappingsModel.this.moveDataToModel();
                }
            } else if (BusinessRuleMappingsModel.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)BusinessRuleMappingsModel.this.m_container).getParentQuery().getTransformModel() == obj) {
                if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataTargetAdded") {
                    BusinessRuleMappingsModel.this.moveDataToModel();
                }
            } else if (obj instanceof ITable) {
                if (BusinessRuleMappingsModel.this.isSourceTable((ITable)obj)) {
                    if (sType == "Table:ColumnAdded") {
                        BusinessRuleMappingsModel.this.addPairingsForSourceColumn((IColumn)ev.getData());
                    } else if (sType == "Table:ColumnMoved") {
                        BusinessRuleMappingsModel.this.removePairingsForSourceColumn((IColumn)ev.getData());
                        BusinessRuleMappingsModel.this.addPairingsForSourceColumn((IColumn)ev.getData());
                    } else if (sType == "Table:ColumnRemoved") {
                        BusinessRuleMappingsModel.this.removePairingsForSourceColumn((IColumn)ev.getData());
                    }
                }
            } else if (obj instanceof IBusinessRuleFlowTable) {
                if (BusinessRuleMappingsModel.this.isTargetTable((IBusinessRuleFlowTable)obj)) {
                    if (sType == "Table:ColumnAdded") {
                        BusinessRuleMappingsModel.this.addPairingsForTargetColumn((IBusinessRuleFlowColumn)ev.getData());
                    } else if (sType == "Table:ColumnMoved") {
                        BusinessRuleMappingsModel.this.removePairingsForTargetColumn((IBusinessRuleFlowColumn)ev.getData());
                        BusinessRuleMappingsModel.this.addPairingsForTargetColumn((IBusinessRuleFlowColumn)ev.getData());
                    } else if (sType == "Table:ColumnRemoved") {
                        BusinessRuleMappingsModel.this.removePairingsForTargetColumn((IBusinessRuleFlowColumn)ev.getData());
                    }
                }
            } else if (obj instanceof IBusinessRuleMapping) {
                IBusinessRuleMapping mapping = (IBusinessRuleMapping)obj;
                if (!BusinessRuleMappingsModel.this.m_filter.pass((Object)mapping) || !BusinessRuleMappingsModel.this.m_container.containsMapping((IMapping)mapping)) {
                    return;
                }
                if (sType == "Mapping:SourceColumnAdded") {
                    BusinessRuleMappingsModel.this.addPairingsForSourceColumnInMapping(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:TargetColumnAdded") {
                    BusinessRuleMappingsModel.this.addPairingsForTargetColumnInMapping(mapping, (IBusinessRuleFlowColumn)ev.getData());
                } else if (sType == "Mapping:SourceColumnRemoved") {
                    BusinessRuleMappingsModel.this.removePairingsForSourceColumnInMapping(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:TargetColumnRemoved") {
                    BusinessRuleMappingsModel.this.removePairingsForTargetColumnInMapping(mapping, (IBusinessRuleFlowColumn)ev.getData());
                }
            }
        }
    }
}

